/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.publish;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.domain.ApplicationData;
import com.digiwin.athena.athena_deployer_service.domain.TenantUser;
import com.digiwin.athena.athena_deployer_service.domain.application.Application;
import com.digiwin.athena.athena_deployer_service.domain.application.CollectionDomain;
import com.digiwin.athena.athena_deployer_service.domain.deploy.CustomPublishParam;
import com.digiwin.athena.athena_deployer_service.domain.param.AuthUserParam;
import com.digiwin.athena.athena_deployer_service.domain.param.PolicyBatchAddParam;
import com.digiwin.athena.athena_deployer_service.http.atmc.AtmcApiHelper;
import com.digiwin.athena.athena_deployer_service.http.bmd.BmdApiHelper;
import com.digiwin.athena.athena_deployer_service.http.km.KmApiHelper;
import com.digiwin.athena.athena_deployer_service.http.km.dto.DeployAppReqDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.SyncPushDataDto;
import com.digiwin.athena.athena_deployer_service.http.scrumbi.ScrumbiApiHelper;
import com.digiwin.athena.athena_deployer_service.http.scrumbi.dto.PushSynonymDto;
import com.digiwin.athena.athena_deployer_service.publish.ActionPublish;
import com.digiwin.athena.athena_deployer_service.publish.BaseCustomPublishService;
import com.digiwin.athena.athena_deployer_service.service.deploy.AsyncService;
import com.digiwin.athena.athena_deployer_service.service.deploy.PageDesignService;
import com.digiwin.athena.athena_deployer_service.service.deploy.TenantService;
import com.digiwin.athena.athena_deployer_service.service.iam.IamService;
import com.digiwin.athena.athena_deployer_service.util.SafeFileUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bson.conversions.Bson;
import org.neo4j.driver.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AgileDataPublish
extends BaseCustomPublishService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AgileDataPublish.class);
    @Autowired
    private ActionPublish actionPublish;
    @Autowired
    private Driver driver1;
    @Autowired(required=false)
    @Qualifier(value="domain2Driver")
    private Driver driver2;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private KmApiHelper kmApiHelper;
    @Autowired
    private AtmcApiHelper atmcApiHelper;
    @Autowired
    private ScrumbiApiHelper scrumbiApiHelper;
    @Autowired
    private BmdApiHelper bmdApiHelper;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Value(value="${envMode}")
    private String envMode;
    @Autowired
    private PageDesignService pageDesignService;
    @Autowired
    private IamService iamService;
    @Autowired
    private AsyncService asyncService;

    public void publish(CustomPublishParam customPublishParam, List<Object> sceneCodes, List<Object> flowCodes, Map<String, Object> extendParams) {
        File paramFile;
        String deployVersion = customPublishParam.getDeployVersion();
        File compileDataDirector = customPublishParam.getCompileDataDirector();
        String path = compileDataDirector.getPath();
        String compileVersion = customPublishParam.getCompileVersion();
        List tenantUsers = customPublishParam.getTenantUsers();
        for (TenantUser user : tenantUsers) {
            user.setOption(Integer.valueOf(3));
        }
        String currTenantId = customPublishParam.getCurrentUser().getTenantId();
        String integrationToken = this.iamService.getIntegrationToken(currTenantId);
        if ("new".equals(customPublishParam.getPublishMode())) {
            CollectionDomain collectionDomain = new CollectionDomain().setCollection("Action").setPrimaryKey("dataFlowCode");
            DeployAppReqDto deployAppReqDto = DeployAppReqDto.create((CustomPublishParam)customPublishParam);
            deployAppReqDto.setSinglePublishNeo4jData(null, flowCodes, collectionDomain);
            collectionDomain.setCollection("DataEntity");
            deployAppReqDto.setSinglePublishNeo4jData(null, flowCodes, collectionDomain);
            collectionDomain.setCollection("DataField");
            deployAppReqDto.setSinglePublishNeo4jData(null, flowCodes, collectionDomain);
            if (!CollectionUtils.isEmpty(sceneCodes)) {
                collectionDomain.setCollection("ReportScene").setPrimaryKey("code");
                deployAppReqDto.setSinglePublishNeo4jData(null, sceneCodes, collectionDomain);
            }
            List cql = this.collectCql(compileDataDirector.getPath(), compileVersion);
            deployAppReqDto.setSinglePublishNeo4jData(cql, null, null);
            collectionDomain.setDatabaseName("knowledgegraphSystem").setCollection("assistDimensionConfig").setPrimaryKey("appCode");
            ArrayList<String> pkValue = new ArrayList<String>();
            pkValue.add(customPublishParam.getApplication());
            List assistDimensionMongoData = super.collectMongoData(collectionDomain, path, compileVersion, pkValue);
            deployAppReqDto.setSinglePublishMongoData(assistDimensionMongoData, pkValue, collectionDomain);
            collectionDomain.setDatabaseName("knowledgegraphSystem").setCollection("agiledata_business_variables").setPrimaryKey("appCode");
            List variablesMongoData = super.collectMongoData(collectionDomain, path, compileVersion, pkValue);
            deployAppReqDto.setSinglePublishMongoData(variablesMongoData, pkValue, collectionDomain);
            collectionDomain.setDatabaseName("knowledgegraphSystem").setCollection("agiledata_business_type").setPrimaryKey("appCode");
            List businessTypesMongoData = super.collectMongoData(collectionDomain, path, compileVersion, pkValue);
            deployAppReqDto.setSinglePublishMongoData(businessTypesMongoData, pkValue, collectionDomain);
            collectionDomain.setDatabaseName("knowledgegraphSystem").setCollection("agiledata_instruction_set").setPrimaryKey("applicationCode");
            List instructionSetMongoData = super.collectMongoData(collectionDomain, path, compileVersion, pkValue);
            deployAppReqDto.setSinglePublishMongoData(instructionSetMongoData, pkValue, collectionDomain);
            collectionDomain.setDatabaseName("knowledgegraphSystem").setCollection("agiledata_board_info").setPrimaryKey("appCode");
            List boardMongoData = super.collectMongoData(collectionDomain, path, compileVersion, pkValue);
            deployAppReqDto.setSinglePublishMongoData(boardMongoData, pkValue, collectionDomain);
            this.iamBoardPublish(integrationToken, customPublishParam.getApplication(), tenantUsers, "board", boardMongoData);
            if (!deployAppReqDto.appDataIsEmpty()) {
                this.kmApiHelper.deployApp(deployAppReqDto, customPublishParam.getCurrentUser().getTenantId());
            }
        }
        this.iamPublish(compileVersion, integrationToken, customPublishParam.getApplication(), tenantUsers, sceneCodes, path);
        this.kmApiHelper.updateApplicationComponentList(customPublishParam.getApplication(), "1.0", currTenantId);
        this.kmApiHelper.cacheReset(currTenantId);
        File synonymFile = SafeFileUtils.createFile((String)(path + File.separator + "designer" + File.separator + "agiledata_synonym" + File.separator + compileVersion + ".json"));
        PushSynonymDto dto = new PushSynonymDto();
        dto.setVersion(deployVersion);
        dto.setTenantUsers(tenantUsers);
        dto.setCurrTenantId(currTenantId);
        dto.setAppCode(customPublishParam.getApplication());
        if (synonymFile.exists()) {
            List data = FileUtil.readLines((File)synonymFile, (Charset)Charset.forName("utf-8"));
            List synonymData = data.stream().map(item -> (JSONObject)JSON.parseObject((String)item, JSONObject.class)).collect(Collectors.toList());
            dto.setSynonyms(synonymData);
            this.scrumbiApiHelper.pushSynonym(dto);
            this.scrumbiApiHelper.pushSynonymToAI(dto);
        }
        if ((paramFile = SafeFileUtils.createFile((String)(path + File.separator + "designer" + File.separator + "agiledata_standard_params" + File.separator + compileVersion + ".json"))).exists()) {
            List data = FileUtil.readLines((File)paramFile, (Charset)Charset.forName("utf-8"));
            List paramData = data.stream().map(item -> (JSONObject)JSON.parseObject((String)item, JSONObject.class)).collect(Collectors.toList());
            dto.setSynonyms(null);
            dto.setStandardParams(paramData);
            this.scrumbiApiHelper.pushStandardParams(dto);
        }
        SyncPushDataDto pushDataDto = new SyncPushDataDto();
        pushDataDto.setTenantId(((TenantUser)tenantUsers.get(0)).getTenantId());
        pushDataDto.setVersion(deployVersion);
        pushDataDto.setCurrTenantId(currTenantId);
        pushDataDto.setAppCodes(Arrays.asList(customPublishParam.getApplication()));
        this.kmApiHelper.syncPushData(pushDataDto);
        pushDataDto.setTenantUsers(tenantUsers);
        this.kmApiHelper.syncVariableData(pushDataDto);
        String source = extendParams.get("source").toString();
        String appName = extendParams.get("appName").toString();
        Map envMap = extendParams.getOrDefault("envMap", new HashMap());
        Map thirdModule = envMap.getOrDefault(this.envMode, new HashMap());
        Object bmdEnv = thirdModule.get("bmdEnvMap");
        String envCode = "";
        if (Objects.nonNull(bmdEnv)) {
            envCode = String.valueOf(thirdModule.get("bmdEnvMap"));
        }
        this.bmdApiHelper.modelRelease(customPublishParam.getApplication(), envCode, tenantUsers, integrationToken, deployVersion, source, appName);
        this.publishRecord(sceneCodes, flowCodes, tenantUsers, customPublishParam.getApplication());
    }

    private void iamBoardPublish(String token, String application, List<TenantUser> tenantUsers, String moduleId, List<JSONObject> dataList) {
        if (!CollectionUtils.isEmpty(dataList)) {
            for (JSONObject line : dataList) {
                String authorityPrefix = line.getString("authorityPrefix");
                if (!StrUtil.isNotBlank((CharSequence)authorityPrefix)) continue;
                JSONObject board = new JSONObject();
                board.put("code", (Object)line.getString("groupId"));
                board.put("name", (Object)line.getString("groupValue"));
                this.iamPublish(application, Boolean.valueOf(false), token, tenantUsers, board, moduleId);
            }
        }
    }

    private void publishRecord(List<Object> sceneCodes, List<Object> flowCodes, List<TenantUser> tenantUsers, String application) {
        try {
            if (!CollectionUtils.isEmpty(sceneCodes)) {
                for (Object assign : sceneCodes) {
                    String assignCode = assign.toString();
                    String operateType = "";
                    operateType = assignCode.startsWith("D") ? "METRIC" : (assignCode.startsWith("S") ? "SCENE" : "SCREEN");
                    for (TenantUser tenantUser : tenantUsers) {
                        this.asyncService.moduleAssignPublishRecord(tenantUser.getTenantId(), this.envMode, application, assignCode, operateType, "", null);
                    }
                }
            } else {
                for (Object assign : flowCodes) {
                    for (TenantUser tenantUser : tenantUsers) {
                        this.asyncService.moduleAssignPublishRecord(tenantUser.getTenantId(), this.envMode, application, assign.toString(), "DATAFLOW", "", null);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("insert publish record error");
        }
    }

    private void iamPublish(String compileVersion, String token, String application, List<TenantUser> tenantUsers, List<Object> pkValueList, String path) {
        File triggerFile = new File(path + File.separator + "designer" + File.separator + "agiledata_scene_trigger" + File.separator + compileVersion + ".json");
        File classificationFile = new File(path + File.separator + "designer" + File.separator + "agiledata_classification" + File.separator + compileVersion + ".json");
        if (triggerFile.exists()) {
            List newTriggerList;
            List triggerStrList = FileUtil.readLines((File)triggerFile, (Charset)Charset.forName("utf-8"));
            ArrayList<JSONObject> triggerList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> screenTriggerList = new ArrayList<JSONObject>();
            for (String line : triggerStrList) {
                JSONObject obj = JSONObject.parseObject((String)line);
                if (!pkValueList.contains(obj.getString("code"))) continue;
                String viewType = obj.getString("viewType");
                if ("screen".equals(viewType)) {
                    screenTriggerList.add(obj);
                    continue;
                }
                triggerList.add(obj);
            }
            List<Object> classificationList = new ArrayList();
            if (classificationFile.exists()) {
                List classificationStrList = FileUtil.readLines((File)classificationFile, (Charset)Charset.forName("utf-8"));
                classificationList = classificationStrList.stream().map(JSON::parseObject).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty((Collection)(newTriggerList = AgileDataPublish.processTriggerAndClassification(triggerList, classificationList)))) {
                for (JSONObject trigger : newTriggerList) {
                    this.iamPublish(application, Boolean.valueOf(false), token, tenantUsers, trigger, trigger.getString("moduleId"));
                }
            }
            if (!CollectionUtils.isEmpty(screenTriggerList)) {
                for (JSONObject screenTrigger : screenTriggerList) {
                    JSONObject pushTrigger = new JSONObject();
                    pushTrigger.put("code", (Object)screenTrigger.getString("code"));
                    pushTrigger.put("name", (Object)screenTrigger.getString("name"));
                    pushTrigger.put("moduleId", (Object)"bigScreen");
                    this.iamPublish(application, Boolean.valueOf(false), token, tenantUsers, pushTrigger, "bigScreen");
                }
            }
        }
    }

    public void iamPublish(String application, Boolean commonApp, String token, List<TenantUser> tenantUsers, JSONObject activity, String module) {
        List tenantSids = tenantUsers.stream().map(tenantUser -> Convert.toLong((Object)tenantUser.getTenantSid())).collect(Collectors.toList());
        this.pageDesignService.iamPublishWithoutTenantSid(token, new Application().setCode(application), tenantSids, (List)ListUtil.toList((Object[])new JSONObject[]{activity}), module);
        ApplicationData applicationData = new ApplicationData().setApplication(application).setAppId(application);
        AuthUserParam authUserParam = new AuthUserParam().setTenantUsers(tenantUsers).setApplicationDataList((List)ListUtil.toList((Object[])new ApplicationData[]{applicationData}));
        this.tenantService.authUser(authUserParam, token);
        PolicyBatchAddParam policyBatchAddParam = new PolicyBatchAddParam().setApplicationDataList((List)ListUtil.toList((Object[])new ApplicationData[]{applicationData})).setModuleId(module).setActivityList((List)ListUtil.toList((Object[])new JSONObject[]{activity})).setTenantUsers(tenantUsers);
        this.tenantService.policyBatch(policyBatchAddParam, token, commonApp);
    }

    private void syncDataToKm(String path, String compileVersion, String application, Bson bson, String collectionName) {
    }

    private static List<JSONObject> processTriggerAndClassification(List<JSONObject> triggerList, List<JSONObject> classificationList) {
        ArrayList<JSONObject> newTriggerList = new ArrayList<JSONObject>();
        HashSet<String> usedTriggerCodes = new HashSet<String>();
        for (JSONObject classification : classificationList) {
            String classCode = classification.getString("code");
            String className = classification.getString("name");
            newTriggerList.add(AgileDataPublish.createNode((String)classCode, (String)className));
            newTriggerList.add(AgileDataPublish.createChildNode((String)classCode, (String)"metric", (String)"\u6307\u6807"));
            newTriggerList.add(AgileDataPublish.createChildNode((String)classCode, (String)"scene", (String)"\u573a\u666f"));
        }
        for (JSONObject document : triggerList) {
            String parentId;
            String code = document.getString("code");
            String authorityPrefix = document.getString("authorityPrefix");
            String viewType = document.getString("viewType");
            if (authorityPrefix == null || authorityPrefix.isEmpty() || (parentId = AgileDataPublish.findParentIdForTrigger((String)code, (String)viewType, classificationList)) == null) continue;
            JSONObject trigger = new JSONObject((Map)document);
            trigger.put("parentId", (Object)parentId);
            trigger.put("moduleId", (Object)"classification");
            newTriggerList.add(trigger);
            usedTriggerCodes.add(code);
        }
        if (usedTriggerCodes.size() != triggerList.size()) {
            String otherCode = "other";
            newTriggerList.add(AgileDataPublish.createNode((String)otherCode, (String)"\u5176\u4ed6"));
            newTriggerList.add(AgileDataPublish.createChildNode((String)otherCode, (String)"metric", (String)"\u6307\u6807"));
            newTriggerList.add(AgileDataPublish.createChildNode((String)otherCode, (String)"scene", (String)"\u573a\u666f"));
            for (JSONObject trigger : triggerList) {
                String code = trigger.getString("code");
                String authorityPrefix = trigger.getString("authorityPrefix");
                String viewType = trigger.getString("viewType");
                if (authorityPrefix == null || authorityPrefix.isEmpty() || usedTriggerCodes.contains(code)) continue;
                JSONObject copy = new JSONObject((Map)trigger);
                copy.put("parentId", (Object)(otherCode + "." + viewType));
                copy.put("moduleId", (Object)"classification");
                newTriggerList.add(copy);
            }
        }
        return AgileDataPublish.sortByLayer(newTriggerList);
    }

    private static JSONObject createNode(String code, String name) {
        JSONObject node = new JSONObject();
        node.put("code", (Object)code);
        node.put("name", (Object)name);
        node.put("moduleId", (Object)"classification");
        return node;
    }

    private static JSONObject createChildNode(String parentCode, String suffix, String name) {
        JSONObject child = new JSONObject();
        child.put("code", (Object)(parentCode + "." + suffix));
        child.put("name", (Object)name);
        child.put("parentId", (Object)parentCode);
        child.put("moduleId", (Object)"classification");
        return child;
    }

    private static String findParentIdForTrigger(String triggerCode, String viewType, List<JSONObject> classificationList) {
        for (JSONObject classification : classificationList) {
            ArrayList relScene;
            ArrayList relMetric = classification.getJSONArray("relMetric") != null ? classification.getJSONArray("relMetric").toJavaList(String.class) : new ArrayList();
            List list = relScene = classification.getJSONArray("relScene") != null ? classification.getJSONArray("relScene").toJavaList(String.class) : new ArrayList();
            if ("metric".equals(viewType) && relMetric.contains(triggerCode)) {
                return classification.getString("code") + ".metric";
            }
            if (!"scene".equals(viewType) || !relScene.contains(triggerCode)) continue;
            return classification.getString("code") + ".scene";
        }
        return null;
    }

    private static List<JSONObject> sortByLayer(List<JSONObject> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, JSONObject> codeToObject = new HashMap<String, JSONObject>();
        for (JSONObject obj2 : list) {
            String code = obj2.getString("code");
            codeToObject.put(code, obj2);
        }
        HashMap<JSONObject, Integer> levelMap = new HashMap<JSONObject, Integer>();
        for (JSONObject obj3 : list) {
            int level = 0;
            String parentId = obj3.getString("parentId");
            while (parentId != null) {
                ++level;
                JSONObject parent = (JSONObject)codeToObject.get(parentId);
                if (parent == null) break;
                parentId = parent.getString("parentId");
            }
            levelMap.put(obj3, level);
        }
        return list.stream().sorted(Comparator.comparingInt(levelMap::get).thenComparing(obj -> AgileDataPublish.isOtherType((String)obj.getString("code")) ? 1 : 0).thenComparing(obj -> obj.getString("code"))).collect(Collectors.toList());
    }

    private static boolean isOtherType(String code) {
        return code != null && code.toLowerCase().contains("other");
    }
}

