/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.publish;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.domain.TenantUser;
import com.digiwin.athena.athena_deployer_service.domain.application.CollectionDomain;
import com.digiwin.athena.athena_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.athena_deployer_service.http.km.KmApiHelper;
import com.digiwin.athena.athena_deployer_service.service.deploy.TenantService;
import com.digiwin.athena.athena_deployer_service.util.Neo4jMultipleUtil;
import com.digiwin.athena.athena_deployer_service.util.SafeFileUtils;
import com.mongodb.MongoWriteException;
import com.mongodb.client.model.Filters;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.neo4j.driver.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class BaseCustomPublishService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseCustomPublishService.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    protected Driver driver1;
    @Autowired(required=false)
    @Qualifier(value="domain2Driver")
    protected Driver driver2;
    @Autowired
    private TenantService tenantService;
    @Autowired
    protected KmApiHelper kmApiHelper;

    public void deleteMongoData(CollectionDomain collectionDomain, String version, List<Object> pkValueList) {
        if (CollUtil.isNotEmpty(pkValueList)) {
            Bson bson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"version", (Object)version), Filters.in((String)collectionDomain.getPrimaryKey(), pkValueList)});
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(collectionDomain.getDatabaseName()).getCollection(collectionDomain.getCollection()).deleteMany(bson);
        }
    }

    public void deleteNeo4jData(CollectionDomain collectionDomain, String version, List<Object> pkValueList) {
        if (CollUtil.isNotEmpty(pkValueList)) {
            String deleteMonitorCql = StrUtil.format((CharSequence)"MATCH (n:{}) where n.{} in $pkValueList and n.version = $version detach delete n", (Object[])new Object[]{StrUtil.upperFirst((CharSequence)collectionDomain.getCollection()), collectionDomain.getPrimaryKey()});
            Neo4jMultipleUtil.executeCql((String)deleteMonitorCql, (Map)MapUtil.builder(new HashMap()).put((Object)"pkValueList", pkValueList).put((Object)"version", (Object)version).build(), (Driver[])new Driver[]{this.driver1, this.driver2});
        }
    }

    public void insertMongoDataWithCompileFile(CollectionDomain collectionDomain, String application, String path, String compileVersion, String deployVersion, List<Object> pkValueList) {
        if (CollUtil.isEmpty(pkValueList)) {
            return;
        }
        File file = SafeFileUtils.createFile((String)(path + File.separator + collectionDomain.getDatabaseName() + File.separator + collectionDomain.getCollection() + File.separator + compileVersion + ".json"));
        if (file.exists()) {
            List data = FileUtil.readLines((File)file, (Charset)Charset.forName("utf-8"));
            for (String line : data) {
                Document document = Document.parse((String)line);
                if (!pkValueList.contains(document.getString((Object)collectionDomain.getPrimaryKey()))) continue;
                document.remove((Object)"_id");
                document.remove((Object)"isMigrate");
                document.put("athena_namespace", (Object)application);
                document.put("compileVersion", (Object)compileVersion);
                document.put("application", (Object)application);
                document.put("version", (Object)deployVersion);
                try {
                    this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(collectionDomain.getDatabaseName()).getCollection(collectionDomain.getCollection()).insertOne((Object)document);
                }
                catch (MongoWriteException e) {
                    log.error("insert data error: ", (Throwable)e);
                }
            }
        }
    }

    public List<JSONObject> collectMongoData(CollectionDomain collectionDomain, String path, String compileVersion, List<Object> pkValueList) {
        ArrayList<JSONObject> res = new ArrayList<JSONObject>();
        if (CollUtil.isEmpty(pkValueList)) {
            return res;
        }
        File file = SafeFileUtils.createFile((String)(path + File.separator + collectionDomain.getDatabaseName() + File.separator + collectionDomain.getCollection() + File.separator + compileVersion + ".json"));
        if (file.exists()) {
            List data = FileUtil.readLines((File)file, (Charset)Charset.forName("utf-8"));
            for (String line : data) {
                JSONObject jsonObject = JSONObject.parseObject((String)line);
                if (!pkValueList.contains(jsonObject.getString(collectionDomain.getPrimaryKey()))) continue;
                jsonObject.remove((Object)"_id");
                jsonObject.remove((Object)"isMigrate");
                jsonObject.put("version", (Object)"1.0");
                res.add(jsonObject);
            }
        }
        return res;
    }

    public void insertNeo4jDataWithCompileFile(CollectionDomain collectionDomain, String path, String compileVersion, String deployVersion, List<Object> pkValueList) {
        if (CollUtil.isEmpty(pkValueList)) {
            return;
        }
        List cqlList = this.collectNeo4jData(collectionDomain, path, compileVersion, deployVersion, pkValueList);
        for (String cql : cqlList) {
            cql = cql.replaceAll("\\{athena_version}", deployVersion);
            cql = cql.replaceAll("\\{common_version}", deployVersion);
            Neo4jMultipleUtil.executeCql((String)cql, (Driver[])new Driver[]{this.driver1, this.driver2});
        }
    }

    public List<String> collectNeo4jData(CollectionDomain collectionDomain, String path, String compileVersion, String deployVersion, List<Object> pkValueList) {
        ArrayList<String> res = new ArrayList<String>();
        if (CollUtil.isEmpty(pkValueList)) {
            return res;
        }
        File cypherFile = SafeFileUtils.createFile((String)(path + File.separator + "cypher" + File.separator + compileVersion + ".json"));
        if (cypherFile.exists()) {
            List cqlList = FileUtil.readLines((File)cypherFile, (Charset)Charset.forName("utf-8"));
            cqlList = cqlList.stream().filter(cql -> cql.contains(StrUtil.format((CharSequence)"create (node:{}", (Object[])new Object[]{collectionDomain.getCollection()}))).collect(Collectors.toList());
            for (String cql2 : cqlList) {
                Boolean isPublishEntity = false;
                for (Object pkValue : pkValueList) {
                    String primaryKey = collectionDomain.getPrimaryKey();
                    if (!cql2.contains(primaryKey + ":'" + String.valueOf(pkValue) + "'")) continue;
                    isPublishEntity = true;
                    break;
                }
                if (!isPublishEntity.booleanValue()) continue;
                res.add(cql2);
            }
        }
        return res;
    }

    public List<String> collectCql(String path, String compileVersion) {
        File cypherFile = SafeFileUtils.createFile((String)(path + File.separator + "cypher" + File.separator + compileVersion + ".json"));
        if (cypherFile.exists()) {
            List cqlList = FileUtil.readLines((File)cypherFile, (Charset)Charset.forName("utf-8"));
            return cqlList;
        }
        return Collections.EMPTY_LIST;
    }

    public List<JSONObject> collectMongo(CollectionDomain collectionDomain, String path, String compileVersion) {
        ArrayList<JSONObject> res = new ArrayList<JSONObject>();
        File file = SafeFileUtils.createFile((String)(path + File.separator + collectionDomain.getDatabaseName() + File.separator + collectionDomain.getCollection() + File.separator + compileVersion + ".json"));
        if (file.exists()) {
            List data = FileUtil.readLines((File)file, (Charset)Charset.forName("utf-8"));
            for (String line : data) {
                JSONObject jsonObject = JSONObject.parseObject((String)line);
                jsonObject.remove((Object)"_id");
                jsonObject.remove((Object)"isMigrate");
                jsonObject.put("version", (Object)"1.0");
                res.add(jsonObject);
            }
        }
        return res;
    }

    public List<TenantUser> getTenantUsersByTenantId(String tenantId) {
        String[] ucTenantIdList = tenantId.split(";");
        ArrayList<TenantUser> ucTenantUsers = new ArrayList<TenantUser>();
        for (String ti : ucTenantIdList) {
            JSONObject jsonObject = this.tenantService.queryUserTenants(ti);
            if (jsonObject.getInteger("code") == null || 200 != jsonObject.getInteger("code")) continue;
            List data = jsonObject.getJSONArray("data").toJavaList(JSONObject.class);
            Long sid = data.stream().filter(da -> ti.equals(da.getString("id"))).findFirst().orElse(new JSONObject()).getLong("sid");
            if (null == sid) {
                throw new BusinessException(ti + "\u79df\u6237\u5bf9\u5e94sid\u672a\u627e\u5230\uff01");
            }
            ucTenantUsers.add(new TenantUser().setTenantId(ti).setOption(Integer.valueOf(1)).setTenantSid(sid));
        }
        return ucTenantUsers;
    }

    public CollectionDomain getCollectionDomainFromCompile(File compileDataDirector, String compileVersion, String CollectionName) {
        String path = compileDataDirector.getPath();
        File collectionPkFile = SafeFileUtils.createFile((String)(path + File.separator + "designer" + File.separator + "collectionPk" + File.separator + compileVersion + ".json"));
        CollectionDomain collectionDomain = new CollectionDomain();
        if (collectionPkFile.exists()) {
            List data = FileUtil.readLines((File)collectionPkFile, (Charset)Charset.forName("utf-8"));
            List collectionDomains = data.stream().map(item -> (CollectionDomain)JSON.parseObject((String)item, CollectionDomain.class)).collect(Collectors.toList());
            collectionDomain = collectionDomains.stream().filter(cd -> cd.getCollection().equals(CollectionName)).findFirst().orElse(new CollectionDomain());
        }
        return collectionDomain;
    }
}

