/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.publish;

import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.domain.TenantUser;
import com.digiwin.athena.athena_deployer_service.domain.application.CollectionDomain;
import com.digiwin.athena.athena_deployer_service.domain.deploy.CustomPublishParam;
import com.digiwin.athena.athena_deployer_service.domain.dsl.Dsl;
import com.digiwin.athena.athena_deployer_service.domain.form.Form;
import com.digiwin.athena.athena_deployer_service.domain.form.LaunchProject;
import com.digiwin.athena.athena_deployer_service.domain.system.AthenaUser;
import com.digiwin.athena.athena_deployer_service.http.designer.DesignerApiHelper;
import com.digiwin.athena.athena_deployer_service.http.km.dto.DeployAppReqDto;
import com.digiwin.athena.athena_deployer_service.publish.BaseCustomPublishService;
import com.digiwin.athena.athena_deployer_service.publish.CustomPublish;
import com.digiwin.athena.athena_deployer_service.publish.ModelDrivenPublish;
import com.digiwin.athena.athena_deployer_service.service.deploy.AsyncService;
import com.digiwin.athena.athena_deployer_service.service.deploy.PageDesignService;
import com.digiwin.athena.athena_deployer_service.service.deploy.TenantService;
import com.digiwin.athena.athena_deployer_service.util.PageDesignPublishUtil;
import com.digiwin.athena.athena_deployer_service.util.SafeFileUtils;
import com.digiwin.athena.athena_deployer_service.util.TemplatePublishUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DataEntryPublish
extends BaseCustomPublishService
implements CustomPublish {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataEntryPublish.class);
    @Autowired
    private PageDesignService pageDesignService;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private ModelDrivenPublish modelDrivenPublish;
    @Value(value="${envMode}")
    private String envMode;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private AsyncService asyncService;
    @Autowired
    private DesignerApiHelper designerApiHelper;
    @Autowired
    private TemplatePublishUtil templatePublishUtil;

    public void publishWithCompile(CustomPublishParam customPublishParam) {
        List publishEntityList = customPublishParam.getPublishEntityList();
        File compileDataDirector = customPublishParam.getCompileDataDirector();
        String compileVersion = customPublishParam.getCompileVersion();
        AthenaUser currentUser = customPublishParam.getCurrentUser();
        String application = customPublishParam.getApplication();
        String deployVersion = customPublishParam.getDeployVersion();
        Boolean commonApp = customPublishParam.getCommonApp();
        List tenantUsers = customPublishParam.getTenantUsers();
        List pkValueList = publishEntityList.stream().filter(publishEntity -> "DataEntry".equals(publishEntity.getType())).map(publishEntity -> publishEntity.getPkValue()).collect(Collectors.toList());
        CollectionDomain collectionDomain = new CollectionDomain().setCollection("Activity").setPrimaryKey("code");
        String path = compileDataDirector.getPath();
        if ("new".equals(customPublishParam.getPublishMode())) {
            DeployAppReqDto deployAppReqDto = DeployAppReqDto.create((CustomPublishParam)customPublishParam);
            List cyphers = super.collectNeo4jData(collectionDomain, path, compileVersion, deployVersion, pkValueList);
            deployAppReqDto.setSinglePublishNeo4jData(cyphers, pkValueList, collectionDomain);
            if (!deployAppReqDto.appDataIsEmpty()) {
                this.kmApiHelper.deployApp(deployAppReqDto, customPublishParam.getCurrentUser().getTenantId());
            }
        }
        String appToken = customPublishParam.getAppToken();
        File modelFile = SafeFileUtils.createFile((String)(path + File.separator + "designer" + File.separator + "modelDriven" + File.separator + compileVersion + ".json"));
        if (modelFile.exists()) {
            List data = FileUtil.readLines((File)modelFile, (Charset)Charset.forName("utf-8"));
            data = data.stream().map(s -> s.replaceAll("\\{athena_version}", "1.0")).collect(Collectors.toList());
            List pageDesignList = data.stream().map(item -> (JSONObject)JSON.parseObject((String)item, JSONObject.class)).filter(item -> pkValueList.contains(item.getString("code"))).collect(Collectors.toList());
            JSONObject extProperties = customPublishParam.getExtProperties();
            String apimgmtUrl = "";
            String apimgmtIntegrationToken = "";
            if (ObjectUtils.isNotEmpty((Object)extProperties)) {
                apimgmtUrl = extProperties.getString("apimgmtUrl");
                apimgmtIntegrationToken = extProperties.getString("apimgmtIntegrationToken");
            }
            for (Object tenantUser : tenantUsers) {
                String targetTenantId = tenantUser.getTenantId();
                for (JSONObject jsonObject : pageDesignList) {
                    this.modelDrivenPublish.justModelPublish(targetTenantId, this.envMode, jsonObject, apimgmtIntegrationToken, appToken, currentUser.getTenantId(), customPublishParam.getApplication(), true, apimgmtUrl);
                }
            }
            JSONArray totalRelateViews = new JSONArray();
            for (JSONObject model : pageDesignList) {
                JSONArray relateViews = model.getJSONArray("relateViews");
                totalRelateViews.addAll((Collection)relateViews);
            }
            if (CollectionUtils.isEmpty((Collection)totalRelateViews)) {
                return;
            }
            if ("new".equals(customPublishParam.getPublishMode())) {
                collectionDomain = new CollectionDomain().setCollection("knowledgegraphSystem").setCollection("dataView").setPrimaryKey("code");
                List mongoData = super.collectMongoData(collectionDomain, path, compileVersion, (List)totalRelateViews);
                for (JSONObject mongoDatum : mongoData) {
                    try {
                        DeployAppReqDto deployAppReqDto = DeployAppReqDto.create((CustomPublishParam)customPublishParam);
                        deployAppReqDto.setSinglePublishMongoData(Arrays.asList(mongoDatum), (List)totalRelateViews, collectionDomain);
                        if (deployAppReqDto.appDataIsEmpty()) break;
                        this.kmApiHelper.deployApp(deployAppReqDto, customPublishParam.getCurrentUser().getTenantId());
                        for (TenantUser tenantUser : tenantUsers) {
                            this.asyncService.moduleAssignPublishRecord(tenantUser.getTenantId(), this.envMode, customPublishParam.getApplication(), mongoDatum.getString("code"), "DATA_VIEW", mongoDatum.getString("productCode"), null);
                        }
                    }
                    catch (Exception e) {
                        log.error("insert data error: ", (Throwable)e);
                    }
                }
            }
        }
    }

    private void publish(String application, String token, String appToken, List<TenantUser> tenantUsers, JSONObject pageDesign) {
        List tenantIds = tenantUsers.stream().map(tenantUser -> tenantUser.getTenantId()).collect(Collectors.toList());
        String code = pageDesign.getString("code");
        Form form = (Form)pageDesign.getObject("form", Form.class);
        JSONObject activity = new JSONObject();
        activity.put("code", (Object)code);
        activity.put("name", (Object)form.getFormName().getZh_CN());
        try {
            Dsl dsl = (Dsl)pageDesign.getObject("detailDsl", Dsl.class);
            Map componentMapping = PageDesignPublishUtil.handleComponentIdMapping((Form)form);
            JSONObject params = new JSONObject();
            if (componentMapping != null) {
                params = PageDesignPublishUtil.handleDslInfo((Dsl)dsl, (Map)componentMapping);
            }
            PageDesignPublishUtil.handleLaunchProjectInfo((JSONObject)params, (LaunchProject)((LaunchProject)JSON.parseObject((String)JSON.toJSONString((Object)pageDesign.get((Object)"launchProject")), LaunchProject.class)));
            this.pageDesignService.schemaPublish(token, appToken, tenantIds, form, params);
        }
        catch (Exception e) {
            log.error("schema\u53d1\u5e03\u5931\u8d25!pageDesignCode:" + pageDesign.getString("code"), (Throwable)e);
        }
        try {
            List tableInfo = PageDesignPublishUtil.handleTbbTableInfo((Form)form);
            this.pageDesignService.tbbPublish(token, "HuaweiTest-TEST", "table", application, tableInfo);
        }
        catch (Exception e) {
            log.error("tbb\u53d1\u5e03\u5931\u8d25!", (Throwable)e);
        }
    }
}

