/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.publish;

import com.digiwin.athena.athena_deployer_service.domain.application.CollectionDomain;
import com.digiwin.athena.athena_deployer_service.domain.deploy.CustomPublishParam;
import com.digiwin.athena.athena_deployer_service.domain.system.AthenaUser;
import com.digiwin.athena.athena_deployer_service.http.designer.DesignerApiHelper;
import com.digiwin.athena.athena_deployer_service.http.km.dto.DeployAppReqDto;
import com.digiwin.athena.athena_deployer_service.publish.BaseCustomPublishService;
import com.digiwin.athena.athena_deployer_service.publish.CustomPublish;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataStatePublish
extends BaseCustomPublishService
implements CustomPublish {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataStatePublish.class);
    @Autowired
    private DesignerApiHelper designerApiHelper;

    public void publishWithCompile(CustomPublishParam customPublishParam) {
        List publishEntityList = customPublishParam.getPublishEntityList();
        List relatedEntityList = publishEntityList.stream().filter(publishEntity -> publishEntity.getType().equals("dataDescription")).collect(Collectors.toList());
        String deployVersion = customPublishParam.getDeployVersion();
        File compileDataDirector = customPublishParam.getCompileDataDirector();
        String compileVersion = customPublishParam.getCompileVersion();
        String application = customPublishParam.getApplication();
        AthenaUser currentUser = customPublishParam.getCurrentUser();
        List namespacePathList = relatedEntityList.stream().map(relatedEntity -> relatedEntity.getType() + "&" + String.valueOf(relatedEntity.getPkValue())).collect(Collectors.toList());
        CollectionDomain collectionDomain = this.getCollectionDomainFromCompile(compileDataDirector, compileVersion, "dataState");
        collectionDomain.setPrimaryKey("namespacePath");
        String path = compileDataDirector.getPath();
        if ("new".equals(customPublishParam.getPublishMode())) {
            DeployAppReqDto deployAppReqDto = DeployAppReqDto.create((CustomPublishParam)customPublishParam);
            List mongoData = super.collectMongoData(collectionDomain, path, compileVersion, namespacePathList);
            deployAppReqDto.setSinglePublishMongoData(mongoData, namespacePathList, collectionDomain);
            if (deployAppReqDto.appDataIsEmpty()) {
                return;
            }
            this.kmApiHelper.deployApp(deployAppReqDto, customPublishParam.getCurrentUser().getTenantId());
        }
    }
}

