/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.publish;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.domain.TenantUser;
import com.digiwin.athena.athena_deployer_service.domain.application.CollectionDomain;
import com.digiwin.athena.athena_deployer_service.domain.deploy.CustomPublishParam;
import com.digiwin.athena.athena_deployer_service.domain.system.AthenaUser;
import com.digiwin.athena.athena_deployer_service.http.km.dto.DeployAppReqDto;
import com.digiwin.athena.athena_deployer_service.publish.BaseCustomPublishService;
import com.digiwin.athena.athena_deployer_service.publish.CustomPublish;
import com.digiwin.athena.athena_deployer_service.service.deploy.AsyncService;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DataViewPublish
extends BaseCustomPublishService
implements CustomPublish {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataViewPublish.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private AsyncService asyncService;
    @Value(value="${envMode}")
    private String envMode;

    public void publishWithCompile(CustomPublishParam customPublishParam) {
        List publishEntityList = customPublishParam.getPublishEntityList();
        File compileDataDirector = customPublishParam.getCompileDataDirector();
        String compileVersion = customPublishParam.getCompileVersion();
        List tenantUsers = customPublishParam.getTenantUsers();
        AthenaUser currentUser = customPublishParam.getCurrentUser();
        List pkValueList = publishEntityList.stream().filter(publishEntity -> "dataView".equals(publishEntity.getType())).map(publishEntity -> publishEntity.getPkValue()).collect(Collectors.toList());
        String path = compileDataDirector.getPath();
        if ("new".equals(customPublishParam.getPublishMode())) {
            DeployAppReqDto deployAppReqDto = DeployAppReqDto.create((CustomPublishParam)customPublishParam);
            if (!CollectionUtils.isEmpty(pkValueList)) {
                CollectionDomain collectionDomain = new CollectionDomain().setDatabaseName("knowledgegraphSystem").setCollection("dataView").setPrimaryKey("code");
                List mongoData = super.collectMongoData(collectionDomain, path, compileVersion, pkValueList);
                for (JSONObject mongoDatum : mongoData) {
                    if (!mongoDatum.containsKey((Object)"dataView")) continue;
                    JSONObject dataView = mongoDatum.getJSONObject("dataView");
                    mongoDatum.remove((Object)"dataView");
                    for (Map.Entry entry : dataView.entrySet()) {
                        mongoDatum.put((String)entry.getKey(), entry.getValue());
                    }
                }
                deployAppReqDto.setSinglePublishMongoData(mongoData, pkValueList, collectionDomain);
                if (deployAppReqDto.appDataIsEmpty()) {
                    return;
                }
                this.kmApiHelper.deployApp(deployAppReqDto, customPublishParam.getCurrentUser().getTenantId());
                for (JSONObject dataView : mongoData) {
                    for (TenantUser tenantUser : tenantUsers) {
                        this.asyncService.moduleAssignPublishRecord(tenantUser.getTenantId(), this.envMode, customPublishParam.getApplication(), dataView.getString("code"), "DATA_VIEW", dataView.getString("productCode"), null);
                    }
                }
            }
        }
    }
}

