/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.publish;

import cn.hutool.core.io.FileUtil;
import com.digiwin.athena.athena_deployer_service.domain.application.CollectionDomain;
import com.digiwin.athena.athena_deployer_service.domain.deploy.CustomPublishParam;
import com.digiwin.athena.athena_deployer_service.domain.deploy.PublishEntity;
import com.digiwin.athena.athena_deployer_service.domain.system.AthenaUser;
import com.digiwin.athena.athena_deployer_service.http.km.dto.DeployAppReqDto;
import com.digiwin.athena.athena_deployer_service.publish.BaseCustomPublishService;
import com.digiwin.athena.athena_deployer_service.publish.CustomPublish;
import com.digiwin.athena.athena_deployer_service.util.SafeFileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class ExtendFieldPublish
extends BaseCustomPublishService
implements CustomPublish {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtendFieldPublish.class);
    @Autowired
    private MongoTemplate mongoTemplate;

    public void publishWithCompile(CustomPublishParam customPublishParam) {
        List publishEntityList = customPublishParam.getPublishEntityList().stream().filter(publishEntity -> "extend".equals(publishEntity.getType())).collect(Collectors.toList());
        String deployVersion = customPublishParam.getDeployVersion();
        File compileDataDirector = customPublishParam.getCompileDataDirector();
        String compileVersion = customPublishParam.getCompileVersion();
        String application = customPublishParam.getApplication();
        String path = compileDataDirector.getPath();
        for (PublishEntity publishEntity2 : publishEntityList) {
            String extendFieldDataPath = publishEntity2.getExtendFieldDataPath();
            String pkField = publishEntity2.getExtendFieldPkField();
            String[] split = extendFieldDataPath.split("/");
            String dbType = split[0];
            String dbName = split[1];
            String collectionName = split[2];
            File extendFieldFile = SafeFileUtils.createFile((String)(path + File.separator + dbName + File.separator + collectionName + File.separator + compileVersion + ".json"));
            if (!extendFieldFile.exists()) continue;
            List extendFieldDataStrList = FileUtil.readLines((File)extendFieldFile, (String)"utf-8");
            for (String line : extendFieldDataStrList) {
                Document document = Document.parse((String)line);
                Boolean fromAthenaExtend = document.getBoolean((Object)"_fromAthenaExtend");
                if (fromAthenaExtend == null || !fromAthenaExtend.booleanValue()) continue;
                Object pkValue = document.get((Object)pkField);
                if (!"new".equals(customPublishParam.getPublishMode())) continue;
                AthenaUser currentUser = customPublishParam.getCurrentUser();
                CollectionDomain collectionDomain = new CollectionDomain().setPrimaryKey(pkField).setCollection(collectionName).setDatabaseName(dbName);
                ArrayList<Object> pkValueList = new ArrayList<Object>();
                pkValueList.add(pkValue);
                DeployAppReqDto deployAppReqDto = DeployAppReqDto.create((CustomPublishParam)customPublishParam);
                List mongoData = super.collectMongoData(collectionDomain, path, compileVersion, pkValueList);
                deployAppReqDto.setSinglePublishMongoData(mongoData, pkValueList, collectionDomain);
                if (deployAppReqDto.appDataIsEmpty()) continue;
                this.kmApiHelper.deployApp(deployAppReqDto, currentUser.getTenantId());
            }
        }
    }
}

