/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.publish;

import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.domain.TenantUser;
import com.digiwin.athena.athena_deployer_service.domain.deploy.CustomPublishParam;
import com.digiwin.athena.athena_deployer_service.domain.system.AthenaUser;
import com.digiwin.athena.athena_deployer_service.http.km.KmApiHelper;
import com.digiwin.athena.athena_deployer_service.publish.BaseCustomPublishService;
import com.digiwin.athena.athena_deployer_service.publish.CustomPublish;
import com.digiwin.athena.athena_deployer_service.publish.ModelDrivenPublish;
import com.digiwin.athena.athena_deployer_service.service.deploy.AsyncService;
import com.digiwin.athena.athena_deployer_service.util.SafeFileUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class KitAssignPublish
extends BaseCustomPublishService
implements CustomPublish {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KitAssignPublish.class);
    @Autowired
    private AsyncService asyncService;
    @Autowired
    private KmApiHelper kmApiHelper;
    @Value(value="${envMode}")
    private String envMode;
    @Autowired
    ModelDrivenPublish modelDrivenPublish;

    public void publishWithCompile(CustomPublishParam customPublishParam) {
        List publishEntityList = customPublishParam.getPublishEntityList();
        File compileDataDirector = customPublishParam.getCompileDataDirector();
        String compileVersion = customPublishParam.getCompileVersion();
        AthenaUser currentUser = customPublishParam.getCurrentUser();
        List pkValueList = publishEntityList.stream().filter(publishEntity -> "kitAssign".equals(publishEntity.getType())).map(publishEntity -> publishEntity.getPkValue()).collect(Collectors.toList());
        String path = compileDataDirector.getPath();
        String appToken = customPublishParam.getAppToken();
        File modelFile = SafeFileUtils.createFile((String)(path + File.separator + "designer" + File.separator + "kitAssign" + File.separator + compileVersion + ".json"));
        List tenantUsers = customPublishParam.getTenantUsers();
        if (modelFile.exists()) {
            List data = FileUtil.readLines((File)modelFile, (Charset)Charset.forName("utf-8"));
            data = data.stream().map(s -> s.replaceAll("\\{athena_version}", "1.0")).collect(Collectors.toList());
            List kitData = data.stream().map(item -> (JSONObject)JSON.parseObject((String)item, JSONObject.class)).filter(item -> pkValueList.contains(item.getString("code"))).collect(Collectors.toList());
            for (TenantUser tenantUser : tenantUsers) {
                String targetTenantId = tenantUser.getTenantId();
                for (JSONObject jsonObject : kitData) {
                    this.justKitPublish(targetTenantId, this.envMode, jsonObject, currentUser.getTenantId(), customPublishParam.getApplication());
                }
            }
        }
    }

    public void justKitPublish(String targetTenantId, String designerDomain, JSONObject data, String tenantId, String application) {
        String code = data.getString("code");
        JSONObject publishKitAssignInfo = data.getJSONObject("publishKitAssignInfo");
        if (Objects.nonNull(publishKitAssignInfo)) {
            JSONObject kitAssign = publishKitAssignInfo.getJSONObject("kitAssign");
            kitAssign.put("targetTenantId", (Object)targetTenantId);
            ArrayList<JSONObject> sets = new ArrayList<JSONObject>();
            sets.add(kitAssign);
            JSONObject body = new JSONObject();
            body.put("sets", sets);
            body.put("tenantId", (Object)tenantId);
            this.kmApiHelper.compileAndSaveSets(body);
            this.asyncService.moduleAssignPublishRecord(targetTenantId, designerDomain, application, code, "KIT_ASSIGN", "", null);
        }
    }
}

