/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.publish;

import cn.hutool.core.io.FileUtil;
import com.digiwin.athena.athena_deployer_service.domain.TenantUser;
import com.digiwin.athena.athena_deployer_service.domain.deploy.CustomPublishParam;
import com.digiwin.athena.athena_deployer_service.domain.deploy.PublishEntity;
import com.digiwin.athena.athena_deployer_service.domain.system.AthenaUser;
import com.digiwin.athena.athena_deployer_service.http.designer.DesignerApiHelper;
import com.digiwin.athena.athena_deployer_service.service.deploy.AsyncService;
import com.digiwin.athena.athena_deployer_service.service.deploy.PageDesignService;
import com.digiwin.athena.athena_deployer_service.service.deploy.TenantService;
import com.digiwin.athena.athena_deployer_service.util.SafeFileUtils;
import com.mongodb.MongoWriteException;
import com.mongodb.client.model.Filters;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MobilePageDesignPublish {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MobilePageDesignPublish.class);
    @Autowired
    private PageDesignService pageDesignService;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private AsyncService asyncService;
    @Value(value="${envMode}")
    private String envMode;
    @Autowired
    private DesignerApiHelper designerApiHelper;

    public void publishWithCompile(CustomPublishParam customPublishParam) {
        File mobilePageDesignFile;
        List publishEntityList = customPublishParam.getPublishEntityList();
        File compileDataDirector = customPublishParam.getCompileDataDirector();
        String compileVersion = customPublishParam.getCompileVersion();
        List tenantUsers = customPublishParam.getTenantUsers();
        AthenaUser currentUser = customPublishParam.getCurrentUser();
        List pkValueList = publishEntityList.stream().filter(publishEntity -> "mobilePageDesign".equals(publishEntity.getType())).map(PublishEntity::getPkValue).collect(Collectors.toList());
        String path = compileDataDirector.getPath();
        Bson bson = !CollectionUtils.isEmpty(pkValueList) ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"version", (Object)customPublishParam.getDeployVersion()), Filters.eq((String)"application", (Object)customPublishParam.getApplication()), Filters.eq((String)"code", pkValueList.get(0))}) : Filters.and((Bson[])new Bson[]{Filters.eq((String)"version", (Object)customPublishParam.getDeployVersion()), Filters.eq((String)"application", (Object)customPublishParam.getApplication())});
        File workbenchFile = SafeFileUtils.createFile((String)(path + File.separator + "knowledgegraphSystem" + File.separator + "workbench" + File.separator + compileVersion + ".json"));
        if (workbenchFile.exists()) {
            List workbenchData = FileUtil.readLines((File)workbenchFile, (Charset)StandardCharsets.UTF_8);
            for (String workbenchLine : workbenchData) {
                Document workbench = Document.parse((String)workbenchLine);
                Bson workBenchBson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"version", (Object)customPublishParam.getDeployVersion()), Filters.eq((String)"application", (Object)customPublishParam.getApplication()), Filters.eq((String)"code", (Object)workbench.get((Object)"code"))});
                workbench.put("athena_namespace", (Object)customPublishParam.getApplication());
                workbench.put("compileVersion", (Object)compileVersion);
                workbench.put("version", (Object)"1.0");
            }
        }
        if ((mobilePageDesignFile = SafeFileUtils.createFile((String)(path + File.separator + "knowledgegraphSystem" + File.separator + "mobilePageDesign" + File.separator + compileVersion + ".json"))).exists()) {
            List data = FileUtil.readLines((File)mobilePageDesignFile, (Charset)StandardCharsets.UTF_8);
            for (String line : data) {
                Document mobilePageDesign = Document.parse((String)line);
                mobilePageDesign.put("athena_namespace", (Object)customPublishParam.getApplication());
                mobilePageDesign.put("compileVersion", (Object)compileVersion);
                mobilePageDesign.put("version", (Object)"1.0");
                try {
                    for (TenantUser tenantUser : tenantUsers) {
                        this.asyncService.moduleAssignPublishRecord(tenantUser.getTenantId(), this.envMode, customPublishParam.getApplication(), mobilePageDesign.getString((Object)"code"), "MOBILE_PAGE_DESIGN", "", null);
                    }
                }
                catch (MongoWriteException e) {
                    log.error("insert data error: ", (Throwable)e);
                }
            }
        }
    }
}

