/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.publish;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.domain.TenantUser;
import com.digiwin.athena.athena_deployer_service.domain.deploy.CustomPublishParam;
import com.digiwin.athena.athena_deployer_service.domain.system.AthenaUser;
import com.digiwin.athena.athena_deployer_service.http.designer.DesignerApiHelper;
import com.digiwin.athena.athena_deployer_service.http.esp.EspApiHelper;
import com.digiwin.athena.athena_deployer_service.publish.BaseCustomPublishService;
import com.digiwin.athena.athena_deployer_service.publish.CustomPublish;
import com.digiwin.athena.athena_deployer_service.service.apimgmt.ApimgmtService;
import com.digiwin.athena.athena_deployer_service.service.deploy.AsyncService;
import com.digiwin.athena.athena_deployer_service.service.iam.IamService;
import com.digiwin.athena.athena_deployer_service.util.SafeFileUtils;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import java.io.File;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ModelDrivenPublish
extends BaseCustomPublishService
implements CustomPublish {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelDrivenPublish.class);
    @Autowired
    private DesignerApiHelper designerApiHelper;
    @Autowired
    private ApimgmtService apimgmtService;
    @Autowired
    private IamService iamService;
    @Autowired
    private AsyncService asyncService;
    @Autowired
    private EspApiHelper espApiHelper;
    @Value(value="${envMode}")
    private String envMode;
    @Autowired
    private MongoTemplate mongoTemplate;

    public void publishWithCompile(CustomPublishParam customPublishParam) {
        List publishEntityList = customPublishParam.getPublishEntityList();
        File compileDataDirector = customPublishParam.getCompileDataDirector();
        String compileVersion = customPublishParam.getCompileVersion();
        AthenaUser currentUser = customPublishParam.getCurrentUser();
        List pkValueList = publishEntityList.stream().filter(publishEntity -> "modelDriven".equals(publishEntity.getType())).map(publishEntity -> publishEntity.getPkValue()).collect(Collectors.toList());
        String path = compileDataDirector.getPath();
        String appToken = customPublishParam.getAppToken();
        File modelFile = SafeFileUtils.createFile((String)(path + File.separator + "designer" + File.separator + "modelDriven" + File.separator + compileVersion + ".json"));
        if (modelFile.exists()) {
            List data = FileUtil.readLines((File)modelFile, (Charset)Charset.forName("utf-8"));
            List modelData = (data = data.stream().map(s -> s.replaceAll("\\{athena_version}", "1.0")).collect(Collectors.toList())).stream().map(item -> (JSONObject)JSON.parseObject((String)item, JSONObject.class)).filter(item -> pkValueList.contains(item.getString("code"))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(modelData)) {
                log.info("no models to be published");
                return;
            }
            JSONObject extProperties = customPublishParam.getExtProperties();
            String apimgmtUrl = "";
            String apimgmtIntegrationToken = "";
            if (ObjectUtils.isNotEmpty((Object)extProperties)) {
                apimgmtUrl = extProperties.getString("apimgmtUrl");
                apimgmtIntegrationToken = extProperties.getString("apimgmtIntegrationToken");
            }
            List tenantUsers = customPublishParam.getTenantUsers();
            for (TenantUser tenantUser : tenantUsers) {
                String targetTenantId = tenantUser.getTenantId();
                for (JSONObject jsonObject : modelData) {
                    this.justModelPublish(targetTenantId, this.envMode, jsonObject, apimgmtIntegrationToken, appToken, currentUser.getTenantId(), customPublishParam.getApplication(), false, apimgmtUrl);
                }
            }
        }
    }

    public void justModelPublish(String targetTenantId, String designerDomain, JSONObject data, String token, String appToken, String tenantId, String application, boolean isAssign, String apimgmtUrl) {
        String code = data.getString("code");
        JSONObject publishModelDrivenInfo = data.getJSONObject("publishModelDrivenInfo");
        if (Objects.isNull(publishModelDrivenInfo)) {
            if (isAssign) {
                this.asyncService.moduleAssignPublishRecord(targetTenantId, designerDomain, application, code, "DATA_ENTRY", "", null);
            }
            return;
        }
        String serviceCode = publishModelDrivenInfo.getString("serviceCode");
        JSONArray publishModels = publishModelDrivenInfo.getJSONArray("publishModels");
        if (Objects.isNull(publishModels)) {
            if (isAssign) {
                this.asyncService.moduleAssignPublishRecord(targetTenantId, designerDomain, application, code, "DATA_ENTRY", serviceCode, null);
            }
            return;
        }
        if (isAssign) {
            this.asyncService.moduleAssignPublishRecord(targetTenantId, designerDomain, application, code, "DATA_ENTRY", serviceCode, null);
        }
        HashMap<String, String> modelComeFromMap = new HashMap<String, String>();
        ArrayList noPublishApis = new ArrayList();
        ArrayList<String> noPublishModelCodes = new ArrayList<String>();
        for (int i = 0; i < publishModels.size(); ++i) {
            String modelCode = publishModels.getJSONObject(i).getString("code");
            String modelComeFrom = publishModels.getJSONObject(i).getString("modelComeFrom");
            modelComeFromMap.put(modelCode, modelComeFrom);
            Date editDate = publishModels.getJSONObject(i).getJSONObject("schema").getDate("editDate");
            JSONObject modelSchema = publishModels.getJSONObject(i).getJSONObject("schema");
            if (this.checkIsNeedPublish(targetTenantId, designerDomain, application, modelCode, editDate, serviceCode, modelSchema)) continue;
            log.info(modelCode + " does not need to be published");
            noPublishModelCodes.add(modelCode);
            this.getNoPublishApis(noPublishApis, modelSchema);
            log.info(String.valueOf(noPublishApis) + " does not need to be published");
        }
        JSONArray publishActionMetaDataInfo = data.getJSONArray("publishActionMetaDataInfo");
        log.info("noPublishApis:{},isAssign:{}", noPublishApis, (Object)isAssign);
        List apiMgmtBaseInfos = this.apimgmtService.publishActionMeataDataToApimgmt(publishActionMetaDataInfo, token, noPublishApis, apimgmtUrl);
        if (ObjectUtil.isNotEmpty((Object)data.get((Object)"deleteApiMetaDataInfos")) && data.getJSONArray("deleteApiMetaDataInfos").size() > 0) {
            this.apimgmtService.deleteApiMetaData(data.getJSONArray("deleteApiMetaDataInfos"), token, apimgmtUrl);
        }
        for (int i = 0; i < publishModels.size(); ++i) {
            String targetProd;
            String modelCode = publishModels.getJSONObject(i).getString("code");
            if (noPublishModelCodes.contains(modelCode)) {
                log.info(modelCode + " does not need to publish to esp");
                continue;
            }
            this.espApiHelper.serviceRegisterToEsp(publishModels.getJSONObject(i), publishModelDrivenInfo.getString("serviceCode"), token, appToken, tenantId);
            JSONObject appInfo = publishModels.getJSONObject(i).getJSONObject("appInfo");
            if (appInfo != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(targetProd = appInfo.getString("targetProd")))) {
                this.espApiHelper.callBMEspService(modelCode, appToken, tenantId, serviceCode, targetProd, apiMgmtBaseInfos, modelComeFromMap);
            }
            JSONObject modelSchema = publishModels.getJSONObject(i).getJSONObject("schema");
            this.asyncService.moduleAssignPublishRecord(targetTenantId, designerDomain, application, modelCode, "MODEL_DRIVEN", serviceCode, modelSchema);
        }
    }

    private void getNoPublishApis(List<String> noPublishModels, JSONObject modelSchema) {
        JSONArray childrenList;
        JSONArray bindApiListConfig = modelSchema.getJSONArray("bindApiListConfig");
        if (null != bindApiListConfig && bindApiListConfig.size() > 0) {
            for (Object apiConfig : bindApiListConfig) {
                noPublishModels.add(((JSONObject)apiConfig).getString("apiName"));
            }
        }
        if (null != (childrenList = modelSchema.getJSONArray("children")) && childrenList.size() > 0) {
            for (Object children : childrenList) {
                this.getNoPublishApis(noPublishModels, (JSONObject)children);
            }
        }
    }

    public boolean checkIsNeedPublish(String targetTenantId, String env, String application, String code, Date editDate, String serviceCode, JSONObject modelSchema) {
        FindIterable documents;
        Document first;
        log.info("models begin to filter by publish record");
        Bson filters = Filters.and((Bson[])new Bson[]{Filters.eq((String)"application", (Object)application), Filters.eq((String)"code", (Object)code), Filters.eq((String)"sourceType", (Object)"MODEL_DRIVEN"), Filters.eq((String)"publishEnv", (Object)this.envMode)});
        if (!StringUtils.isEmpty((Object)serviceCode)) {
            filters = Filters.and((Bson[])new Bson[]{filters, Filters.eq((String)"serviceCode", (Object)serviceCode)});
        }
        if (Objects.isNull(first = (Document)(documents = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("deployer").getCollection("modulePublishRecord").find(filters)).first())) {
            return true;
        }
        try {
            String publishTime = first.getString((Object)"publishTime");
            String md5Record = first.getString((Object)"md5Record");
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)md5Record) && modelSchema != null) {
                String md5RecordCome = DigestUtils.md5Hex((String)JSON.toJSONString((Object)modelSchema));
                return !md5Record.equals(md5RecordCome);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date publishTimeDate = sdf.parse(publishTime);
            int compare = DateUtil.compare((Date)editDate, (Date)publishTimeDate, (String)"yyyy-MM-dd HH:mm:ss");
            if (compare < 0) {
                log.info("{} is no need to publish again", (Object)code);
                return false;
            }
        }
        catch (ParseException e) {
            return true;
        }
        return true;
    }
}

