/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.publish;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.domain.application.CollectionDomain;
import com.digiwin.athena.athena_deployer_service.domain.deploy.CustomPublishParam;
import com.digiwin.athena.athena_deployer_service.domain.system.AthenaUser;
import com.digiwin.athena.athena_deployer_service.http.km.KmApiHelper;
import com.digiwin.athena.athena_deployer_service.http.km.dto.DeployAppReqDto;
import com.digiwin.athena.athena_deployer_service.publish.BaseCustomPublishService;
import com.digiwin.athena.athena_deployer_service.publish.CustomPublish;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MonitorRulePublish
extends BaseCustomPublishService
implements CustomPublish {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitorRulePublish.class);
    @Autowired
    private KmApiHelper kmApiHelper;

    public void publishWithCompile(CustomPublishParam customPublishParam) {
        List publishEntityList = customPublishParam.getPublishEntityList();
        String deployVersion = customPublishParam.getDeployVersion();
        File compileDataDirector = customPublishParam.getCompileDataDirector();
        String application = customPublishParam.getApplication();
        String compileVersion = customPublishParam.getCompileVersion();
        AthenaUser currentUser = customPublishParam.getCurrentUser();
        List pkValueList = publishEntityList.stream().filter(publishEntity -> "monitorRule".equals(publishEntity.getType())).map(publishEntity -> publishEntity.getPkValue()).collect(Collectors.toList());
        CollectionDomain collectionDomain = new CollectionDomain().setCollection("MonitorRule").setPrimaryKey("code");
        JSONObject requestBody = new JSONObject();
        requestBody.put("appCode", (Object)application);
        requestBody.put("version", (Object)"1.0");
        requestBody.put("type", (Object)"publish");
        requestBody.put("objectType", (Object)"monitorRule");
        requestBody.put("tenantId", (Object)currentUser.getTenantId());
        requestBody.put("timeOn", (Object)"begin");
        this.kmApiHelper.publishEventToKM(requestBody);
        String path = compileDataDirector.getPath();
        DeployAppReqDto deployAppReqDto = DeployAppReqDto.create((CustomPublishParam)customPublishParam);
        if ("new".equals(customPublishParam.getPublishMode())) {
            List cqlList = super.collectNeo4jData(collectionDomain, path, compileVersion, deployVersion, pkValueList);
            deployAppReqDto.setSinglePublishNeo4jData(cqlList, pkValueList, collectionDomain);
        }
        collectionDomain.setCollection("monitorRuleProductConfig").setDatabaseName("knowledgegraphSystem").setPrimaryKey("monitorRuleId");
        if ("new".equals(customPublishParam.getPublishMode())) {
            List mongoData = super.collectMongoData(collectionDomain, path, compileVersion, pkValueList);
            deployAppReqDto.setSinglePublishMongoData(mongoData, pkValueList, collectionDomain);
            if (deployAppReqDto.appDataIsEmpty()) {
                return;
            }
            this.kmApiHelper.deployApp(deployAppReqDto, customPublishParam.getCurrentUser().getTenantId());
        }
        requestBody.put("timeOn", (Object)"end");
        this.kmApiHelper.publishEventToKM(requestBody);
    }
}

