/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.publish;

import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.domain.TenantUser;
import com.digiwin.athena.athena_deployer_service.domain.application.CollectionDomain;
import com.digiwin.athena.athena_deployer_service.domain.deploy.CustomPublishParam;
import com.digiwin.athena.athena_deployer_service.domain.system.AthenaUser;
import com.digiwin.athena.athena_deployer_service.http.atmc.AtmcApiHelper;
import com.digiwin.athena.athena_deployer_service.http.designer.DesignerApiHelper;
import com.digiwin.athena.athena_deployer_service.http.km.KmApiHelper;
import com.digiwin.athena.athena_deployer_service.http.km.dto.DeployAppReqDto;
import com.digiwin.athena.athena_deployer_service.publish.BaseCustomPublishService;
import com.digiwin.athena.athena_deployer_service.publish.CustomPublish;
import com.digiwin.athena.athena_deployer_service.service.deploy.AsyncService;
import com.digiwin.athena.athena_deployer_service.service.deploy.TenantService;
import com.digiwin.athena.athena_deployer_service.util.SafeFileUtils;
import com.mongodb.MongoWriteException;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProcessPublish
extends BaseCustomPublishService
implements CustomPublish {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessPublish.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private AsyncService asyncService;
    @Value(value="${envMode}")
    private String envMode;
    @Autowired
    private DesignerApiHelper designerApiHelper;
    @Autowired
    private KmApiHelper kmApiHelper;
    @Autowired
    private AtmcApiHelper atmcApiHelper;
    @Autowired
    private TenantService tenantService;

    public void publishWithCompile(CustomPublishParam customPublishParam) {
        JSONObject compileData = customPublishParam.getCompileData();
        AthenaUser currentUser = customPublishParam.getCurrentUser();
        String application = customPublishParam.getApplication();
        List tenantUsers = customPublishParam.getTenantUsers();
        File compileDataDirector = customPublishParam.getCompileDataDirector();
        String compileVersion = customPublishParam.getCompileVersion();
        String path = compileDataDirector.getPath();
        if (compileData != null && compileData.get((Object)"allowCustomPublish") != null && compileData.getBoolean("allowCustomPublish").booleanValue()) {
            return;
        }
        List publishEntityList = customPublishParam.getPublishEntityList();
        List pkValueList = publishEntityList.stream().filter(publishEntity -> "process".equals(publishEntity.getType())).map(publishEntity -> publishEntity.getPkValue()).collect(Collectors.toList());
        if ("new".equals(customPublishParam.getPublishMode()) && !CollectionUtils.isEmpty(pkValueList)) {
            DeployAppReqDto deployAppReqDto = DeployAppReqDto.create((CustomPublishParam)customPublishParam);
            CollectionDomain collectionDomain = new CollectionDomain().setDatabaseName("datamap").setCollection("process").setPrimaryKey("processId");
            List processMongoData = super.collectMongo(collectionDomain, path, compileVersion);
            deployAppReqDto.setSinglePublishMongoData(processMongoData, pkValueList, collectionDomain);
            collectionDomain.setDatabaseName("datamap").setCollection("project");
            List projectMongoData = super.collectMongo(collectionDomain, path, compileVersion);
            deployAppReqDto.setSinglePublishMongoData(projectMongoData, pkValueList, collectionDomain);
            List projectCode = projectMongoData.stream().map(o -> o.get((Object)"code")).collect(Collectors.toList());
            CollectionDomain projectCd = new CollectionDomain().setDatabaseName("knowledgegraphSystem").setCollection("applicationRelation").setPrimaryKey("code");
            deployAppReqDto.setSinglePublishMongoData(null, projectCode, projectCd);
            collectionDomain.setDatabaseName("datamap").setCollection("task");
            List taskMongoData = super.collectMongo(collectionDomain, path, compileVersion);
            List taskCode = taskMongoData.stream().map(o -> o.get((Object)"code")).collect(Collectors.toList());
            CollectionDomain taskCollectionDomain = new CollectionDomain().setDatabaseName("datamap").setCollection("task").setPrimaryKey("code");
            deployAppReqDto.setSinglePublishMongoData(taskMongoData, taskCode, taskCollectionDomain);
            collectionDomain.setCollection("processConditions").setDatabaseName("datamap");
            List processConditionsMongoData = super.collectMongo(collectionDomain, path, compileVersion);
            deployAppReqDto.setSinglePublishMongoData(processConditionsMongoData, pkValueList, collectionDomain);
            CollectionDomain cd = new CollectionDomain().setDatabaseName("knowledgegraphSystem").setCollection("applicationRelation").setPrimaryKey("code");
            deployAppReqDto.setSinglePublishMongoData(null, taskCode, cd);
            collectionDomain.setCollection("pageView").setDatabaseName("datamap");
            List pageViewMongoData = super.collectMongo(collectionDomain, path, compileVersion);
            deployAppReqDto.setSinglePublishMongoData(pageViewMongoData, pkValueList, collectionDomain);
            List pageViewCode = pageViewMongoData.stream().map(o -> o.get((Object)"code")).collect(Collectors.toList());
            CollectionDomain pageViewCd = new CollectionDomain().setDatabaseName("datamap").setCollection("pageView").setPrimaryKey("code");
            deployAppReqDto.setSinglePublishMongoData(null, pageViewCode, pageViewCd);
            collectionDomain.setDatabaseName("datamap").setCollection("eventSubscribe");
            List eventSubscribeMongoData = super.collectMongo(collectionDomain, path, compileVersion);
            deployAppReqDto.setSinglePublishMongoData(eventSubscribeMongoData, pkValueList, collectionDomain);
            collectionDomain.setDatabaseName("preset").setCollection("rules");
            List ruleMongoData = super.collectMongo(collectionDomain, path, compileVersion);
            deployAppReqDto.setSinglePublishMongoData(ruleMongoData, pkValueList, collectionDomain);
            CollectionDomain arCollectionDomain = new CollectionDomain().setDatabaseName("knowledgegraphSystem").setCollection("applicationRelation").setPrimaryKey("code");
            String applicationRelationPath = path + File.separator + "knowledgegraphSystem" + File.separator + "applicationRelation" + File.separator + compileVersion + ".json";
            File applicationRelationFile = SafeFileUtils.createFile((String)applicationRelationPath);
            if (applicationRelationFile.exists()) {
                List data = FileUtil.readLines((File)applicationRelationFile, (Charset)Charset.forName("utf-8"));
                data = data.stream().map(s -> s.replaceAll("\\{athena_version}", "1.0")).collect(Collectors.toList());
                List mongoData = data.stream().map(s -> JSONObject.parseObject((String)s)).collect(Collectors.toList());
                deployAppReqDto.setSinglePublishMongoData(mongoData, null, arCollectionDomain);
            }
            collectionDomain = new CollectionDomain().setCollection("MonitorRule").setPrimaryKey("code");
            List cqlList = super.collectNeo4jData(collectionDomain, path, compileVersion, customPublishParam.getDeployVersion(), pkValueList);
            deployAppReqDto.setSinglePublishNeo4jData(cqlList, pkValueList, collectionDomain);
            collectionDomain.setCollection("monitorRuleProductConfig").setDatabaseName("knowledgegraphSystem").setPrimaryKey("monitorRuleId");
            List monitorRuleMongoData = super.collectMongoData(collectionDomain, path, compileVersion, pkValueList);
            deployAppReqDto.setSinglePublishMongoData(monitorRuleMongoData, pkValueList, collectionDomain);
            collectionDomain = new CollectionDomain().setCollection("activityTemplate").setDatabaseName("knowledgegraphSystem").setPrimaryKey("adpDataSourceId");
            List activityTemplateMongoData = super.collectMongoData(collectionDomain, path, compileVersion, pkValueList);
            deployAppReqDto.setSinglePublishMongoData(activityTemplateMongoData, pkValueList, collectionDomain);
            collectionDomain = new CollectionDomain().setCollection("activityTemplateRel").setDatabaseName("knowledgegraphSystem").setPrimaryKey("adpDataSourceId");
            List activityTemplateRelMongoData = super.collectMongoData(collectionDomain, path, compileVersion, pkValueList);
            deployAppReqDto.setSinglePublishMongoData(activityTemplateRelMongoData, pkValueList, collectionDomain);
            String subApproveConditionDropDownPath = path + File.separator + "knowledgegraphSystem" + File.separator + "subApproveConditionDropDown" + File.separator + compileVersion + ".json";
            File subApproveConditionDropDownFile = SafeFileUtils.createFile((String)subApproveConditionDropDownPath);
            if (subApproveConditionDropDownFile.exists()) {
                CollectionDomain subApproveConditionDropDownCollectionDomain = new CollectionDomain().setDatabaseName("knowledgegraphSystem").setCollection("subApproveConditionDropDown").setPrimaryKey("code");
                List data = FileUtil.readLines((File)subApproveConditionDropDownFile, (Charset)Charset.forName("utf-8"));
                List mongoData = data.stream().map(s -> JSONObject.parseObject((String)s)).collect(Collectors.toList());
                List codeList = mongoData.stream().map(e -> e.get((Object)"code")).collect(Collectors.toList());
                deployAppReqDto.setSinglePublishMongoData(mongoData, codeList, subApproveConditionDropDownCollectionDomain);
            }
            if (deployAppReqDto.appDataIsEmpty()) {
                return;
            }
            this.kmApiHelper.deployApp(deployAppReqDto, customPublishParam.getCurrentUser().getTenantId());
            try {
                for (JSONObject process : processMongoData) {
                    for (TenantUser tenantUser : tenantUsers) {
                        this.asyncService.moduleAssignPublishRecord(tenantUser.getTenantId(), this.envMode, customPublishParam.getApplication(), process.getString("processId"), "PROCESS", "", null);
                    }
                }
            }
            catch (Exception e2) {
                log.error("insert data error: ", (Throwable)e2);
            }
        }
        String tenantId = ((TenantUser)tenantUsers.get(0)).getTenantId();
        this.kmApiHelper.updateApplicationComponentList(customPublishParam.getApplication(), "1.0", tenantId);
        this.kmApiHelper.cacheReset(tenantId);
        this.atmcApiHelper.cacheReset();
    }

    private void updateProcessStatus(CustomPublishParam customPublishParam) {
        List tenantUsers = customPublishParam.getTenantUsers();
        File compileDataDirector = customPublishParam.getCompileDataDirector();
        String compileVersion = customPublishParam.getCompileVersion();
        String path = compileDataDirector.getPath();
        String processName = path + File.separator + "datamap" + File.separator + "process" + File.separator + compileVersion + ".json";
        File processFile = SafeFileUtils.createFile((String)processName);
        if (processFile.exists()) {
            List data = FileUtil.readLines((File)processFile, (Charset)Charset.forName("utf-8"));
            for (String line : data) {
                Document process = Document.parse((String)line);
                process.put("athena_namespace", (Object)customPublishParam.getApplication());
                process.put("compileVersion", (Object)compileVersion);
                process.put("version", (Object)"1.0");
                try {
                    for (TenantUser tenantUser : tenantUsers) {
                        this.asyncService.moduleAssignPublishRecord(tenantUser.getTenantId(), this.envMode, customPublishParam.getApplication(), process.getString((Object)"processId"), "PROCESS", "", null);
                    }
                }
                catch (MongoWriteException e) {
                    log.error("insert data error: ", (Throwable)e);
                }
            }
        }
    }
}

