/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.publish;

import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.domain.application.CollectionDomain;
import com.digiwin.athena.athena_deployer_service.domain.deploy.CustomPublishParam;
import com.digiwin.athena.athena_deployer_service.domain.system.AthenaUser;
import com.digiwin.athena.athena_deployer_service.http.designer.DesignerApiHelper;
import com.digiwin.athena.athena_deployer_service.http.km.dto.DeployAppReqDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.KmSingleModuleJobDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.KmSingleModuleParamDto;
import com.digiwin.athena.athena_deployer_service.publish.BaseCustomPublishService;
import com.digiwin.athena.athena_deployer_service.publish.CustomPublish;
import com.digiwin.athena.athena_deployer_service.util.SafeFileUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProjectPublish
extends BaseCustomPublishService
implements CustomPublish {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectPublish.class);
    @Autowired
    private DesignerApiHelper designerApiHelper;
    @Autowired
    private MongoTemplate mongoTemplate;

    public void publishWithCompile(CustomPublishParam customPublishParam) {
        List publishEntityList = customPublishParam.getPublishEntityList();
        String deployVersion = customPublishParam.getDeployVersion();
        File compileDataDirector = customPublishParam.getCompileDataDirector();
        String application = customPublishParam.getApplication();
        String compileVersion = customPublishParam.getCompileVersion();
        AthenaUser currentUser = customPublishParam.getCurrentUser();
        List pkValueList = publishEntityList.stream().filter(publishEntity -> "project".equals(publishEntity.getType())).map(publishEntity -> publishEntity.getPkValue()).collect(Collectors.toList());
        CollectionDomain collectionDomain = this.getCollectionDomainFromCompile(compileDataDirector, compileVersion, "project");
        String path = compileDataDirector.getPath();
        DeployAppReqDto deployAppReqDto = DeployAppReqDto.create((CustomPublishParam)customPublishParam);
        if ("new".equals(customPublishParam.getPublishMode())) {
            List mongoData = super.collectMongoData(collectionDomain, path, compileVersion, pkValueList);
            deployAppReqDto.setSinglePublishMongoData(mongoData, pkValueList, collectionDomain);
            String subApproveConditionDropDownPath = path + File.separator + "knowledgegraphSystem" + File.separator + "subApproveConditionDropDown" + File.separator + compileVersion + ".json";
            File subApproveConditionDropDownFile = SafeFileUtils.createFile((String)subApproveConditionDropDownPath);
            if (subApproveConditionDropDownFile.exists()) {
                CollectionDomain subApproveConditionDropDownCollectionDomain = new CollectionDomain().setDatabaseName("knowledgegraphSystem").setCollection("subApproveConditionDropDown").setPrimaryKey("code");
                List data = FileUtil.readLines((File)subApproveConditionDropDownFile, (Charset)Charset.forName("utf-8"));
                List subMongoData = data.stream().map(s -> JSONObject.parseObject((String)s)).collect(Collectors.toList());
                List codeList = subMongoData.stream().map(e -> e.get((Object)"code")).collect(Collectors.toList());
                deployAppReqDto.setSinglePublishMongoData(subMongoData, codeList, subApproveConditionDropDownCollectionDomain);
            }
        }
        if ("new".equals(customPublishParam.getPublishMode())) {
            KmSingleModuleJobDto kmSingleModuleJobDto = new KmSingleModuleJobDto();
            kmSingleModuleJobDto.setDb("datamap");
            kmSingleModuleJobDto.setTable("tenantProductRelation");
            HashMap key = new HashMap();
            kmSingleModuleJobDto.getKeys().add(key);
            deployAppReqDto.getJobList().add(kmSingleModuleJobDto);
            KmSingleModuleParamDto.MongoParamData mongoParamData = new KmSingleModuleParamDto.MongoParamData();
            mongoParamData.setDb("datamap");
            mongoParamData.setCol("tenantProductRelation");
            for (Object pkValue : pkValueList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("tenantId", currentUser.getTenantId());
                map.put("objectType", "project");
                map.put("objectCode", (String)pkValue);
                mongoParamData.getDocs().add(map);
            }
            if (!CollectionUtils.isEmpty((Collection)mongoParamData.getDocs())) {
                deployAppReqDto.getAppData().getMongoData().add(mongoParamData);
            }
            if (deployAppReqDto.appDataIsEmpty()) {
                return;
            }
            this.kmApiHelper.deployApp(deployAppReqDto, customPublishParam.getCurrentUser().getTenantId());
        }
    }
}

