/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.publish;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.domain.application.CollectionDomain;
import com.digiwin.athena.athena_deployer_service.domain.deploy.CustomPublishParam;
import com.digiwin.athena.athena_deployer_service.domain.system.AthenaUser;
import com.digiwin.athena.athena_deployer_service.http.km.dto.DeployAppReqDto;
import com.digiwin.athena.athena_deployer_service.publish.BaseCustomPublishService;
import com.digiwin.athena.athena_deployer_service.publish.CustomPublish;
import com.digiwin.athena.athena_deployer_service.publish.DataEntryPublish;
import com.digiwin.athena.athena_deployer_service.service.deploy.StatementService;
import com.digiwin.athena.athena_deployer_service.service.iam.IamService;
import com.digiwin.athena.athena_deployer_service.util.SafeFileUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatementPublish
extends BaseCustomPublishService
implements CustomPublish {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatementPublish.class);
    @Autowired
    private StatementService statementService;
    @Autowired
    private IamService iamService;
    @Autowired
    private DataEntryPublish dataEntryPublish;

    public void publishWithCompile(CustomPublishParam customPublishParam) {
        List publishEntityList = customPublishParam.getPublishEntityList();
        String deployVersion = customPublishParam.getDeployVersion();
        File compileDataDirector = customPublishParam.getCompileDataDirector();
        String compileVersion = customPublishParam.getCompileVersion();
        String branch = customPublishParam.getBranch();
        String env = customPublishParam.getEnv();
        JSONObject extProperties = customPublishParam.getExtProperties();
        List pkValueList = publishEntityList.stream().filter(publishEntity -> "Statement".equals(publishEntity.getType())).map(publishEntity -> publishEntity.getPkValue()).collect(Collectors.toList());
        CollectionDomain collectionDomain = new CollectionDomain().setCollection("Activity").setPrimaryKey("code");
        String path = compileDataDirector.getPath();
        if ("new".equals(customPublishParam.getPublishMode())) {
            DeployAppReqDto deployAppReqDto = DeployAppReqDto.create((CustomPublishParam)customPublishParam);
            List cqlList = super.collectNeo4jData(collectionDomain, path, compileVersion, deployVersion, pkValueList);
            deployAppReqDto.setSinglePublishNeo4jData(cqlList, pkValueList, collectionDomain);
            CollectionDomain collectionDomain2 = new CollectionDomain().setCollection("activityConfigsBasic").setDatabaseName("knowledgegraphSystem").setPrimaryKey("code").setApplication(customPublishParam.getApplication());
            List mongoData = super.collectMongoData(collectionDomain2, path, compileVersion, pkValueList);
            deployAppReqDto.setSinglePublishMongoData(mongoData, pkValueList, collectionDomain2);
            if (deployAppReqDto.appDataIsEmpty()) {
                return;
            }
            this.kmApiHelper.deployApp(deployAppReqDto, customPublishParam.getCurrentUser().getTenantId());
        }
        this.publishStatement(customPublishParam, pkValueList, collectionDomain, path);
    }

    private void publishStatement(CustomPublishParam customPublishParam, List<Object> pkValueList, CollectionDomain collectionDomain, String path) {
        File cypherFile = SafeFileUtils.createFile((String)(path + File.separator + "cypher" + File.separator + customPublishParam.getCompileVersion() + ".json"));
        ArrayList<Document> activityConfigDocumentList = new ArrayList<Document>();
        File activityConfigsFile = SafeFileUtils.createFile((String)(path + File.separator + "knowledgegraphSystem" + File.separator + "activityConfigs" + File.separator + customPublishParam.getCompileVersion() + ".json"));
        if (activityConfigsFile.exists()) {
            List activityConfigsStrList = FileUtil.readLines((File)activityConfigsFile, (Charset)Charset.forName("utf-8"));
            for (String line : activityConfigsStrList) {
                Document document = Document.parse((String)line);
                if (!pkValueList.contains(document.getString((Object)"code"))) continue;
                activityConfigDocumentList.add(document);
            }
        }
        AthenaUser currentUser = customPublishParam.getCurrentUser();
        JSONObject extProperties = customPublishParam.getExtProperties();
        String branch = customPublishParam.getBranch();
        String application = customPublishParam.getApplication();
        String sourceApplicationCode = customPublishParam.getSourceApplicationCode();
        List tenantIdList = customPublishParam.getTenantUsers().stream().map(tenantUser -> tenantUser.getTenantId()).collect(Collectors.toList());
        String isvCode = this.iamService.getIsvCode(currentUser.getTenantId());
        if (cypherFile.exists()) {
            List cqlList = FileUtil.readLines((File)cypherFile, (Charset)Charset.forName("utf-8"));
            cqlList = cqlList.stream().filter(cql -> cql.contains("create (node:Activity")).collect(Collectors.toList());
            for (String cql2 : cqlList) {
                String category;
                Boolean isPublishEntity = false;
                for (Object pkValue : pkValueList) {
                    String primaryKey = collectionDomain.getPrimaryKey();
                    if (!cql2.contains(primaryKey + ":'" + String.valueOf(pkValue) + "'")) continue;
                    isPublishEntity = true;
                    break;
                }
                if (!isPublishEntity.booleanValue()) continue;
                String code = extProperties.getString("code");
                String pattern = extProperties.getString("pattern");
                if (this.isTbbStatement(pattern, category = extProperties.getString("category"))) {
                    String tenantId;
                    JSONObject param = new JSONObject();
                    param.put("tenantIds", tenantIdList);
                    if (cql2.contains("tenantId") && null != (tenantId = StrUtil.subBetween((CharSequence)cql2, (CharSequence)"tenantId:'", (CharSequence)"',")) && !"SYSTEM".equals(tenantId)) {
                        param.put("tenantIds", (Object)tenantId.split(";"));
                    }
                    param.put("appCode", (Object)(StringUtils.isEmpty((CharSequence)sourceApplicationCode) ? application : sourceApplicationCode));
                    param.put("ucAppCode", (Object)(StringUtils.isEmpty((CharSequence)sourceApplicationCode) ? null : application));
                    param.put("reportList", Arrays.asList(extProperties.get((Object)"resCode")));
                    param.put("env", (Object)customPublishParam.getEnv());
                    param.put("token", (Object)currentUser.getToken());
                    param.put("branch", (Object)branch);
                    param.put("reports", extProperties.get((Object)"reports"));
                    param.put("operate", (Object)"publish");
                    param.put("ucTenantIdList", extProperties.get((Object)"ucTenantIdList"));
                    if (ObjectUtils.isNotEmpty((Object)extProperties)) {
                        param.put("tbbInnerToken", (Object)extProperties.getString("tbbInnerToken"));
                        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{extProperties.getString("tbb_uri")})) {
                            param.put("tbb_uri", (Object)extProperties.getString("tbb_uri"));
                        }
                    }
                    this.statementService.tbbStatementPublish(param);
                    continue;
                }
                if (!this.isAbiStatement(pattern, category)) continue;
                Document document = activityConfigDocumentList.stream().filter(activityConfigDocument -> activityConfigDocument.getString((Object)"code").equals(code)).findAny().orElse(null);
                JSONObject activityConfigObj = JSON.parseObject((String)document.toJson());
                Map resIdMap = this.getResidByAc(activityConfigObj);
                JSONObject param = new JSONObject();
                param.put("isvCode", (Object)isvCode);
                param.put("tenantId", (Object)currentUser.getTenantId());
                param.put("token", (Object)currentUser.getToken());
                param.put("code", (Object)code);
                param.put("env", (Object)customPublishParam.getEnv());
                param.put("appCode", (Object)application);
                if (ObjectUtils.isNotEmpty((Object)extProperties)) {
                    param.put("abiInnerToken", (Object)extProperties.getString("abiInnerToken"));
                }
                for (String resid : resIdMap.values()) {
                    param.put("resid", (Object)resid);
                    this.statementService.abiStatementPublish(param);
                }
            }
        }
    }

    private boolean isTbbStatement(String pattern, String category) {
        return Arrays.asList("STATEMENT").contains(category) && Arrays.asList("STATEMENT", "MOBI-STATEMENT").contains(pattern);
    }

    private boolean isAbiStatement(String pattern, String category) {
        return Arrays.asList("ABI-STATEMENT").contains(category) && Arrays.asList("STATEMENT").contains(pattern);
    }

    private Map<String, String> getResidByAc(JSONObject jsonObject) {
        Map condition_detail;
        Map pages = (Map)JSON.parseObject((String)JSON.toJSONString((Object)jsonObject.getJSONObject("pages")), Map.class);
        Map<String, String> extendedFields = new HashMap();
        if (!ObjectUtils.isEmpty((Object)pages) && !ObjectUtils.isEmpty(pages.get("condition-detail")) && !ObjectUtils.isEmpty((Object)(condition_detail = (Map)pages.get("condition-detail"))) && (extendedFields = (Map)condition_detail.get("extendedFields")).containsKey("STATEMENT__resid")) {
            String defaultResid = (String)extendedFields.get("STATEMENT__resid");
            if (!extendedFields.containsKey("STATEMENT__resid_en_US")) {
                extendedFields.put("STATEMENT__resid_en_US", defaultResid);
            }
            if (!extendedFields.containsKey("STATEMENT__resid_zh_CN")) {
                extendedFields.put("STATEMENT__resid_zh_CN", defaultResid);
            }
            if (!extendedFields.containsKey("STATEMENT__resid_zh_TW")) {
                extendedFields.put("STATEMENT__resid_zh_TW", defaultResid);
            }
        }
        HashMap<String, String> returnExtendedFields = new HashMap<String, String>();
        if (extendedFields.containsKey("STATEMENT__resid")) {
            returnExtendedFields.put("STATEMENT__resid", (String)extendedFields.get("STATEMENT__resid"));
        }
        if (extendedFields.containsKey("STATEMENT__resid_en_US")) {
            returnExtendedFields.put("STATEMENT__resid_en_US", (String)extendedFields.get("STATEMENT__resid_en_US"));
        }
        if (extendedFields.containsKey("STATEMENT__resid_zh_CN")) {
            returnExtendedFields.put("STATEMENT__resid_zh_CN", (String)extendedFields.get("STATEMENT__resid_zh_CN"));
        }
        if (extendedFields.containsKey("STATEMENT__resid_zh_TW")) {
            returnExtendedFields.put("STATEMENT__resid_zh_TW", (String)extendedFields.get("STATEMENT__resid_zh_TW"));
        }
        return returnExtendedFields;
    }
}

