/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.schedule;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.athena.athena_deployer_service.domain.kmDeployer.KmDeployRecord;
import com.digiwin.athena.athena_deployer_service.http.km.dto.EventLog;
import com.digiwin.athena.athena_deployer_service.service.deploy.KmDeployRecordService;
import com.digiwin.athena.athena_deployer_service.util.LogUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class KmDeployRecordCheckSchedule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KmDeployRecordCheckSchedule.class);
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private KmDeployRecordService kmDeployRecordService;
    public static final String KM_DEPLOY_RECORD_CHECK_SCHEDULE_KEY = "deployer_service_km_deploy_record_check_schedule_key";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="${jobCron.KmDeployRecordCheckSchedule}")
    public void run() {
        block10: {
            log.info("KmDeployRecordCheckSchedule start");
            try {
                RLock rLock = this.redissonClient.getLock(KM_DEPLOY_RECORD_CHECK_SCHEDULE_KEY);
                String message = "KM\u53d1\u5e03\u72b6\u6001\u68c0\u67e5\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0:%s";
                String timeout = "KM\u53d1\u5e03\u72b6\u6001\u68c0\u67e5\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0:%s";
                boolean isLock = rLock.tryLock();
                if (!isLock) break block10;
                try {
                    List kmDeployRecordList = this.kmDeployRecordService.getExecutingRecord();
                    log.info("kmDeployRecordList size:" + kmDeployRecordList.size());
                    String messageId = IdUtil.fastUUID().replace("-", "");
                    for (KmDeployRecord kmDeployRecord : kmDeployRecordList) {
                        try {
                            this.kmDeployRecordService.checkEventStatus(kmDeployRecord);
                        }
                        catch (Exception e) {
                            log.error(kmDeployRecord.getKmDeployId() + " KmDeployId exception:" + e.getMessage(), (Throwable)e);
                            LogUtils.buildAgileLog((String)kmDeployRecord.getApplication(), (String)LogUtils.MODULE_AADCS, (String)"checkEventStatus", (String)LogUtils.AADCS_500_0005, (String)JSON.toJSONString((Object)kmDeployRecord), (String)String.format(message, e.getMessage()), (String)String.format("\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff0c\u5e76\u63d0\u4f9b\u6d88\u606f\u5e8f\u5217\u53f7\uff08%s\uff09", messageId), (String)messageId);
                            try {
                                Date curTime;
                                if (!"executing".equals(kmDeployRecord.getStatus()) || (curTime = new Date()).getTime() - kmDeployRecord.getCreateDate().getTime() <= 900000L) continue;
                                kmDeployRecord.setStatus("fail");
                                EventLog eventLog = new EventLog();
                                eventLog.setMsg("km\u6267\u884c\u8d85\u65f6");
                                kmDeployRecord.setEventLog(Arrays.asList(eventLog));
                                LogUtils.buildAgileLog((String)kmDeployRecord.getApplication(), (String)LogUtils.MODULE_AADCS, (String)"checkEventStatus", (String)LogUtils.AADCS_504_0001, (String)JSON.toJSONString((Object)kmDeployRecord), (String)String.format(timeout, e.getMessage()), (String)String.format("\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\u68c0\u67e5%s\u670d\u52a1", LogUtils.THIRD_KM), (String)messageId);
                                this.kmDeployRecordService.changeKmDataPublishStatus(kmDeployRecord);
                            }
                            catch (Exception ex) {
                                LogUtils.buildAgileLog((String)kmDeployRecord.getApplication(), (String)LogUtils.MODULE_AADCS, (String)"checkEventStatus", (String)LogUtils.AADCS_500_0006, (String)JSON.toJSONString((Object)kmDeployRecord), (String)String.format(message, e.getMessage()), (String)String.format("\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff0c\u5e76\u63d0\u4f9b\u6d88\u606f\u5e8f\u5217\u53f7\uff08%s\uff09", messageId), (String)messageId);
                                log.error(kmDeployRecord.getKmDeployId() + "\u4efb\u52a1\u8d85\u65f6\u68c0\u6d4b\uff0c\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
                finally {
                    rLock.unlock();
                }
            }
            catch (Exception e) {
                log.error("KmDeployRecordCheckSchedule exception:" + e.getMessage(), (Throwable)e);
            }
        }
        log.info("KmDeployRecordCheckSchedule end");
    }
}

