/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.service.apimgmt.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.config.ModuleConfig;
import com.digiwin.athena.athena_deployer_service.domain.apimgmt.AdvanceSearchConditions;
import com.digiwin.athena.athena_deployer_service.domain.apimgmt.ApiAdvanceSearchInfo;
import com.digiwin.athena.athena_deployer_service.domain.apimgmt.ApiAdvanceSearchResponse;
import com.digiwin.athena.athena_deployer_service.domain.apimgmt.ApiMgmtBaseInfo;
import com.digiwin.athena.athena_deployer_service.domain.apimgmt.ApiMgmtCondition;
import com.digiwin.athena.athena_deployer_service.domain.apimgmt.ApiMgmtDeleteModel;
import com.digiwin.athena.athena_deployer_service.domain.apimgmt.ApiMgmtUpdateModel;
import com.digiwin.athena.athena_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.athena_deployer_service.service.apimgmt.ApimgmtService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ApimgmtServiceImpl
implements ApimgmtService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApimgmtServiceImpl.class);
    @Autowired
    private ModuleConfig moduleConfig;
    @Value(value="${envMode}")
    private String envMode;

    public List<ApiMgmtBaseInfo> publishActionMeataDataToApimgmt(JSONArray publishActionMetaDataInfo, String token, List<String> noPublishApis, String apimgmtUrl) {
        if (publishActionMetaDataInfo == null) {
            log.info("publishActionMeataDataToApimgmt, publishActionMetaDataInfo is null");
            return new ArrayList<ApiMgmtBaseInfo>();
        }
        log.info("----------------\u5f00\u59cb\u4fdd\u5b58\u6570\u636e");
        List apiMgmtBaseInfos = this.dealApiMgmtProcessSave(publishActionMetaDataInfo, token, noPublishApis, apimgmtUrl);
        log.info("----------------\u5f00\u59cb\u4fdd\u5b58\u6570\u636e--\u5b8c\u6210");
        log.info("----------------\u5f00\u59cb\u9001\u5ba1");
        this.dealApiMgmtProcessUpdate(apiMgmtBaseInfos, token, apimgmtUrl);
        log.info("----------------\u9001\u5ba1\u5b8c\u6210--\u5b8c\u6210");
        if (!(this.envMode.equals("HuaweiTest-TEST") || this.envMode.equals("AliTest-TEST") || this.envMode.equals("Huaweidev-dev"))) {
            log.info("--------------\u9700\u8981\u5b9a\u7248--\u5f00\u59cb\u5b9a\u7248--\u5b9a\u7248");
            this.dealApiMgmtProcessConfirmed(apiMgmtBaseInfos, token, apimgmtUrl);
            log.info("----------------\u5b9a\u7248\u5b8c\u6210--\u5b8c\u6210");
        }
        log.info("update api mgmt success, apiName is list");
        return apiMgmtBaseInfos;
    }

    private void dealApiMgmtProcessConfirmed(List<ApiMgmtBaseInfo> apiUpdateList, String token, String apimgmtUrl) {
        if (CollUtil.isEmpty(apiUpdateList)) {
            log.info("update api mgmt apiUpdateList is null, not need to Confirmed");
            return;
        }
        ArrayList<ApiMgmtBaseInfo> apiSubmitList = new ArrayList<ApiMgmtBaseInfo>();
        for (ApiMgmtBaseInfo apiMgmtBaseInfo : apiUpdateList) {
            if (!StringUtils.isBlank((CharSequence)apiMgmtBaseInfo.getModelComeFrom()) && apiMgmtBaseInfo.getModelComeFrom().equals("bc")) continue;
            apiSubmitList.add(apiMgmtBaseInfo);
        }
        if (CollUtil.isEmpty(apiSubmitList)) {
            log.info("apiSubmitList api mgmt apiUpdateList is null, not need to Confirmed");
            return;
        }
        ApiMgmtUpdateModel apiMgmtUpdateModel = new ApiMgmtUpdateModel();
        apiMgmtUpdateModel.setApiList(apiSubmitList);
        String jsonUpdateRequest = JSON.toJSONString((Object)apiMgmtUpdateModel);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        String confirmedUrl = apimgmtUrl + "/restful/standard/apimgmt/ApiComfirmed/Update";
        log.info("apiConfirmedUpdate api mgmt request is -->{}", (Object)jsonUpdateRequest);
        String confirmedResponse = ((HttpRequest)HttpUtil.createPost((String)confirmedUrl).addHeaders(headers)).body(jsonUpdateRequest).execute().body();
        log.info("apiConfirmedUpdate api mgmt response is -->{}", (Object)confirmedResponse);
        JSONObject jsonObjectUpdateResponse = JSON.parseObject((String)confirmedResponse);
        JSONObject responseUpdate = jsonObjectUpdateResponse.getJSONObject("response");
        String updateCode = responseUpdate.getString("code");
        if (!"000".equals(updateCode)) {
            throw new BusinessException(confirmedResponse);
        }
    }

    private void dealApiMgmtProcessUpdate(List<ApiMgmtBaseInfo> apiUpdateList, String token, String apimgmtUrl) {
        if (CollUtil.isEmpty(apiUpdateList)) {
            log.info("update api mgmt apiUpdateList is null, no need to update");
            return;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        String updateUrl = apimgmtUrl + "/restful/standard/apimgmt/ApiReview/Update";
        ApiMgmtUpdateModel apiMgmtUpdateModel = new ApiMgmtUpdateModel();
        apiMgmtUpdateModel.setApiList(apiUpdateList);
        String jsonUpdateRequest = JSON.toJSONString((Object)apiMgmtUpdateModel);
        log.info("update api mgmt request is -->{}", (Object)jsonUpdateRequest);
        String updateResponse = ((HttpRequest)HttpUtil.createPost((String)updateUrl).body(jsonUpdateRequest).addHeaders(headers)).execute().body();
        log.info("update api mgmt update response is -->{}", (Object)updateResponse);
        JSONObject jsonObjectUpdateResponse = JSON.parseObject((String)updateResponse);
        JSONObject responseUpdate = jsonObjectUpdateResponse.getJSONObject("response");
        String updateCode = responseUpdate.getString("code");
        if (!"000".equals(updateCode)) {
            throw new BusinessException(updateResponse);
        }
    }

    private List<ApiMgmtBaseInfo> dealApiMgmtProcessSave(JSONArray publishActionMetaDataInfo, String token, List<String> noPublishApis, String apimgmtUrl) {
        if (publishActionMetaDataInfo == null) {
            log.info("publishActionMeataDataToApimgmt, publishActionMetaDataInfo is null");
            return new ArrayList<ApiMgmtBaseInfo>();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        ArrayList<ApiMgmtBaseInfo> apiUpdateList = new ArrayList<ApiMgmtBaseInfo>();
        for (int i = 0; i < publishActionMetaDataInfo.size(); ++i) {
            int status;
            ApiMgmtBaseInfo apiMgmtBaseInfo = new ApiMgmtBaseInfo();
            JSONObject jsonObject = publishActionMetaDataInfo.getJSONObject(i);
            JSONObject apiMgmtModelSaveJson = jsonObject.getJSONObject("apiMgmtModelSave");
            String modelComeFrom = jsonObject.getString("modelComeFrom");
            if (apiMgmtModelSaveJson == null) continue;
            String tenantId = apiMgmtModelSaveJson.getString("tenantId");
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                apiMgmtModelSaveJson.remove((Object)"tenantId");
            }
            String apiName = jsonObject.getString("apiName");
            if (!CollectionUtils.isEmpty(noPublishApis) && noPublishApis.contains(apiName)) {
                log.info("The api {} does not need to publish api mgmt", (Object)apiName);
                continue;
            }
            apiMgmtBaseInfo.setApiName(apiName);
            apiMgmtBaseInfo.setModelComeFrom(modelComeFrom);
            String advanceSearchUrl = apimgmtUrl + "/restful/standard/apimgmt/AdvanceSearchApiListOther/Get";
            ArrayList<ApiMgmtCondition> apiMgmtConditions = new ArrayList<ApiMgmtCondition>();
            ApiMgmtCondition apiMgmtCondition = new ApiMgmtCondition();
            apiMgmtCondition.setCondition("apiName");
            apiMgmtCondition.setEquation("equal");
            apiMgmtCondition.setContent((Object)apiName);
            apiMgmtConditions.add(apiMgmtCondition);
            AdvanceSearchConditions advanceSearchConditions = new AdvanceSearchConditions();
            advanceSearchConditions.setConditionList(apiMgmtConditions);
            String advanceSearchRequest = JSON.toJSONString((Object)advanceSearchConditions);
            log.info("advanceSearch api mgmt request is -->{}", (Object)advanceSearchRequest);
            String advanceSearchResponse = ((HttpRequest)HttpUtil.createPost((String)advanceSearchUrl).addHeaders(headers)).body(advanceSearchRequest).execute().body();
            log.info("advanceSearch api mgmt response is -->{}", (Object)advanceSearchResponse);
            ArrayList apiAdvanceSearchList = new ArrayList();
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                ApiAdvanceSearchResponse apiAdvanceSearchResponse = (ApiAdvanceSearchResponse)objectMapper.readValue(advanceSearchResponse, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                status = apiAdvanceSearchResponse.getStatus();
                ApiAdvanceSearchResponse.ApiAdvanceSearchResponseInfo apiAdvanceSearchResponseInfo = apiAdvanceSearchResponse.getResponse();
                if (ObjectUtil.isNotEmpty((Object)apiAdvanceSearchResponseInfo) && CollUtil.isNotEmpty((Collection)apiAdvanceSearchResponseInfo.getValue())) {
                    apiAdvanceSearchList.addAll(apiAdvanceSearchResponseInfo.getValue());
                }
            }
            catch (Exception exception) {
                throw new BusinessException("\u89e3\u6790-\u67e5\u8be2api\u7ed3\u679c\u5f02\u5e38");
            }
            if (status != 200) {
                throw new BusinessException(advanceSearchResponse);
            }
            if (CollUtil.isNotEmpty(apiAdvanceSearchList)) {
                ApiAdvanceSearchInfo apiAdvanceSearchInfo = (ApiAdvanceSearchInfo)apiAdvanceSearchList.get(0);
                int approvedStatusCode = apiAdvanceSearchInfo.getApprovedStatusCode();
                String apiBuildAcct = apiAdvanceSearchInfo.getApiBuildAcct();
                if (apiBuildAcct.equals("virtual")) {
                    log.info(apiName + " \u662f\u865a\u62df\u7528\u6237\uff0c\u5148\u8fdb\u884c\u5220\u9664\u64cd\u4f5c");
                    this.dealApiMgmtDelete(apiName, "1.1", token, apimgmtUrl);
                    this.dealApiMgmtDelete(apiName, "1.0", token, apimgmtUrl);
                    approvedStatusCode = 1;
                }
                String version = apiAdvanceSearchInfo.getVersion();
                apiMgmtBaseInfo.setVersion(version);
                switch (approvedStatusCode) {
                    case 1: {
                        log.info("api\u662f\u8349\u7a3f\u72b6\u6001");
                        this.dealApiMgmtSave(apiMgmtModelSaveJson, version, token, apimgmtUrl);
                        break;
                    }
                    case 3: {
                        log.info("api\u662f\u5f00\u53d1\u72b6\u6001\uff0c\u9700\u8981\u53d6\u56de");
                        this.dealApiMgmtRetrieve(apiName, version, token, apimgmtUrl);
                        log.info("\u5df2\u53d6\u56de");
                        this.dealApiMgmtSave(apiMgmtModelSaveJson, version, token, apimgmtUrl);
                        break;
                    }
                    case 4: {
                        log.info("api\u5df2\u7ecf\u5b9a\u7248\uff0c\u9700\u8981\u83b7\u53d6\u8fdb\u7248\u7248\u672c\u53f7\u518d\u8fdb\u7248");
                        String apiVersion = this.getApiVersion(apiName, token, apimgmtUrl);
                        apiMgmtBaseInfo.setVersion(apiVersion);
                        log.info("\u8fdb\u7248\u7248\u672c\u53f7={}", (Object)apiVersion);
                        this.dealApiMgmtSave(apiMgmtModelSaveJson, apiVersion, token, apimgmtUrl);
                        break;
                    }
                    default: {
                        throw new BusinessException("\u89e3\u6790-\u67e5\u8be2api\u7ed3\u679c\u7684\u72b6\u6001\u672a\u77e5apiName=" + apiName);
                    }
                }
            } else {
                apiMgmtBaseInfo.setVersion("1.0");
                log.info(apiName + "\u6ca1\u6709\u6570\u636e\uff0c\u7b2c\u4e00\u6b21\u4fdd\u5b58");
                this.dealApiMgmtSave(apiMgmtModelSaveJson, "1.0", token, apimgmtUrl);
            }
            apiUpdateList.add(apiMgmtBaseInfo);
        }
        return apiUpdateList;
    }

    private void dealApiMgmtDelete(String apiName, String version, String token, String apimgmtUrl) {
        ApiMgmtBaseInfo apiMgmtBaseInfo = new ApiMgmtBaseInfo();
        apiMgmtBaseInfo.setApiName(apiName);
        apiMgmtBaseInfo.setVersion(version);
        ArrayList<ApiMgmtBaseInfo> apiList = new ArrayList<ApiMgmtBaseInfo>();
        apiList.add(apiMgmtBaseInfo);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        String deleteUrl = apimgmtUrl + "/restful/standard/apimgmt/ApiDelete/Delete";
        ApiMgmtUpdateModel apiMgmtApiDelete = new ApiMgmtUpdateModel();
        apiMgmtApiDelete.setApiList(apiList);
        apiMgmtApiDelete.setStatusId(3);
        String jsonRetrieveApi = JSON.toJSONString((Object)apiMgmtApiDelete);
        log.info("ApiDelete api mgmt request is -->{}", (Object)jsonRetrieveApi);
        String deleteApiResponse = ((HttpRequest)HttpUtil.createPost((String)deleteUrl).body(jsonRetrieveApi).addHeaders(headers)).execute().body();
        log.info("ApiDelete api mgmt response is -->{}", (Object)deleteApiResponse);
        JSONObject jsonObjectResponse = JSON.parseObject((String)deleteApiResponse);
        JSONObject response1 = jsonObjectResponse.getJSONObject("response");
        String code = response1.getString("code");
        if (!"000".equals(code)) {
            throw new BusinessException(deleteApiResponse);
        }
        log.info("\u5220\u9664\u6210\u529f, apiName is -->{}", (Object)apiName);
    }

    private String getApiVersion(String apiName, String token, String apimgmtUrl) {
        ApiMgmtBaseInfo apiMgmtBaseInfo = new ApiMgmtBaseInfo();
        apiMgmtBaseInfo.setApiName(apiName);
        apiMgmtBaseInfo.setTenantId("");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        String getVersionUrl = apimgmtUrl + "/restful/standard/apimgmt/ApiVersion/Get";
        String jsonStringRequest = JSON.toJSONString((Object)apiMgmtBaseInfo);
        log.info("get version api mgmt request is -->{}", (Object)jsonStringRequest);
        String response = ((HttpRequest)HttpUtil.createPost((String)getVersionUrl).addHeaders(headers)).body(jsonStringRequest).execute().body();
        log.info("get version api mgmt response is -->{}", (Object)response);
        JSONObject jsonObjectResponse = JSON.parseObject((String)response);
        JSONObject response1 = jsonObjectResponse.getJSONObject("response");
        String code = response1.getString("code");
        if (!"000".equals(code)) {
            throw new BusinessException(response);
        }
        String version = response1.getString("version");
        return version;
    }

    private void dealApiMgmtRetrieve(String apiName, String version, String token, String apimgmtUrl) {
        ApiMgmtUpdateModel apiMgmtRetrieveModel = new ApiMgmtUpdateModel();
        ArrayList<ApiMgmtBaseInfo> apiList = new ArrayList<ApiMgmtBaseInfo>();
        ApiMgmtBaseInfo apiMgmtBaseInfo = new ApiMgmtBaseInfo();
        apiMgmtBaseInfo.setApiName(apiName);
        apiMgmtBaseInfo.setVersion(version);
        apiList.add(apiMgmtBaseInfo);
        apiMgmtRetrieveModel.setApiList(apiList);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        String retrieveUrl = apimgmtUrl + "/restful/standard/apimgmt/ApiSpecRetrieve/Update";
        String jsonStringRequest = JSON.toJSONString((Object)apiMgmtRetrieveModel);
        log.info("retrieve api mgmt request is -->{}", (Object)jsonStringRequest);
        String response = ((HttpRequest)HttpUtil.createPost((String)retrieveUrl).addHeaders(headers)).body(jsonStringRequest).execute().body();
        log.info("retrieve api mgmt response is -->{}", (Object)response);
        JSONObject jsonObjectResponse = JSON.parseObject((String)response);
        JSONObject response1 = jsonObjectResponse.getJSONObject("response");
        String code = response1.getString("code");
        if (!"000".equals(code)) {
            throw new BusinessException(response);
        }
        log.info("retrieve api mgmt success, apiName is -->{}", (Object)apiName);
    }

    private void dealApiMgmtSave(JSONObject apiMgmtModelSaveJson, String version, String token, String apimgmtUrl) {
        apiMgmtModelSaveJson.put("apiVersion", (Object)version);
        String apiName = apiMgmtModelSaveJson.getString("apiName");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        String saveUrl = apimgmtUrl + "/restful/standard/apimgmt/ApiSpec/Save";
        String jsonStringRequest = JSON.toJSONString((Object)apiMgmtModelSaveJson);
        log.info("save api mgmt request is -->{}", (Object)jsonStringRequest);
        String response = ((HttpRequest)HttpUtil.createPost((String)saveUrl).addHeaders(headers)).body(jsonStringRequest).execute().body();
        log.info("save api mgmt response is -->{}", (Object)response);
        JSONObject jsonObjectResponse = JSON.parseObject((String)response);
        JSONObject response1 = jsonObjectResponse.getJSONObject("response");
        String code = response1.getString("code");
        if (!"000".equals(code)) {
            throw new BusinessException(response);
        }
        log.info("\u4fdd\u5b58\u6210\u529f, apiName is -->{}", (Object)apiName);
    }

    public void deleteActionMeataDataInApimgmt(JSONObject publishActionMetaDataInfo, String token, String apimgmtUrl) {
        if (publishActionMetaDataInfo == null) {
            log.info("deleteActionMeataDataInApimgmt, publishActionMetaDataInfo is null");
            return;
        }
        String uri = apimgmtUrl + "/restful/standard/apimgmt/ApiDelete/Delete";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        ApiMgmtDeleteModel apiMgmtDeleteModel = new ApiMgmtDeleteModel();
        ArrayList<ApiMgmtBaseInfo> list = new ArrayList<ApiMgmtBaseInfo>();
        JSONArray jsonArray = publishActionMetaDataInfo.getJSONArray("apiList");
        if (jsonArray == null || jsonArray.isEmpty()) {
            log.info("dpublishActionMetaDataInfo.getJSONArray is null");
            return;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            ApiMgmtBaseInfo apiMgmtBaseInfo = new ApiMgmtBaseInfo();
            String apiName = jsonObject.getString("apiName");
            ApiAdvanceSearchInfo apiAdvanceSearchInfo = this.queryApiVersionAndStatus(apiName, token, apimgmtUrl);
            if (apiAdvanceSearchInfo == null) continue;
            int approvedStatusCode = apiAdvanceSearchInfo.getApprovedStatusCode();
            if (4 == approvedStatusCode) {
                log.info("do not delete confirmed api , apiName is = {}", (Object)apiName);
                continue;
            }
            apiMgmtBaseInfo.setApiName(apiName);
            apiMgmtBaseInfo.setVersion(apiAdvanceSearchInfo.getVersion());
            list.add(apiMgmtBaseInfo);
        }
        apiMgmtDeleteModel.setStatusId(1);
        apiMgmtDeleteModel.setApiList(list);
        String jsonStringRequest = JSON.toJSONString((Object)apiMgmtDeleteModel);
        log.info("deleteActionMeataDataInApimgmt api mgmt request is -->{}", (Object)jsonStringRequest);
        String response = ((HttpRequest)HttpUtil.createPost((String)uri).addHeaders(headers)).body(jsonStringRequest).execute().body();
        log.info("deleteActionMeataDataInApimgmt api mgmt response is -->{}", (Object)response);
        JSONObject jsonObjectDelResponse = JSON.parseObject((String)response);
        JSONObject responseDel = jsonObjectDelResponse.getJSONObject("response");
        String updateCode = responseDel.getString("code");
        if (!"000".equals(updateCode)) {
            throw new BusinessException(response);
        }
        log.info("delete api mgmt success");
    }

    public void deleteApiMetaData(JSONArray publishActionMetaDataInfo, String token, String apimgmtUrl) {
        String uri = apimgmtUrl + "/restful/standard/apimgmt/ApiDelete/Delete";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        ApiMgmtDeleteModel apiMgmtDeleteModel = new ApiMgmtDeleteModel();
        ArrayList<ApiMgmtBaseInfo> list = new ArrayList<ApiMgmtBaseInfo>();
        if (null != publishActionMetaDataInfo && publishActionMetaDataInfo.size() > 0) {
            for (int i = 0; i < publishActionMetaDataInfo.size(); ++i) {
                JSONObject jsonObject = publishActionMetaDataInfo.getJSONObject(i);
                ApiMgmtBaseInfo apiMgmtBaseInfo = new ApiMgmtBaseInfo();
                String apiName = jsonObject.getString("apiName");
                ApiAdvanceSearchInfo apiAdvanceSearchInfo = this.queryApiVersionAndStatus(apiName, token, apimgmtUrl);
                if (apiAdvanceSearchInfo == null) continue;
                int approvedStatusCode = apiAdvanceSearchInfo.getApprovedStatusCode();
                if (4 == approvedStatusCode) {
                    log.info("do not delete confirmed api , apiName is = {}", (Object)apiName);
                    continue;
                }
                apiMgmtBaseInfo.setApiName(apiName);
                apiMgmtBaseInfo.setVersion(apiAdvanceSearchInfo.getVersion());
                list.add(apiMgmtBaseInfo);
            }
        }
        if (CollUtil.isNotEmpty(list)) {
            apiMgmtDeleteModel.setStatusId(1);
            apiMgmtDeleteModel.setApiList(list);
            String jsonStringRequest = JSON.toJSONString((Object)apiMgmtDeleteModel);
            log.info("deleteApiMetaData api mgmt request is -->{}", (Object)jsonStringRequest);
            String response = ((HttpRequest)HttpUtil.createPost((String)uri).addHeaders(headers)).body(jsonStringRequest).execute().body();
            log.info("deleteApiMetaData api mgmt response is -->{}", (Object)response);
            JSONObject jsonObjectDelResponse = JSON.parseObject((String)response);
            JSONObject responseDel = jsonObjectDelResponse.getJSONObject("response");
            String updateCode = responseDel.getString("code");
            if (!"000".equals(updateCode)) {
                throw new BusinessException(response);
            }
            log.info("deleteApiMetaData success");
        }
    }

    public ApiAdvanceSearchInfo queryApiVersionAndStatus(String apiName, String token, String apimgmtUrl) {
        int status;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        String advanceSearchUrl = apimgmtUrl + "/restful/standard/apimgmt/AdvanceSearchApiListOther/Get";
        ArrayList<ApiMgmtCondition> apiMgmtConditions = new ArrayList<ApiMgmtCondition>();
        ApiMgmtCondition apiMgmtCondition = new ApiMgmtCondition();
        apiMgmtCondition.setCondition("apiName");
        apiMgmtCondition.setEquation("equal");
        apiMgmtCondition.setContent((Object)apiName);
        apiMgmtConditions.add(apiMgmtCondition);
        AdvanceSearchConditions advanceSearchConditions = new AdvanceSearchConditions();
        advanceSearchConditions.setConditionList(apiMgmtConditions);
        String advanceSearchRequest = JSON.toJSONString((Object)advanceSearchConditions);
        log.info("advanceSearch api mgmt queryApiVersionAndStatus request is -->{}", (Object)advanceSearchRequest);
        String advanceSearchResponse = ((HttpRequest)HttpUtil.createPost((String)advanceSearchUrl).addHeaders(headers)).body(advanceSearchRequest).execute().body();
        log.info("advanceSearch api mgmt queryApiVersionAndStatus response is -->{}", (Object)advanceSearchResponse);
        ArrayList apiAdvanceSearchList = new ArrayList();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            ApiAdvanceSearchResponse apiAdvanceSearchResponse = (ApiAdvanceSearchResponse)objectMapper.readValue(advanceSearchResponse, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            status = apiAdvanceSearchResponse.getStatus();
            ApiAdvanceSearchResponse.ApiAdvanceSearchResponseInfo apiAdvanceSearchResponseInfo = apiAdvanceSearchResponse.getResponse();
            if (ObjectUtil.isNotEmpty((Object)apiAdvanceSearchResponseInfo) && CollUtil.isNotEmpty((Collection)apiAdvanceSearchResponseInfo.getValue())) {
                apiAdvanceSearchList.addAll(apiAdvanceSearchResponseInfo.getValue());
            }
        }
        catch (Exception exception) {
            log.info("get apiName is nothing!!!!!");
            return null;
        }
        if (status != 200) {
            throw new BusinessException(advanceSearchResponse);
        }
        if (CollUtil.isEmpty(apiAdvanceSearchList)) {
            return null;
        }
        return (ApiAdvanceSearchInfo)apiAdvanceSearchList.get(0);
    }
}

