/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.service.deploy.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.config.neo4j.Neo4jManager;
import com.digiwin.athena.athena_deployer_service.domain.action.ApiDataFieldMetadataDTO;
import com.digiwin.athena.athena_deployer_service.domain.action.EspActionIdSwitchResDto;
import com.digiwin.athena.athena_deployer_service.domain.action.EspActionProp;
import com.digiwin.athena.athena_deployer_service.domain.neo4j.Cql;
import com.digiwin.athena.athena_deployer_service.enums.EspSwitchMsgEnum;
import com.digiwin.athena.athena_deployer_service.http.km.KmApiHelper;
import com.digiwin.athena.athena_deployer_service.service.deploy.ActionService;
import com.digiwin.athena.athena_deployer_service.service.deploy.ApplicationService;
import com.digiwin.athena.athena_deployer_service.util.Neo4jMultipleUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.neo4j.driver.Driver;
import org.neo4j.driver.internal.InternalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ActionServiceImpl
implements ActionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActionServiceImpl.class);
    @Autowired
    private Driver driver1;
    @Autowired(required=false)
    @Qualifier(value="domain2Driver")
    private Driver driver2;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private KmApiHelper kmApiHelper;

    public void updateEspActionEnumKey(Map<String, List<String>> espActionEnumKey) {
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        for (Map.Entry<String, List<String>> entry : espActionEnumKey.entrySet()) {
            executorService.submit(() -> this.updateEspDictionaryKey((String)entry.getKey(), (List)entry.getValue()));
        }
        executorService.shutdown();
    }

    public void incrementSwitchEspAction(String id) {
        Neo4jManager neo4jManager = new Neo4jManager(this.driver1);
        List testAction = neo4jManager.ExecuteQuery("MATCH (n:EspAction) WHERE n.version = '1.0' RETURN n.actionId as actionId", new HashMap());
        List prodAction = neo4jManager.ExecuteQuery("MATCH (n:EspAction) WHERE n.version = '2.0' RETURN n.actionId as actionId", new HashMap());
        HashSet testActionIdList = new HashSet();
        if (CollUtil.isNotEmpty((Collection)testAction)) {
            testAction.forEach(ta -> testActionIdList.add(String.valueOf(ta.get("actionId"))));
        }
        HashSet prodActionIdList = new HashSet();
        if (CollUtil.isNotEmpty((Collection)prodAction)) {
            prodAction.forEach(ta -> prodActionIdList.add(String.valueOf(ta.get("actionId"))));
        }
        testActionIdList.removeAll(prodActionIdList);
        HashMap params = new HashMap();
        params.put("actionIdList", testActionIdList);
        List needCreateNodes = neo4jManager.executeQueryList("MATCH (node:EspAction) WHERE node.actionId in $actionIdList RETURN node.actionId as actionId,labels(node) as labels", params, EspActionProp.class);
        List needUpdateNodes = neo4jManager.executeQueryList("MATCH (node:EspAction{version:'1.0'}) MATCH (m:EspAction{version:'2.0'}) where node.actionId = m.actionId and ((node.updateTime>m.updateTime) or (node.updateTime is not null and m.updateTime is null)) return node.actionId as actionId", new HashMap(), EspActionProp.class);
        ArrayList executeCqlList = new ArrayList();
        List createNodeStatementList = this.buildCreateNodeStatement(needCreateNodes);
        createNodeStatementList.forEach(s -> executeCqlList.add(new Cql().setCql(StringEscapeUtils.escapeJava((String)s))));
        List updateNodesStatementList = this.buildUpdateNodeStatement(needUpdateNodes);
        updateNodesStatementList.forEach(s -> executeCqlList.add(new Cql().setCql(StringEscapeUtils.escapeJava((String)s))));
        Neo4jMultipleUtil.executeCql(executeCqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
        if (CollUtil.isNotEmpty((Collection)needCreateNodes)) {
            this.kmApiHelper.mergeCommonAppRelaWithVirtualTenant("espCommon", "2.0", "2.0");
        }
    }

    private List<String> buildUpdateNodeStatement(List<EspActionProp> needUpdateNodes) {
        String updateCql = "match (n:EspAction{version:'1.0'}),(m:EspAction{version:'2.0'}) where n.actionId in [%s] and m.actionId = n.actionId set m=n,m.version='2.0',m.switchTime='%s';";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = simpleDateFormat.format(new Date());
        ArrayList<ArrayList<EspActionProp>> partition = new ArrayList<ArrayList<EspActionProp>>();
        for (int i = 0; i < needUpdateNodes.size(); i += 200) {
            int end = Math.min(i + 200, needUpdateNodes.size());
            partition.add(new ArrayList<EspActionProp>(needUpdateNodes.subList(i, end)));
        }
        ArrayList<String> res = new ArrayList<String>();
        for (List list : partition) {
            String actionIds = list.stream().map(e -> "'" + e.getActionId() + "'").collect(Collectors.joining(","));
            res.add(String.format(updateCql, actionIds, dateStr));
        }
        return res;
    }

    private List<String> buildCreateNodeStatement(List<EspActionProp> espActionPropList) {
        String createCql = "match (n:EspAction) where n.version = '1.0' and n.actionId in [%s] create (m%s) set m = n set m.version='2.0',m.switchTime='%s';";
        Map<String, List<EspActionProp>> labelsMap = espActionPropList.stream().collect(Collectors.groupingBy(e -> String.join((CharSequence)":", e.getLabels())));
        ArrayList<String> res = new ArrayList<String>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = simpleDateFormat.format(new Date());
        for (Map.Entry<String, List<EspActionProp>> entry : labelsMap.entrySet()) {
            String labels = entry.getKey();
            List<EspActionProp> value = entry.getValue();
            ArrayList<ArrayList<EspActionProp>> partition = new ArrayList<ArrayList<EspActionProp>>();
            for (int i = 0; i < value.size(); i += 200) {
                int n = Math.min(i + 200, value.size());
                partition.add(new ArrayList<EspActionProp>(value.subList(i, n)));
            }
            for (List list : partition) {
                String actionIds = list.stream().map(e -> "'" + e.getActionId() + "'").collect(Collectors.joining(","));
                res.add(String.format(createCql, actionIds, ":" + labels, dateStr));
            }
        }
        return res;
    }

    private StringBuffer buildUpdateNodeStatement(Map<String, Object> nodeResult) {
        Map properties = ((InternalNode)nodeResult.get("node")).asMap();
        String actionId = ObjectUtils.isEmpty(properties.get("actionId")) ? "" : (String)properties.get("actionId");
        StringBuffer nodeCypher = new StringBuffer("match (node");
        Collection labels = ((InternalNode)nodeResult.get("node")).labels();
        for (String label : labels) {
            nodeCypher.append(String.format(":%s", label));
        }
        nodeCypher.append("{actionId:'").append(actionId).append("', version:'2.0'}) set ");
        properties.forEach((k, v) -> {
            if (!"version".equals(k) && !"actionId".equals(k)) {
                if (k.contains(".")) {
                    nodeCypher.append("node.").append(String.format("`%s`", k));
                } else {
                    nodeCypher.append("node.").append(String.format("%s", k));
                }
                if (v instanceof String) {
                    String propertyValue2 = (String)v;
                    propertyValue2 = propertyValue2.replace("'", "\\\"");
                    nodeCypher.append("=").append(String.format("'%s',", propertyValue2));
                } else if (v instanceof Collection) {
                    nodeCypher.append("=[");
                    List propertyValueList = (List)v;
                    propertyValueList.forEach(propertyValue -> {
                        if (propertyValue instanceof String) {
                            nodeCypher.append(String.format("'%s'", propertyValue)).append(",");
                        } else {
                            nodeCypher.append(propertyValue).append(",");
                        }
                    });
                    if (!propertyValueList.isEmpty()) {
                        nodeCypher.deleteCharAt(nodeCypher.length() - 1);
                    }
                    nodeCypher.append("],");
                } else {
                    nodeCypher.append("=").append(v).append(",");
                }
            }
        });
        nodeCypher.append(String.format("node.switchTime='%s' return node", DateUtil.now()));
        return nodeCypher;
    }

    private StringBuffer buildCreateNodeStatement(Map<String, Object> nodeResult) {
        StringBuffer nodeCypher = new StringBuffer("create (node");
        Collection labels = ((InternalNode)nodeResult.get("node")).labels();
        for (String label : labels) {
            nodeCypher.append(String.format(":%s", label));
        }
        nodeCypher.append("{");
        Map properties = ((InternalNode)nodeResult.get("node")).asMap();
        String actionId = ObjectUtils.isEmpty(properties.get("actionId")) ? "" : (String)properties.get("actionId");
        this.applicationService.combineNodeProperties(properties, nodeCypher);
        nodeCypher.append(String.format("version:'2.0', switchTime:'%s'}) return id(node) as nodeId", DateUtil.now()));
        return nodeCypher;
    }

    public EspActionIdSwitchResDto assignSwitchEspAction(String id, String actionId, List<String> createdActionIdList) {
        Neo4jManager neo4jManager1 = new Neo4jManager(this.driver1);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("actionId", actionId);
        List testAction = neo4jManager1.ExecuteQuery("MATCH (n:EspAction) WHERE n.version = '1.0' and n.actionId=$actionId RETURN n.actionId as actionId", param);
        List prodAction = neo4jManager1.ExecuteQuery("MATCH (n:EspAction) WHERE n.version = '2.0' and n.actionId=$actionId RETURN n.actionId as actionId", param);
        ArrayList testActionIdList = new ArrayList();
        ArrayList prodActionIdList = new ArrayList();
        if (CollUtil.isEmpty((Collection)testAction)) {
            return new EspActionIdSwitchResDto(EspSwitchMsgEnum.UPDATE_FAIL.getType(), EspSwitchMsgEnum.UPDATE_FAIL.formatMsg(actionId, "\u672a\u67e5\u52301.0\u7248\u672c\u7684\u6570\u636e"));
        }
        testAction.forEach(ta -> testActionIdList.add(String.valueOf(ta.get("actionId"))));
        if (CollUtil.isNotEmpty((Collection)prodAction)) {
            prodAction.forEach(ta -> prodActionIdList.add(String.valueOf(ta.get("actionId"))));
        }
        ArrayList<Cql> executeCqlList = new ArrayList<Cql>();
        if (prodActionIdList.size() > 0) {
            List needUpdateNodes = neo4jManager1.ExecuteQuery("MATCH (node:EspAction{version:'1.0'}) MATCH (m:EspAction{version:'2.0'}) where node.actionId = m.actionId and m.actionId = $actionId and ((node.updateTime>m.updateTime) or (node.updateTime is not null and m.updateTime is null)) return node", param);
            if (needUpdateNodes.isEmpty()) {
                return new EspActionIdSwitchResDto(EspSwitchMsgEnum.NOT_NEED_UPDATE.getType(), EspSwitchMsgEnum.NOT_NEED_UPDATE.formatMsg(actionId, "1.0\u548c2.0\u6570\u636e\u66f4\u65b0\u65f6\u95f4\u76f8\u540c"));
            }
            for (Map nodeResult : needUpdateNodes) {
                StringBuffer nodeCypher = this.buildUpdateNodeStatement(nodeResult);
                executeCqlList.add(new Cql().setCql(StringEscapeUtils.escapeJava((String)nodeCypher.toString())));
            }
            Neo4jMultipleUtil.executeCqlTrans(executeCqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
        } else {
            List needCreateNodes = neo4jManager1.ExecuteQuery("MATCH (node:EspAction) WHERE node.version='1.0' and node.actionId = $actionId RETURN node", param);
            for (Map nodeResult : needCreateNodes) {
                StringBuffer nodeCypher = this.buildCreateNodeStatement(nodeResult);
                executeCqlList.add(new Cql().setCql(StringEscapeUtils.escapeJava((String)nodeCypher.toString())));
            }
            Neo4jMultipleUtil.executeCqlTrans(executeCqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
            createdActionIdList.add(actionId);
        }
        return new EspActionIdSwitchResDto(EspSwitchMsgEnum.UPDATE_SUCCESS.getType(), EspSwitchMsgEnum.UPDATE_SUCCESS.formatMsg(actionId, ""));
    }

    public void createEspActionRelaWithVirtualTenant() {
        this.kmApiHelper.mergeCommonAppRelaWithVirtualTenant("espCommon", "2.0", "2.0");
    }

    public List<EspActionIdSwitchResDto> kmAssignSwitchEspAction(String token, String id, String actionIds) {
        List res = this.kmApiHelper.assignSwitchEspAction(token, id, actionIds);
        return res;
    }

    public void updateEspDictionaryKey(String actionId, List<String> actionEnumKey) {
        Neo4jManager neo4jManager = new Neo4jManager(this.driver1);
        HashMap<String, String> upAppParams = new HashMap<String, String>();
        upAppParams.put("actionId", actionId);
        upAppParams.put("version", "1.0");
        List executeQuery = neo4jManager.ExecuteQuery("match(n:EspAction) where n.actionId=$actionId and n.version=$version return n.request_parameters as request_parameters,n.response_object as response_object", upAppParams);
        if (executeQuery.size() > 0) {
            Object request_parameters_str = ((Map)executeQuery.get(0)).get("request_parameters");
            List request_parameters = JSONArray.parseArray((String)((String)request_parameters_str), ApiDataFieldMetadataDTO.class);
            request_parameters.forEach(request_parameter -> this.putEnumKey("request", request_parameter.getData_name(), request_parameter, actionEnumKey));
            String request_str = JSON.toJSONString((Object)request_parameters);
            Object response_object_str = ((Map)executeQuery.get(0)).get("response_object");
            String response_str = "";
            if (!ObjectUtils.isEmpty(response_object_str)) {
                ApiDataFieldMetadataDTO response_object = (ApiDataFieldMetadataDTO)JSONObject.parseObject((String)((String)response_object_str), ApiDataFieldMetadataDTO.class);
                this.putEnumKey("response", response_object.getData_name(), response_object, actionEnumKey);
                response_str = JSON.toJSONString((Object)response_object);
            }
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Match (action:Action:EspAction {");
            stringBuffer.append("actionId:'");
            stringBuffer.append(actionId);
            stringBuffer.append("', version:'1.0'}) set action.request_parameters='");
            stringBuffer.append(request_str);
            stringBuffer.append("', action.response_object='");
            stringBuffer.append(response_str);
            stringBuffer.append("', action.updateTime='");
            stringBuffer.append(dateFormat.format(date));
            stringBuffer.append("'");
            Neo4jMultipleUtil.executeCql((String)StringEscapeUtils.escapeJava((String)stringBuffer.toString()), new HashMap(), (Driver[])new Driver[]{this.driver1, this.driver2});
        }
    }

    public void putEnumKey(String type, String fullPath, ApiDataFieldMetadataDTO apiDataFieldMetadataDTO, List<String> actionEnumKey) {
        if ("object".equals(apiDataFieldMetadataDTO.getData_type())) {
            List subFieldList = apiDataFieldMetadataDTO.getField();
            for (ApiDataFieldMetadataDTO subField : subFieldList) {
                if ("object".equals(subField.getData_type())) {
                    this.putEnumKey(type, fullPath + "." + subField.getData_name(), subField, actionEnumKey);
                    continue;
                }
                String path = type + "___" + fullPath + "." + subField.getData_name() + "___" + subField.getData_name();
                subField.setEnum_key(this.findEnumKey(actionEnumKey, path));
            }
        } else {
            String path = type + "___" + fullPath + "___" + apiDataFieldMetadataDTO.getData_name();
            apiDataFieldMetadataDTO.setEnum_key(this.findEnumKey(actionEnumKey, path));
        }
    }

    private String findEnumKey(List<String> actionEnumKey, String path) {
        String data = actionEnumKey.stream().filter(ae -> ae.contains(path)).findFirst().orElse(null);
        if (StringUtils.isEmpty((Object)data)) {
            return null;
        }
        String[] split = data.split(path + "___");
        if (split.length > 1) {
            return split[split.length - 1];
        }
        return null;
    }
}

