/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.service.deploy.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.domain.param.AdTemplatePublishParam;
import com.digiwin.athena.athena_deployer_service.domain.system.AthenaUser;
import com.digiwin.athena.athena_deployer_service.domain.template.AdTemplate;
import com.digiwin.athena.athena_deployer_service.service.deploy.AdTemplateService;
import com.digiwin.athena.athena_deployer_service.service.iam.IamService;
import com.digiwin.athena.athena_deployer_service.service.sd.SmartDataService;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdTemplateServiceImpl
implements AdTemplateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdTemplateServiceImpl.class);
    @Autowired
    private SmartDataService smartDataService;
    @Autowired
    private IamService iamService;

    public void publish(AdTemplatePublishParam adTemplatePublishParam) {
        JSONObject adTemplate = adTemplatePublishParam.getAdTemplate();
        AthenaUser currentUser = adTemplatePublishParam.getCurrentUser();
        String token = this.iamService.getIntegrationToken(currentUser.getTenantId());
        List tenantIds = adTemplatePublishParam.getTenantUsers().stream().map(t -> t.getTenantId()).collect(Collectors.toList());
        this.smartDataService.batchPublish(token, tenantIds, (AdTemplate)adTemplate.toJavaObject(AdTemplate.class));
    }

    public void publishScDispatcherTemplate(AdTemplatePublishParam adTemplatePublishParam) {
        JSONObject adTemplate = adTemplatePublishParam.getAdTemplate();
        AthenaUser currentUser = adTemplatePublishParam.getCurrentUser();
        String token = this.iamService.getIntegrationToken(currentUser.getTenantId());
        this.smartDataService.publish(token, adTemplatePublishParam.getNeedRouterKey(), null, (AdTemplate)adTemplate.toJavaObject(AdTemplate.class));
    }

    public void disableTemplateAllVersion(AdTemplatePublishParam adTemplatePublishParam) {
        JSONObject adTemplate = adTemplatePublishParam.getAdTemplate();
        List tenantIds = adTemplatePublishParam.getTenantIds();
        AthenaUser currentUser = adTemplatePublishParam.getCurrentUser();
        String token = this.iamService.getIntegrationToken(currentUser.getTenantId());
        this.smartDataService.batchDisable(token, tenantIds, (AdTemplate)adTemplate.toJavaObject(AdTemplate.class));
    }

    public void publishV2(AdTemplatePublishParam adTemplatePublishParam) {
        JSONObject adTemplate = adTemplatePublishParam.getAdTemplate();
        AthenaUser currentUser = adTemplatePublishParam.getCurrentUser();
        String token = this.iamService.getIntegrationToken(currentUser.getTenantId());
        List tenantIds = adTemplatePublishParam.getTenantUsers().stream().map(t -> t.getTenantId()).collect(Collectors.toList());
        this.smartDataService.batchPublishV2(token, tenantIds, (AdTemplate)adTemplate.toJavaObject(AdTemplate.class), adTemplatePublishParam.getIsCustom());
    }

    public void publishScDispatcherTemplateV2(AdTemplatePublishParam adTemplatePublishParam) {
        JSONObject adTemplate = adTemplatePublishParam.getAdTemplate();
        AthenaUser currentUser = adTemplatePublishParam.getCurrentUser();
        String token = this.iamService.getIntegrationToken(currentUser.getTenantId());
        this.smartDataService.publishV2(token, adTemplatePublishParam.getNeedRouterKey(), null, (AdTemplate)adTemplate.toJavaObject(AdTemplate.class), adTemplatePublishParam.getIsCustom());
    }

    public void disableTemplateAllVersionV2(AdTemplatePublishParam adTemplatePublishParam) {
        JSONObject adTemplate = adTemplatePublishParam.getAdTemplate();
        List tenantIds = adTemplatePublishParam.getTenantIds();
        AthenaUser currentUser = adTemplatePublishParam.getCurrentUser();
        String token = this.iamService.getIntegrationToken(currentUser.getTenantId());
        this.smartDataService.batchDisableV2(token, tenantIds, (AdTemplate)adTemplate.toJavaObject(AdTemplate.class), adTemplatePublishParam.getIsCustom());
    }
}

