/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.service.deploy.impl;

import com.digiwin.athena.athena_deployer_service.domain.application.Application;
import com.digiwin.athena.athena_deployer_service.neo4jbasepkg.backup.domain.BackupAppEntity;
import com.digiwin.athena.athena_deployer_service.neo4jbasepkg.backup.repository.BackupAppEntityRepository;
import com.digiwin.athena.athena_deployer_service.neo4jbasepkg.master.domain.MasterAppEntity;
import com.digiwin.athena.athena_deployer_service.neo4jbasepkg.master.repository.MasterAppEntityRepository;
import com.digiwin.athena.athena_deployer_service.service.deploy.AppEntityService;
import java.util.List;
import lombok.Generated;
import org.neo4j.driver.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class AppEntityServiceImpl
implements AppEntityService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppEntityServiceImpl.class);
    @Autowired
    private MasterAppEntityRepository masterAppEntityRepository;
    @Autowired(required=false)
    private BackupAppEntityRepository backupAppEntityRepository;
    @Autowired(required=false)
    @Qualifier(value="domain2Driver")
    private Driver backupDriver;

    public void save(Application application, List<String> tenantIds) {
        MasterAppEntity masterAppEntity = this.masterAppEntityRepository.findByCode(application.getCode());
        if (masterAppEntity == null) {
            masterAppEntity = new MasterAppEntity().setCode(application.getCode()).setNamespace(application.getCode()).setName(application.getName()).setVersion(application.getVersion());
            this.masterAppEntityRepository.save((Object)masterAppEntity);
        }
        this.masterAppEntityRepository.mergeRelation(tenantIds, application.getCode());
        if (this.backupDriver != null) {
            BackupAppEntity backupAppEntity = this.backupAppEntityRepository.findByCode(application.getCode());
            if (backupAppEntity == null) {
                backupAppEntity = new BackupAppEntity().setCode(application.getCode()).setNamespace(application.getCode()).setName(application.getName()).setVersion(application.getVersion());
                this.backupAppEntityRepository.save((Object)backupAppEntity);
            }
            this.backupAppEntityRepository.mergeRelation(tenantIds, application.getCode());
        }
    }

    public void save(Application application) {
        BackupAppEntity backupAppEntity;
        MasterAppEntity masterAppEntity = this.masterAppEntityRepository.findByCode(application.getCode());
        if (masterAppEntity == null) {
            masterAppEntity = new MasterAppEntity().setCode(application.getCode()).setNamespace(application.getCode()).setName(application.getName()).setVersion(application.getVersion());
            this.masterAppEntityRepository.save((Object)masterAppEntity);
        }
        if (this.backupDriver != null && (backupAppEntity = this.backupAppEntityRepository.findByCode(application.getCode())) != null) {
            backupAppEntity = new BackupAppEntity().setCode(application.getCode()).setNamespace(application.getCode()).setName(application.getName()).setVersion(application.getVersion());
            this.backupAppEntityRepository.save((Object)backupAppEntity);
        }
    }
}

