/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.service.deploy.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.service.deploy.AsyncService;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AsyncServiceImpl
implements AsyncService {
    @Autowired
    private MongoTemplate mongoTemplate;

    @Async(value="asyncExecutor")
    public void moduleAssignPublishRecord(String targetTenantId, String designerDomain, String application, String code, String operateType, String serviceCode, JSONObject modelSchema) {
        FindIterable documents;
        Document first;
        Bson filters = Filters.and((Bson[])new Bson[]{Filters.eq((String)"application", (Object)application), Filters.eq((String)"code", (Object)code), Filters.eq((String)"sourceType", (Object)operateType), Filters.eq((String)"publishEnv", (Object)designerDomain)});
        if (!StringUtils.isEmpty((Object)serviceCode)) {
            filters = Filters.and((Bson[])new Bson[]{filters, Filters.eq((String)"serviceCode", (Object)serviceCode)});
        }
        if (Objects.isNull(first = (Document)(documents = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("deployer").getCollection("modulePublishRecord").find(filters)).first())) {
            Document modulePublishRecord = new Document();
            modulePublishRecord.put("publishEnv", (Object)designerDomain);
            modulePublishRecord.put("targetTenantId", (Object)targetTenantId);
            modulePublishRecord.put("application", (Object)application);
            modulePublishRecord.put("sourceType", (Object)operateType);
            modulePublishRecord.put("code", (Object)code);
            modulePublishRecord.put("publishTime", (Object)DateUtil.now());
            modulePublishRecord.put("serviceCode", (Object)serviceCode);
            if (modelSchema != null) {
                String md5Record = DigestUtils.md5Hex((String)JSON.toJSONString((Object)modelSchema));
                modulePublishRecord.put("md5Record", (Object)md5Record);
            }
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("deployer").getCollection("modulePublishRecord").insertOne((Object)modulePublishRecord);
        } else {
            first.put("publishTime", (Object)DateUtil.now());
            if (modelSchema != null) {
                String md5Record = DigestUtils.md5Hex((String)JSON.toJSONString((Object)modelSchema));
                first.put("md5Record", (Object)md5Record);
            }
            first.remove((Object)"_id");
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("deployer").getCollection("modulePublishRecord").updateOne(filters, (Bson)new Document("$set", (Object)first), new UpdateOptions().upsert(false));
        }
    }
}

