/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.service.deploy.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.domain.TenantUser;
import com.digiwin.athena.athena_deployer_service.domain.deploy.CustomPublishParam;
import com.digiwin.athena.athena_deployer_service.domain.deploy.PublishEntity;
import com.digiwin.athena.athena_deployer_service.enums.FromNodeToNodeEnum;
import com.digiwin.athena.athena_deployer_service.http.atmc.AtmcApiHelper;
import com.digiwin.athena.athena_deployer_service.http.km.KmApiHelper;
import com.digiwin.athena.athena_deployer_service.http.km.dto.DeployAppReqDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.KmSingleModuleJobDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.KmSingleModuleParamDto;
import com.digiwin.athena.athena_deployer_service.publish.CustomPublish;
import com.digiwin.athena.athena_deployer_service.publish.DataFlowPublish;
import com.digiwin.athena.athena_deployer_service.publish.DataViewPublish;
import com.digiwin.athena.athena_deployer_service.publish.EventPublish;
import com.digiwin.athena.athena_deployer_service.publish.KitAssignPublish;
import com.digiwin.athena.athena_deployer_service.publish.MobilePageDesignPublish;
import com.digiwin.athena.athena_deployer_service.publish.ModelDrivenPublish;
import com.digiwin.athena.athena_deployer_service.publish.ProcessPublish;
import com.digiwin.athena.athena_deployer_service.publish.SceneTriggerPublish;
import com.digiwin.athena.athena_deployer_service.publish.TenantProcessPublish;
import com.digiwin.athena.athena_deployer_service.service.deploy.CustomPublishService;
import com.digiwin.athena.athena_deployer_service.service.deploy.TenantService;
import com.digiwin.athena.athena_deployer_service.service.dmc.DmcService;
import com.digiwin.athena.athena_deployer_service.util.Neo4jMultipleUtil;
import com.digiwin.athena.athena_deployer_service.util.SafeFileUtils;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bson.Document;
import org.neo4j.driver.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class CustomPublishServiceImpl
implements CustomPublishService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomPublishServiceImpl.class);
    @Value(value="${compile.zipPath}")
    private String compileZipPath;
    @Value(value="${compile.dataPath}")
    private String compileDataPath;
    @Autowired
    private DmcService dmcService;
    @Autowired
    private List<CustomPublish> customPublishList;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private Driver driver1;
    @Autowired(required=false)
    @Qualifier(value="domain2Driver")
    private Driver driver2;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private KmApiHelper kmApiHelper;
    @Autowired
    private AtmcApiHelper atmcApiHelper;
    @Autowired
    private ModelDrivenPublish modelDrivenPublish;
    @Autowired
    private KitAssignPublish kitAssignPublish;
    @Autowired
    private DataViewPublish dataViewPublish;
    @Autowired
    private MobilePageDesignPublish mobilePageDesignPublish;
    @Autowired
    private ProcessPublish processPublish;
    @Autowired
    private EventPublish eventPublish;
    @Autowired
    private DataFlowPublish dataFlowPublish;
    @Autowired
    private TenantProcessPublish tenantProcessPublish;
    @Autowired
    private SceneTriggerPublish sceneTriggerPublish;
    private static Map<String, List<FromNodeToNodeEnum>> MODULE_RELATION_MAP = new HashMap();

    @PostConstruct
    public void initModuleRelation() {
        MODULE_RELATION_MAP.put("monitorRule", ListUtil.toList((Object[])new FromNodeToNodeEnum[]{FromNodeToNodeEnum.MONITOR}));
        MODULE_RELATION_MAP.put("task", ListUtil.toList((Object[])new FromNodeToNodeEnum[]{FromNodeToNodeEnum.RELATED_OBJECT, FromNodeToNodeEnum.TAG, FromNodeToNodeEnum.SOLVE_PLAN, FromNodeToNodeEnum.DATA_ENTITY}));
        MODULE_RELATION_MAP.put("action", ListUtil.toList((Object[])new FromNodeToNodeEnum[]{FromNodeToNodeEnum.ACTION, FromNodeToNodeEnum.DATA_ENTITY}));
        MODULE_RELATION_MAP.put("DataEntry", ListUtil.toList((Object[])new FromNodeToNodeEnum[]{FromNodeToNodeEnum.RELATED_OBJECT, FromNodeToNodeEnum.TAG}));
        MODULE_RELATION_MAP.put("Statement", ListUtil.toList((Object[])new FromNodeToNodeEnum[]{FromNodeToNodeEnum.RELATED_OBJECT, FromNodeToNodeEnum.TAG}));
        this.customPublishList = this.customPublishList.stream().filter(c -> {
            if (c instanceof ProcessPublish) {
                return false;
            }
            if (c instanceof EventPublish) {
                return false;
            }
            if (c instanceof DataViewPublish) {
                return false;
            }
            if (c instanceof DataFlowPublish) {
                return false;
            }
            return !(c instanceof SceneTriggerPublish);
        }).collect(Collectors.toList());
    }

    public void customPublish(CustomPublishParam customPublishParam) {
        String application = customPublishParam.getApplication();
        String compileVersion = customPublishParam.getCompileVersion();
        String deployVersion = customPublishParam.getDeployVersion();
        JSONObject compileData = customPublishParam.getCompileData();
        List tenantUsers = customPublishParam.getTenantUsers();
        List publishEntityList = customPublishParam.getPublishEntityList();
        File compileDataDirector = this.getCompiledDataFiles(application, compileVersion, compileData);
        customPublishParam.setCompileDataDirector(compileDataDirector);
        try {
            for (CustomPublish customPublish : this.customPublishList) {
                customPublish.publishWithCompile(customPublishParam);
            }
            File cypherFile = SafeFileUtils.createFile((String)(compileDataDirector.getPath() + File.separator + "cypher" + File.separator + compileVersion + ".json"));
            if (!"new".equals(customPublishParam.getPublishMode())) {
                Boolean commonApp;
                if (cypherFile.exists()) {
                    matchCql = this.filterRelationCql(publishEntityList, cypherFile);
                    for (String cql : matchCql) {
                        cql = cql.replaceAll("\\{athena_version}", deployVersion);
                        cql = cql.replaceAll("\\{common_version}", deployVersion);
                        Neo4jMultipleUtil.executeCql((String)cql, (Driver[])new Driver[]{this.driver1, this.driver2});
                    }
                }
                if ((commonApp = Optional.ofNullable(customPublishParam.getCommonApp()).orElse(false)).booleanValue()) {
                    this.kmApiHelper.mergeCommonAppRelaWithVirtualTenant(application, "1.0", "1.0");
                } else {
                    this.tenantService.createTenantAndApplicationRelation(application, "1.0", "1.0", new ArrayList());
                }
            } else if (cypherFile.exists()) {
                matchCql = this.filterRelationCql(publishEntityList, cypherFile);
                matchCql = matchCql.stream().map(c -> c.replaceAll("\\{athena_version\\}", "1.0")).collect(Collectors.toList());
                DeployAppReqDto deployAppReqDto = DeployAppReqDto.create((CustomPublishParam)customPublishParam);
                KmSingleModuleParamDto kmSingleModuleParamDto = new KmSingleModuleParamDto();
                kmSingleModuleParamDto.setCyphers(matchCql);
                deployAppReqDto.setAppData(kmSingleModuleParamDto);
                deployAppReqDto.getJobList().add(KmSingleModuleJobDto.createEmptyJob());
                if (!deployAppReqDto.appDataIsEmpty()) {
                    this.kmApiHelper.deployApp(deployAppReqDto, customPublishParam.getCurrentUser().getTenantId());
                }
            }
            String tenantId = ((TenantUser)tenantUsers.get(0)).getTenantId();
            String appCode = "tenantApp".equals(customPublishParam.getKmDeployAppType()) ? customPublishParam.getSourceApplicationCode() : customPublishParam.getApplication();
            this.kmApiHelper.updateApplicationComponentList(appCode, "1.0", tenantId);
            this.kmApiHelper.cacheReset(tenantId);
            this.atmcApiHelper.cacheReset();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            FileUtil.del((File)compileDataDirector);
            ArrayList module = new ArrayList();
            publishEntityList.forEach(pe -> module.add(pe.getType()));
            String compiledDataFileId = compileData.getString("compiledDataFileId");
            Document document = new Document();
            document.put("compiledDataFileId", (Object)compiledDataFileId);
            document.put("time", (Object)new Date());
            document.put("application", (Object)application);
            document.put("module", module);
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("deployer").getCollection("modulePublishLog").insertOne((Object)document);
        }
    }

    public void customTenantDtdPublish(CustomPublishParam customPublishParam) {
        this.tenantProcessPublish.publishWithCompile(customPublishParam);
    }

    public void customModelPublish(CustomPublishParam customPublishParam) {
        String application = customPublishParam.getApplication();
        String compileVersion = customPublishParam.getCompileVersion();
        String deployVersion = customPublishParam.getDeployVersion();
        JSONObject compileData = customPublishParam.getCompileData();
        List publishEntityList = customPublishParam.getPublishEntityList();
        File compileDataDirector = this.getCompiledDataFiles(application, compileVersion, compileData);
        customPublishParam.setCompileDataDirector(compileDataDirector);
        try {
            this.modelDrivenPublish.publishWithCompile(customPublishParam);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            FileUtil.del((File)compileDataDirector);
            String compiledDataFileId = compileData.getString("compiledDataFileId");
            Document document = new Document();
            document.put("compiledDataFileId", (Object)compiledDataFileId);
            document.put("time", (Object)new Date());
            document.put("application", (Object)application);
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("deployer").getCollection("modulePublishLog").insertOne((Object)document);
        }
    }

    public void customKitPublish(CustomPublishParam customPublishParam) {
        String application = customPublishParam.getApplication();
        String compileVersion = customPublishParam.getCompileVersion();
        JSONObject compileData = customPublishParam.getCompileData();
        File compileDataDirector = this.getCompiledDataFiles(application, compileVersion, compileData);
        customPublishParam.setCompileDataDirector(compileDataDirector);
        try {
            this.kitAssignPublish.publishWithCompile(customPublishParam);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            FileUtil.del((File)compileDataDirector);
            String compiledDataFileId = compileData.getString("compiledDataFileId");
            Document document = new Document();
            document.put("compiledDataFileId", (Object)compiledDataFileId);
            document.put("time", (Object)new Date());
            document.put("application", (Object)application);
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("deployer").getCollection("modulePublishLog").insertOne((Object)document);
        }
    }

    public void customDataViewPublish(CustomPublishParam customPublishParam) {
        String application = customPublishParam.getApplication();
        String compileVersion = customPublishParam.getCompileVersion();
        JSONObject compileData = customPublishParam.getCompileData();
        File compileDataDirector = this.getCompiledDataFiles(application, compileVersion, compileData);
        customPublishParam.setCompileDataDirector(compileDataDirector);
        try {
            this.dataViewPublish.publishWithCompile(customPublishParam);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            FileUtil.del((File)compileDataDirector);
            String compiledDataFileId = compileData.getString("compiledDataFileId");
            Document document = new Document();
            document.put("compiledDataFileId", (Object)compiledDataFileId);
            document.put("time", (Object)new Date());
            document.put("application", (Object)application);
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("deployer").getCollection("modulePublishLog").insertOne((Object)document);
        }
    }

    public void customMobilePageDesignPublish(CustomPublishParam customPublishParam) {
        String application = customPublishParam.getApplication();
        String compileVersion = customPublishParam.getCompileVersion();
        JSONObject compileData = customPublishParam.getCompileData();
        File compileDataDirector = this.getCompiledDataFiles(application, compileVersion, compileData);
        customPublishParam.setCompileDataDirector(compileDataDirector);
        try {
            this.mobilePageDesignPublish.publishWithCompile(customPublishParam);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            FileUtil.del((File)compileDataDirector);
            String compiledDataFileId = compileData.getString("compiledDataFileId");
            Document document = new Document();
            document.put("compiledDataFileId", (Object)compiledDataFileId);
            document.put("time", (Object)new Date());
            document.put("application", (Object)application);
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("deployer").getCollection("modulePublishLog").insertOne((Object)document);
        }
    }

    public void customProcessPublish(CustomPublishParam customPublishParam) {
        String application = customPublishParam.getApplication();
        String compileVersion = customPublishParam.getCompileVersion();
        JSONObject compileData = customPublishParam.getCompileData();
        File compileDataDirector = this.getCompiledDataFiles(application, compileVersion, compileData);
        customPublishParam.setCompileDataDirector(compileDataDirector);
        try {
            this.processPublish.publishWithCompile(customPublishParam);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            FileUtil.del((File)compileDataDirector);
            String compiledDataFileId = compileData.getString("compiledDataFileId");
            Document document = new Document();
            document.put("compiledDataFileId", (Object)compiledDataFileId);
            document.put("time", (Object)new Date());
            document.put("application", (Object)application);
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("deployer").getCollection("modulePublishLog").insertOne((Object)document);
        }
    }

    public void customEventPublish(CustomPublishParam customPublishParam) {
        String application = customPublishParam.getApplication();
        String compileVersion = customPublishParam.getCompileVersion();
        JSONObject compileData = customPublishParam.getCompileData();
        File compileDataDirector = this.getCompiledDataFiles(application, compileVersion, compileData);
        customPublishParam.setCompileDataDirector(compileDataDirector);
        try {
            this.eventPublish.publishWithCompile(customPublishParam);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            FileUtil.del((File)compileDataDirector);
            String compiledDataFileId = compileData.getString("compiledDataFileId");
            Document document = new Document();
            document.put("compiledDataFileId", (Object)compiledDataFileId);
            document.put("time", (Object)new Date());
            document.put("application", (Object)application);
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("deployer").getCollection("modulePublishLog").insertOne((Object)document);
        }
    }

    public void customDataFlowPublish(CustomPublishParam customPublishParam) {
        String application = customPublishParam.getApplication();
        String compileVersion = customPublishParam.getCompileVersion();
        JSONObject compileData = customPublishParam.getCompileData();
        File compileDataDirector = this.getCompiledDataFiles(application, compileVersion, compileData);
        customPublishParam.setCompileDataDirector(compileDataDirector);
        try {
            this.dataFlowPublish.publishWithCompile(customPublishParam);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            FileUtil.del((File)compileDataDirector);
            String compiledDataFileId = compileData.getString("compiledDataFileId");
            Document document = new Document();
            document.put("compiledDataFileId", (Object)compiledDataFileId);
            document.put("time", (Object)new Date());
            document.put("application", (Object)application);
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("deployer").getCollection("modulePublishLog").insertOne((Object)document);
        }
    }

    public void customScenePublish(CustomPublishParam customPublishParam) {
        String application = customPublishParam.getApplication();
        String compileVersion = customPublishParam.getCompileVersion();
        JSONObject compileData = customPublishParam.getCompileData();
        File compileDataDirector = this.getCompiledDataFiles(application, compileVersion, compileData);
        customPublishParam.setCompileDataDirector(compileDataDirector);
        try {
            this.sceneTriggerPublish.publishWithCompile(customPublishParam);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            FileUtil.del((File)compileDataDirector);
            String compiledDataFileId = compileData.getString("compiledDataFileId");
            Document document = new Document();
            document.put("compiledDataFileId", (Object)compiledDataFileId);
            document.put("time", (Object)new Date());
            document.put("application", (Object)application);
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("deployer").getCollection("modulePublishLog").insertOne((Object)document);
        }
    }

    public void customTenantProcessPublish(CustomPublishParam customPublishParam) {
        this.tenantProcessPublish.publishWithCompile(customPublishParam);
    }

    public void singleModulePublishV2(CustomPublishParam customPublishParam) {
        String application = customPublishParam.getApplication();
        String compileVersion = customPublishParam.getCompileVersion();
        JSONObject compileData = customPublishParam.getCompileData();
        List tenantUsers = customPublishParam.getTenantUsers();
        File compileDataDirector = this.getCompiledDataFiles(application, compileVersion, compileData);
        customPublishParam.setCompileDataDirector(compileDataDirector);
        try {
            DeployAppReqDto deployAppReqDto = DeployAppReqDto.create((CustomPublishParam)customPublishParam);
            deployAppReqDto.collectPublishData(customPublishParam);
            this.kmApiHelper.deployApp(deployAppReqDto, customPublishParam.getCurrentUser().getTenantId());
            String tenantId = ((TenantUser)tenantUsers.get(0)).getTenantId();
            String appCode = "tenantApp".equals(customPublishParam.getKmDeployAppType()) ? customPublishParam.getSourceApplicationCode() : customPublishParam.getApplication();
            this.kmApiHelper.updateApplicationComponentList(appCode, "1.0", tenantId);
            this.kmApiHelper.cacheReset(tenantId);
            this.atmcApiHelper.cacheReset();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            FileUtil.del((File)compileDataDirector);
        }
    }

    private List<String> filterRelationCql(List<PublishEntity> publishEntityList, File cypherFile) {
        List cqlList;
        Map<String, List<PublishEntity>> collect = publishEntityList.stream().collect(Collectors.groupingBy(publishEntity -> publishEntity.getType()));
        List finalCqlList = cqlList = FileUtil.readLines((File)cypherFile, (Charset)Charset.forName("utf-8"));
        ArrayList<String> matchCql = new ArrayList<String>();
        collect.forEach((module, publishEntities) -> {
            List fromNodeToNodeEnums = (List)MODULE_RELATION_MAP.get(module);
            if (CollUtil.isNotEmpty((Collection)fromNodeToNodeEnums)) {
                ArrayList<String> regexList = new ArrayList<String>();
                Set publishEntityPkList = publishEntities.stream().map(publishEntity -> String.valueOf(publishEntity.getPkValue())).collect(Collectors.toSet());
                CharSequence[] publishEntityPkArray = (String[])ArrayUtil.toArray(publishEntityPkList, String.class);
                for (FromNodeToNodeEnum fromNodeToNodeEnum : fromNodeToNodeEnums) {
                    String fromNode = fromNodeToNodeEnum.getFromNode();
                    List toNodeList = fromNodeToNodeEnum.getToNode();
                    for (String toNode : toNodeList) {
                        regexList.add(StrUtil.format((CharSequence)".*fromNode:{}.*toNode:{}.*", (Object[])new Object[]{fromNode, toNode}));
                    }
                }
                List tagIdList = cqlList.stream().filter(arg_0 -> CustomPublishServiceImpl.lambda$filterRelationCql$5((String[])publishEntityPkArray, arg_0)).map(cql -> StrUtil.subBetween((CharSequence)cql, (CharSequence)"id:", (CharSequence)",")).collect(Collectors.toList());
                block2: for (String cql2 : finalCqlList) {
                    for (String regex : regexList) {
                        boolean match = ReUtil.isMatch((String)regex, (CharSequence)cql2);
                        if (!match || !StrUtil.containsAny((CharSequence)cql2, (CharSequence[])publishEntityPkArray) && !StrUtil.containsAny((CharSequence)cql2, (CharSequence[])((CharSequence[])ArrayUtil.toArray(tagIdList, String.class)))) continue;
                        matchCql.add(cql2);
                        continue block2;
                    }
                }
            }
        });
        return matchCql;
    }

    private File getCompiledDataFiles(String application, String version, JSONObject compiledData) {
        String applicationCompileZipPath = this.compileZipPath + File.separator + application + File.separator;
        String applicationCompileDataPath = this.compileDataPath + File.separator + application + File.separator;
        String compiledDataFileId = compiledData.getString("compiledDataFileId");
        String compileDataZipPath = StrUtil.format((CharSequence)(applicationCompileZipPath + application + "_{}.zip"), (Object[])new Object[]{version});
        InputStream inputStream = this.dmcService.download(compiledDataFileId);
        FileUtil.writeFromStream((InputStream)inputStream, (String)compileDataZipPath);
        ZipUtil.unzip((String)compileDataZipPath, (String)applicationCompileDataPath);
        File compileDataDirector = SafeFileUtils.createFile((String)applicationCompileDataPath);
        FileUtil.del((String)compileDataZipPath);
        return compileDataDirector;
    }

    private static /* synthetic */ boolean lambda$filterRelationCql$5(String[] publishEntityPkArray, String cql) {
        return cql.startsWith("create (node:Tag") && StrUtil.containsAny((CharSequence)cql, (CharSequence[])publishEntityPkArray);
    }
}

