/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.service.deploy.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.config.neo4j.Neo4jManager;
import com.digiwin.athena.athena_deployer_service.constant.TbbDataTypeConstant;
import com.digiwin.athena.athena_deployer_service.domain.ApplicationData;
import com.digiwin.athena.athena_deployer_service.domain.activity.ActivityConfig;
import com.digiwin.athena.athena_deployer_service.domain.activity.Neo4jActivity;
import com.digiwin.athena.athena_deployer_service.domain.application.Application;
import com.digiwin.athena.athena_deployer_service.domain.deploy.DeployProcess;
import com.digiwin.athena.athena_deployer_service.domain.designer.File2DbResult;
import com.digiwin.athena.athena_deployer_service.domain.dsl.Dsl;
import com.digiwin.athena.athena_deployer_service.domain.dsl.component.AbstractComponent;
import com.digiwin.athena.athena_deployer_service.domain.form.Form;
import com.digiwin.athena.athena_deployer_service.domain.form.FormField;
import com.digiwin.athena.athena_deployer_service.domain.form.FormSchema;
import com.digiwin.athena.athena_deployer_service.domain.form.LaunchProject;
import com.digiwin.athena.athena_deployer_service.domain.neo4j.Cql;
import com.digiwin.athena.athena_deployer_service.domain.neo4j.CqlMapper;
import com.digiwin.athena.athena_deployer_service.domain.neo4j.MyStatement;
import com.digiwin.athena.athena_deployer_service.domain.param.CleanMongoParam;
import com.digiwin.athena.athena_deployer_service.domain.param.CleanNeo4jParam;
import com.digiwin.athena.athena_deployer_service.domain.param.DeployParam;
import com.digiwin.athena.athena_deployer_service.domain.param.File2DbParam;
import com.digiwin.athena.athena_deployer_service.domain.param.PolicyBatchAddParam;
import com.digiwin.athena.athena_deployer_service.domain.param.SwitchVersionParam;
import com.digiwin.athena.athena_deployer_service.domain.system.AthenaUser;
import com.digiwin.athena.athena_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.athena_deployer_service.domain.system.MultiLanguageDTO;
import com.digiwin.athena.athena_deployer_service.http.designer.DesignerApiHelper;
import com.digiwin.athena.athena_deployer_service.http.km.KmApiHelper;
import com.digiwin.athena.athena_deployer_service.service.deploy.AppEntityService;
import com.digiwin.athena.athena_deployer_service.service.deploy.DeployService;
import com.digiwin.athena.athena_deployer_service.service.deploy.PageDesignService;
import com.digiwin.athena.athena_deployer_service.service.deploy.StatementService;
import com.digiwin.athena.athena_deployer_service.service.deploy.TenantService;
import com.digiwin.athena.athena_deployer_service.service.dmc.DmcService;
import com.digiwin.athena.athena_deployer_service.service.iam.IamService;
import com.digiwin.athena.athena_deployer_service.service.sd.SmartDataService;
import com.digiwin.athena.athena_deployer_service.util.MongoUtil;
import com.digiwin.athena.athena_deployer_service.util.Neo4jMultipleUtil;
import com.digiwin.athena.athena_deployer_service.util.PageDesignPublishUtil;
import com.digiwin.athena.athena_deployer_service.util.RedisCache;
import com.digiwin.athena.athena_deployer_service.util.SafeFileUtils;
import com.mongodb.MongoWriteException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.neo4j.driver.Driver;
import org.neo4j.driver.internal.InternalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DeployServiceImpl
implements DeployService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployServiceImpl.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private Driver driver1;
    @Autowired(required=false)
    @Qualifier(value="domain2Driver")
    private Driver driver2;
    @Value(value="${compile.zipPath}")
    private String compileZipPath;
    @Value(value="${compile.dataPath}")
    private String compileDataPath;
    @Value(value="${design.zipPath}")
    private String designZipPath;
    @Value(value="${design.dataPath}")
    private String designDataPath;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private DmcService dmcService;
    @Autowired
    private SmartDataService smartDataService;
    @Autowired
    private DesignerApiHelper designerApiHelper;
    @Autowired
    private PageDesignService pageDesignService;
    @Autowired
    private AppEntityService appEntityService;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private StatementService statementService;
    @Autowired
    private IamService iamService;
    @Autowired
    private KmApiHelper kmApiHelper;
    public static final String PARTITION = "DEPLOY_PROCESS";
    private static ReentrantLock LOCK = new ReentrantLock();
    private static final List<String> COMPENT_TYPE = Arrays.asList("SELECT", "RADIO_GROUP");
    protected static final List<String> PATTERN_TBB = Arrays.asList("STATEMENT", "MOBI-STATEMENT");
    protected static final List<String> PATTERN_ABI = Arrays.asList("STATEMENT");
    protected static final List<String> CATEGORY_TBB = Arrays.asList("STATEMENT");
    protected static final List<String> CATEGORY_ABI = Arrays.asList("ABI-STATEMENT");

    public void deploy(DeployParam deployParam) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public void writeData2Db(DeployParam deployParam) {
        List pageDesignList;
        log.info("\u5f00\u59cb\u5199\u5165\u6570\u636e{}:{}", (Object)deployParam.getApplication(), (Object)Thread.currentThread().getId());
        String deployVersion = deployParam.getDeployVersion();
        JSONObject compiledData = deployParam.getCompiledData();
        String application = deployParam.getApplication();
        String env = deployParam.getEnv();
        String compileVersion = compiledData.getString("version");
        File[] compiledDataFiles = this.getCompiledDataFiles(application, compileVersion, compiledData);
        try {
            File[] file2DbParam = new File2DbParam();
            file2DbParam.setApplication(application).setCompileDataFiles(compiledDataFiles).setDeployVersion(deployVersion).setCompileVersion(compileVersion);
            List results = this.fileData2Db((File2DbParam)file2DbParam);
            pageDesignList = results.stream().filter(result -> "pageDesign".equals(result.getKey())).map(result -> JSON.parseObject((String)JSON.toJSONString((Object)result.getValue()))).collect(Collectors.toList());
            List adTemplateList = results.stream().filter(result -> "adTemplate".equals(result.getKey())).map(result -> JSON.parseObject((String)JSON.toJSONString((Object)result.getValue()))).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("\u5199\u5165\u6570\u636e\u5931\u8d25\uff1a", (Throwable)e);
            File[] results = compiledDataFiles;
            int n = results.length;
            int compiledDataFile = 0;
            while (true) {
                if (compiledDataFile >= n) {
                    throw new BusinessException("Failed to write data. Please contact the developer");
                }
                File compileDataFile = results[compiledDataFile];
                FileUtil.del((String)compileDataFile.getAbsolutePath());
                ++compiledDataFile;
            }
        }
        finally {
            File[] fileArray = compiledDataFiles;
            int n = fileArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                }
                File compiledDataFile = fileArray[n2];
                FileUtil.del((File)compiledDataFile);
                ++n2;
            }
        }
        this.appEntityService.save(new Application().setCode(application).setVersion(deployVersion));
        AthenaUser currentUser = deployParam.getCurrentUser();
        String token = this.iamService.getIntegrationToken(currentUser.getTenantId());
        String appToken = deployParam.getAppToken();
        List tenantIds = deployParam.getTenantUsers().stream().map(t -> t.getTenantId()).collect(Collectors.toList());
        List tenantSids = deployParam.getTenantUsers().stream().map(t -> t.getTenantSid()).collect(Collectors.toList());
        ArrayList tableInfos = new ArrayList();
        for (JSONObject jsonObject : pageDesignList) {
            List tableInfo;
            Form form = (Form)jsonObject.getObject("form", Form.class);
            JSONObject activity = new JSONObject();
            activity.put("code", (Object)jsonObject.getString("code"));
            activity.put("name", (Object)form.getFormName().getZh_CN());
            try {
                Dsl dsl = (Dsl)jsonObject.getObject("detailDsl", Dsl.class);
                Map compentMapping = PageDesignPublishUtil.handleComponentIdMapping((Form)form);
                JSONObject params = new JSONObject();
                if (compentMapping != null) {
                    params = PageDesignPublishUtil.handleDslInfo((Dsl)dsl, (Map)compentMapping);
                }
                PageDesignPublishUtil.handleLaunchProjectInfo((JSONObject)params, (LaunchProject)((LaunchProject)JSON.parseObject((String)JSON.toJSONString((Object)jsonObject.get((Object)"launchProject")), LaunchProject.class)));
                this.pageDesignService.schemaPublish(token, appToken, tenantIds, form, params);
            }
            catch (Exception e) {
                log.error("schema\u53d1\u5e03\u5931\u8d25!pageDesignCode:" + jsonObject.getString("code"), (Throwable)e);
            }
            try {
                this.pageDesignService.iamPublish(token, new Application().setCode(application), tenantSids, (List)ListUtil.toList((Object[])new JSONObject[]{activity}), "basicDataEntry");
            }
            catch (Exception e) {
                log.error("iam\u53d1\u5e03\u5931\u8d25!pageDesignCode:" + jsonObject.getString("code"), (Throwable)e);
            }
            if (CollectionUtils.isEmpty((Collection)(tableInfo = PageDesignPublishUtil.handleTbbTableInfo((Form)form)))) continue;
            tableInfos.addAll(tableInfo);
        }
        try {
            this.pageDesignService.tbbPublish(token, env, "application", application, tableInfos);
        }
        catch (Exception e) {
            log.error("tbb\u53d1\u5e03\u5931\u8d25!", (Throwable)e);
        }
        try {
            if (!env.contains("Prod")) {
                // empty if block
            }
        }
        catch (Exception e) {
            log.error("\u670d\u52a1\u7f16\u6392\u53d1\u5e03\u5931\u8d25!", (Throwable)e);
        }
        DeployProcess deployProcess = (DeployProcess)this.redisCache.get(PARTITION, application, DeployProcess.class);
        if (deployProcess != null) {
            deployProcess.setDeployedNum(deployProcess.getTotal());
        }
        log.info("\u5199\u5165\u6570\u636e\u5b8c\u6210:{}", (Object)Thread.currentThread().getId());
    }

    public void addReportPolicy(DeployParam deployParam) {
        PolicyBatchAddParam policyBatchAddParam;
        ApplicationData applicationData;
        ArrayList jsonObjectList;
        JSONObject jsonObject;
        Object authorityPrefix;
        log.info("\u5f00\u59cb\u53d1\u5e03\u62a5\u8868{}:{}", (Object)deployParam.getApplication(), (Object)Thread.currentThread().getId());
        JSONObject compiledData = deployParam.getCompiledData();
        String application = deployParam.getApplication();
        String env = deployParam.getEnv();
        String compileVersion = compiledData.getString("version");
        File[] designDataFiles = this.getDesignDataFiles(application, compileVersion, compiledData);
        ArrayList<JSONObject> activityConfigList = new ArrayList<JSONObject>();
        ArrayList<JSONObject> reportList = new ArrayList<JSONObject>();
        try {
            for (File designDataFile : designDataFiles) {
                File[] files;
                String activityConfigPath;
                File activityConfigFile;
                if (!designDataFile.isDirectory()) continue;
                String neo4jActivityPath = designDataFile.getPath() + File.separator + "athenadesigner" + File.separator + "neo4jActivity";
                File neo4jActivityFile = SafeFileUtils.createFile((String)neo4jActivityPath);
                if (neo4jActivityFile.exists()) {
                    File[] files2;
                    for (File file : files2 = neo4jActivityFile.listFiles()) {
                        String content = FileUtil.readString((File)file, (Charset)Charset.forName("utf-8"));
                        JSONObject jsonObject2 = JSON.parseObject((String)content);
                        reportList.add(jsonObject2);
                    }
                }
                if (!(activityConfigFile = SafeFileUtils.createFile((String)(activityConfigPath = designDataFile.getPath() + File.separator + "knowledgegraphSystem" + File.separator + "activityConfigs"))).exists()) continue;
                for (File file : files = activityConfigFile.listFiles()) {
                    String content = FileUtil.readString((File)file, (Charset)Charset.forName("utf-8"));
                    JSONObject jsonObject3 = JSON.parseObject((String)content);
                    activityConfigList.add(jsonObject3);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5199\u5165\u6570\u636e\u5931\u8d25\uff1a", (Throwable)e);
            for (File compileDataFile : designDataFiles) {
                FileUtil.del((String)compileDataFile.getAbsolutePath());
            }
            throw new BusinessException("\u5199\u5165\u6570\u636e\u5931\u8d25,\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458");
        }
        finally {
            for (File designDataFile : designDataFiles) {
                FileUtil.del((File)designDataFile);
            }
        }
        AthenaUser currentUser = deployParam.getCurrentUser();
        String integrationToken = this.iamService.getIntegrationToken(currentUser.getTenantId());
        List tenantIds = deployParam.getTenantUsers().stream().map(t -> t.getTenantId()).collect(Collectors.toList());
        List tenantSids = deployParam.getTenantUsers().stream().map(t -> t.getTenantSid()).collect(Collectors.toList());
        List activityConfigs = JSON.parseArray((String)JSON.toJSONString(activityConfigList), ActivityConfig.class);
        List neo4jActivities = JSON.parseArray((String)JSON.toJSONString(reportList), Neo4jActivity.class);
        Map<String, ActivityConfig> activityConfigMap = activityConfigs.stream().collect(Collectors.toMap(ActivityConfig::getCode, ActivityConfig2 -> ActivityConfig2));
        List tbbReport = neo4jActivities.stream().filter(t -> this.isTbbStatement(t.getPattern(), t.getCategory())).collect(Collectors.toList());
        List abiReport = neo4jActivities.stream().filter(t -> this.isAbiStatement(t.getPattern(), t.getCategory())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(tbbReport)) {
            List resCode = tbbReport.stream().map(Neo4jActivity::getResCode).collect(Collectors.toList());
            JSONObject tbbJsonObject = new JSONObject();
            tbbJsonObject.put("tenantIds", tenantIds);
            tbbJsonObject.put("appCode", (Object)application);
            tbbJsonObject.put("token", (Object)currentUser.getToken());
            tbbJsonObject.put("env", (Object)env);
            tbbJsonObject.put("reportList", resCode);
            this.statementService.tbbStatementPublish(tbbJsonObject);
            for (Neo4jActivity activity : tbbReport) {
                String code = activity.getCode();
                ActivityConfig activityConfig = activityConfigMap.get(code);
                authorityPrefix = activityConfig.getAuthorityPrefix();
                if (!StringUtils.isNotEmpty((CharSequence)authorityPrefix)) continue;
                jsonObject = new JSONObject();
                jsonObject.put("code", (Object)activity.getCode());
                jsonObject.put("name", (Object)activity.getName());
                jsonObjectList = ListUtil.toList((Object[])new JSONObject[]{jsonObject});
                this.pageDesignService.iamPublish(integrationToken, new Application().setCode(application), tenantSids, (List)jsonObjectList, "report");
                applicationData = new ApplicationData();
                applicationData.setAppId(application);
                policyBatchAddParam = new PolicyBatchAddParam();
                policyBatchAddParam.setApplicationDataList((List)ListUtil.toList((Object[])new ApplicationData[]{applicationData}));
                policyBatchAddParam.setActivityList((List)jsonObjectList);
                policyBatchAddParam.setTenantUsers(deployParam.getTenantUsers());
                policyBatchAddParam.setModuleId("report");
                this.tenantService.policyBatch(policyBatchAddParam, integrationToken, null);
            }
        }
        String isvCode = this.iamService.getIsvCode(currentUser.getTenantId());
        for (Neo4jActivity activity : abiReport) {
            String code = activity.getCode();
            ActivityConfig activityConfig = activityConfigMap.get(code);
            Map residMap = this.getResidByAc(activityConfig);
            for (String key : residMap.keySet()) {
                String resid = (String)residMap.get(key);
                JSONObject jsonObject4 = new JSONObject();
                jsonObject4.put("isvCode", (Object)isvCode);
                jsonObject4.put("resid", (Object)resid);
                jsonObject4.put("tenantId", (Object)currentUser.getTenantId());
                jsonObject4.put("code", (Object)code);
                jsonObject4.put("appCode", (Object)application);
                this.statementService.abiStatementPublish(jsonObject4);
            }
            authorityPrefix = activityConfig.getAuthorityPrefix();
            if (!StringUtils.isNotEmpty((CharSequence)authorityPrefix)) continue;
            jsonObject = new JSONObject();
            jsonObject.put("code", (Object)activity.getCode());
            jsonObject.put("name", (Object)activity.getName());
            jsonObjectList = ListUtil.toList((Object[])new JSONObject[]{jsonObject});
            this.pageDesignService.iamPublish(integrationToken, new Application().setCode(application), tenantSids, (List)jsonObjectList, "report");
            applicationData = new ApplicationData();
            applicationData.setAppId(application);
            policyBatchAddParam = new PolicyBatchAddParam();
            policyBatchAddParam.setApplicationDataList((List)ListUtil.toList((Object[])new ApplicationData[]{applicationData}));
            policyBatchAddParam.setActivityList((List)jsonObjectList);
            policyBatchAddParam.setTenantUsers(deployParam.getTenantUsers());
            policyBatchAddParam.setModuleId("report");
            this.tenantService.policyBatch(policyBatchAddParam, integrationToken, null);
        }
        log.info("\u62a5\u8868\u6388\u6743\u5b8c\u6210:{}", (Object)Thread.currentThread().getId());
    }

    private boolean isTbbStatement(String pattern, String category) {
        return CATEGORY_TBB.contains(category) && PATTERN_TBB.contains(pattern);
    }

    private boolean isAbiStatement(String pattern, String category) {
        return CATEGORY_ABI.contains(category) && PATTERN_ABI.contains(pattern);
    }

    private Map<String, String> getResidByAc(ActivityConfig activityConfig) {
        Map condition_detail;
        Map pages = activityConfig.getPages();
        Map<String, String> extendedFields = new HashMap();
        if (!ObjectUtils.isEmpty((Object)pages) && !ObjectUtils.isEmpty(pages.get("condition-detail")) && !ObjectUtils.isEmpty((Object)(condition_detail = (Map)pages.get("condition-detail"))) && (extendedFields = (Map)condition_detail.get("extendedFields")).containsKey("STATEMENT__resid")) {
            String defaultResid = (String)extendedFields.get("STATEMENT__resid");
            if (!extendedFields.containsKey("STATEMENT__resid_en_US")) {
                extendedFields.put("STATEMENT__resid_en_US", defaultResid);
            }
            if (!extendedFields.containsKey("STATEMENT__resid_zh_CN")) {
                extendedFields.put("STATEMENT__resid_zh_CN", defaultResid);
            }
            if (!extendedFields.containsKey("STATEMENT__resid_zh_TW")) {
                extendedFields.put("STATEMENT__resid_zh_TW", defaultResid);
            }
        }
        HashMap<String, String> returnExtendedFields = new HashMap<String, String>();
        if (extendedFields.containsKey("STATEMENT__resid")) {
            returnExtendedFields.put("STATEMENT__resid", (String)extendedFields.get("STATEMENT__resid"));
        }
        if (extendedFields.containsKey("STATEMENT__resid_en_US")) {
            returnExtendedFields.put("STATEMENT__resid_en_US", (String)extendedFields.get("STATEMENT__resid_en_US"));
        }
        if (extendedFields.containsKey("STATEMENT__resid_zh_CN")) {
            returnExtendedFields.put("STATEMENT__resid_zh_CN", (String)extendedFields.get("STATEMENT__resid_zh_CN"));
        }
        if (extendedFields.containsKey("STATEMENT__resid_zh_TW")) {
            returnExtendedFields.put("STATEMENT__resid_zh_TW", (String)extendedFields.get("STATEMENT__resid_zh_TW"));
        }
        return returnExtendedFields;
    }

    private Map<String, List<String>> handleCompentIdMapping(Form form) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        FormSchema formSchema = form.getFormSchema();
        if (formSchema == null) {
            return null;
        }
        this.addMappingField(formSchema, map);
        List childs = formSchema.getChildren();
        if (!CollectionUtils.isEmpty((Collection)childs)) {
            for (FormSchema child : childs) {
                this.addMappingField(child, map);
            }
        }
        return map;
    }

    private void addMappingField(FormSchema formSchema, Map<String, List<String>> map) {
        String userTableName = formSchema.getUserTableName();
        List formFields = formSchema.getFields();
        if (!CollectionUtils.isEmpty((Collection)formFields)) {
            ArrayList<String> formIdList = new ArrayList<String>();
            for (FormField formField : formFields) {
                formIdList.add(formField.getFieldId());
            }
            map.put(userTableName, formIdList);
        }
    }

    private JSONObject handleDslInfo(Dsl dsl, Map<String, List<String>> map) {
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        if (dsl == null) {
            return jsonObject;
        }
        List layouts = dsl.getLayout();
        if (CollectionUtils.isEmpty((Collection)layouts)) {
            return jsonObject;
        }
        for (AbstractComponent layout : layouts) {
            if (layout == null) continue;
            this.handleMainField(layout, jsonArray);
            this.handleChildField(layout, jsonArray);
        }
        JSONObject dataI18n = this.getObjByArray(jsonArray, map);
        jsonObject.put("dataI18n", (Object)dataI18n);
        return jsonObject;
    }

    private void handleLaunchProjectInfo(JSONObject params, LaunchProject launchProject) {
        if (launchProject != null && launchProject.getNeedStatusAction().booleanValue() && !CollectionUtils.isEmpty((Collection)launchProject.getStateTransferAction())) {
            params.put("launchProject", (Object)launchProject.getStateTransferAction());
        }
    }

    private void handleMainField(AbstractComponent layout, JSONArray jsonArray) {
        List groups = layout.getGroup();
        if (CollectionUtils.isEmpty((Collection)groups)) {
            return;
        }
        for (Map group : groups) {
            List options;
            String type = (String)group.get("type");
            if (!COMPENT_TYPE.contains(type) || (options = (List)group.get("options")) == null) continue;
            String schema = (String)group.get("schema");
            for (Map option : options) {
                JSONObject field = new JSONObject();
                field.put("fieldId", (Object)schema);
                field.put("dataValue", option.get("value"));
                Map lang = (Map)option.get("lang");
                field.put("i18nMapping", lang.get("title"));
                jsonArray.add((Object)field);
            }
        }
    }

    private void handleChildField(AbstractComponent layout, JSONArray jsonArray) {
        List columnDefs = layout.getColumnDefs();
        if (CollectionUtils.isEmpty((Collection)columnDefs)) {
            return;
        }
        for (Map columnDef : columnDefs) {
            List columns = (List)columnDef.get("columns");
            if (CollectionUtils.isEmpty((Collection)columns)) continue;
            for (Map column : columns) {
                List options;
                String type = (String)column.get("type");
                if (!COMPENT_TYPE.contains(type) || (options = (List)column.get("options")) == null) continue;
                String schema = (String)column.get("schema");
                for (Map option : options) {
                    JSONObject field = new JSONObject();
                    field.put("fieldId", (Object)schema);
                    field.put("dataValue", option.get("value"));
                    Map lang = (Map)option.get("lang");
                    field.put("i18nMapping", lang.get("title"));
                    jsonArray.add((Object)field);
                }
            }
        }
    }

    private JSONObject getObjByArray(JSONArray jsonArray, Map<String, List<String>> map) {
        JSONObject returnJson = new JSONObject();
        for (String key : map.keySet()) {
            List<String> fieldIdList = map.get(key);
            JSONArray fieldArray = new JSONArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String fieldId = jsonObject.getString("fieldId");
                if (!fieldIdList.contains(fieldId)) continue;
                fieldArray.add((Object)jsonObject);
            }
            returnJson.put(key, (Object)fieldArray);
        }
        return returnJson;
    }

    private List<JSONObject> handleTbbTableInfo(Form form) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("formId", (Object)form.getFormId());
        MultiLanguageDTO multiLanguageDTO = form.getFormName();
        if (multiLanguageDTO != null) {
            jsonObject.put("tableNameCn", (Object)multiLanguageDTO.getZh_CN());
        }
        if (form.getFormSchema() == null) {
            return null;
        }
        jsonObject.put("tableName", (Object)form.getFormSchema().getUserTableName());
        JSONArray schemaArray = new JSONArray();
        for (FormField formField : form.getFormSchema().getFields()) {
            JSONObject schemaJson = new JSONObject();
            schemaJson.put("title", (Object)formField.getFieldName());
            schemaJson.put("dataType", (Object)TbbDataTypeConstant.transDateType((String)formField.getFieldType()));
            schemaJson.put("name", (Object)formField.getFieldId());
            schemaArray.add((Object)schemaJson);
        }
        jsonObject.put("schema", (Object)schemaArray);
        List childs = form.getFormSchema().getChildren();
        if (!CollectionUtils.isEmpty((Collection)childs)) {
            JSONArray childArray = new JSONArray();
            for (FormSchema formSchema : childs) {
                JSONObject childJson = new JSONObject();
                childJson.put("tableName", (Object)formSchema.getUserTableName());
                List formFields = formSchema.getFields();
                if (!CollectionUtils.isEmpty((Collection)formFields)) {
                    JSONArray childSchemaArray = new JSONArray();
                    for (FormField formField : formFields) {
                        JSONObject schemaJson = new JSONObject();
                        schemaJson.put("title", (Object)formField.getFieldName());
                        schemaJson.put("dataType", (Object)TbbDataTypeConstant.transDateType((String)formField.getFieldType()));
                        schemaJson.put("name", (Object)formField.getFieldId());
                        childSchemaArray.add((Object)schemaJson);
                    }
                    childJson.put("schema", (Object)childSchemaArray);
                }
                childArray.add((Object)childJson);
            }
            jsonObject.put("child", (Object)childArray);
        }
        ArrayList<JSONObject> tableInfos = new ArrayList<JSONObject>();
        tableInfos.add(jsonObject);
        return tableInfos;
    }

    public List<File2DbResult> fileData2Db(File2DbParam file2DbParam) {
        ArrayList<File2DbResult> results = new ArrayList<File2DbResult>();
        File[] compileDataFiles = file2DbParam.getCompileDataFiles();
        String application = file2DbParam.getApplication();
        String deployVersion = file2DbParam.getDeployVersion();
        String compileVersion = file2DbParam.getCompileVersion();
        for (File compileDataFile : compileDataFiles) {
            File[] files;
            if (!compileDataFile.isDirectory()) continue;
            String dbName = compileDataFile.getName();
            if ("cypher".equals(dbName)) {
                for (File file : files = compileDataFile.listFiles()) {
                    if (".DS_Store".equals(file.getName())) continue;
                    List data = FileUtil.readLines((File)file, (Charset)Charset.forName("utf-8"));
                    this.cleanNeo4jCopyData(application, deployVersion, data);
                    for (String line : data) {
                        DeployProcess deployProcess = (DeployProcess)this.redisCache.get(PARTITION, application, DeployProcess.class);
                        if (deployProcess != null) {
                            deployProcess.deployedNumIncrease();
                            String label = StrUtil.subBetween((CharSequence)"node:", (CharSequence)"{");
                            if (StrUtil.isBlank((CharSequence)label)) {
                                label = "Relation";
                            }
                            deployProcess.setType("neo4j." + label);
                        }
                        line = line.replaceAll("\\{athena_version}", deployVersion);
                        line = line.replaceAll("\\{common_version}", deployVersion);
                        Neo4jMultipleUtil.executeCql((String)line, (Driver[])new Driver[]{this.driver1, this.driver2});
                    }
                }
                continue;
            }
            for (File file : files = compileDataFile.listFiles()) {
                List data;
                if (!file.isDirectory()) continue;
                String collectionName = file.getName();
                File[] dataFile = file.listFiles();
                if ("athenadesigner".equals(dbName) || "designer".equals(dbName)) {
                    for (File f : dataFile) {
                        if (".DS_Store".equals(f.getName())) continue;
                        data = FileUtil.readLines((File)f, (Charset)Charset.forName("utf-8"));
                        for (String line : data) {
                            JSONObject jsonObject = JSON.parseObject((String)line);
                            File2DbResult file2DbResult = new File2DbResult().setKey(collectionName).setValue((Object)jsonObject);
                            results.add(file2DbResult);
                        }
                    }
                    continue;
                }
                this.cleanMongoData(application, deployVersion, dbName, collectionName);
                for (File f : dataFile) {
                    if (".DS_Store".equals(f.getName())) continue;
                    data = FileUtil.readLines((File)f, (Charset)Charset.forName("utf-8"));
                    for (String line : data) {
                        DeployProcess deployProcess = (DeployProcess)this.redisCache.get(PARTITION, application, DeployProcess.class);
                        if (deployProcess != null) {
                            deployProcess.deployedNumIncrease();
                            deployProcess.setType(dbName + "." + collectionName);
                        }
                        Document document = Document.parse((String)line);
                        document.remove((Object)"_id");
                        document.remove((Object)"isMigrate");
                        document.put("athena_namespace", (Object)application);
                        document.put("compileVersion", (Object)compileVersion);
                        document.put("application", (Object)application);
                        document.put("version", (Object)deployVersion);
                        try {
                            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(dbName).getCollection(collectionName).insertOne((Object)document);
                        }
                        catch (MongoWriteException e) {
                            log.error("insert data error: ", (Throwable)e);
                        }
                    }
                }
            }
        }
        return results;
    }

    private void cleanNeo4jCopyData(String application, String deployVersion, List<String> data) {
        String cql;
        HashMap<String, String> param;
        if (data.contains("Create (action:Action:EspAction")) {
            param = new HashMap<String, String>();
            param.put("version", deployVersion);
            cql = "MATCH (node)  where node.version =$version and node.nameSpace in ['espCommon','common'] and not any(label in labels(node) WHERE label in ['AppEntity','TenantEntity']) detach delete node";
            Neo4jMultipleUtil.executeCql((String)cql, param, (Driver[])new Driver[]{this.driver1, this.driver2});
        }
        param = new HashMap();
        param.put("nameSpace", application);
        param.put("version", deployVersion);
        cql = "MATCH (node)  where node.version =$version and node.nameSpace =$nameSpace and not any(label in labels(node) WHERE label in ['AppEntity','TenantEntity']) detach delete node";
        Neo4jMultipleUtil.executeCql((String)cql, param, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    private void cleanMongoData(String application, String deployVersion, String dbName, String collectionName) {
        Bson bson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"version", (Object)deployVersion), Filters.or((Bson[])new Bson[]{Filters.eq((String)"application", (Object)application), Filters.eq((String)"athena_namespace", (Object)application)})});
        this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(dbName).getCollection(collectionName).deleteMany(bson);
    }

    public void modifyDifferenceData(String applicationCode, String version) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", version);
        param.put("applicationCode", applicationCode);
        String cql1 = "match (tag:Tag) where tag.version=$version and tag.athena_namespace=$applicationCode and tag.category='ROLE__ACTIVITY' and tag.code starts with 'performer__' match (relatedObject:RelatedObject) where relatedObject.id='performer' and relatedObject.version=$version merge (relatedObject)-[:USE]->(tag)";
        String cql2 = "match (tag:Tag) where tag.version=$version and tag.athena_namespace=$applicationCode and tag.category='ROLE__ACTIVITY' and tag.code starts with 'charge__' match (relatedObject:RelatedObject) where relatedObject.id='charge' and relatedObject.version=$version merge (relatedObject)-[:USE]->(tag)";
        Neo4jMultipleUtil.executeCql((String)cql1, param, (Driver[])new Driver[]{this.driver1, this.driver2});
        Neo4jMultipleUtil.executeCql((String)cql2, param, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    private File[] getCompiledDataFiles(String application, String version, JSONObject compiledData) {
        String applicationCompileZipPath = this.compileZipPath + File.separator + application + File.separator;
        String applicationCompileDataPath = this.compileDataPath + File.separator + application + File.separator;
        String compiledDataFileId = compiledData.getString("compiledDataFileId");
        String compileDataZipPath = StrUtil.format((CharSequence)(applicationCompileZipPath + application + "_{}.zip"), (Object[])new Object[]{version});
        this.downloadFileFromDmc(compiledDataFileId, compileDataZipPath);
        ZipUtil.unzip((String)compileDataZipPath, (String)applicationCompileDataPath);
        File compileDataDirector = SafeFileUtils.createFile((String)applicationCompileDataPath);
        NameFileFilter nameFileFilter = new NameFileFilter(".DS_Store");
        NotFileFilter notFileFilter = new NotFileFilter((IOFileFilter)nameFileFilter);
        List files = FileUtil.loopFiles((File)compileDataDirector, (FileFilter)notFileFilter);
        int total = files.stream().mapToInt(file -> FileUtil.readLines((File)file, (String)"utf-8").size()).sum();
        DeployProcess deployProcess = new DeployProcess().setTotal(Integer.valueOf(total)).setLeft(Integer.valueOf(total));
        this.redisCache.set(PARTITION, application, (Object)deployProcess);
        File[] compileDataFiles = compileDataDirector.listFiles();
        return compileDataFiles;
    }

    private File[] getDesignDataFiles(String application, String version, JSONObject compiledData) {
        String applicationDesignZipPath = this.designDataPath + File.separator + application + File.separator;
        String applicationDesignDataPath = this.designDataPath + File.separator + application + File.separator;
        String designDataFileId = compiledData.getString("designDataFileId");
        String compileDataZipPath = StrUtil.format((CharSequence)(applicationDesignZipPath + application + "_{}.zip"), (Object[])new Object[]{version});
        this.downloadFileFromDmc(designDataFileId, compileDataZipPath);
        ZipUtil.unzip((String)compileDataZipPath, (String)applicationDesignDataPath);
        File designDataDirector = SafeFileUtils.createFile((String)applicationDesignDataPath);
        File[] designDataFiles = designDataDirector.listFiles();
        return designDataFiles;
    }

    private void copyStandardDesignData2Tenant(String application, String compileVersion, String deployVersion, JSONObject compiledData, AthenaUser currentUser) {
    }

    private void copyFileData2DB(String application, File[] dataFiles, String deployVersion, AthenaUser athenaUser) {
    }

    private void copyMongoData(String application, String deployVersion, File applicationFile) {
        File[] mongoDataFiles = applicationFile.listFiles();
        if (mongoDataFiles == null || mongoDataFiles.length <= 0) {
            return;
        }
        for (File mongoDataFile : mongoDataFiles) {
            File[] files;
            if (!mongoDataFile.isDirectory()) continue;
            for (File file : files = mongoDataFile.listFiles()) {
                if (!file.isDirectory()) continue;
                String collectionName = file.getName();
                File[] collectionFiles = file.listFiles();
                String applicationKey = "application";
                if ("application".equals(collectionName)) {
                    applicationKey = "code";
                }
                this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)applicationKey).is((Object)application).and("tenantId").is((Object)"SYSTEM")), collectionName);
                for (File f : collectionFiles) {
                    if (".DS_Store".equals(f.getName())) continue;
                    String json = FileUtil.readString((File)f, (Charset)Charset.forName("utf-8"));
                    Document document = Document.parse((String)json);
                    document.remove((Object)"_id");
                    document.put("version", (Object)deployVersion);
                    document.put("tenantId", (Object)"SYSTEM");
                    try {
                        this.mongoTemplate.insert((Object)document, collectionName);
                    }
                    catch (Exception e) {
                        log.error("insert data error: ", (Throwable)e);
                    }
                }
            }
        }
    }

    private void copyNeo4jData(String application, String deployVersion, File dataFile, AthenaUser athenaUser) {
    }

    public void checkApplicationVersion() {
        JSONObject publishProgressResult = (JSONObject)this.mongoTemplate.findOne(new Query().with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"majorVersionNum")})).limit(1), JSONObject.class, "publishProgressResult");
        Boolean nextVersionCopied = publishProgressResult.getBoolean("nextVersionCopied");
        if (nextVersionCopied == null || !nextVersionCopied.booleanValue()) {
            ThreadUtil.execute(() -> {
                Integer majorVersionNum = publishProgressResult.getInteger("majorVersionNum");
                String minorVersion = publishProgressResult.getString("minorVersion");
                String currentVersion = majorVersionNum + "." + minorVersion;
                Integer n = majorVersionNum;
                majorVersionNum = majorVersionNum + 1;
                String deployVersion = majorVersionNum + "." + minorVersion;
                Boolean result = this.copyApplicationData(deployVersion, currentVersion);
                if (result.booleanValue()) {
                    Update update = new Update();
                    update.set("nextVersionCopied", (Object)true);
                    this.mongoTemplate.upsert(new Query((CriteriaDefinition)Criteria.where((String)"_id").is(publishProgressResult.get((Object)"_id"))), (UpdateDefinition)update, "publishProgressResult");
                }
            });
        }
    }

    public void updateDataVersion(String oldVersion, String newVersion) {
        List initMongoList = MongoUtil.getMongoCollection();
        Bson filter = Filters.ne((String)"version", (Object)oldVersion);
        Bson deleteFilter = Filters.ne((String)"version", (Object)newVersion);
        Document update = new Document("$set", (Object)new Document().append("version", (Object)newVersion));
        for (HashMap initMongo : initMongoList) {
            ((List)initMongo.get("collectionName")).forEach(arg_0 -> this.lambda$updateDataVersion$13(initMongo, deleteFilter, filter, (Bson)update, arg_0));
        }
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", newVersion);
        Cql updateCql = new Cql();
        updateCql.setCql("match (node) set node.version=$version");
        updateCql.setParams(param);
        Cql deleteCql = new Cql();
        deleteCql.setCql("match (node) where node.version=$version delete node");
        deleteCql.setParams(param);
        cqlList.add(deleteCql);
        cqlList.add(updateCql);
        Neo4jManager neo4jManager1 = new Neo4jManager(this.driver1);
        neo4jManager1.ExecuteTransactionNoQuery(cqlList);
        if (this.driver2 != null) {
            Neo4jManager neo4jManager2 = new Neo4jManager(this.driver2);
            neo4jManager2.ExecuteTransactionNoQuery(cqlList);
        }
    }

    public void switchVersion(SwitchVersionParam switchVersionParam) {
        String version = switchVersionParam.getVersion();
        String application = switchVersionParam.getApplication();
        List tenantIdList = switchVersionParam.getTenantIdList();
        Boolean commonApp = switchVersionParam.getCommonApp();
        this.tenantService.createTenants(tenantIdList, version);
        this.updateAppEntityVersion(application, tenantIdList, version, commonApp);
        this.updateTenantVersion(tenantIdList, application, version, commonApp);
    }

    public void createAllTenantEntityAndCommonRelation(SwitchVersionParam switchVersionParam) {
        log.info("-----\u5f00\u59cb\u521b\u5efa\u6240\u6709\u79df\u6237\u4e0ecommon\u7684relation----------");
        String version = switchVersionParam.getVersion();
        String application = switchVersionParam.getApplication();
        List tenantIdList = switchVersionParam.getTenantIdList();
        Boolean commonApp = switchVersionParam.getCommonApp();
        this.tenantService.createOrUpdateTenants(tenantIdList, version);
        this.updateTenantVersion(tenantIdList, application, version, commonApp);
        log.info("-----\u521b\u5efa\u6240\u6709\u79df\u6237\u4e0ecommon\u7684relation\u7ed3\u675f----------");
    }

    public void updateTenantVersion(List<String> tenantIdList, String application, String version, Boolean commonApp) {
        log.info("\u66f4\u65b0\u79df\u6237\u7248\u672c\uff1a\u79df\u6237:{},\u7248\u672c:{} ...", tenantIdList, (Object)version);
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        cqlList.add(CqlMapper.updateTenantVersion(tenantIdList, (String)version));
        this.tenantService.modifyTenantConfig(version, tenantIdList);
        cqlList.add(CqlMapper.mergeTenantAppEntityRelation(tenantIdList, (String)application));
        if (commonApp.booleanValue()) {
            this.kmApiHelper.mergeCommonAppRelaWithVirtualTenant(application, version, version);
        } else {
            List mergeTenantAndAppDataRelationCql = this.tenantService.getMergeTenantAndAppDataRelationCql(application, version, version, tenantIdList);
            cqlList.addAll(mergeTenantAndAppDataRelationCql);
        }
        this.updateTenantProductRelation(tenantIdList, application, version);
        log.info("\u66f4\u65b0\u79df\u6237--\u5f00\u59cb\u6267\u884ccql\uff1a" + JSON.toJSONString(cqlList));
        new Neo4jManager(this.driver1).ExecuteTransactionNoQuery(cqlList);
        if (this.driver2 != null) {
            new Neo4jManager(this.driver2).ExecuteTransactionNoQuery(cqlList);
        }
        log.info("\u66f4\u65b0\u79df\u6237\u7248\u672c\u5b8c\u6210\uff1a\u79df\u6237:{},\u7248\u672c:{} ...", tenantIdList, (Object)version);
    }

    private void updateTenantProductRelation(List<String> tenantIdList, String application, String version) {
        Bson projectFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"athena_namespace", (Object)application), Filters.eq((String)"version", (Object)version)});
        FindIterable projectDocuments = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("project").find(projectFilter);
        HashSet projectCodeList = new HashSet();
        projectDocuments.forEach(projectDocument -> {
            String code = projectDocument.getString((Object)"code");
            projectCodeList.add(code);
        });
        if (CollUtil.isNotEmpty(projectCodeList)) {
            for (String tenantId : tenantIdList) {
                Bson tenantProductRelationFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"tenantId", (Object)tenantId), Filters.eq((String)"objectType", (Object)"project"), Filters.in((String)"objectCode", projectCodeList)});
                FindIterable tenantProductRelationDocuments = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("tenantProductRelation").find(tenantProductRelationFilter);
                HashSet<String> relatedProjectCodeList = new HashSet<String>();
                for (Document document : tenantProductRelationDocuments) {
                    String relatedProjectCode = document.getString((Object)"objectCode");
                    relatedProjectCodeList.add(relatedProjectCode);
                }
                Collection disjunction = CollUtil.disjunction(projectCodeList, relatedProjectCodeList);
                if (!CollUtil.isNotEmpty((Collection)disjunction)) continue;
                for (String projectCode : disjunction) {
                    Document tenantProductRelation = new Document();
                    tenantProductRelation.put("tenantId", (Object)tenantId);
                    tenantProductRelation.put("objectType", (Object)"project");
                    tenantProductRelation.put("objectCode", (Object)projectCode);
                    this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("tenantProductRelation").insertOne((Object)tenantProductRelation);
                }
            }
        }
    }

    private List<Cql> mergeTenantVersionRelation(String tenantId, String application, String version) {
        log.info("\u66f4\u65b0{}\u5173\u8054\u7684\u7248\u672c", (Object)tenantId);
        ArrayList<Cql> transactionCqlList = new ArrayList<Cql>();
        Cql tenantTaskRelationCql = CqlMapper.mergeTenantAndTaskExcludeTenantTask((String)application, (String)tenantId, (Driver)this.driver1);
        transactionCqlList.add(tenantTaskRelationCql);
        List tenantActivityRelationCqlList = CqlMapper.mergeTenantAndActivityExcludeTenantActivity((String)application, (String)tenantId, (Driver)this.driver1);
        transactionCqlList.addAll(tenantActivityRelationCqlList);
        Cql tenantActionCql = CqlMapper.mergeTenantAndActionExcludeTenantAction((String)application, (String)tenantId, (Driver)this.driver1);
        transactionCqlList.add(tenantActionCql);
        List tenantMonitorRuleCql = CqlMapper.mergeTenantAndActivityExcludeTenantMonitorRule((String)application, (String)tenantId, (Driver)this.driver1);
        transactionCqlList.addAll(tenantMonitorRuleCql);
        log.info("\u66f4\u65b0\u5b8c\u6210: \u66f4\u65b0{}\u5173\u8054\u7684\u7248\u672c", (Object)tenantId);
        return transactionCqlList;
    }

    private void updateDTDTenantVersion(String tenantId, String application, String version) {
        Bson projectFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"athena_namespace", (Object)application), Filters.eq((String)"version", (Object)version)});
        FindIterable projectDocuments = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("project").find(projectFilter);
        projectDocuments.forEach(projectDocument -> {
            Bson tenantProductRelationFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"tenantId", (Object)tenantId), Filters.eq((String)"objectType", (Object)"project"), Filters.eq((String)"objectCode", (Object)projectDocument.getString((Object)"code"))});
            FindIterable tenantProductRelationDocuments = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("tenantProductRelation").find(tenantProductRelationFilter);
            AtomicInteger tenantProductRelationCount = new AtomicInteger();
            tenantProductRelationDocuments.forEach(tenantProductRelationDocument -> tenantProductRelationCount.getAndIncrement());
            if (tenantProductRelationCount.get() < 1) {
                Document tenantProductRelation = new Document();
                tenantProductRelation.put("tenantId", (Object)tenantId);
                tenantProductRelation.put("objectType", (Object)"project");
                tenantProductRelation.put("objectCode", (Object)projectDocument.getString((Object)"code"));
                this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("tenantProductRelation").insertOne((Object)tenantProductRelation);
            }
        });
    }

    private void updateAppEntityVersion(String application, List<String> tenantIdList, String version, Boolean commonApp) {
        this.appEntityService.save(new Application().setCode(application).setVersion(version), tenantIdList);
        StringBuilder cql = new StringBuilder(StrUtil.format((CharSequence)"MERGE (n:AppEntity{code:'{}'})", (Object[])new Object[]{application}));
        if (commonApp.booleanValue()) {
            cql.append(StrUtil.format((CharSequence)" ON CREATE SET n.version = '{}', n.commonApp = {} ", (Object[])new Object[]{version, commonApp}));
            cql.append(StrUtil.format((CharSequence)" ON MATCH SET n.commonApp = {} ", (Object[])new Object[]{commonApp}));
        } else {
            cql.append(StrUtil.format((CharSequence)" ON CREATE SET n.version = '{}' ", (Object[])new Object[]{version}));
        }
        Neo4jMultipleUtil.executeCql((String)cql.toString(), (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    public Boolean copyApplicationData(String oldVersion, String newVersion) {
        boolean locked = LOCK.isLocked();
        if (locked) {
            throw new BusinessException("Copying app data, please try again later!");
        }
        LOCK.lock();
        try {
            log.info("\u5f00\u59cb\u590d\u5236{}\u7248\u672c\u6570\u636e\u81f3{}\u7248\u672c......", (Object)oldVersion, (Object)newVersion);
            Neo4jManager neo4jManager1 = new Neo4jManager(this.driver1);
            this.addNeo4jVersion(newVersion, oldVersion, neo4jManager1);
            if (this.driver2 != null) {
                Neo4jManager neo4jManager2 = new Neo4jManager(this.driver2);
                this.addNeo4jVersion(newVersion, oldVersion, neo4jManager2);
            }
            this.addMongoVersion(newVersion, oldVersion);
            Update update = new Update();
            update.set("applicationCopied", (Object)true);
            this.mongoTemplate.upsert(new Query(), (UpdateDefinition)update, "globalConfig");
            log.info("\u590d\u5236\u5b8c\u6210");
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error(newVersion + "\u7248\u672c\u6570\u636e\u590d\u5236\u5931\u8d25", (Throwable)e);
            this.revert(newVersion);
            Update update = new Update();
            update.set("applicationCopied", (Object)false);
            this.mongoTemplate.upsert(new Query(), (UpdateDefinition)update, "globalConfig");
            throw new BusinessException("Legacy data replication failed!");
        }
        finally {
            LOCK.unlock();
        }
    }

    public Boolean appPublishStatus(String appCode) {
        StringBuilder cql = new StringBuilder("MATCH (n:AppEntity) WHERE n.code = $appCode return n");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("appCode", appCode);
        Neo4jManager neo4jManager1 = new Neo4jManager(this.driver1);
        List result = neo4jManager1.ExecuteQuery(cql.toString(), param);
        if (CollectionUtils.isEmpty((Collection)result)) {
            return false;
        }
        return true;
    }

    public void cleanNeo4jData(CleanNeo4jParam cleanNeo4jParam) {
        Boolean cleanEsp = cleanNeo4jParam.getCleanEsp();
        log.info("begin to cleanNeo4jData!");
        String deployVersion = cleanNeo4jParam.getDeployVersion();
        String application = cleanNeo4jParam.getApplication();
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("nameSpace", application);
        param.put("version", deployVersion);
        String cql = "MATCH (node)  where node.version =$version and (node.nameSpace =$nameSpace or node.athena_namespace=$nameSpace) and not any(label in labels(node) WHERE label in ['AppEntity','TenantEntity']) detach delete node";
        cqlList.add(new Cql().setCql(cql).setParams(param));
        Neo4jMultipleUtil.executeCqlTrans(cqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
        log.info("cleanNeo4jData have been done!");
    }

    public void cleanMongoData(CleanMongoParam cleanMongoParam) {
        Map collectionInfo = cleanMongoParam.getCollectionInfo();
        String application = cleanMongoParam.getApplication();
        log.info("begin to cleanMongoData!");
        collectionInfo.forEach((dbName, collectionNameList) -> {
            Bson bson = Filters.and((Bson[])new Bson[]{Filters.or((Bson[])new Bson[]{Filters.eq((String)"version", (Object)cleanMongoParam.getDeployVersion()), Filters.eq((String)"version", (Object)"{athena_version}")}), Filters.or((Bson[])new Bson[]{Filters.eq((String)"application", (Object)application), Filters.eq((String)"athena_namespace", (Object)application)}), Filters.or((Bson[])new Bson[]{Filters.eq((String)"tenantId", null), Filters.eq((String)"tenantId", (Object)"SYSTEM"), Filters.and((Bson[])new Bson[]{Filters.ne((String)"tenantId", null), Filters.ne((String)"tenantId", (Object)"SYSTEM"), Filters.eq((String)"athena_publishType", (Object)"individualCase")})})});
            for (String collectionName : collectionNameList) {
                this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(dbName).getCollection(collectionName).deleteMany(bson);
            }
        });
        log.info("cleanMongoData have been done!");
    }

    private void addNeo4jVersion(String version, String prodVersion, Neo4jManager neo4jManager) {
        String relationCypher;
        ConcurrentHashMap<Long, Long> nodeNeo4jIdMap = new ConcurrentHashMap<Long, Long>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", prodVersion);
        List nodeResultList = neo4jManager.ExecuteQuery("match (node) where node.version = $version and not any(label in labels(node) WHERE label in ['TenantEntity','AppEntity']) return node", param);
        List relationList = neo4jManager.ExecuteQuery("match (startNode)-[relation]->(endNode) where startNode.version = $version and endNode.version = $version and not any(startNodeLabel in labels(startNode) WHERE startNodeLabel in ['TenantEntity']) return id(startNode) as startNodeId,type(relation) as relationType,id(endNode) as endNodeId", param);
        for (Map nodeResult : nodeResultList) {
            StringBuffer nodeCypher = new StringBuffer("create (node");
            Collection labels = ((InternalNode)nodeResult.get("node")).labels();
            for (String label : labels) {
                nodeCypher.append(String.format(":%s", label));
            }
            nodeCypher.append("{");
            Map properties = ((InternalNode)nodeResult.get("node")).asMap();
            properties.forEach((k, v) -> {
                if (!"version".equals(k)) {
                    if (k.contains(".")) {
                        nodeCypher.append(String.format("`%s`:", k));
                    } else {
                        nodeCypher.append(String.format("%s:", k));
                    }
                    if (v instanceof String) {
                        String propertyValue2 = (String)v;
                        propertyValue2 = propertyValue2.replace("'", "\\\"");
                        nodeCypher.append(String.format("'%s',", propertyValue2));
                    } else if (v instanceof Collection) {
                        nodeCypher.append("[");
                        List propertyValueList = (List)v;
                        propertyValueList.forEach(propertyValue -> {
                            if (propertyValue instanceof String) {
                                nodeCypher.append(String.format("'%s'", propertyValue)).append(",");
                            } else {
                                nodeCypher.append(propertyValue).append(",");
                            }
                        });
                        if (!propertyValueList.isEmpty()) {
                            nodeCypher.deleteCharAt(nodeCypher.length() - 1);
                        }
                        nodeCypher.append("],");
                    } else {
                        nodeCypher.append(v).append(",");
                    }
                }
            });
            nodeCypher.append(String.format("version:'%s'}) return id(node) as nodeId", version));
            List newNodeResultList = neo4jManager.ExecuteQuery(StringEscapeUtils.escapeJava((String)nodeCypher.toString()));
            Long newNodeNeo4jId = Convert.toLong(((Map)newNodeResultList.get(0)).get("nodeId"));
            nodeNeo4jIdMap.put(((InternalNode)nodeResult.get("node")).id(), newNodeNeo4jId);
        }
        relationList.forEach(relation -> {
            relation.put("startNodeId", nodeNeo4jIdMap.get(relation.get("startNodeId")));
            relation.put("endNodeId", nodeNeo4jIdMap.get(relation.get("endNodeId")));
        });
        ArrayList<MyStatement> relationStatementList = new ArrayList<MyStatement>();
        for (Map relation2 : relationList) {
            int startNodeId = (Integer)relation2.get("startNodeId");
            int endNodeId = (Integer)relation2.get("endNodeId");
            relationCypher = String.format("match (startNode),(endNode) WHERE id(startNode)=%d and id(endNode)=%d merge (startNode)-[relation:%s]->(endNode)", startNodeId, endNodeId, relation2.get("relationType"));
            relationStatementList.add(new MyStatement(relationCypher));
        }
        for (Map relation2 : relationList) {
            int startNodeId = (Integer)relation2.get("startNodeId");
            int endNodeId = (Integer)relation2.get("endNodeId");
            relationCypher = String.format("match (startNode),(endNode) WHERE id(startNode)=%d and id(endNode)=%d merge (startNode)-[relation:%s]->(endNode)", startNodeId, endNodeId, relation2.get("relationType"));
            neo4jManager.ExecuteNoQuery(relationCypher);
        }
    }

    private void addMongoVersion(String newVersion, String oldVersion) {
        List initMongoList = MongoUtil.getMongoCollection();
        Bson bson = Filters.eq((String)"version", (Object)oldVersion);
        for (HashMap initMongo : initMongoList) {
            ((List)initMongo.get("collectionName")).forEach(collection -> {
                ArrayList newDocuments = new ArrayList();
                FindIterable documents = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase((String)initMongo.get("dbName")).getCollection(collection).find(bson);
                documents.forEach(document -> {
                    Document newDocument = new Document((Map)document);
                    newDocument.remove((Object)"_id");
                    newDocument.put("version", (Object)newVersion);
                    newDocuments.add(newDocument);
                });
                if (!newDocuments.isEmpty()) {
                    this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase((String)initMongo.get("dbName")).getCollection(collection).insertMany(newDocuments);
                }
            });
        }
    }

    public void revert(String version) {
        if ("1.0".equals(version)) {
            throw new BusinessException("Illegal version number!");
        }
        String cql1 = StrUtil.format((CharSequence)"MATCH (node)  where node.version ='{}' and not any(label in labels(node) WHERE label in ['AppEntity','TenantEntity']) detach delete node", (Object[])new Object[]{version});
        String cql2 = StrUtil.format((CharSequence)"MATCH (node)  where node.version ='{}' and node.nameSpace in ['espCommon','common'] and not any(label in labels(node) WHERE label in ['AppEntity','TenantEntity']) detach delete node", (Object[])new Object[]{version});
        Neo4jManager neo4jManager1 = new Neo4jManager(this.driver1);
        neo4jManager1.ExecuteNoQuery(cql1);
        neo4jManager1.ExecuteNoQuery(cql2);
        if (this.driver2 != null) {
            Neo4jManager neo4jManager2 = new Neo4jManager(this.driver2);
            neo4jManager2.ExecuteNoQuery(cql1);
            neo4jManager2.ExecuteNoQuery(cql2);
        }
        List mongoCollection = MongoUtil.getMongoCollection();
        Bson bson = Filters.eq((String)"version", (Object)version);
        for (HashMap map : mongoCollection) {
            String dbName = (String)map.get("dbName");
            List collections = (List)map.get("collectionName");
            collections.forEach(collection -> this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(dbName).getCollection(collection).deleteMany(bson));
        }
    }

    private void downloadFileFromDmc(String fileId, String destPath) {
        InputStream inputStream = this.dmcService.download(fileId);
        FileUtil.writeFromStream((InputStream)inputStream, (String)destPath);
    }

    private /* synthetic */ void lambda$updateDataVersion$13(HashMap initMongo, Bson deleteFilter, Bson filter, Bson update, String collection) {
        this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase((String)initMongo.get("dbName")).getCollection(collection).deleteMany(deleteFilter);
        this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase((String)initMongo.get("dbName")).getCollection(collection).updateMany(filter, update);
    }
}

