/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.service.deploy.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.dao.KmDeployRecordMongoDao;
import com.digiwin.athena.athena_deployer_service.domain.deploy.DataPublishStatusReqDto;
import com.digiwin.athena.athena_deployer_service.domain.deploy.DataPublishStatusResDto;
import com.digiwin.athena.athena_deployer_service.domain.kmDeployer.KmDeployRecord;
import com.digiwin.athena.athena_deployer_service.http.deployer.DeployerApiHelper;
import com.digiwin.athena.athena_deployer_service.http.km.KmApiHelper;
import com.digiwin.athena.athena_deployer_service.http.km.dto.CommonParadigmDeployDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.DeployAppReqDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.DeployAppResDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.DeployLogResDto;
import com.digiwin.athena.athena_deployer_service.http.km.dto.SwitchAppReqDto;
import com.digiwin.athena.athena_deployer_service.service.deploy.KmDeployRecordService;
import com.digiwin.athena.athena_deployer_service.util.LogUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KmDeployRecordServiceImpl
implements KmDeployRecordService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KmDeployRecordServiceImpl.class);
    @Autowired
    private KmDeployRecordMongoDao kmDeployRecordMongoDao;
    @Autowired
    private KmApiHelper kmApiHelper;
    @Autowired
    private DeployerApiHelper deployerApiHelper;

    public DeployAppResDto deployApp(DeployAppReqDto deployAppReqDto) {
        KmDeployRecord kmDeployRecord = this.kmDeployRecordMongoDao.selectByKmDeployIdAndType(deployAppReqDto.getDeployId(), "publish");
        if (kmDeployRecord == null) {
            kmDeployRecord = KmDeployRecord.create((DeployAppReqDto)deployAppReqDto);
        }
        String deployTenantId = deployAppReqDto.getDeployTenantId();
        deployAppReqDto.setDeployTenantId(null);
        deployAppReqDto.setDeployerToken(null);
        deployAppReqDto.setDeployerDomain(null);
        if ("tenantApp".equals(deployAppReqDto.getType())) {
            deployAppReqDto.setAppId(deployAppReqDto.getSourceApplicationCode());
        }
        DeployAppResDto deployAppResDto = this.kmApiHelper.deployApp(deployAppReqDto, deployTenantId);
        kmDeployRecord.setEventId(deployAppResDto.getEventId());
        kmDeployRecord.setEventStatus(KmDeployRecord.EXECUTING_DEPLOY_EVENT_STATUS);
        kmDeployRecord.setStatus("executing");
        kmDeployRecord.setEditDate(new Date());
        if (kmDeployRecord.getId() == null) {
            this.kmDeployRecordMongoDao.insert(kmDeployRecord);
        } else {
            this.kmDeployRecordMongoDao.save(kmDeployRecord);
        }
        return deployAppResDto;
    }

    public DeployAppResDto switchApp(SwitchAppReqDto switchAppReqDto) {
        KmDeployRecord kmDeployRecord = this.kmDeployRecordMongoDao.selectByApplicationAndDeployLogIdAndType(switchAppReqDto.getApplication(), switchAppReqDto.getDeployerLogId(), "switch");
        if (kmDeployRecord == null) {
            kmDeployRecord = KmDeployRecord.create((SwitchAppReqDto)switchAppReqDto);
        }
        String deployTenantId = switchAppReqDto.getDeployTenantId();
        switchAppReqDto.setDeployTenantId(null);
        switchAppReqDto.setDeployerToken(null);
        switchAppReqDto.setDeployerDomain(null);
        DeployAppResDto deployAppResDto = this.kmApiHelper.switchApp(switchAppReqDto, deployTenantId);
        kmDeployRecord.setEventId(deployAppResDto.getEventId());
        kmDeployRecord.setEventStatus(KmDeployRecord.EXECUTING_DEPLOY_EVENT_STATUS);
        kmDeployRecord.setStatus("executing");
        kmDeployRecord.setEditDate(new Date());
        if (kmDeployRecord.getId() == null) {
            this.kmDeployRecordMongoDao.insert(kmDeployRecord);
        } else {
            this.kmDeployRecordMongoDao.save(kmDeployRecord);
        }
        return deployAppResDto;
    }

    public List<KmDeployRecord> getExecutingRecord() {
        return this.kmDeployRecordMongoDao.selectByStatus(Arrays.asList("waiting", "executing"));
    }

    public void checkEventStatus(KmDeployRecord kmDeployRecord) {
        DeployLogResDto deployLogResDto = this.kmApiHelper.deployLogs(kmDeployRecord.getEventId(), kmDeployRecord.getDeployTenantId());
        JSONObject ext = deployLogResDto.getExt();
        Integer status = ext.getInteger("status");
        kmDeployRecord.setEventStatus(status);
        kmDeployRecord.setEventLog(deployLogResDto.getData());
        kmDeployRecord.setEditDate(new Date());
        String messageId = IdUtil.fastUUID().replace("-", "");
        String message = "\u8c03KM\u63a5\u53e3\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0:%s";
        if (KmDeployRecord.EXECUTING_DEPLOY_EVENT_STATUS.equals(status)) {
            kmDeployRecord.setStatus("executing");
            this.kmDeployRecordMongoDao.save(kmDeployRecord);
            return;
        }
        if (KmDeployRecord.FINISH_DEPLOY_EVENT_STATUS.equals(status)) {
            kmDeployRecord.setStatus("success");
            LogUtils.buildAgileLog((String)kmDeployRecord.getApplication(), (String)LogUtils.MODULE_AADCS, (String)"checkEventStatus", (String)LogUtils.SUCCESS, (String)JSON.toJSONString((Object)kmDeployRecord), (String)JSON.toJSONString((Object)deployLogResDto), (String)"", (String)messageId);
        } else if (KmDeployRecord.ERROR_DEPLOY_EVENT_STATUS.equals(status) || KmDeployRecord.TIMEOUT_DEPLOY_EVENT_STATUS.equals(status)) {
            kmDeployRecord.setStatus("fail");
            LogUtils.buildAgileLog((String)kmDeployRecord.getApplication(), (String)LogUtils.MODULE_AADCS, (String)"checkEventStatus", (String)LogUtils.AADCS_500_0004, (String)JSON.toJSONString((Object)kmDeployRecord), (String)String.format(message, deployLogResDto), (String)String.format("\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff0c\u5e76\u63d0\u4f9b\u6d88\u606f\u5e8f\u5217\u53f7\uff08%s\uff09", messageId), (String)messageId);
        } else if (KmDeployRecord.WARN_DEPLOY_EVENT_STATUS.equals(status)) {
            kmDeployRecord.setStatus("warn");
            LogUtils.buildAgileLog((String)kmDeployRecord.getApplication(), (String)LogUtils.MODULE_AADCS, (String)"checkEventStatus", (String)LogUtils.WARING, (String)JSON.toJSONString((Object)kmDeployRecord), (String)JSON.toJSONString((Object)deployLogResDto), (String)"", (String)messageId);
        }
        this.changeKmDataPublishStatus(kmDeployRecord);
    }

    public void changeKmDataPublishStatus(KmDeployRecord kmDeployRecord) {
        if ("fail".equals(kmDeployRecord.getStatus()) || "success".equals(kmDeployRecord.getStatus()) || "warn".equals(kmDeployRecord.getStatus())) {
            this.kmDeployRecordMongoDao.save(kmDeployRecord);
        }
    }

    public List<DataPublishStatusResDto> checkKmTaskStatus(List<DataPublishStatusReqDto> dataPublishStatusReqs) {
        List deployNoList = dataPublishStatusReqs.stream().map(DataPublishStatusReqDto::getDeployNo).collect(Collectors.toList());
        List kmDeployRecords = this.kmDeployRecordMongoDao.selectByDeployerLogIds(deployNoList);
        Set keys = dataPublishStatusReqs.stream().map(d -> d.getApplication() + d.getDeployNo()).collect(Collectors.toSet());
        kmDeployRecords = kmDeployRecords.stream().filter(k -> keys.contains(k.getApplication() + k.getDeployerLogId())).collect(Collectors.toList());
        return kmDeployRecords.stream().map(DataPublishStatusResDto::create).collect(Collectors.toList());
    }

    public DeployAppResDto commonParadigmDeploy(CommonParadigmDeployDto deployDto) {
        return this.kmApiHelper.commonParadigmDeploy(deployDto, deployDto.getTenantId());
    }
}

