/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.service.deploy.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.domain.dsl.Dsl;
import com.digiwin.athena.athena_deployer_service.domain.form.Form;
import com.digiwin.athena.athena_deployer_service.domain.form.LaunchProject;
import com.digiwin.athena.athena_deployer_service.domain.param.LcdpPublishParam;
import com.digiwin.athena.athena_deployer_service.domain.system.AthenaUser;
import com.digiwin.athena.athena_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.athena_deployer_service.service.deploy.LcdpService;
import com.digiwin.athena.athena_deployer_service.service.deploy.PageDesignService;
import com.digiwin.athena.athena_deployer_service.service.iam.IamService;
import com.digiwin.athena.athena_deployer_service.util.PageDesignPublishUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LcdpServiceImpl
implements LcdpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LcdpServiceImpl.class);
    @Autowired
    private PageDesignService pageDesignService;
    @Autowired
    private IamService iamService;

    public void publish(LcdpPublishParam lcdpPublishParam) {
        String appToken = lcdpPublishParam.getAppToken();
        List tenantUsers = lcdpPublishParam.getTenantUsers();
        JSONObject pageDesign = lcdpPublishParam.getPageDesign();
        AthenaUser currentUser = lcdpPublishParam.getCurrentUser();
        List tenantIds = tenantUsers.stream().map(t -> t.getTenantId()).collect(Collectors.toList());
        Form form = (Form)pageDesign.getObject("form", Form.class);
        JSONObject activity = new JSONObject();
        activity.put("code", (Object)pageDesign.getString("code"));
        activity.put("name", (Object)form.getFormName().getZh_CN());
        Dsl dsl = (Dsl)pageDesign.getObject("detailDsl", Dsl.class);
        Map compentMapping = PageDesignPublishUtil.handleComponentIdMapping((Form)form);
        JSONObject params = new JSONObject();
        if (compentMapping != null) {
            params = PageDesignPublishUtil.handleDslInfo((Dsl)dsl, (Map)compentMapping);
        }
        PageDesignPublishUtil.handleLaunchProjectInfo((JSONObject)params, (LaunchProject)((LaunchProject)JSON.parseObject((String)JSON.toJSONString((Object)pageDesign.get((Object)"launchProject")), LaunchProject.class)));
        this.pageDesignService.schemaPublish(currentUser.getToken(), appToken, tenantIds, form, params);
    }

    public void tbbAuthorize(LcdpPublishParam lcdpPublishParam) {
        JSONObject jsonObject;
        Integer code;
        AthenaUser currentUser = lcdpPublishParam.getCurrentUser();
        String env = lcdpPublishParam.getEnv();
        String application = lcdpPublishParam.getApplication();
        JSONObject pageDesign = lcdpPublishParam.getPageDesign();
        String token = this.iamService.getIntegrationToken(currentUser.getTenantId());
        ArrayList tableInfos = new ArrayList();
        Form form = (Form)pageDesign.getObject("form", Form.class);
        List tableInfo = PageDesignPublishUtil.handleTbbTableInfo((Form)form);
        if (!CollectionUtils.isEmpty((Collection)tableInfo)) {
            tableInfos.addAll(tableInfo);
        }
        if ((code = (jsonObject = this.pageDesignService.tbbPublish(token, env, "application", application, tableInfos)).getInteger("status")) == null || code != 200 || !jsonObject.getJSONObject("response").getBoolean("success").booleanValue()) {
            throw new BusinessException(JSON.toJSONString((Object)jsonObject));
        }
    }
}

