/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.service.deploy.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.config.ModuleConfig;
import com.digiwin.athena.athena_deployer_service.domain.apimgmt.ApiMgmtBaseInfo;
import com.digiwin.athena.athena_deployer_service.domain.application.Application;
import com.digiwin.athena.athena_deployer_service.domain.form.Form;
import com.digiwin.athena.athena_deployer_service.domain.param.PageDesignData;
import com.digiwin.athena.athena_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.athena_deployer_service.domain.system.MultiLanguageDTO;
import com.digiwin.athena.athena_deployer_service.http.esp.EspApiHelper;
import com.digiwin.athena.athena_deployer_service.neo4jbasepkg.master.repository.MasterActivityRepository;
import com.digiwin.athena.athena_deployer_service.service.deploy.ActivityService;
import com.digiwin.athena.athena_deployer_service.service.deploy.AppEntityService;
import com.digiwin.athena.athena_deployer_service.service.deploy.PageDesignService;
import com.digiwin.athena.athena_deployer_service.service.deploy.TagService;
import com.digiwin.athena.athena_deployer_service.service.deploy.TenantService;
import com.digiwin.athena.athena_deployer_service.service.iam.IamService;
import com.digiwin.athena.athena_deployer_service.util.Neo4jMultipleUtil;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.neo4j.driver.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PageDesignServiceImpl
implements PageDesignService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PageDesignServiceImpl.class);
    @Autowired
    private ModuleConfig moduleConfig;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private AppEntityService appEntityService;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private TagService tagService;
    @Autowired
    private MasterActivityRepository masterActivityRepository;
    @Autowired
    private EspApiHelper espApiHelper;
    @Autowired
    private IamService iamService;
    @Value(value="${appToken}")
    private String appToken;
    @Autowired
    private Driver driver1;
    @Value(value="${envMode}")
    private String envMode;
    @Autowired(required=false)
    @Qualifier(value="domain2Driver")
    private Driver driver2;

    public void schemaPublish(String token, String appToken, List<String> targetTenantIds, Form form, JSONObject paramJson) {
        JSONObject formJSON = JSON.parseObject((String)JSON.toJSONString((Object)form));
        JSONObject param = new JSONObject();
        MultiLanguageDTO formName = form.getFormName();
        if (formName != null) {
            String formNameZhCn = formName.getZh_CN();
            formJSON.put("formName", (Object)formNameZhCn);
        }
        param.put("form", (Object)formJSON);
        param.put("targetTenantIds", targetTenantIds);
        param.put("params", (Object)paramJson);
        ModuleConfig.Module lcdp = this.moduleConfig.getLcdp();
        String lcdpDomain = lcdp.getDomain();
        String url = lcdpDomain + "/restful/service/lcdp/FormDesign/PublishSchema";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", token);
        headers.put("digi-middleware-auth-app", appToken);
        String response = ((HttpRequest)HttpRequest.put((String)url).addHeaders(headers)).body(JSON.toJSONString((Object)param)).timeout(30000).execute().body();
        JSONObject jsonObject = JSON.parseObject((String)response);
        Integer status = jsonObject.getInteger("status");
        if (status != 200) {
            log.info("\u8868\u5355\u53d1\u5e03\u5931\u8d25:{}", (Object)response);
            throw new BusinessException(jsonObject.getString("errorMessage"));
        }
        JSONObject responseObj = jsonObject.getJSONObject("response");
        Boolean success = responseObj.getBoolean("success");
        if (!success.booleanValue()) {
            log.info("\u8868\u5355\u53d1\u5e03\u5931\u8d25:{}", (Object)response);
            JSONArray failureList = responseObj.getJSONObject("data").getJSONArray("failureList");
            List messageList = failureList.stream().map(failure -> JSON.parseObject((String)JSON.toJSONString((Object)failure)).getString("message")).collect(Collectors.toList());
            throw new BusinessException(String.join((CharSequence)",", messageList));
        }
        log.info("schema\u53d1\u5e03\u6210\u529f\uff01");
    }

    public void iamPublish(String token, Application application, List<Long> tenantSids, List<JSONObject> activityList, String moduleId) {
        ModuleConfig.Module iam = this.moduleConfig.getIam();
        String iamDomain = iam.getDomain();
        String singlePublish = "/api/iam/v2/app/action/update";
        for (Long tenantSid : tenantSids) {
            JSONObject param = new JSONObject();
            param.put("tenantSid", (Object)tenantSid);
            param.put("appId", (Object)application.getCode());
            param.put("moduleId", (Object)moduleId);
            for (JSONObject activity : activityList) {
                String code = activity.getString("code");
                String name = activity.getString("name");
                String parentId = activity.getString("parentId");
                if (parentId != null && !parentId.trim().isEmpty()) {
                    param.put("parentId", (Object)parentId);
                }
                param.put("id", (Object)code);
                param.put("name", (Object)name);
                this.callIamSingleGrantAuthorization(token, iamDomain + singlePublish, param);
            }
        }
        log.info("iam\u53d1\u5e03\u6210\u529f\uff01");
    }

    public void iamPublishWithoutTenantSid(String token, Application application, List<Long> tenantSids, List<JSONObject> activityList, String moduleId) {
        ModuleConfig.Module iam = this.moduleConfig.getIam();
        String iamDomain = iam.getDomain();
        String singlePublish = "/api/iam/v2/app/action/update";
        JSONObject param = new JSONObject();
        param.put("appId", (Object)application.getCode());
        param.put("moduleId", (Object)moduleId);
        for (JSONObject activity : activityList) {
            String code = activity.getString("code");
            String name = activity.getString("name");
            String parentId = activity.getString("parentId");
            if (parentId != null && !parentId.trim().isEmpty()) {
                param.put("parentId", (Object)parentId);
            }
            param.put("id", (Object)code);
            param.put("name", (Object)name);
            this.callIamSingleGrantAuthorization(token, iamDomain + singlePublish, param);
        }
        log.info("iam\u53d1\u5e03\u6210\u529f\uff01WithoutTenantSid!");
    }

    public void commonIamPublish(String token, Application application, List<Long> tenantSids, List<JSONObject> activityList) {
        Long appSid = this.getAppSid(application.getCode(), token);
        ModuleConfig.Module iam = this.moduleConfig.getIam();
        String iamDomain = iam.getDomain();
        String iamUrl = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/dev/app/module";
        JSONObject param = new JSONObject();
        for (JSONObject activity : activityList) {
            String nameUS;
            String nameTW;
            String nameCN;
            String code = activity.getString("code");
            JSONObject lang = activity.getJSONObject("lang");
            if (lang == null) {
                nameTW = nameCN = activity.getString("name");
                nameUS = nameCN;
            } else {
                nameCN = lang.getJSONObject("name").getString("zh_CN");
                nameTW = lang.getJSONObject("name").getString("zh_TW");
                nameUS = lang.getJSONObject("name").getString("zh_US");
            }
            param.put("remarks", (Object)"");
            param.put("id", (Object)code);
            param.put("nameCN", (Object)nameCN);
            param.put("nameTW", (Object)nameTW);
            param.put("nameUS", (Object)nameUS);
            param.put("appSid", (Object)appSid);
            String response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)iamUrl).body(JSON.toJSONString((Object)param)).header("digi-middleware-auth-user", token)).header("digi-middleware-auth-app", this.appToken)).execute().body();
            JSONObject responseObj = JSON.parseObject((String)response);
            Boolean success = responseObj.getBoolean("success");
            if (success.booleanValue()) continue;
            log.error("\u521b\u5efa\u6a21\u7ec4\u5931\u8d25\uff0c\u53c2\u6570:{}\uff0c\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)param), (Object)response);
        }
        String singlePublish = "/api/iam/v2/app/action/update";
        for (Long tenantSid : tenantSids) {
            JSONObject paramAuth = new JSONObject();
            paramAuth.put("tenantSid", (Object)tenantSid);
            paramAuth.put("appId", (Object)application.getCode());
            for (JSONObject activity : activityList) {
                String code = activity.getString("code");
                String name = activity.getString("name");
                paramAuth.put("id", (Object)code);
                paramAuth.put("name", (Object)name);
                paramAuth.put("moduleId", (Object)code);
                this.callIamSingleGrantAuthorization(token, iamDomain + singlePublish, paramAuth);
            }
        }
        log.info("iam\u53d1\u5e03\u6210\u529f\uff01");
    }

    private Long getAppSid(String appCode, String token) {
        String iamUrl = this.moduleConfig.getIam().getDomain() + StrUtil.format((CharSequence)"/api/iam/v2/dev/app/id/{}", (Object[])new Object[]{appCode});
        String response = ((HttpRequest)((HttpRequest)HttpUtil.createGet((String)iamUrl).header("digi-middleware-auth-user", token)).header("digi-middleware-auth-app", this.appToken)).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        Boolean success = responseObj.getBoolean("success");
        if (!success.booleanValue()) {
            log.error("\u83b7\u53d6\u5e94\u7528sid\u5931\u8d25\uff0c\u8fd4\u56de:{}", (Object)response);
            throw new BusinessException("\u83b7\u53d6\u5e94\u7528sid\u5931\u8d25\uff0c\u521b\u5efa\u5e94\u7528\u6a21\u7ec4\u5931\u8d25!");
        }
        String appSid = responseObj.getJSONObject("data").getString("sid");
        return Long.parseLong(appSid);
    }

    public JSONObject tbbPublish(String token, String mode, String level, String application, List<JSONObject> tableinfo) {
        ModuleConfig.Module tbb;
        JSONObject param = new JSONObject();
        if (StringUtils.isEmpty((Object)mode)) {
            mode = this.envMode;
        }
        if ("AliTest-TEST".equals(mode)) {
            mode = "HuaweiTest-TEST";
        }
        if (null == (tbb = this.moduleConfig.getTbb()) || StringUtils.isEmpty((Object)tbb.getDomain())) {
            throw new BusinessException("\u73af\u5883\u53d8\u91cf\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4tbb\u670d\u52a1\u914d\u7f6e\u662f\u5426\u6b63\u5e38\uff01");
        }
        param.put("mode", (Object)mode);
        param.put("level", (Object)level);
        param.put("appCode", (Object)application);
        param.put("tableInfo", tableinfo);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("token", token);
        String tbbDomain = tbb.getDomain();
        String iamPublishApiUrl = tbbDomain + "/tbb-system/platform_integration/data_entry";
        log.info("tbbPublish url is -->{}", (Object)iamPublishApiUrl);
        log.info("tbbPublish headers is -->{}", headers);
        log.info("tbbPublish request is -->{}", (Object)param);
        String response = ((HttpRequest)HttpUtil.createPost((String)iamPublishApiUrl).body(JSON.toJSONString((Object)param)).addHeaders(headers)).timeout(30000).execute().body();
        log.info("tbbPublish response is -->{}", (Object)response);
        JSONObject responseObj = JSON.parseObject((String)response);
        Integer code = responseObj.getInteger("status");
        if (code == null || code != 200 || !responseObj.getJSONObject("response").getBoolean("success").booleanValue()) {
            log.error("\u53d1\u5e03\u5230tbb\u5931\u8d25---" + response);
        }
        return responseObj;
    }

    public List<JSONObject> kmPublish(Application application, List<PageDesignData> pageDesignDataList, List<String> tenantIds) {
        List mongoDataList = pageDesignDataList.stream().filter(pageDesignData -> "mongo".equals(pageDesignData.getDataType())).collect(Collectors.toList());
        List neo4jDataList = pageDesignDataList.stream().filter(pageDesignData -> "neo4j".equals(pageDesignData.getDataType())).collect(Collectors.toList());
        log.info("mongoDataList:{}", mongoDataList);
        log.info("neo4jDataList:{}", neo4jDataList);
        for (PageDesignData pageDesignData2 : mongoDataList) {
            String collectionName = pageDesignData2.getCollectionName();
            String dbName = pageDesignData2.getDbName();
            String dataStr = pageDesignData2.getDataStr();
            Document document = Document.parse((String)dataStr);
            String version = pageDesignData2.getVersion();
            if (StrUtil.isNotBlank((CharSequence)version)) {
                document.put("version", (Object)version);
                document.put("athena_namespace", (Object)application.getCode());
            }
            String[] pks = pageDesignData2.getPk().split(",");
            ArrayList<Bson> deleteFilters = new ArrayList<Bson>();
            for (String pk : pks) {
                if ("_id".equals(pk)) {
                    pk = "objectId";
                }
                Bson deleteFilterElement = Filters.eq((String)pk, (Object)document.get((Object)pk));
                deleteFilters.add(deleteFilterElement);
            }
            Bson deleteFilter = Filters.and(deleteFilters);
            if (!"taggingData".equals(collectionName)) {
                this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(dbName).getCollection(collectionName).deleteOne(deleteFilter);
            }
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(dbName).getCollection(collectionName).insertOne((Object)document);
        }
        this.tenantService.createTenants(tenantIds, "1.0");
        ArrayList<JSONObject> activityList = new ArrayList<JSONObject>();
        for (PageDesignData pageDesignData3 : neo4jDataList) {
            String dataStr = pageDesignData3.getDataStr();
            dataStr = dataStr.replaceAll("\\{athena_version}", pageDesignData3.getVersion());
            Neo4jMultipleUtil.executeCql((String)dataStr, (Driver[])new Driver[]{this.driver1, this.driver2});
            String collection = pageDesignData3.getCollectionName();
            if (!"Activity".equals(collection)) continue;
            this.masterActivityRepository.mergeRelation(tenantIds, Convert.toStr((Object)pageDesignData3.getPkValue()), pageDesignData3.getVersion(), DateUtil.now());
        }
        this.appEntityService.save(application, tenantIds);
        log.info("km\u53d1\u5e03\u6210\u529f\uff01");
        return activityList;
    }

    public void deleteSchema(String token, String appToken, String formId) {
        ModuleConfig.Module lcdp = this.moduleConfig.getLcdp();
        String lcdpDomain = lcdp.getDomain();
        String url = lcdpDomain + "/restful/service/lcdp/FormDesign";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", token);
        headers.put("digi-middleware-auth-app", appToken);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("formId", formId);
        log.info("deleteSchema url is -->{}", (Object)url);
        log.info("deleteSchema headers is -->{}", headers);
        log.info("deleteSchema request is -->{}", param);
        String response = ((HttpRequest)HttpRequest.delete((String)url).addHeaders(headers)).body(JSON.toJSONString(param)).execute().body();
        log.info("deleteSchema response is -->{}", (Object)response);
        JSONObject jsonObject = JSON.parseObject((String)response);
        Integer status = jsonObject.getInteger("status");
        if (status != 200) {
            throw new BusinessException(jsonObject.getString("errorMessage"));
        }
        log.info("delete form schema success");
    }

    public void publishModel(String token, String appToken, JSONObject publishModel, String tenantId, String serviceCode, String modelCode, JSONArray apiBaseInfos) {
        String targetProd;
        JSONObject appInfo;
        this.espApiHelper.serviceRegisterToEsp(publishModel, serviceCode, token, appToken, tenantId);
        HashMap<String, String> modelComeFromMap = new HashMap<String, String>();
        ArrayList<ApiMgmtBaseInfo> apiMgmtBaseInfos = new ArrayList<ApiMgmtBaseInfo>();
        if (CollUtil.isNotEmpty((Collection)apiBaseInfos)) {
            for (int i = 0; i < apiBaseInfos.size(); ++i) {
                JSONObject apiBaseInfo = apiBaseInfos.getJSONObject(i);
                ApiMgmtBaseInfo apiMgmtBaseInfo = new ApiMgmtBaseInfo();
                apiMgmtBaseInfo.setApiName(apiBaseInfo.getString("apiName"));
                apiMgmtBaseInfo.setVersion(apiBaseInfo.getString("version"));
                apiMgmtBaseInfo.setModelComeFrom(apiBaseInfo.getString("modelComeFrom"));
                modelComeFromMap.put(modelCode, apiBaseInfo.getString("modelComeFrom"));
                apiMgmtBaseInfos.add(apiMgmtBaseInfo);
            }
        }
        if (publishModel.get((Object)"appInfo") != null && (appInfo = publishModel.getJSONObject("appInfo")) != null && !StringUtils.isEmpty((Object)(targetProd = appInfo.getString("targetProd")))) {
            this.espApiHelper.callBMEspService(modelCode, appToken, tenantId, serviceCode, targetProd, apiMgmtBaseInfos, modelComeFromMap);
        }
    }

    public void deleteModel(String token, String appToken, JSONObject publishModelDrivenInfo, String tenantId) {
        try {
            this.espApiHelper.serviceDelToEsp(publishModelDrivenInfo, token, appToken, tenantId);
        }
        catch (Exception e) {
            log.info("serviceDelToEsp have exception");
        }
    }

    private void callIamSingleGrantAuthorization(String token, String url, JSONObject param) {
        JSONObject jsonObject;
        String response = null;
        try {
            response = ((HttpRequest)HttpUtil.createPost((String)url).header("digi-middleware-auth-user", token)).body(JSON.toJSONString((Object)param)).timeout(30000).execute().body();
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message.contains("\"errorCode\":\"21035\"")) {
                return;
            }
            throw new RuntimeException(e);
        }
        if (!(NumberUtil.isNumber((CharSequence)response) || (jsonObject = JSON.parseObject((String)response)).getBoolean("success").booleanValue() && jsonObject.getInteger("code") != 500)) {
            if (jsonObject.containsKey((Object)"errorCode") && "21035".equals(jsonObject.get((Object)"errorCode"))) {
                log.warn("callIamSingleGrantAuthorization \u6267\u884c\u5931\u8d25\uff1a" + response);
                return;
            }
            throw new BusinessException(Integer.valueOf(-1), response);
        }
    }

    public void deleteAppModel(String token, String appToken, JSONObject publishModelDrivenInfo, String tenantId) {
        log.info("deleteAppModel method start,param is:{}", (Object)JSON.toJSONString((Object)publishModelDrivenInfo));
        try {
            this.espApiHelper.serviceDelModelToEsp(publishModelDrivenInfo, token, appToken, tenantId);
        }
        catch (Exception e) {
            log.error("deleteAppModel have exception");
        }
    }
}

