/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.service.deploy.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.config.ModuleConfig;
import com.digiwin.athena.athena_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.athena_deployer_service.enums.AbiAddressEnum;
import com.digiwin.athena.athena_deployer_service.http.designer.DesignerApiHelper;
import com.digiwin.athena.athena_deployer_service.service.deploy.StatementService;
import com.digiwin.athena.athena_deployer_service.service.iam.IamService;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class StatementServiceImpl
implements StatementService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatementServiceImpl.class);
    @Autowired
    private ModuleConfig moduleConfig;
    @Value(value="${envMode}")
    private String envMode;
    @Autowired
    private IamService iamService;
    @Autowired
    private DesignerApiHelper designerApiHelper;

    public JSONObject tbbStatementPublish(JSONObject jsonObject) {
        log.info("tbbStatementPublish param:{}", (Object)JSON.toJSONString((Object)jsonObject));
        ModuleConfig.Module tbb = this.moduleConfig.getTbb();
        if (null == tbb || StringUtils.isEmpty((CharSequence)tbb.getDomain())) {
            throw new BusinessException("\u73af\u5883\u53d8\u91cf\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4tbb\u670d\u52a1\u914d\u7f6e\u662f\u5426\u6b63\u5e38\uff01");
        }
        String tbbUri = jsonObject.getString("tbb_uri");
        if (StringUtils.isBlank((CharSequence)tbbUri)) {
            tbbUri = tbb.getDomain();
        }
        String tbbServiceUrl = tbbUri + "/tbb-system/platform_integration/publish_report";
        List tenantIdList = (List)JSON.parseObject((String)JSON.toJSONString((Object)jsonObject.getJSONArray("tenantIds")), List.class);
        String appCode = jsonObject.getString("appCode");
        String mode = jsonObject.getString("env");
        String innerToken = jsonObject.getString("tbbInnerToken");
        String unAppcode = jsonObject.getString("ucAppCode");
        Object reports = jsonObject.get((Object)"reports");
        log.info("tbbInnerToken:{},tbbServiceUrl:{}", (Object)innerToken, (Object)tbbServiceUrl);
        if (StringUtils.isEmpty((CharSequence)mode) && "AliTest-TEST".equals(mode = this.envMode)) {
            mode = "HuaweiTest-TEST";
        }
        if ("AliTest-TEST".equals(mode)) {
            mode = "HuaweiTest-TEST";
        }
        String operate = jsonObject.getString("operate");
        JSONArray reportList = jsonObject.getJSONArray("reportList");
        JSONObject param = new JSONObject();
        param.put("tenantIdList", (Object)tenantIdList);
        param.put("appCode", (Object)appCode);
        param.put("reportList", (Object)reportList);
        param.put("mode", (Object)mode);
        param.put("operate", (Object)(StrUtil.isBlank((CharSequence)operate) ? "publish" : operate));
        param.put("ucAppCode", (Object)unAppcode);
        param.put("reports", reports);
        param.put("ucTenantIdList", jsonObject.get((Object)"ucTenantIdList"));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("innerToken", innerToken);
        log.info("tbb\u62a5\u8868\u53d1\u5e03param--" + JSON.toJSONString((Object)param));
        String response = ((HttpRequest)HttpUtil.createPost((String)tbbServiceUrl).body(JSON.toJSONString((Object)param)).addHeaders(headers)).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        Integer code = responseObj.getInteger("status");
        if (code == null || code != 200) {
            log.info("tbb\u62a5\u8868\u53d1\u5e03url" + tbbServiceUrl);
            log.error("tbb\u62a5\u8868\u53d1\u5e03\u5931\u8d25" + response);
            throw new BusinessException("tbb\u62a5\u8868\u53d1\u5e03\u5931\u8d25\uff01\u8fd4\u56de\u4fe1\u606f\uff1a" + String.valueOf(responseObj));
        }
        return responseObj;
    }

    public JSONObject abiStatementPublish(JSONObject jsonObject) {
        String tenantId = jsonObject.getString("tenantId");
        String integrationToken = this.iamService.getIntegrationToken(tenantId);
        ModuleConfig.Module abi = this.moduleConfig.getAbi();
        if (null == abi || StringUtils.isEmpty((CharSequence)abi.getDomain())) {
            throw new BusinessException("\u73af\u5883\u53d8\u91cf\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4abi\u670d\u52a1\u914d\u7f6e\u662f\u5426\u6b63\u5e38\uff01");
        }
        String abiServiceUrl = abi.getDomain() + "/abi/lcdp.rpt.release?@routerKey=uploadabireport";
        JSONObject param = new JSONObject();
        String isvCode = jsonObject.getString("isvCode");
        String resid = jsonObject.getString("resid");
        String code = jsonObject.getString("code");
        String appCode = jsonObject.getString("appCode");
        String innerToken = jsonObject.getString("abiInnerToken");
        log.info("abiInnerToken:" + innerToken);
        param.put("isvcode", (Object)isvCode);
        param.put("resid", (Object)resid);
        param.put("program_code", (Object)code);
        param.put("app_id", (Object)appCode);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("digi-middleware-auth-user", integrationToken);
        headers.put("innerToken", innerToken);
        String response = ((HttpRequest)HttpUtil.createPost((String)abiServiceUrl).body(JSON.toJSONString((Object)param)).addHeaders(headers)).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        Integer responseCode = responseObj.getInteger("status");
        if (responseCode == null || responseCode != 200) {
            log.error("abi\u62a5\u8868\u53d1\u5e03url\uff1a" + abiServiceUrl);
            log.error("abi\u62a5\u8868\u53d1\u5e03body\uff1a" + JSON.toJSONString((Object)param));
            log.error("abi\u62a5\u8868\u53d1\u5e03\u5931\u8d25\uff1a" + response);
            throw new BusinessException("abi\u62a5\u8868(resid:" + resid + ")\u53d1\u5e03\u5931\u8d25! \u8fd4\u56de\u4fe1\u606f\uff1a" + String.valueOf(responseObj));
        }
        return responseObj;
    }

    public void syncAbi(String env, List<String> resIds, String application, String token, String tenantId) {
        Integer exportType = 1;
        Integer importType = 4;
        Boolean needCallAbiApi = Boolean.FALSE;
        if ("HuaweiProd-TEST".equals(env) || "AzureProd-TEST".equals(env) || "DEV-TEST".equals(env)) {
            needCallAbiApi = Boolean.TRUE;
            ModuleConfig.Module abi = this.moduleConfig.getAbi();
            if (null == abi || StringUtils.isEmpty((CharSequence)abi.getDomain())) {
                throw new BusinessException("\u73af\u5883\u53d8\u91cf\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4abi\u670d\u52a1\u914d\u7f6e\u662f\u5426\u6b63\u5e38\uff01");
            }
            String domain = abi.getDomain();
            if (domain.contains("paas")) {
                exportType = AbiAddressEnum.EXPORT_TYPE_PAAS.getType();
                importType = AbiAddressEnum.IMPORT_TYPE_TEST.getType();
            } else {
                exportType = AbiAddressEnum.EXPORT_TYPE_TEST.getType();
                if ("HuaweiProd-TEST".equals(env)) {
                    importType = AbiAddressEnum.IMPORT_TYPE_HUAWEI.getType();
                }
                if ("AzureProd-TEST".equals(env)) {
                    importType = AbiAddressEnum.IMPORT_TYPE_AZUREPROD.getType();
                }
                if ("DEV-TEST".equals(env)) {
                    importType = AbiAddressEnum.IMPORT_TYPE_DEV.getType();
                }
            }
        }
        if ("HuaweiTest-TEST".equals(env) || "AzureTest-TEST".equals(env)) {
            String area = "HuaweiTest-TEST".equals(env) ? "\u534e\u4e3a" : "\u5fae\u8f6f";
            String isvCode = this.iamService.getIsvCode(tenantId);
            this.syncAbiTheme(area, isvCode, tenantId, application, importType, exportType);
        }
        if (needCallAbiApi.booleanValue()) {
            String resIdStr = String.join((CharSequence)",", resIds);
            this.callAbiApi(resIdStr, importType, exportType, application);
        }
    }

    private void syncAbiTheme(String area, String isvcode, String tenantID, String appCode, Integer importType, Integer exportType) {
        JSONObject jsonObject;
        Integer status;
        ModuleConfig.Module abi = this.moduleConfig.getAbi();
        if (null == abi || StringUtils.isEmpty((CharSequence)abi.getDomain())) {
            throw new BusinessException("\u73af\u5883\u53d8\u91cf\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4abi\u670d\u52a1\u914d\u7f6e\u662f\u5426\u6b63\u5e38\uff01");
        }
        String domain = abi.getDomain();
        String url = "/abi/report/lcdp/restore/back?id=admin&pw=rootadmin";
        JSONObject body = new JSONObject();
        body.put("area", (Object)area);
        body.put("isvcode", (Object)isvcode);
        body.put("tenantID", (Object)tenantID);
        body.put("appCode", (Object)appCode);
        body.put("importType", (Object)importType);
        body.put("exportType", (Object)exportType);
        log.info("syncAbiTheme url:" + url + " body:" + body.toJSONString());
        String responseStr = HttpUtil.createPost((String)(domain + url)).body(body.toJSONString()).execute().body();
        log.info("/abi/report/lcdp/restore/back responseStr:" + responseStr);
        if (!(StringUtils.isEmpty((CharSequence)responseStr) || (status = (jsonObject = JSON.parseObject((String)responseStr)).getInteger("status")) != null && status == 200)) {
            log.info("\u540c\u6b65abi\u4e3b\u9898\u96c6\u5931\u8d25\u5165\u53c2:{}", (Object)body.toJSONString());
            log.info("\u540c\u6b65abi\u4e3b\u9898\u96c6\u5931\u8d25\u8fd4\u56de\u4fe1\u606f:{}", (Object)responseStr);
        }
    }

    private void callAbiApi(String resIdStr, Integer importType, Integer exportType, String application) {
        ModuleConfig.Module abi = this.moduleConfig.getAbi();
        if (null == abi || StringUtils.isEmpty((CharSequence)abi.getDomain())) {
            throw new BusinessException("\u73af\u5883\u53d8\u91cf\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4abi\u670d\u52a1\u914d\u7f6e\u662f\u5426\u6b63\u5e38\uff01");
        }
        String domain = abi.getDomain();
        String url = "/abi/lcdp.rpt.imports?@routerKey=uploadabireport";
        JSONObject body = new JSONObject();
        body.put("ids", (Object)resIdStr);
        body.put("importType", (Object)importType);
        body.put("exportType", (Object)exportType);
        body.put("appCode", (Object)application);
        String responseStr = HttpUtil.createPost((String)(domain + url)).body(body.toJSONString()).execute().body();
        log.info("/abi/lcdp.rpt.imports response:" + responseStr);
        JSONObject jsonObject = JSON.parseObject((String)responseStr);
        Integer status = jsonObject.getInteger("status");
        if (status == null || status != 200) {
            log.info("/abi/lcdp.rpt.imports\u540c\u6b65abi\u62a5\u8868\u5931\u8d25\u5165\u53c2:{}", (Object)body);
            log.info("/abi/lcdp.rpt.imports\u540c\u6b65abi\u62a5\u8868\u5931\u8d25\u8fd4\u56de\u4fe1\u606f:{}", (Object)responseStr);
            throw new BusinessException("\u540c\u6b65abi\u62a5\u8868\u5931\u8d25:" + responseStr);
        }
    }
}

