/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.service.deploy.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.config.neo4j.Neo4jManager;
import com.digiwin.athena.athena_deployer_service.constant.GmcModuleConstant;
import com.digiwin.athena.athena_deployer_service.domain.ApplicationData;
import com.digiwin.athena.athena_deployer_service.domain.ApplicationInfoDto;
import com.digiwin.athena.athena_deployer_service.domain.TenantUser;
import com.digiwin.athena.athena_deployer_service.domain.neo4j.Cql;
import com.digiwin.athena.athena_deployer_service.domain.param.AuthUserParam;
import com.digiwin.athena.athena_deployer_service.domain.param.AuthUserResponse;
import com.digiwin.athena.athena_deployer_service.domain.param.GmcUpdateParam;
import com.digiwin.athena.athena_deployer_service.domain.param.PolicyBatchAddParam;
import com.digiwin.athena.athena_deployer_service.domain.param.TenantVersion;
import com.digiwin.athena.athena_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.athena_deployer_service.domain.system.TenantUserResult;
import com.digiwin.athena.athena_deployer_service.http.gmc.GmcApiHelper;
import com.digiwin.athena.athena_deployer_service.service.deploy.TenantService;
import com.digiwin.athena.athena_deployer_service.service.iam.IamService;
import com.digiwin.athena.athena_deployer_service.util.LogUtils;
import com.digiwin.athena.athena_deployer_service.util.Neo4jMultipleUtil;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.neo4j.driver.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class TenantServiceImpl
implements TenantService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantServiceImpl.class);
    private static final String queryAllTenants = "/api/iam/v2/tenant/tenants/by/customer";
    private static final String queryAllTenantUser = "/api/iam/v2/tenant/user/list";
    private static final String tokenParseUrl = "/api/iam/v2/identity/token/analyze";
    private static final String authUserUrl = "/api/iam/v2/tenant/auth/with/users";
    private static final String policyAddUrl = "/api/iam/v2/policy/batch/add";
    private static final String GMC_MULTI_LANGUAGE_SEARCH = "/api/gmc/v2/multi/language/{}";
    private static final String GMC_MODULE_UPDATE = "/api/cloudgoods/modules";
    @Value(value="${appToken}")
    private String appToken;
    @Value(value="${module.iam.domain}")
    private String iamUrl;
    @Value(value="${module.gmc.domain}")
    private String gmcUrl;
    @Autowired
    private Driver driver1;
    @Autowired(required=false)
    @Qualifier(value="domain2Driver")
    private Driver driver2;
    @Autowired
    private IamService iamService;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private GmcApiHelper gmcApiHelper;

    public JSONObject queryUserTenants(String tenantId) {
        String curToken = this.iamService.getIntegrationToken(tenantId);
        try {
            String response = ((HttpRequest)HttpUtil.createGet((String)(this.iamUrl + queryAllTenants)).header("digi-middleware-auth-user", curToken)).execute().body();
            JSONObject responseJson = JSON.parseObject((String)response);
            return responseJson;
        }
        catch (Exception e) {
            JSONObject responseObj = new JSONObject();
            log.error("\u67e5\u8be2\u79df\u6237\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            responseObj.put("code", (Object)-1);
            responseObj.put("messgge", (Object)e.getMessage());
            return responseObj;
        }
    }

    public TenantUserResult queryUserInTenant(String tenantId, String token, Integer pageSize, Integer pageNum) {
        String param = String.format("?pageSize=%d&pageNum=%d", pageSize, pageNum);
        String queryUserInTenantsUrl = queryAllTenantUser + param;
        JSONObject paramJson = new JSONObject();
        paramJson.put("tenantId", (Object)tenantId);
        this.addParamToQueryUser(tenantId, paramJson);
        String response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)(this.iamUrl + queryUserInTenantsUrl)).header("digi-middleware-auth-app", this.appToken)).header("digi-middleware-auth-user", token)).body(paramJson.toJSONString()).execute().body();
        try {
            JSONObject responseObj = JSON.parseObject((String)response);
            List users = responseObj.getJSONArray("list").toJavaList(JSONObject.class);
            Integer total = responseObj.getInteger("total");
            return new TenantUserResult().setUserList(users).setTotal(total);
        }
        catch (Exception e) {
            JSONObject responseObj = JSON.parseObject((String)response);
            log.error("\u67e5\u8be2\u7528\u6237\u5931\u8d25:{}", (Object)response);
            throw new BusinessException(responseObj.getString("errorMessage"));
        }
    }

    public List<JSONObject> queryAllUserInTenant(String tenantId, String token) {
        ArrayList<JSONObject> allUsers = new ArrayList<JSONObject>();
        Integer pageSize = 100;
        Integer pageNum = 1;
        String param = String.format("?pageSize=%d&pageNum=%d", pageSize, pageNum);
        String queryUserInTenantsUrl = queryAllTenantUser + param;
        JSONObject paramJson = new JSONObject();
        paramJson.put("tenantId", (Object)tenantId);
        this.addParamToQueryUser(tenantId, paramJson);
        String response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)(this.iamUrl + queryUserInTenantsUrl)).header("digi-middleware-auth-app", this.appToken)).header("digi-middleware-auth-user", token)).body(paramJson.toJSONString()).execute().body();
        log.info("queryAllUserInTenant response:{}", (Object)response);
        try {
            JSONObject responseJson = JSON.parseObject((String)response);
            String code = responseJson.getString("code");
            if (!StringUtils.isEmpty((CharSequence)code) && "500".equals(code)) {
                JSONObject tenantInfoByToken = this.getTenantInfoByToken(token);
                String id = tenantInfoByToken.getString("id");
                JSONArray list = new JSONArray();
                JSONObject supplementObject = new JSONObject();
                supplementObject.put("id", (Object)id);
                list.add((Object)supplementObject);
                responseJson.put("list", (Object)list);
                responseJson.put("total", (Object)1);
            }
            List users = responseJson.getJSONArray("list").toJavaList(JSONObject.class);
            allUsers.addAll(users);
            Integer total = responseJson.getInteger("total");
            if (total > pageSize) {
                Integer size = total / pageSize;
                for (int i = 0; i < size; ++i) {
                    Integer n = pageNum;
                    pageNum = pageNum + 1;
                    TenantUserResult tenantUserResult = this.queryUserInTenant(tenantId, token, pageSize, pageNum);
                    List userJson = tenantUserResult.getUserList();
                    allUsers.addAll(userJson);
                }
            }
            return allUsers;
        }
        catch (Exception e) {
            JSONObject responseObj = JSON.parseObject((String)response);
            log.error("\u67e5\u8be2\u7528\u6237\u5931\u8d25\u5f02\u5e38\u4fe1\u606f:", (Throwable)e);
            throw new BusinessException(responseObj.getString("errorMessage"));
        }
    }

    private void addParamToQueryUser(String tenantId, JSONObject paramJson) {
        String isvCode = this.iamService.getIsvCode(tenantId);
        if (StrUtil.isEmpty((CharSequence)isvCode)) {
            paramJson.put("searchType", (Object)1);
        }
    }

    public JSONObject authUser(AuthUserParam authUserParam, String token) {
        JSONObject jsonObject = new JSONObject();
        ArrayList<AuthUserResponse> successAuthUserList = new ArrayList<AuthUserResponse>();
        ArrayList<AuthUserResponse> failAuthUserList = new ArrayList<AuthUserResponse>();
        List applicationDatas = authUserParam.getApplicationDataList();
        List tenantUsers = authUserParam.getTenantUsers();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("digi-middleware-auth-app", this.appToken);
        if (CollectionUtils.isEmpty((Collection)applicationDatas)) {
            jsonObject.put("code", (Object)-1);
            jsonObject.put("msg", (Object)"The application list is empty");
            return jsonObject;
        }
        if (CollectionUtils.isEmpty((Collection)tenantUsers)) {
            jsonObject.put("code", (Object)-1);
            jsonObject.put("msg", (Object)"Authorized tenant is empty");
            return jsonObject;
        }
        log.info("TenantServiceImpl.authUserParam:{}", (Object)authUserParam);
        for (TenantUser tenantUser : tenantUsers) {
            String tenantId = tenantUser.getTenantId();
            String curToken = this.iamService.getIntegrationToken(tenantId);
            header.put("digi-middleware-auth-user", curToken);
            Integer option = tenantUser.getOption();
            ArrayList<String> userIdList = tenantUser.getUserIdList();
            if (option == null || option == 1) {
                log.info("tenantUser.tenantId:{},curToken:{}", (Object)tenantId, (Object)curToken);
                List userJson = this.queryAllUserInTenant(tenantId, curToken);
                userIdList = this.getUserIdList(userJson);
            } else if (option == 3) {
                log.info("tenantUser.currentUserId:{}", (Object)tenantUser.getCurrentUserId());
                userIdList = new ArrayList<String>();
                userIdList.add(tenantUser.getCurrentUserId());
            }
            for (ApplicationData applicationData : applicationDatas) {
                String appId = applicationData.getAppId();
                if (StringUtils.isEmpty((CharSequence)appId)) {
                    AuthUserResponse authUserResponse = new AuthUserResponse();
                    authUserResponse.setApplicationData(applicationData);
                    authUserResponse.setTenantUser(tenantUser);
                    authUserResponse.setAuthMsg("AppId is empty");
                    failAuthUserList.add(authUserResponse);
                    continue;
                }
                String strategyCode = appId + "_daplcdp_default";
                JSONObject paramJson = new JSONObject();
                paramJson.put("tenantId", (Object)tenantId);
                paramJson.put("userIds", userIdList);
                paramJson.put("appId", (Object)appId);
                paramJson.put("strategyCode", (Object)strategyCode);
                paramJson.put("strategyDetail", (Object)this.getStrategyDetail(applicationData, strategyCode));
                log.info("authUser header is-->{}", (Object)JSONObject.toJSONString(header));
                log.info("authUser param is-->{}", (Object)JSONObject.toJSONString((Object)paramJson));
                HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)(this.iamUrl + authUserUrl)).addHeaders(header)).body(paramJson.toJSONString()).execute();
                log.info("authUser response is-->{}", (Object)response);
                AuthUserResponse authUserResponse = new AuthUserResponse();
                String message = "\u8c03IAM\u63a5\u53e3\u5f02\u5e38,\u5931\u8d25\u539f\u56e0:%s";
                String messageId = IdUtil.fastUUID().replace("-", "");
                if (response != null && 200 == response.getStatus()) {
                    authUserResponse.setApplicationData(applicationData);
                    authUserResponse.setTenantUser(tenantUser);
                    authUserResponse.setAuthMsg("Authorization succeeded");
                    successAuthUserList.add(authUserResponse);
                    LogUtils.buildAgileLog((String)appId, (String)LogUtils.MODULE_AADCS, (String)"authUser", (String)LogUtils.SUCCESS, (String)JSON.toJSONString((Object)paramJson), (String)JSON.toJSONString((Object)authUserResponse), (String)"", (String)messageId);
                    continue;
                }
                authUserResponse.setApplicationData(applicationData);
                authUserResponse.setTenantUser(tenantUser);
                assert (response != null);
                authUserResponse.setAuthMsg("Privilege grant failed" + response.body());
                failAuthUserList.add(authUserResponse);
                LogUtils.buildAgileLog((String)appId, (String)LogUtils.MODULE_AADCS, (String)"authUser", (String)LogUtils.AADCS_500_0001, (String)JSON.toJSONString((Object)paramJson), (String)String.format(message, response), (String)String.format("\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff0c\u5e76\u63d0\u4f9b\u6d88\u606f\u5e8f\u5217\u53f7\uff08%s\uff09", messageId), (String)messageId);
            }
        }
        Integer code = 0;
        if (!CollectionUtils.isEmpty(failAuthUserList)) {
            code = 1;
        }
        jsonObject.put("code", (Object)code);
        jsonObject.put("success", successAuthUserList);
        jsonObject.put("fail", failAuthUserList);
        return jsonObject;
    }

    private JSONObject getStrategyDetail(ApplicationData applicationData, String strategyCode) {
        ApplicationInfoDto applicationInfoDto = applicationData.getApplicationInfoDto();
        String applicationName = applicationInfoDto != null ? applicationInfoDto.getName() : applicationData.getAppId();
        JSONObject strategyDetail = new JSONObject();
        strategyDetail.put("code", (Object)strategyCode);
        strategyDetail.put("name", (Object)applicationName);
        strategyDetail.put("goodsCode", (Object)applicationData.getAppId());
        strategyDetail.put("tenancyPeriod", (Object)12);
        strategyDetail.put("usersNumber", (Object)9999);
        strategyDetail.put("useCount", (Object)0);
        strategyDetail.put("enabledModules", new ArrayList());
        return strategyDetail;
    }

    public JSONObject policyBatch(PolicyBatchAddParam policyBatchAddParam, String token, Boolean commonApp) {
        JSONObject jsonObject = new JSONObject();
        List applicationDatas = policyBatchAddParam.getApplicationDataList();
        List tenantUsers = policyBatchAddParam.getTenantUsers();
        List activityList = policyBatchAddParam.getActivityList();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("digi-middleware-auth-app", this.appToken);
        header.put("digi-middleware-auth-user", token);
        if (CollectionUtils.isEmpty((Collection)applicationDatas)) {
            jsonObject.put("code", (Object)-1);
            jsonObject.put("msg", (Object)"The application list is empty");
            return jsonObject;
        }
        if (CollectionUtils.isEmpty((Collection)tenantUsers)) {
            jsonObject.put("code", (Object)-1);
            jsonObject.put("msg", (Object)"Authorized tenant is empty");
            return jsonObject;
        }
        ArrayList targets = new ArrayList();
        activityList.forEach(activity -> {
            JSONObject target = new JSONObject();
            if (commonApp == null || !commonApp.booleanValue()) {
                target.put("moduleId", (Object)policyBatchAddParam.getModuleId());
            } else {
                target.put("moduleId", (Object)activity.getString("code"));
            }
            target.put("actionId", (Object)activity.getString("code"));
            targets.add(target);
        });
        for (TenantUser tenantUser : tenantUsers) {
            String tenantId = tenantUser.getTenantId();
            Integer option = tenantUser.getOption();
            List<String> userIdList = tenantUser.getUserIdList();
            if (option == 1) {
                List userJson = this.queryAllUserInTenant(tenantId, token);
                userIdList = this.getUserIdList(userJson);
            } else if (option == 3) {
                userIdList = new ArrayList();
                userIdList.add(tenantUser.getCurrentUserId());
            }
            if (CollectionUtils.isEmpty((Collection)userIdList)) continue;
            List userIdJson = this.handleUserIdList(userIdList);
            targets.forEach(target -> {
                target.put("self", (Object)true);
                target.put("tenantSid", (Object)tenantUser.getTenantSid());
            });
            for (ApplicationData applicationData : applicationDatas) {
                String appId = applicationData.getAppId();
                if (StringUtils.isEmpty((CharSequence)appId)) continue;
                JSONObject paramJson = new JSONObject();
                paramJson.put("tenantId", (Object)tenantId);
                paramJson.put("appId", (Object)appId);
                paramJson.put("users", (Object)userIdJson);
                paramJson.put("targets", targets);
                HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)(this.iamUrl + policyAddUrl)).addHeaders(header)).body(paramJson.toJSONString()).execute();
                if (response != null && 200 == response.getStatus()) {
                    jsonObject.put("code", (Object)0);
                    jsonObject.put("msg", (Object)"Enable authorization successfully");
                    log.info("\u5f00\u542f\u6388\u6743\u6210\u529f");
                    continue;
                }
                jsonObject.put("code", (Object)-1);
                jsonObject.put("msg", (Object)("Failed to open authorization" + paramJson.toJSONString()));
                log.error("\u5f00\u542f\u6388\u6743\u5931\u8d25" + paramJson.toJSONString());
            }
        }
        return jsonObject;
    }

    public JSONObject updateGmcModule(GmcUpdateParam gmcUpdateParam, String token) {
        JSONObject returnJson = new JSONObject();
        returnJson.put("code", (Object)0);
        String application = gmcUpdateParam.getApplication();
        List assignmentList = gmcUpdateParam.getAssignmentList();
        if (StringUtils.isEmpty((CharSequence)application)) {
            return returnJson;
        }
        ArrayList<JSONObject> multiLanguageResource = new ArrayList<JSONObject>();
        JSONObject modulesZHCN = new JSONObject();
        JSONObject modulesZHTW = new JSONObject();
        JSONObject modulesENUS = new JSONObject();
        try {
            JSONObject name;
            JSONObject gmc = this.gmcApiHelper.getGmcInfo(application);
            if (gmc == null) {
                return returnJson;
            }
            HashMap<String, String> appNameMultiLangMap = new HashMap<String, String>();
            String appNameZHCN = "";
            String appNameZHTW = "";
            String appNameENUS = "";
            JSONObject appJson = gmcUpdateParam.getAppJson();
            String appName = appJson.getString("name");
            JSONObject appLang = appJson.getJSONObject("lang");
            if (!(appLang == null && appLang.isEmpty() || (name = appLang.getJSONObject("name")) == null && name.isEmpty())) {
                appNameZHCN = name.getString("zh_CN");
                appNameZHTW = name.getString("zh_TW");
                appNameENUS = name.getString("en_US");
            }
            appNameZHCN = StringUtils.isEmpty((CharSequence)appNameZHCN) ? appName : appNameZHCN;
            appNameZHTW = StringUtils.isEmpty((CharSequence)appNameZHTW) ? appName : appNameZHTW;
            appNameENUS = StringUtils.isEmpty((CharSequence)appNameENUS) ? appName : appNameENUS;
            appNameMultiLangMap.put("zh-CN", appNameZHCN);
            appNameMultiLangMap.put("zh-TW", appNameZHTW);
            appNameMultiLangMap.put("en-US", appNameENUS);
            String integrationToken = this.iamService.getIntegrationToken(gmcUpdateParam.getTenantId());
            Long sid = gmc.getLong("id");
            JSONObject modules = gmc.getJSONObject("modules");
            JSONArray multiLanguageData = this.getmultiLanguageData(sid, integrationToken);
            if (multiLanguageData != null && multiLanguageData.size() > 0) {
                for (int i = 0; i < multiLanguageData.size(); ++i) {
                    JSONObject jsonObject = multiLanguageData.getJSONObject(i);
                    String language = jsonObject.getString("language");
                    if ("zh-CN".equals(language)) {
                        modulesZHCN = this.getMoudlesContent(jsonObject);
                    }
                    if ("zh-TW".equals(language)) {
                        modulesZHTW = this.getMoudlesContent(jsonObject);
                    }
                    if (!"en-US".equals(language)) continue;
                    modulesENUS = this.getMoudlesContent(jsonObject);
                }
            }
            modulesZHCN = modulesZHCN.isEmpty() ? JSONObject.parseObject((String)modules.toJSONString()) : modulesZHCN;
            modulesZHTW = modulesZHTW.isEmpty() ? JSONObject.parseObject((String)modules.toJSONString()) : modulesZHTW;
            modulesENUS = modulesENUS.isEmpty() ? JSONObject.parseObject((String)modules.toJSONString()) : modulesENUS;
            HashMap idNameMap = new HashMap();
            assignmentList.forEach(activity -> {
                JSONObject name;
                String id = activity.getString("id");
                String zhCN = "";
                String zhTW = "";
                String enUS = "";
                JSONObject lang = activity.getJSONObject("lang");
                if (lang != null && !lang.isEmpty() && (name = lang.getJSONObject("name")) != null && !name.isEmpty()) {
                    zhCN = name.getString("zh_CN");
                    zhTW = name.getString("zh_TW");
                    enUS = name.getString("en_US");
                }
                zhCN = StringUtils.isEmpty((CharSequence)zhCN) ? activity.getString("name") : zhCN;
                zhTW = StringUtils.isEmpty((CharSequence)zhTW) ? activity.getString("name") : zhTW;
                enUS = StringUtils.isEmpty((CharSequence)enUS) ? activity.getString("name") : enUS;
                HashMap<String, String> multiLangMap = new HashMap<String, String>();
                multiLangMap.put("zh-CN", zhCN);
                multiLangMap.put("zh-TW", zhTW);
                multiLangMap.put("en-US", enUS);
                idNameMap.put(id, multiLangMap);
            });
            Integer appType = appJson.getInteger("appType");
            List needDelAssigns = new ArrayList();
            if (Objects.nonNull(appType) && (appType == 6 || appType == 12) && !CollectionUtils.isEmpty((Collection)assignmentList)) {
                HashMap<String, List> moduleAssigns = new HashMap<String, List>();
                JSONObject assign = (JSONObject)assignmentList.get(0);
                moduleAssigns.put(assign.getString("moduleId"), assignmentList);
                needDelAssigns = this.getAssignsNeedDeleted(application, integrationToken, moduleAssigns);
            }
            Boolean needButtonAuth = gmcUpdateParam.getNeedButtonAuth();
            JSONObject needDelAuthKeyAssignMap = gmcUpdateParam.getNeedDelAuthKeyAssignMap();
            this.handleMultiLangModules(modules, assignmentList, null, idNameMap, appType, needDelAssigns, needButtonAuth, needDelAuthKeyAssignMap);
            this.handleMultiLangModules(modulesZHCN, assignmentList, "zh-CN", idNameMap, appType, needDelAssigns, needButtonAuth, needDelAuthKeyAssignMap);
            this.handleMultiLangModules(modulesZHTW, assignmentList, "zh-TW", idNameMap, appType, needDelAssigns, needButtonAuth, needDelAuthKeyAssignMap);
            this.handleMultiLangModules(modulesENUS, assignmentList, "en-US", idNameMap, appType, needDelAssigns, needButtonAuth, needDelAuthKeyAssignMap);
            multiLanguageResource.add(this.handleMultiLanguageResource(sid, multiLanguageData, appNameMultiLangMap, modulesZHCN, "zh-CN"));
            multiLanguageResource.add(this.handleMultiLanguageResource(sid, multiLanguageData, appNameMultiLangMap, modulesZHTW, "zh-TW"));
            multiLanguageResource.add(this.handleMultiLanguageResource(sid, multiLanguageData, appNameMultiLangMap, modulesENUS, "en-US"));
            this.updateGmcModule(modules, application, integrationToken, multiLanguageResource);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0gmc\u5546\u54c1\u6a21\u7ec4\u4fe1\u606f\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            returnJson.put("code", (Object)-1);
            returnJson.put("msg", (Object)e.getMessage());
            return returnJson;
        }
        return returnJson;
    }

    public JSONObject gmcModuleSupplement(GmcUpdateParam gmcUpdateParam) {
        JSONObject returnJson = new JSONObject();
        returnJson.put("code", (Object)0);
        String application = gmcUpdateParam.getApplication();
        List assignmentList = gmcUpdateParam.getAssignmentList();
        if (StringUtils.isEmpty((CharSequence)application)) {
            return returnJson;
        }
        ArrayList<JSONObject> multiLanguageResource = new ArrayList<JSONObject>();
        JSONObject modulesZHCN = new JSONObject();
        JSONObject modulesZHTW = new JSONObject();
        JSONObject modulesENUS = new JSONObject();
        try {
            JSONObject name;
            JSONObject gmc = this.gmcApiHelper.getGmcInfo(application);
            if (gmc == null) {
                return returnJson;
            }
            HashMap<String, String> appNameMultiLangMap = new HashMap<String, String>();
            String appNameZHCN = "";
            String appNameZHTW = "";
            String appNameENUS = "";
            JSONObject appJson = gmcUpdateParam.getAppJson();
            String appName = appJson.getString("name");
            JSONObject appLang = appJson.getJSONObject("lang");
            if (!(appLang == null && appLang.isEmpty() || (name = appLang.getJSONObject("name")) == null && name.isEmpty())) {
                appNameZHCN = name.getString("zh_CN");
                appNameZHTW = name.getString("zh_TW");
                appNameENUS = name.getString("en_US");
            }
            appNameZHCN = StringUtils.isEmpty((CharSequence)appNameZHCN) ? appName : appNameZHCN;
            appNameZHTW = StringUtils.isEmpty((CharSequence)appNameZHTW) ? appName : appNameZHTW;
            appNameENUS = StringUtils.isEmpty((CharSequence)appNameENUS) ? appName : appNameENUS;
            appNameMultiLangMap.put("zh-CN", appNameZHCN);
            appNameMultiLangMap.put("zh-TW", appNameZHTW);
            appNameMultiLangMap.put("en-US", appNameENUS);
            String integrationToken = this.iamService.getIntegrationToken(gmcUpdateParam.getTenantId());
            Long sid = gmc.getLong("id");
            JSONObject modules = gmc.getJSONObject("modules");
            JSONArray multiLanguageData = this.getmultiLanguageData(sid, integrationToken);
            if (multiLanguageData != null && multiLanguageData.size() > 0) {
                for (int i = 0; i < multiLanguageData.size(); ++i) {
                    JSONObject jsonObject = multiLanguageData.getJSONObject(i);
                    String language = jsonObject.getString("language");
                    if ("zh-CN".equals(language)) {
                        modulesZHCN = this.getMoudlesContent(jsonObject);
                    }
                    if ("zh-TW".equals(language)) {
                        modulesZHTW = this.getMoudlesContent(jsonObject);
                    }
                    if (!"en-US".equals(language)) continue;
                    modulesENUS = this.getMoudlesContent(jsonObject);
                }
            }
            modulesZHCN = modulesZHCN.isEmpty() ? JSONObject.parseObject((String)modules.toJSONString()) : modulesZHCN;
            modulesZHTW = modulesZHTW.isEmpty() ? JSONObject.parseObject((String)modules.toJSONString()) : modulesZHTW;
            modulesENUS = modulesENUS.isEmpty() ? JSONObject.parseObject((String)modules.toJSONString()) : modulesENUS;
            HashMap idNameMap = new HashMap();
            assignmentList.forEach(module -> {
                String id = module.getString("id");
                String zhCN = module.getString("nameCN");
                String zhTW = module.getString("nameTW");
                String enUS = module.getString("nameUS");
                HashMap<String, String> multiLangMap = new HashMap<String, String>();
                multiLangMap.put("zh-CN", zhCN);
                multiLangMap.put("zh-TW", zhTW);
                multiLangMap.put("en-US", enUS);
                idNameMap.put(id, multiLangMap);
            });
            Integer appType = appJson.getInteger("appType");
            this.handleMultiLangModulesForAddModule(modules, assignmentList, null, idNameMap, appType);
            this.handleMultiLangModulesForAddModule(modulesZHCN, assignmentList, "zh-CN", idNameMap, appType);
            this.handleMultiLangModulesForAddModule(modulesZHTW, assignmentList, "zh-TW", idNameMap, appType);
            this.handleMultiLangModulesForAddModule(modulesENUS, assignmentList, "en-US", idNameMap, appType);
            multiLanguageResource.add(this.handleMultiLanguageResource(sid, multiLanguageData, appNameMultiLangMap, modulesZHCN, "zh-CN"));
            multiLanguageResource.add(this.handleMultiLanguageResource(sid, multiLanguageData, appNameMultiLangMap, modulesZHTW, "zh-TW"));
            multiLanguageResource.add(this.handleMultiLanguageResource(sid, multiLanguageData, appNameMultiLangMap, modulesENUS, "en-US"));
            this.updateGmcModule(modules, application, integrationToken, multiLanguageResource);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0gmc\u5546\u54c1\u6a21\u7ec4\u4fe1\u606f\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            returnJson.put("code", (Object)-1);
            returnJson.put("msg", (Object)e.getMessage());
            return returnJson;
        }
        return returnJson;
    }

    private List<String> getAssignsNeedDeleted(String application, String integrationToken, Map<String, List<JSONObject>> moduleAssigns) {
        JSONArray iamPublicAssignments = this.iamService.getIamPublicAssignments(application, integrationToken);
        if (CollectionUtils.isEmpty((Collection)iamPublicAssignments)) {
            return new ArrayList<String>();
        }
        ArrayList<String> needDel = new ArrayList<String>();
        for (Map.Entry<String, List<JSONObject>> entry : moduleAssigns.entrySet()) {
            JSONObject module;
            JSONArray actions;
            String moduleId = entry.getKey();
            List<JSONObject> valueList = entry.getValue();
            List publicList = iamPublicAssignments.toJavaList(JSONObject.class);
            List modules = publicList.stream().filter(jsonObject -> StringUtils.equals((CharSequence)jsonObject.getString("id"), (CharSequence)moduleId)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(modules) || CollectionUtils.isEmpty((Collection)(actions = (module = (JSONObject)modules.get(0)).getJSONArray("actions")))) continue;
            List pubList = actions.toJavaList(JSONObject.class);
            ArrayList iamPubAssigns = new ArrayList();
            pubList.forEach(e -> iamPubAssigns.add(e.getString("id")));
            log.info("iam\u73b0\u6709\u516c\u6709\u4f5c\u4e1a:{},\u6a21\u7ec4:{}", iamPubAssigns, (Object)moduleId);
            ArrayList currAssigns = new ArrayList();
            valueList.forEach(e -> currAssigns.add(e.getString("id")));
            log.info("\u5f53\u524d\u5e94\u7528\u5207\u7248\u7684\u4f5c\u4e1a:{}", currAssigns);
            if (!CollectionUtils.isEmpty(currAssigns) && ((String)currAssigns.get(0)).equals("needDelId")) {
                iamPubAssigns.addAll(currAssigns);
            } else {
                iamPubAssigns.removeAll(currAssigns);
            }
            needDel.addAll(iamPubAssigns);
        }
        return needDel;
    }

    public JSONObject updateCommonGmcModule(GmcUpdateParam gmcUpdateParam) {
        String version = gmcUpdateParam.getVersion();
        JSONObject returnJson = new JSONObject();
        returnJson.put("code", (Object)0);
        String application = gmcUpdateParam.getApplication();
        List assignmentList = gmcUpdateParam.getAssignmentList();
        if (StringUtils.isEmpty((CharSequence)application)) {
            return returnJson;
        }
        ArrayList<JSONObject> multiLanguageResource = new ArrayList<JSONObject>();
        JSONObject modulesZHCN = new JSONObject();
        JSONObject modulesZHTW = new JSONObject();
        JSONObject modulesENUS = new JSONObject();
        try {
            JSONObject name;
            JSONObject gmc = this.gmcApiHelper.getGmcInfo(application);
            if (gmc == null) {
                return returnJson;
            }
            HashMap<String, String> appNameMultiLangMap = new HashMap<String, String>();
            String appNameZHCN = "";
            String appNameZHTW = "";
            String appNameENUS = "";
            JSONObject appJson = gmcUpdateParam.getAppJson();
            String appName = appJson.getString("name");
            JSONObject appLang = appJson.getJSONObject("lang");
            if (!(appLang == null && appLang.isEmpty() || (name = appLang.getJSONObject("name")) == null && name.isEmpty())) {
                appNameZHCN = name.getString("zh_CN");
                appNameZHTW = name.getString("zh_TW");
                appNameENUS = name.getString("en_US");
            }
            appNameZHCN = StringUtils.isEmpty((CharSequence)appNameZHCN) ? appName : appNameZHCN;
            appNameZHTW = StringUtils.isEmpty((CharSequence)appNameZHTW) ? appName : appNameZHTW;
            appNameENUS = StringUtils.isEmpty((CharSequence)appNameENUS) ? appName : appNameENUS;
            appNameMultiLangMap.put("zh-CN", appNameZHCN);
            appNameMultiLangMap.put("zh-TW", appNameZHTW);
            appNameMultiLangMap.put("en-US", appNameENUS);
            String integrationToken = this.iamService.getIntegrationToken(gmcUpdateParam.getTenantId());
            Long sid = gmc.getLong("id");
            JSONObject modules = gmc.getJSONObject("modules");
            JSONArray multiLanguageData = this.getmultiLanguageData(sid, integrationToken);
            if (multiLanguageData != null && multiLanguageData.size() > 0) {
                for (int i = 0; i < multiLanguageData.size(); ++i) {
                    JSONObject jsonObject = multiLanguageData.getJSONObject(i);
                    String language = jsonObject.getString("language");
                    if ("zh-CN".equals(language)) {
                        modulesZHCN = this.getMoudlesContent(jsonObject);
                    }
                    if ("zh-TW".equals(language)) {
                        modulesZHTW = this.getMoudlesContent(jsonObject);
                    }
                    if (!"en-US".equals(language)) continue;
                    modulesENUS = this.getMoudlesContent(jsonObject);
                }
            }
            assert (modulesZHCN != null);
            JSONObject jSONObject = modulesZHCN = modulesZHCN.isEmpty() ? JSONObject.parseObject((String)modules.toJSONString()) : modulesZHCN;
            assert (modulesZHTW != null);
            JSONObject jSONObject2 = modulesZHTW = modulesZHTW.isEmpty() ? JSONObject.parseObject((String)modules.toJSONString()) : modulesZHTW;
            assert (modulesENUS != null);
            modulesENUS = modulesENUS.isEmpty() ? JSONObject.parseObject((String)modules.toJSONString()) : modulesENUS;
            HashMap idNameMap = new HashMap();
            assignmentList.forEach(activity -> {
                JSONObject name;
                String id = activity.getString("code");
                if (StrUtil.isEmpty((CharSequence)id)) {
                    id = activity.getString("id");
                }
                String zhCN = "";
                String zhTW = "";
                String enUS = "";
                JSONObject lang = activity.getJSONObject("lang");
                if (lang != null && !lang.isEmpty() && (name = lang.getJSONObject("name")) != null && !name.isEmpty()) {
                    zhCN = name.getString("zh_CN");
                    zhTW = name.getString("zh_TW");
                    enUS = name.getString("en_US");
                }
                zhCN = StringUtils.isEmpty((CharSequence)zhCN) ? activity.getString("name") : zhCN;
                zhTW = StringUtils.isEmpty((CharSequence)zhTW) ? activity.getString("name") : zhTW;
                enUS = StringUtils.isEmpty((CharSequence)enUS) ? activity.getString("name") : enUS;
                HashMap<String, String> multiLangMap = new HashMap<String, String>();
                multiLangMap.put("zh-CN", zhCN);
                multiLangMap.put("zh-TW", zhTW);
                multiLangMap.put("en-US", enUS);
                idNameMap.put(id, multiLangMap);
            });
            Boolean needButtonAuth = gmcUpdateParam.getNeedButtonAuth();
            JSONObject needDelAuthKeyAssignMap = gmcUpdateParam.getNeedDelAuthKeyAssignMap();
            this.handleCommonMultiLangModules(modules, assignmentList, null, idNameMap, version, needButtonAuth, needDelAuthKeyAssignMap);
            this.handleCommonMultiLangModules(modulesZHCN, assignmentList, "zh-CN", idNameMap, version, needButtonAuth, needDelAuthKeyAssignMap);
            this.handleCommonMultiLangModules(modulesZHTW, assignmentList, "zh-TW", idNameMap, version, needButtonAuth, needDelAuthKeyAssignMap);
            this.handleCommonMultiLangModules(modulesENUS, assignmentList, "en-US", idNameMap, version, needButtonAuth, needDelAuthKeyAssignMap);
            multiLanguageResource.add(this.handleMultiLanguageResource(sid, multiLanguageData, appNameMultiLangMap, modulesZHCN, "zh-CN"));
            multiLanguageResource.add(this.handleMultiLanguageResource(sid, multiLanguageData, appNameMultiLangMap, modulesZHTW, "zh-TW"));
            multiLanguageResource.add(this.handleMultiLanguageResource(sid, multiLanguageData, appNameMultiLangMap, modulesENUS, "en-US"));
            this.updateGmcModule(modules, application, integrationToken, multiLanguageResource);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0commonGmc\u5546\u54c1\u6a21\u7ec4\u4fe1\u606f\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            returnJson.put("code", (Object)-1);
            returnJson.put("msg", (Object)e.getMessage());
            return returnJson;
        }
        return returnJson;
    }

    private void handleMultiLangModules(JSONObject modules, List<JSONObject> assignmentList, String locale, Map<String, Map<String, String>> idNameMap, Integer appType, List<String> needDelAssigns, Boolean needButtonAuth, JSONObject needDelAuthKeyAssignMap) {
        JSONArray existModules = modules.getJSONArray("modules");
        ArrayList<String> moduleIds = new ArrayList<String>();
        for (int i = 0; i < existModules.size(); ++i) {
            JSONObject module = existModules.getJSONObject(i);
            String id = module.getString("id");
            moduleIds.add(id);
        }
        if (Objects.nonNull(appType) && appType == 6) {
            this.checkModule(existModules, moduleIds, "bigScreen", GmcModuleConstant.getBIG_SCREEN_NAME(), locale);
            this.checkModule(existModules, moduleIds, "scene", GmcModuleConstant.getSCENE_NAME(), locale);
            this.checkModule(existModules, moduleIds, "appData", GmcModuleConstant.getAPP_DATA_NAME(), locale);
            this.checkModule(existModules, moduleIds, "metric", GmcModuleConstant.getMETRIC_NAME(), locale);
            this.checkModule(existModules, moduleIds, "board", GmcModuleConstant.getBOARD_NAME(), locale);
            this.checkModule(existModules, moduleIds, "classification", GmcModuleConstant.getCLASSIFICATION_NAME(), locale);
            this.checkModule(existModules, moduleIds, "dataset", GmcModuleConstant.getDATASET_NAME(), locale);
        } else if (Objects.nonNull(appType) && appType == 12) {
            this.checkModule(existModules, moduleIds, "dataset", GmcModuleConstant.getDATASET_NAME(), locale);
        } else {
            this.checkModule(existModules, moduleIds, "basicDataEntry", GmcModuleConstant.getBASIC_DATA_ENTRY_NAME(), locale);
            this.checkModule(existModules, moduleIds, "report", GmcModuleConstant.getREPORT_NAME(), locale);
            this.checkModule(existModules, moduleIds, "datasource", GmcModuleConstant.getDATA_SOURCE_NAME(), locale);
            this.checkModule(existModules, moduleIds, "startProject", GmcModuleConstant.getSTART_PROJECT_NAME(), locale);
        }
        modules.put("modules", (Object)existModules);
        JSONArray actions = modules.getJSONArray("actions");
        ArrayList<String> existActionId = new ArrayList<String>();
        for (int i = 0; i < actions.size(); ++i) {
            JSONObject action2 = actions.getJSONObject(i);
            String actionId = action2.getString("id");
            existActionId.add(actionId);
        }
        assignmentList.forEach(activity -> {
            String id = activity.getString("id");
            if (StringUtils.equals((CharSequence)id, (CharSequence)"needDelId")) {
                return;
            }
            String name = StringUtils.isEmpty((CharSequence)locale) ? activity.getString("name") : (String)((Map)idNameMap.get(id)).get(locale);
            String parentId = activity.getString("parentId");
            if (!existActionId.contains(id)) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)id);
                jsonObject.put("name", (Object)name);
                jsonObject.put("moduleId", (Object)activity.getString("moduleId"));
                jsonObject.put("regardlessAuth", (Object)activity.getBoolean("regardlessAuth"));
                if (StringUtils.isNotBlank((CharSequence)parentId)) {
                    jsonObject.put("parentId", (Object)parentId);
                }
                if (needButtonAuth.booleanValue() && Objects.nonNull(activity.get((Object)"iamCondition"))) {
                    jsonObject.put("condition", activity.get((Object)"iamCondition"));
                }
                actions.add((Object)jsonObject);
            } else {
                for (int i = 0; i < actions.size(); ++i) {
                    JSONObject action = actions.getJSONObject(i);
                    String actionId = action.getString("id");
                    if (!actionId.equals(id)) continue;
                    action.put("regardlessAuth", (Object)activity.getBoolean("regardlessAuth"));
                    action.put("name", (Object)name);
                    if (StringUtils.isNotBlank((CharSequence)parentId)) {
                        action.put("parentId", (Object)parentId);
                    }
                    if (!needButtonAuth.booleanValue() || !Objects.nonNull(activity.get((Object)"iamCondition"))) break;
                    JSONArray iamCondition = activity.getJSONArray("iamCondition");
                    JSONArray existCondition = Objects.isNull(action.getJSONArray("condition")) ? new JSONArray() : action.getJSONArray("condition");
                    JSONArray array = new JSONArray();
                    if (CollectionUtil.isNotEmpty((Map)needDelAuthKeyAssignMap) && Objects.nonNull(needDelAuthKeyAssignMap.getJSONArray(actionId)) && !needDelAuthKeyAssignMap.getJSONArray(actionId).isEmpty()) {
                        array = needDelAuthKeyAssignMap.getJSONArray(actionId);
                    }
                    List needDelAuthKeys = !array.isEmpty() ? array.toJavaList(String.class) : new ArrayList();
                    JSONArray condition = this.handleAssignmentAuthCondition(iamCondition, existCondition, needDelAuthKeys);
                    action.put("condition", (Object)condition);
                    break;
                }
            }
        });
        if (!(appType != 6 && appType != 12 || CollectionUtils.isEmpty(needDelAssigns))) {
            log.info("\u589e\u91cf\u65b0\u589e\u540e\u7684actions:{}", (Object)actions);
            log.info("\u9700\u8981\u5220\u9664\u7684\u516c\u6709\u4f5c\u4e1a\u5217\u8868:{}", needDelAssigns);
            actions.removeIf(action -> needDelAssigns.contains(JSON.parseObject((String)JSON.toJSONString((Object)action)).getString("id")));
        }
        modules.put("actions", (Object)actions);
    }

    private JSONArray handleAssignmentAuthCondition(JSONArray iamCondition, JSONArray existCondition, List<String> needDelAuthKeys) {
        String key;
        JSONObject existObj;
        int i;
        Iterator iterator = existCondition.iterator();
        while (iterator.hasNext()) {
            JSONObject existObj2 = (JSONObject)iterator.next();
            String key2 = existObj2.getString("key");
            if (!needDelAuthKeys.contains(key2)) continue;
            iterator.remove();
        }
        HashMap<String, JSONObject> existMap = new HashMap<String, JSONObject>();
        for (i = 0; i < existCondition.size(); ++i) {
            existObj = existCondition.getJSONObject(i);
            key = existObj.getString("key");
            existMap.put(key, existObj);
        }
        for (i = 0; i < iamCondition.size(); ++i) {
            JSONObject iamObj = iamCondition.getJSONObject(i);
            String iamKey = iamObj.getString("key");
            if (!existMap.containsKey(iamKey)) {
                existCondition.add((Object)iamObj);
                continue;
            }
            existMap.put(iamKey, iamObj);
        }
        for (i = 0; i < existCondition.size(); ++i) {
            existObj = existCondition.getJSONObject(i);
            key = existObj.getString("key");
            if (!existMap.containsKey(key)) continue;
            existCondition.set(i, existMap.get(key));
        }
        return existCondition;
    }

    private void handleMultiLangModulesForAddModule(JSONObject modules, List<JSONObject> assignmentList, String locale, Map<String, Map<String, String>> idNameMap, Integer appType) {
        JSONArray existModules = modules.getJSONArray("modules");
        ArrayList moduleIds = new ArrayList();
        existModules.forEach(module -> {
            String id = ((JSONObject)module).getString("id");
            moduleIds.add(id);
        });
        for (Map.Entry<String, Map<String, String>> entry : idNameMap.entrySet()) {
            this.checkModule(existModules, moduleIds, entry.getKey(), entry.getValue(), locale);
        }
        modules.put("modules", (Object)existModules);
    }

    private void handleCommonMultiLangModules(JSONObject modules, List<JSONObject> assignmentList, String locale, Map<String, Map<String, String>> idNameMap, String version, Boolean needButtonAuth, JSONObject needDelAuthKeyAssignMap) {
        JSONArray existModules = modules.getJSONArray("modules");
        ArrayList<String> moduleIds = new ArrayList<String>();
        for (int i = 0; i < existModules.size(); ++i) {
            JSONObject module = existModules.getJSONObject(i);
            String id = module.getString("id");
            moduleIds.add(id);
        }
        JSONArray actions = modules.getJSONArray("actions");
        ArrayList<String> existActionId = new ArrayList<String>();
        for (int i = 0; i < actions.size(); ++i) {
            JSONObject action = actions.getJSONObject(i);
            String actionId = action.getString("id");
            existActionId.add(actionId);
        }
        assignmentList.forEach(activity -> {
            String id = activity.getString("code");
            if (StrUtil.isEmpty((CharSequence)id)) {
                id = activity.getString("id");
            }
            String name = StringUtils.isEmpty((CharSequence)locale) ? activity.getString("name") : (String)((Map)idNameMap.get(id)).get(locale);
            if (!existActionId.contains(id)) {
                if ("2.0".equals(version)) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("id", (Object)id);
                    jsonObject.put("name", (Object)name);
                    jsonObject.put("moduleId", (Object)id);
                    jsonObject.put("regardlessAuth", (Object)activity.getBoolean("regardlessAuth"));
                    if (needButtonAuth.booleanValue() && Objects.nonNull(activity.get((Object)"iamCondition"))) {
                        jsonObject.put("condition", activity.get((Object)"iamCondition"));
                    }
                    actions.add((Object)jsonObject);
                }
                if (!moduleIds.contains(id)) {
                    JSONObject module = new JSONObject();
                    module.put("id", (Object)id);
                    module.put("name", (Object)name);
                    existModules.add((Object)module);
                }
            } else {
                int i;
                if ("2.0".equals(version)) {
                    for (i = 0; i < actions.size(); ++i) {
                        JSONObject action = actions.getJSONObject(i);
                        String actionId = action.getString("id");
                        if (!actionId.equals(id)) continue;
                        action.put("name", (Object)name);
                        action.put("regardlessAuth", (Object)activity.getBoolean("regardlessAuth"));
                        if (!needButtonAuth.booleanValue() || !Objects.nonNull(activity.get((Object)"iamCondition"))) break;
                        JSONArray iamCondition = activity.getJSONArray("iamCondition");
                        JSONArray existCondition = Objects.isNull(action.getJSONArray("condition")) ? new JSONArray() : action.getJSONArray("condition");
                        JSONArray array = new JSONArray();
                        if (CollectionUtil.isNotEmpty((Map)needDelAuthKeyAssignMap) && Objects.nonNull(needDelAuthKeyAssignMap.getJSONArray(actionId)) && !needDelAuthKeyAssignMap.getJSONArray(actionId).isEmpty()) {
                            array = needDelAuthKeyAssignMap.getJSONArray(actionId);
                        }
                        List needDelAuthKeys = !array.isEmpty() ? array.toJavaList(String.class) : new ArrayList();
                        JSONArray condition = this.handleAssignmentAuthCondition(iamCondition, existCondition, needDelAuthKeys);
                        action.put("condition", (Object)condition);
                        break;
                    }
                }
                for (i = 0; i < existModules.size(); ++i) {
                    JSONObject module = existModules.getJSONObject(i);
                    String moduleId = module.getString("id");
                    if (!moduleId.equals(id)) continue;
                    module.put("name", (Object)name);
                }
            }
        });
        modules.put("actions", (Object)actions);
        modules.put("modules", (Object)existModules);
    }

    private void checkModule(JSONArray modules, List<String> ids, String id, Map<String, String> map, String locale) {
        String string = locale = StringUtils.isEmpty((CharSequence)locale) ? "zh-CN" : locale;
        if (!ids.contains(id)) {
            JSONObject module = new JSONObject();
            module.put("id", (Object)id);
            module.put("name", (Object)map.get(locale));
            modules.add((Object)module);
        } else {
            for (int i = 0; i < modules.size(); ++i) {
                JSONObject jsonObject = modules.getJSONObject(i);
                String id1 = jsonObject.getString("id");
                if (!id.equals(id1)) continue;
                jsonObject.put("name", (Object)map.get(locale));
            }
        }
    }

    private JSONArray getmultiLanguageData(Long sid, String token) {
        String url = this.gmcUrl + StrUtil.format((CharSequence)GMC_MULTI_LANGUAGE_SEARCH, (Object[])new Object[]{sid});
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("digi-middleware-auth-app", this.appToken);
        header.put("digi-middleware-auth-user", token);
        HttpResponse response = ((HttpRequest)HttpUtil.createGet((String)url).addHeaders(header)).execute();
        if (response != null && 200 == response.getStatus()) {
            String responseStr = response.body();
            JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
            JSONObject data = jsonObject.getJSONObject("data");
            if (data == null) {
                return null;
            }
            return data.getJSONArray("multiLanguageDataVOS");
        }
        return null;
    }

    private JSONObject getMoudlesContent(JSONObject jsonObject) {
        JSONArray dataVOS = jsonObject.getJSONArray("dataVOS");
        if (dataVOS == null) {
            return null;
        }
        for (int i = 0; i < dataVOS.size(); ++i) {
            JSONObject jsonObject1 = dataVOS.getJSONObject(i);
            String fieldName = jsonObject1.getString("fieldName");
            if (!"modules".equals(fieldName)) continue;
            String content = jsonObject1.getString("content");
            return JSONObject.parseObject((String)content);
        }
        return null;
    }

    private JSONObject handleMultiLanguageResource(Long sid, JSONArray multiLanguageData, Map<String, String> appNameMultiLang, JSONObject modules, String locale) {
        JSONObject multiLanguageResource = new JSONObject();
        multiLanguageResource.put("dataSid", (Object)sid);
        multiLanguageResource.put("language", (Object)locale);
        JSONArray dataResource = new JSONArray();
        if (multiLanguageData == null || multiLanguageData.size() == 0) {
            dataResource = this.handleDefaultData(appNameMultiLang, modules, locale);
            multiLanguageResource.put("data", (Object)dataResource);
            return multiLanguageResource;
        }
        for (int i = 0; i < multiLanguageData.size(); ++i) {
            JSONArray data;
            JSONObject languageData = multiLanguageData.getJSONObject(i);
            String language = languageData.getString("language");
            if (!locale.equals(language) || (data = languageData.getJSONArray("dataVOS")) == null || data.size() == 0) continue;
            for (int j = 0; j < data.size(); ++j) {
                JSONObject jsonObject = data.getJSONObject(j);
                String fieldName = jsonObject.getString("fieldName");
                if ("goodsName".equals(fieldName)) {
                    jsonObject.put("content", (Object)appNameMultiLang.get(locale));
                }
                if ("modules".equals(fieldName)) {
                    jsonObject.put("content", (Object)modules.toJSONString());
                }
                dataResource.add((Object)jsonObject);
            }
        }
        if (dataResource.size() == 0) {
            dataResource = this.handleDefaultData(appNameMultiLang, modules, locale);
        }
        multiLanguageResource.put("data", (Object)dataResource);
        return multiLanguageResource;
    }

    private JSONArray handleDefaultData(Map<String, String> appNameMultiLang, JSONObject modules, String locale) {
        JSONArray dataResource = new JSONArray();
        JSONObject initGoodsName = new JSONObject();
        JSONObject initModules = new JSONObject();
        initGoodsName.put("fieldName", (Object)"goodsName");
        initGoodsName.put("content", (Object)appNameMultiLang.get(locale));
        initModules.put("fieldName", (Object)"modules");
        initModules.put("content", (Object)modules.toJSONString());
        dataResource.add((Object)initGoodsName);
        dataResource.add((Object)initModules);
        return dataResource;
    }

    private void updateGmcModule(JSONObject modules, String gmcCode, String token, List<JSONObject> multiLanguageResource) {
        String url = this.gmcUrl + GMC_MODULE_UPDATE;
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("digi-middleware-auth-app", this.appToken);
        header.put("digi-middleware-auth-user", token);
        JSONObject param = new JSONObject();
        param.put("code", (Object)gmcCode);
        param.put("multiLanguageResource", multiLanguageResource);
        param.put("modules", (Object)modules);
        log.info("\u66f4\u65b0\u5546\u54c1\u6a21\u7ec4url:" + url);
        log.info("\u66f4\u65b0\u5546\u54c1\u6a21\u7ec4header:" + String.valueOf(header));
        log.info("\u66f4\u65b0\u5546\u54c1\u6a21\u7ec4\u5165\u53c2param:" + String.valueOf(param));
        HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)url).addHeaders(header)).body(param.toJSONString()).execute();
        log.info("\u66f4\u65b0\u5546\u54c1\u6a21\u7ec4response:" + String.valueOf(response));
        String message = "\u8c03GMC\u63a5\u53e3\u5f02\u5e38,\u5931\u8d25\u539f\u56e0:%s";
        String messageId = IdUtil.fastUUID().replace("-", "");
        if (response == null || 200 != response.getStatus()) {
            LogUtils.buildAgileLog((String)gmcCode, (String)LogUtils.MODULE_AADCS, (String)"updateGmcModule", (String)LogUtils.AADCS_500_0003, (String)JSON.toJSONString((Object)param), (String)String.format(message, response), (String)String.format("\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff0c\u5e76\u63d0\u4f9b\u6d88\u606f\u5e8f\u5217\u53f7\uff08%s\uff09", messageId), (String)messageId);
            assert (response != null);
            log.error("\u66f4\u65b0\u5546\u54c1\u6a21\u7ec4\u5931\u8d25:" + response.body());
            throw new BusinessException("\u66f4\u65b0\u5546\u54c1\u6a21\u7ec4\u5931\u8d25:" + response.body());
        }
        LogUtils.buildAgileLog((String)gmcCode, (String)LogUtils.MODULE_AADCS, (String)"updateGmcModule", (String)LogUtils.SUCCESS, (String)JSON.toJSONString((Object)param), (String)JSON.toJSONString((Object)response), (String)"", (String)messageId);
        log.info("\u66f4\u65b0\u5546\u54c1\u6a21\u7ec4\u6210\u529f!");
    }

    private List<String> getUserIdList(List<JSONObject> userJson) {
        ArrayList<String> userIdList = new ArrayList<String>();
        userJson.forEach(user -> userIdList.add(user.getString("id")));
        return userIdList;
    }

    private List<JSONObject> handleUserIdList(List<String> userIds) {
        ArrayList<JSONObject> userIdJson = new ArrayList<JSONObject>();
        userIds.forEach(userId -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", userId);
            userIdJson.add(jsonObject);
        });
        return userIdJson;
    }

    public boolean currentUserExistInTenant(String userId, String tenantId, String token) {
        ArrayList allUsers = new ArrayList();
        Integer pageSize = 100;
        Integer pageNum = 1;
        String param = String.format("?pageSize=%d&pageNum=%d", pageSize, pageNum);
        String queryUserInTenantsUrl = queryAllTenantUser + param;
        JSONObject paramJson = new JSONObject();
        paramJson.put("tenantId", (Object)tenantId);
        paramJson.put("userContent", (Object)userId);
        String iamToken = this.iamService.getIntegrationToken(tenantId);
        log.info("paramJson-----" + paramJson.toJSONString());
        log.info("queryUserInTenantsUrl-----" + this.iamUrl + queryUserInTenantsUrl);
        log.info("token-----" + iamToken);
        log.info("appToken-----" + this.appToken);
        String response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)(this.iamUrl + queryUserInTenantsUrl)).header("digi-middleware-auth-app", this.appToken)).header("digi-middleware-auth-user", iamToken)).body(paramJson.toJSONString()).execute().body();
        log.info("response---" + response);
        try {
            JSONObject responseJson = JSON.parseObject((String)response);
            List users = responseJson.getJSONArray("list").toJavaList(JSONObject.class);
            allUsers.addAll(users);
            Integer total = responseJson.getInteger("total");
            if (total > pageSize) {
                Integer size = total / pageSize;
                for (int i = 0; i < size; ++i) {
                    Integer n = pageNum;
                    pageNum = pageNum + 1;
                    TenantUserResult tenantUserResult = this.queryUserInTenant(tenantId, iamToken, pageSize, pageNum);
                    List userJson = tenantUserResult.getUserList();
                    allUsers.addAll(userJson);
                }
            }
            if (CollectionUtils.isEmpty(allUsers)) {
                return false;
            }
            List userIds = this.getUserIdList(allUsers);
            return userIds.contains(userId);
        }
        catch (Exception e) {
            JSONObject responseObj = JSON.parseObject((String)response);
            log.error("\u67e5\u8be2\u7528\u6237\u5931\u8d25:{}", (Object)response);
            throw new BusinessException(responseObj.getString("errorMessage"));
        }
    }

    public void createTenants(List<String> tenantIds, String version) {
        for (String tenantId : tenantIds) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("tenantId", tenantId);
            param.put("version", version);
            String findCql = "MATCH (n:TenantEntity) where n.tenantId = $tenantId RETURN properties(n) as tenant";
            List tenants = new Neo4jManager(this.driver1).ExecuteQuery(findCql, param);
            if (!CollUtil.isEmpty((Collection)tenants)) continue;
            String cql = "create (n:TenantEntity{tenantId:$tenantId,tenantName:$tenantId,version:$version})";
            Neo4jMultipleUtil.executeCql((String)cql, param, (Driver[])new Driver[]{this.driver1, this.driver2});
        }
    }

    public void createOrUpdateTenants(List<String> tenantIds, String version) {
        for (String tenantId : tenantIds) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("tenantId", tenantId);
            param.put("version", version);
            String findCql = "MATCH (n:TenantEntity) where n.tenantId = $tenantId RETURN properties(n) as tenant";
            List tenants = new Neo4jManager(this.driver1).ExecuteQuery(findCql, param);
            String cql = "";
            cql = CollUtil.isEmpty((Collection)tenants) ? "create (n:TenantEntity{tenantId:$tenantId,tenantName:$tenantId,version:$version})" : "MATCH (n:TenantEntity) where n.tenantId = $tenantId set n.version = $version";
            Neo4jMultipleUtil.executeCql((String)cql, param, (Driver[])new Driver[]{this.driver1, this.driver2});
        }
    }

    public void createTenantAndApplicationRelation(String application, String tenantVersion, String appVersion, List<String> tenantIds) {
        List authAppTenantIdList = this.getAuthAppTenantIdList(application, tenantVersion, tenantIds);
        this.mergeRelation(application, tenantVersion, appVersion, authAppTenantIdList);
    }

    public void createAllAuthTenantAndApplicationRelation(String application, String tenantVersion, String appVersion) {
        List authAppTenantIdList = this.getAllAuthAppTenantIdList(application, tenantVersion);
        this.mergeRelation(application, tenantVersion, appVersion, authAppTenantIdList);
    }

    public void createRelation(String application, String tenantVersion, String appVersion, List<String> tenantIds) {
        this.mergeRelation(application, tenantVersion, appVersion, tenantIds);
    }

    private void mergeRelation(String application, String tenantVersion, String appVersion, List<String> authAppTenantIdList) {
        List executeCqlList = this.getMergeTenantAndAppDataRelationCql(application, tenantVersion, appVersion, authAppTenantIdList);
        Neo4jMultipleUtil.executeCqlTrans((List)executeCqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    public List<Cql> getMergeTenantAndAppDataRelationCql(String application, String tenantVersion, String appVersion, List<String> authAppTenantIdList) {
        ArrayList<Cql> executeCqlList = new ArrayList<Cql>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("nameSpace", application);
        param.put("tenantVersion", tenantVersion);
        param.put("appVersion", appVersion);
        param.put("tenantIdList", authAppTenantIdList);
        String cql2 = "match(n:TenantEntity{version:$tenantVersion}) where n.tenantId in $tenantIdList match(m:Activity{version:$appVersion}) where (m.nameSpace = $nameSpace or m.athena_namespace = $nameSpace) and ((m.inclusionTenant is null and m.notInclusionTenant is null) or (m.inclusionTenant is not null and n.tenantId in m.inclusionTenant) or (m.notInclusionTenant is not null and not n.tenantId in m.notInclusionTenant)) merge (n)-[:ACTIVITY]->(m)";
        executeCqlList.add(new Cql().setCql(cql2).setParams(param));
        String cql3 = "match(n:TenantEntity{version:$tenantVersion}) where n.tenantId in $tenantIdList match(m:MonitorRule{version:$appVersion}) where (m.nameSpace = $nameSpace or m.athena_namespace = $nameSpace) and ((m.inclusionTenant is null and m.notInclusionTenant is null) or (m.inclusionTenant is not null and n.tenantId in m.inclusionTenant) or (m.notInclusionTenant is not null and not n.tenantId in m.notInclusionTenant)) merge (n)-[:USE]->(m)";
        executeCqlList.add(new Cql().setCql(cql3).setParams(param));
        String cql4 = "match(n:TenantEntity{version:$tenantVersion}) where n.tenantId in $tenantIdList match(m:Action{version:$appVersion}) where (m.nameSpace = $nameSpace or m.athena_namespace = $nameSpace) and ((m.inclusionTenant is null and m.notInclusionTenant is null) or (m.inclusionTenant is not null and n.tenantId in m.inclusionTenant) or (m.notInclusionTenant is not null and not n.tenantId in m.notInclusionTenant)) merge (n)-[:ACTION]->(m)";
        executeCqlList.add(new Cql().setCql(cql4).setParams(param));
        List cqls = this.addTenantRelaWithProcess(Stream.of(application).collect(Collectors.toSet()), tenantVersion, appVersion, authAppTenantIdList);
        executeCqlList.addAll(cqls);
        return executeCqlList;
    }

    private List<Cql> mergeSpecificTenantAndAppDataRelation(String tenantId, String tenantVersion, String appVersion, Set<String> appCodeList) {
        ArrayList<Cql> executeCqlList = new ArrayList<Cql>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantId", tenantId);
        param.put("tenantVersion", tenantVersion);
        param.put("appVersion", appVersion);
        param.put("appCodeList", appCodeList);
        String cql2 = "match(n:TenantEntity{version:$tenantVersion, tenantId:$tenantId}) match(m:Activity{version:$appVersion}) where (m.athena_namespace in $appCodeList or m.nameSpace in $appCodeList) and ((m.inclusionTenant is null and m.notInclusionTenant is null) or (m.inclusionTenant is not null and n.tenantId in m.inclusionTenant) or (m.notInclusionTenant is not null and not n.tenantId in m.notInclusionTenant)) merge (n)-[:ACTIVITY]->(m)";
        executeCqlList.add(new Cql().setCql(cql2).setParams(param));
        String cql3 = "match(n:TenantEntity{version:$tenantVersion, tenantId:$tenantId}) match(m:MonitorRule{version:$appVersion}) where (m.athena_namespace in $appCodeList or m.nameSpace in $appCodeList) and ((m.inclusionTenant is null and m.notInclusionTenant is null) or (m.inclusionTenant is not null and n.tenantId in m.inclusionTenant) or (m.notInclusionTenant is not null and not n.tenantId in m.notInclusionTenant)) merge (n)-[:USE]->(m)";
        executeCqlList.add(new Cql().setCql(cql3).setParams(param));
        String cql4 = "match(n:TenantEntity{version:$tenantVersion, tenantId:$tenantId}) match(m:Action{version:$appVersion}) where (m.athena_namespace in $appCodeList or m.nameSpace in $appCodeList) and ((m.inclusionTenant is null and m.notInclusionTenant is null) or (m.inclusionTenant is not null and n.tenantId in m.inclusionTenant) or (m.notInclusionTenant is not null and not n.tenantId in m.notInclusionTenant)) merge (n)-[:ACTION]->(m)";
        executeCqlList.add(new Cql().setCql(cql4).setParams(param));
        List cqls = this.addTenantRelaWithProcess(appCodeList, tenantVersion, appVersion, Collections.singletonList(tenantId));
        executeCqlList.addAll(cqls);
        return executeCqlList;
    }

    public List<String> getAuthAppTenantIdList(String application, String version, List<String> excludeTenants) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("application", application);
        param.put("excludeTenants", excludeTenants);
        param.put("version", version);
        String cql = "match(n:TenantEntity{version:$version}) -[]-> (m:AppEntity{code:$application}) where not n.tenantId in $excludeTenants return n.tenantId as tenantId";
        List authAppTenantList = new Neo4jManager(this.driver1).ExecuteQuery(cql, param);
        List<String> authAppTenantIdList = authAppTenantList.stream().map(authAppTenant -> String.valueOf(authAppTenant.get("tenantId"))).collect(Collectors.toList());
        return authAppTenantIdList;
    }

    private List<String> getAllAuthAppTenantIdList(String application, String version) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("application", application);
        param.put("version", version);
        String cql = "match(n:TenantEntity{version:$version}) -[]-> (m:AppEntity{code:$application}) return n.tenantId as tenantId";
        List authAppTenantList = new Neo4jManager(this.driver1).ExecuteQuery(cql, param);
        List<String> authAppTenantIdList = authAppTenantList.stream().map(authAppTenant -> String.valueOf(authAppTenant.get("tenantId"))).collect(Collectors.toList());
        return authAppTenantIdList;
    }

    public void createTenantAndCommonRelation(List<String> tenantIds, String version) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantIdList", tenantIds);
        param.put("version", version);
        param.put("publishTime", DateUtil.now());
        ArrayList<Cql> executeCqlList = new ArrayList<Cql>();
        String cql2 = "match(m:Activity{version:$version}) where not (m)<-[:ACTIVITY]-(:TenantEntity) and m.nameSpace in ['common','espCommon'] match(n:TenantEntity) where not n.tenantId in $tenantIdList merge (n)-[:ACTIVITY]->(m)";
        executeCqlList.add(new Cql().setCql(cql2).setParams(param));
        String cql3 = "match(m:MonitorRule{version:$version}) where not (m)<-[:USE]-(:TenantEntity) and m.nameSpace in ['common','espCommon'] match(n:TenantEntity) where not n.tenantId in $tenantIdList merge (n)-[:USE]->(m)";
        executeCqlList.add(new Cql().setCql(cql3).setParams(param));
        String cql4 = "match(m:Action{version:$version}) WHERE NOT (m)<-[:ACTION]-(:TenantEntity) and m.nameSpace in ['common','espCommon'] match(n:TenantEntity) where not n.tenantId in $tenantIdList merge (n)-[:ACTION]->(m)";
        executeCqlList.add(new Cql().setCql(cql4).setParams(param));
        Neo4jMultipleUtil.executeCqlTrans(executeCqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    public List<Cql> createAllTenantAndCommonRelation(String version) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", version);
        ArrayList<Cql> executeCqlList = new ArrayList<Cql>();
        String cql2 = "match(m:Activity{version:$version}) match(n:TenantEntity{version:$version}) where m.nameSpace = 'common' merge (n)-[:ACTIVITY]->(m)";
        executeCqlList.add(new Cql().setCql(cql2).setParams(param));
        String cql3 = "match(m:MonitorRule{version:$version}) match(n:TenantEntity{version:$version}) where m.nameSpace = 'common' merge (n)-[:USE]->(m)";
        executeCqlList.add(new Cql().setCql(cql3).setParams(param));
        String cql4 = "match(m:Action{version:$version}) match(n:TenantEntity{version:$version}) where m.nameSpace = 'common' merge (n)-[:ACTION]->(m)";
        executeCqlList.add(new Cql().setCql(cql4).setParams(param));
        return executeCqlList;
    }

    public List<Cql> getSpecificTenantAndCommonAndEspRelationCql(String tenantId, String version) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        param.put("version", version);
        ArrayList<Cql> executeCqlList = new ArrayList<Cql>();
        String cql2 = "match(m:Activity{version:$version}) match(n:TenantEntity{version:$version, tenantId:$tenantId}) where m.nameSpace in ['common','espCommon'] merge (n)-[:ACTIVITY]->(m)";
        executeCqlList.add(new Cql().setCql(cql2).setParams(param));
        String cql3 = "match(m:MonitorRule{version:$version}) match(n:TenantEntity{version:$version, tenantId:$tenantId}) where m.nameSpace in ['common','espCommon'] merge (n)-[:USE]->(m)";
        executeCqlList.add(new Cql().setCql(cql3).setParams(param));
        String cql4 = "match(m:Action{version:$version}) match(n:TenantEntity{version:$version, tenantId:$tenantId}) WHERE m.nameSpace in ['common','espCommon'] and (m.tenantId is null or m.tenantId = $tenantId) merge (n)-[:ACTION]->(m)";
        executeCqlList.add(new Cql().setCql(cql4).setParams(param));
        return executeCqlList;
    }

    public Cql getSpecificTenantAndEspActionRelationCql(String tenantId, String version) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        param.put("version", version);
        String addRelaCql1 = "match(m:Action{version:$version}) match(n:TenantEntity{version:$version, tenantId:$tenantId}) WHERE m.nameSpace = 'espCommon' and (m.tenantId is null or m.tenantId = $tenantId) merge (n)-[:ACTION]->(m)";
        return new Cql().setCql(addRelaCql1).setParams(param);
    }

    public JSONObject getTenantInfoByToken(String token) {
        String response = this.analyzeIamToken(token);
        JSONObject responseObj = JSON.parseObject((String)response);
        String tenantId = responseObj.getString("tenantId");
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            log.error("\u89e3\u6790token\u5931\u8d25:", (Object)response);
            throw new BusinessException("\u79df\u6237\u83b7\u53d6\u5931\u8d25\uff1a" + responseObj.getString("errorMessage"));
        }
        log.info("getTenantInfoByToken response is -->{}", (Object)responseObj);
        return responseObj;
    }

    public String analyzeIamToken(String token) {
        String response = ((HttpRequest)HttpUtil.createPost((String)(this.iamUrl + tokenParseUrl)).header("digi-middleware-auth-user", token)).execute().body();
        return response;
    }

    public Set<String> getAllTenants(String version) {
        String findCql = "MATCH (n:TenantEntity{version:$version}) RETURN n.tenantId as tenantId";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", version);
        List tenants = new Neo4jManager(this.driver1).ExecuteQuery(findCql, param);
        HashSet<String> tenantIdList = new HashSet<String>();
        if (CollUtil.isNotEmpty((Collection)tenants)) {
            tenants.forEach(tenant -> tenantIdList.add(String.valueOf(tenant.get("tenantId"))));
        }
        return tenantIdList;
    }

    public Map<String, String> getTenantVersion(List<String> tenantIdList) {
        String findCql = "MATCH (n:TenantEntity) WHERE n.tenantId in $tenantIdList RETURN n.tenantId as tenantId, n.version as version";
        HashMap<String, List<String>> param = new HashMap<String, List<String>>();
        param.put("tenantIdList", tenantIdList);
        List tenants = new Neo4jManager(this.driver1).ExecuteQuery(findCql, param);
        HashMap<String, String> re = new HashMap<String, String>();
        if (CollUtil.isNotEmpty((Collection)tenants)) {
            tenants.forEach(tenant -> re.put((String)tenant.get("tenantId"), (String)tenant.get("version")));
        }
        return re;
    }

    public Set<String> getAppEntityFullNamespace(Set<String> appCode) {
        String findCql = "MATCH (n:AppEntity) WHERE n.code in $appCode RETURN n.fullNamespace as fullNamespace";
        HashMap<String, Set<String>> param = new HashMap<String, Set<String>>();
        param.put("appCode", appCode);
        List appInfo = new Neo4jManager(this.driver1).ExecuteQuery(findCql, param);
        HashSet<String> re = new HashSet<String>();
        if (CollUtil.isNotEmpty((Collection)appInfo)) {
            appInfo.forEach(info -> {
                if (!String.valueOf(info.get("fullNamespace")).equals("NULL") && !ObjectUtils.isEmpty(info.get("fullNamespace"))) {
                    re.add(String.valueOf(info.get("fullNamespace")));
                }
            });
        }
        return re;
    }

    public void mergeRelationBetweenTenantAndAppInVersionChange(String application, List<String> tenantIdList, String targetVersion, Map<String, String> tenantVersionMap) {
        log.info(application + "\u53d1\u7248/\u5207\u7248\uff1a\u5f00\u59cb\u83b7\u53d6\u4fee\u6539\u79df\u6237\u548cneo4j\u6570\u636e\u8282\u70b9\u5173\u7cfb\u7684cql");
        List cqlList = this.getMergeRelationBetweenTenantAndAppInVersionChangeCql(application, tenantIdList, targetVersion, tenantVersionMap);
        log.info(application + "\u53d1\u7248/\u5207\u7248\uff1a\u5f00\u59cb\u6267\u884ccql");
        Neo4jMultipleUtil.executeCqlTrans((List)cqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
        log.info(application + "\u53d1\u7248/\u5207\u7248\uff1a\u6267\u884ccql\u7ed3\u675f");
    }

    public List<Cql> getMergeRelationBetweenTenantAndAppInVersionChangeCql(String application, List<String> tenantIdList, String targetVersion, Map<String, String> tenantVersionMap) {
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        for (String tenantId : tenantIdList) {
            if (StringUtils.isEmpty((CharSequence)tenantVersionMap.get(tenantId)) || targetVersion.equals(tenantVersionMap.get(tenantId))) continue;
            Set appCodeList = this.getNotCommonAppCodeRelaToTenantId(tenantId);
            appCodeList.remove(application);
            List cql2 = this.mergeSpecificTenantAndAppDataRelation(tenantId, targetVersion, targetVersion, appCodeList);
            cqlList.addAll(cql2);
        }
        return cqlList;
    }

    public void modifyTenantRelaWithNotMatchAppDataInSwitch(String application, List<String> tenantIdList, Boolean commonApp) {
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        if (!commonApp.booleanValue()) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("application", application);
            param.put("version", "1.0");
            String cql = "match(n:TenantEntity{version:$version}) -[]-> (m:AppEntity{code:$application}) return n.tenantId as tenantId";
            List authAppTenantList = new Neo4jManager(this.driver1).ExecuteQuery(cql, param);
            List authAppTenantIdList = authAppTenantList.stream().map(authAppTenant -> String.valueOf(authAppTenant.get("tenantId"))).collect(Collectors.toList());
            List deleteCqls = this.deleteRelationBetweenAppAndTenant(application, "1.0", "2.0", authAppTenantIdList);
            cqlList.addAll(deleteCqls);
            List mergeCqls = this.getMergeTenantAndAppDataRelationCql(application, "1.0", "1.0", authAppTenantIdList);
            cqlList.addAll(mergeCqls);
        }
        cqlList.add(this.deleteDiffVersionRelaBetweenTenantAndAppData("2.0", "1.0", tenantIdList));
        Neo4jMultipleUtil.executeCqlTrans(cqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    public List<Cql> deleteRelationBetweenAppAndTenant(String application, String tenantVersion, String appVersion, List<String> authAppTenantIdList) {
        ArrayList<Cql> executeCqlList = new ArrayList<Cql>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("application", application);
        param.put("tenantVersion", tenantVersion);
        param.put("appVersion", appVersion);
        param.put("tenantIdList", authAppTenantIdList);
        String cql1 = "match (n:TenantEntity{version:$tenantVersion})-[r:ACTIVITY]->(m:Activity{version:$appVersion}) where n.tenantId in $tenantIdList and (m.athena_namespace=$application or m.nameSpace=$application) delete r";
        executeCqlList.add(new Cql().setCql(cql1).setParams(param));
        String cql2 = "match (n:TenantEntity{version:$tenantVersion})-[r:USE]->(m:MonitorRule{version:$appVersion}) where n.tenantId in $tenantIdList and (m.athena_namespace=$application or m.nameSpace=$application) delete r";
        executeCqlList.add(new Cql().setCql(cql2).setParams(param));
        String cql3 = "match (n:TenantEntity{version:$tenantVersion})-[r:ACTION]->(m:Action{version:$appVersion}) where n.tenantId in $tenantIdList and (m.athena_namespace=$application or m.nameSpace=$application) delete r";
        executeCqlList.add(new Cql().setCql(cql3).setParams(param));
        String cql4 = "match (n:TenantEntity{version:$tenantVersion})-[r:TASK]->(m:TASK{version:$appVersion}) where n.tenantId in $tenantIdList and (m.athena_namespace=$application or m.nameSpace=$application) delete r";
        executeCqlList.add(new Cql().setCql(cql4).setParams(param));
        return executeCqlList;
    }

    public void modifyTenantRelaWithNotMatchAppDataInPublish(String application, List<String> tenantIdList) {
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        cqlList.add(this.deleteDiffVersionRelaBetweenTenantAndAppData("1.0", "2.0", tenantIdList));
        Neo4jMultipleUtil.executeCqlTrans(cqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    public void modifyTenantConfig(String version, List<String> tenantIdList) {
        String tenantConfigVersion = version.split("\\.")[0] + ".x";
        for (String tenantId : tenantIdList) {
            Bson filterFind = Filters.eq((String)"tenantId", (Object)tenantId);
            FindIterable documents = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("tenantConfig").find(filterFind);
            Document document = (Document)documents.first();
            if (document == null) {
                Document newDocument = new Document();
                newDocument.put("version", (Object)tenantConfigVersion);
                newDocument.put("tenantId", (Object)tenantId);
                this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("tenantConfig").insertOne((Object)newDocument);
                continue;
            }
            boolean needUpdate = false;
            for (Document doc : documents) {
                if (tenantConfigVersion.equals(doc.get((Object)"version"))) continue;
                needUpdate = true;
                break;
            }
            if (!needUpdate) continue;
            Document update = new Document("$set", (Object)new Document().append("version", (Object)tenantConfigVersion));
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase("datamap").getCollection("tenantConfig").updateMany(filterFind, (Bson)update);
        }
    }

    private Cql deleteDiffVersionRelaBetweenTenantAndAppData(String tenantVersion, String appVersion, List<String> tenantIdList) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantVersion", tenantVersion);
        param.put("appVersion", appVersion);
        param.put("tenantIdList", tenantIdList);
        String cqlStr = "match (n:TenantEntity{version:$tenantVersion})-[r]->(m) where n.tenantId in $tenantIdList and m.version=$appVersion and NOT m:AppEntity delete r";
        Cql cql = new Cql().setCql(cqlStr).setParams(param);
        return cql;
    }

    private Set<String> getNotCommonAppCodeRelaToTenantId(String tenantId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        String cql = "match(n:TenantEntity{tenantId:$tenantId})-[]->(m:AppEntity) where m.commonApp is null or m.commonApp<>true return m.code as code";
        List authAppCodeList = new Neo4jManager(this.driver1).ExecuteQuery(cql, param);
        Set<String> appCode = authAppCodeList.stream().map(authAppCode -> String.valueOf(authAppCode.get("code"))).collect(Collectors.toSet());
        return appCode;
    }

    private List<Cql> addTenantRelaWithProcess(Set<String> application, String tenantVersion, String appVersion, List<String> tenantIdList) {
        List<Object> executeCqlList = new ArrayList<Cql>();
        if (!tenantVersion.equals(appVersion)) {
            return executeCqlList;
        }
        Set fullNameSpace = this.getAppEntityFullNamespace(application);
        if (CollUtil.isEmpty((Collection)fullNameSpace)) {
            return executeCqlList;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("application", application);
        param.put("tenantVersion", tenantVersion);
        param.put("appVersion", appVersion);
        param.put("tenantIdList", tenantIdList);
        param.put("fullNameSpace", fullNameSpace);
        executeCqlList = this.addTenantRelaWithNodeInProcess(param);
        return executeCqlList;
    }

    private List<Cql> addTenantRelaWithNodeInProcess(Map<String, Object> param) {
        ArrayList<Cql> executeCqlList = new ArrayList<Cql>();
        String cql1 = "match(n:TenantEntity{version:$tenantVersion}) where n.tenantId in $tenantIdList match(m:Task{version:$appVersion}) where (m.nameSpace in $fullNameSpace or m.athena_namespace in $fullNameSpace) and ((m.inclusionTenant is null and m.notInclusionTenant is null) or (m.inclusionTenant is not null and n.tenantId in m.inclusionTenant) or (m.notInclusionTenant is not null and not n.tenantId in m.notInclusionTenant)) merge (n)-[:TASK]->(m)";
        executeCqlList.add(new Cql().setCql(cql1).setParams(param));
        String cql2 = "match(n:TenantEntity{version:$tenantVersion}) where n.tenantId in $tenantIdList match(m:Activity{version:$appVersion}) where (m.nameSpace in $fullNameSpace or m.athena_namespace in $fullNameSpace) and ((m.inclusionTenant is null and m.notInclusionTenant is null) or (m.inclusionTenant is not null and n.tenantId in m.inclusionTenant) or (m.notInclusionTenant is not null and not n.tenantId in m.notInclusionTenant)) merge (n)-[:ACTIVITY]->(m)";
        executeCqlList.add(new Cql().setCql(cql2).setParams(param));
        String cql3 = "match(n:TenantEntity{version:$tenantVersion}) where n.tenantId in $tenantIdList match(m:MonitorRule{version:$appVersion}) where (m.nameSpace in $fullNameSpace or m.athena_namespace in $fullNameSpace) and ((m.inclusionTenant is null and m.notInclusionTenant is null) or (m.inclusionTenant is not null and n.tenantId in m.inclusionTenant) or (m.notInclusionTenant is not null and not n.tenantId in m.notInclusionTenant)) merge (n)-[:USE]->(m)";
        executeCqlList.add(new Cql().setCql(cql3).setParams(param));
        String cql4 = "match(n:TenantEntity{version:$tenantVersion}) where n.tenantId in $tenantIdList match(m:Action{version:$appVersion}) where (m.nameSpace in $fullNameSpace or m.athena_namespace in $fullNameSpace) and ((m.inclusionTenant is null and m.notInclusionTenant is null) or (m.inclusionTenant is not null and n.tenantId in m.inclusionTenant) or (m.notInclusionTenant is not null and not n.tenantId in m.notInclusionTenant)) merge (n)-[:ACTION]->(m)";
        executeCqlList.add(new Cql().setCql(cql4).setParams(param));
        return executeCqlList;
    }

    public List<TenantVersion> getTenantVersionByTenantId(String tenantId) {
        HashSet<String> tenantIds = new HashSet<String>();
        tenantIds.add(tenantId);
        String findCql = "MATCH (n:TenantEntity) WHERE n.tenantId in $tenantIds RETURN n.tenantId as tenantId, n.tenantName as tenantName, n.name as name, n.version as version";
        HashMap<String, HashSet<String>> param = new HashMap<String, HashSet<String>>();
        param.put("tenantIds", tenantIds);
        List tenants = new Neo4jManager(this.driver1).ExecuteQuery(findCql, param);
        return this.getTenantVersionInfoByCqlResult(tenants);
    }

    public List<TenantVersion> getTenantVersionByApp(String appCode) {
        String findCql = "MATCH (n:TenantEntity)-[]->(a:AppEntity) WHERE a.code=$appCode RETURN n.tenantId as tenantId, n.tenantName as tenantName, n.version as version";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("appCode", appCode);
        List tenants = new Neo4jManager(this.driver1).ExecuteQuery(findCql, param);
        return this.getTenantVersionInfoByCqlResult(tenants);
    }

    private List<TenantVersion> getTenantVersionInfoByCqlResult(List<Map<String, Object>> tenants) {
        ArrayList re = new ArrayList();
        if (CollUtil.isNotEmpty(tenants)) {
            tenants.forEach(tenant -> {
                TenantVersion ambi = new TenantVersion();
                ambi.setTenantId((String)tenant.get("tenantId"));
                ambi.setVersion((String)tenant.get("version"));
                Object tenantName = tenant.get("tenantName");
                if (tenantName != null && tenantName instanceof String) {
                    ambi.setTenantName((String)tenant.get("tenantName"));
                } else {
                    Object name = tenant.get("name");
                    if (tenant.get("name") != null && name instanceof String) {
                        ambi.setTenantName((String)tenant.get("name"));
                    }
                }
                re.add(ambi);
            });
        }
        return re.stream().distinct().collect(Collectors.toList());
    }

    public List<TenantVersion> getTenantVersionBySameCustomId(String tenantId) {
        JSONObject jsonObject = this.queryUserTenants(tenantId);
        Integer code = jsonObject.getInteger("code");
        Boolean success = jsonObject.getBoolean("success");
        HashSet<String> tenantIds = new HashSet<String>();
        if (code != -1 && null != success && success.booleanValue()) {
            JSONArray data = jsonObject.getJSONArray("data");
            if (CollUtil.isNotEmpty((Collection)data)) {
                data.forEach(da -> {
                    JSONObject dataJson = JSON.parseObject((String)JSON.toJSONString((Object)da));
                    String id = dataJson.getString("id");
                    if (null != id) {
                        tenantIds.add(id);
                    }
                });
            }
        } else {
            tenantIds.add(tenantId);
        }
        String findCql = "MATCH (n:TenantEntity) WHERE n.tenantId in $tenantIds RETURN n.tenantId as tenantId, n.tenantName as tenantName, n.version as version";
        HashMap<String, HashSet<String>> param = new HashMap<String, HashSet<String>>();
        param.put("tenantIds", tenantIds);
        List tenants = new Neo4jManager(this.driver1).ExecuteQuery(findCql, param);
        return this.getTenantVersionInfoByCqlResult(tenants);
    }
}

