/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.service.esp.Impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.config.ModuleConfig;
import com.digiwin.athena.athena_deployer_service.domain.esp.response.StdData;
import com.digiwin.athena.athena_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.athena_deployer_service.service.esp.ESPService;
import com.digiwin.athena.athena_deployer_service.service.iam.IamService;
import com.digiwin.athena.athena_deployer_service.util.EspCommonUtils;
import com.digiwin.athena.esp.sdk.Invoker;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ESPServiceImpl
implements ESPService {
    @Generated
    private static final Logger log = LogManager.getLogger(ESPServiceImpl.class);
    @Autowired
    private ModuleConfig moduleConfig;
    @Autowired
    private IamService iamService;
    @Autowired
    private RestTemplate restTemplate;

    public Map<String, Object> invokeEspSync(String serviceName, String serviceProd, String tenantId, Map<String, String> headers, Map<String, Object> body) throws Exception {
        RequestModel requestModel = EspCommonUtils.createEspRequestModel((String)serviceName, (String)serviceProd, (String)tenantId, headers, body, (ModuleConfig)this.moduleConfig);
        ResponseModel responseModel = Invoker.invokeRestSync((RequestModel)requestModel);
        if (Objects.isNull(responseModel) || StringUtils.isEmpty((CharSequence)responseModel.getBodyJsonString())) {
            throw new BusinessException("invokeRestSync response err.serviceName:" + serviceName);
        }
        StdData stdData = EspCommonUtils.toStdData((String)responseModel.getBodyJsonString());
        if (!"0".equals(stdData.getCode())) {
            throw new BusinessException("invokeRestSync fail." + stdData.getDescription());
        }
        return stdData.getParameter();
    }

    public void callDataViewEspServiceApi(Map<String, Object> dataViewMap, String tenantId, String appToken, String serviceCode) {
        String integrationToken;
        String token = integrationToken = this.iamService.getIntegrationToken(tenantId);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("digi-middleware-auth-app", appToken);
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        headers.put("digi-type", "sync");
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String formatTime = sdf.format(date);
        HashMap<String, String> headMapDigi_Host = new HashMap<String, String>();
        headMapDigi_Host.put("prod", "Athena");
        headMapDigi_Host.put("ver", "1.0");
        headMapDigi_Host.put("lang", "zh_CN");
        headMapDigi_Host.put("timestamp", formatTime);
        headMapDigi_Host.put("ip", "");
        headMapDigi_Host.put("eoc_acct", "athena");
        headMapDigi_Host.put("acct", "athena");
        headers.put("digi-host", JSON.toJSONString(headMapDigi_Host));
        HashMap<String, String> headMapDigi_Service = new HashMap<String, String>();
        headMapDigi_Service.put("prod", serviceCode);
        headMapDigi_Service.put("uid", serviceCode);
        headMapDigi_Service.put("tenant_id", tenantId);
        headMapDigi_Service.put("name", "modeldriven.dataview.update");
        headers.put("digi-service", JSON.toJSONString(headMapDigi_Service));
        HashMap requestMap = new HashMap();
        HashMap<String, Map<String, Object>> parameter = new HashMap<String, Map<String, Object>>();
        parameter.put("parameter", dataViewMap);
        requestMap.put("std_data", parameter);
        String requestJson = JSON.toJSONString(requestMap);
        String logKey = "modeldriven.dataview.update";
        try {
            String fileMD5 = DigestUtils.md5Hex((String)(JSON.toJSONString(headMapDigi_Host) + JSON.toJSONString(headMapDigi_Service)));
            headers.put("digi-key", fileMD5);
            log.info("dataview esp headers headers is ={}", (Object)JSON.toJSONString(headers));
            log.info("dataview esp  request is ={}", (Object)requestJson);
            String url = this.moduleConfig.getEsp().getDomain() + "/CROSS/RESTful";
            String StdResponse = ((HttpRequest)HttpUtil.createPost((String)url).body(requestJson).addHeaders(headers)).execute().body();
            log.info("espService." + logKey + " response is ={}", (Object)StdResponse);
            String result = "-2";
            JSONObject responseObj = JSON.parseObject((String)StdResponse);
            JSONObject std_data = responseObj.getJSONObject("std_data");
            if (Objects.nonNull(std_data)) {
                JSONObject execution = std_data.getJSONObject("execution");
                result = execution.getString("code");
                if ("0".equals(result)) {
                    log.info("espService." + logKey + " execute success");
                } else if ("-1".equals(result)) {
                    execution = std_data.getJSONObject("execution");
                    String description = execution.getString("description");
                    throw new BusinessException(description);
                }
            }
            if (!result.equals("0")) {
                throw new BusinessException(StdResponse);
            }
        }
        catch (Exception e) {
            throw new BusinessException(logKey + " have exception: " + e.getMessage());
        }
    }

    public void callActivityEspServiceApi(Map<String, Object> activityAndModelMap, String applicationCode, String publishFlag, String tenantId, String appToken, String serviceCode) {
        String integrationToken;
        String token = integrationToken = this.iamService.getIntegrationToken(tenantId);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("digi-middleware-auth-app", appToken);
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        headers.put("digi-type", "sync");
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String formatTime = sdf.format(date);
        HashMap<String, String> headMapDigi_Host = new HashMap<String, String>();
        headMapDigi_Host.put("prod", "Athena");
        headMapDigi_Host.put("ver", "1.0");
        headMapDigi_Host.put("lang", "zh_CN");
        headMapDigi_Host.put("timestamp", formatTime);
        headMapDigi_Host.put("ip", "");
        headMapDigi_Host.put("eoc_acct", "athena");
        headMapDigi_Host.put("acct", "athena");
        headers.put("digi-host", JSON.toJSONString(headMapDigi_Host));
        HashMap<String, String> headMapDigi_Service = new HashMap<String, String>();
        headMapDigi_Service.put("prod", serviceCode);
        headMapDigi_Service.put("uid", serviceCode);
        headMapDigi_Service.put("tenant_id", tenantId);
        headMapDigi_Service.put("name", "modeldriven.activity.update");
        headers.put("digi-service", JSON.toJSONString(headMapDigi_Service));
        HashMap requestMap = new HashMap();
        HashMap<String, Map<String, Object>> parameter = new HashMap<String, Map<String, Object>>();
        activityAndModelMap.put("application", applicationCode);
        activityAndModelMap.put("publishFlag", publishFlag);
        parameter.put("parameter", activityAndModelMap);
        requestMap.put("std_data", parameter);
        String requestJson = JSON.toJSONString(requestMap);
        String logKey = "modeldriven.activity.update";
        try {
            String fileMD5 = DigestUtils.md5Hex((String)(JSON.toJSONString(headMapDigi_Host) + JSON.toJSONString(headMapDigi_Service)));
            headers.put("digi-key", fileMD5);
            log.info("activity esp headers headers is ={}", (Object)JSON.toJSONString(headers));
            log.info("activity esp  request is ={}", (Object)requestJson);
            String url = this.moduleConfig.getEsp().getDomain() + "/CROSS/RESTful";
            String StdResponse = ((HttpRequest)HttpUtil.createPost((String)url).body(requestJson).addHeaders(headers)).execute().body();
            log.info("espService." + logKey + " response is ={}", (Object)StdResponse);
            String result = "-2";
            JSONObject responseObj = JSON.parseObject((String)StdResponse);
            JSONObject std_data = responseObj.getJSONObject("std_data");
            if (Objects.nonNull(std_data)) {
                JSONObject execution = std_data.getJSONObject("execution");
                result = execution.getString("code");
                if ("0".equals(result)) {
                    log.info("espService." + logKey + " execute success");
                } else if ("-1".equals(result)) {
                    execution = std_data.getJSONObject("execution");
                    String description = execution.getString("description");
                    throw new BusinessException(description);
                }
            }
            if (!result.equals("0")) {
                throw new BusinessException(StdResponse);
            }
        }
        catch (Exception e) {
            throw new BusinessException(logKey + " have exception: " + e.getMessage());
        }
    }

    public String getModelDrivenEvnVersion(String tenantId, String appToken, String serviceCode, String version) {
        String integrationToken = this.iamService.getIntegrationToken(tenantId);
        HttpHeaders httpHeaders = new HttpHeaders();
        if (StringUtils.isNotBlank((CharSequence)appToken)) {
            httpHeaders.add("digi-middleware-auth-app", appToken);
        }
        httpHeaders.add("token", integrationToken);
        httpHeaders.add("Content-Type", "application/json");
        httpHeaders.add("digi-type", "sync");
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String formatTime = sdf.format(date);
        HashMap<String, String> headHost = new HashMap<String, String>();
        headHost.put("prod", "Athena");
        headHost.put("ver", "1.0");
        headHost.put("lang", "zh_CN");
        headHost.put("timestamp", formatTime);
        headHost.put("ip", "");
        headHost.put("eoc_acct", "athena");
        headHost.put("acct", "athena");
        httpHeaders.add("digi-host", JSON.toJSONString(headHost));
        HashMap<String, String> headService = new HashMap<String, String>();
        headService.put("prod", serviceCode);
        headService.put("uid", serviceCode);
        headService.put("tenant_id", tenantId);
        headService.put("name", "modeldriven.env.version.get");
        httpHeaders.add("digi-service", JSON.toJSONString(headService));
        HashMap requestMap = new HashMap();
        HashMap parameter = new HashMap();
        parameter.put("parameter", new HashMap());
        requestMap.put("std_data", parameter);
        String logKey = "modeldriven.env.version.get";
        String fileMD5 = DigestUtils.md5Hex((String)(JSON.toJSONString(headHost) + JSON.toJSONString(headService)));
        httpHeaders.add("digi-key", fileMD5);
        String url = this.moduleConfig.getEsp().getDomain() + "/CROSS/RESTful";
        HttpEntity httpEntity = new HttpEntity(requestMap, (MultiValueMap)httpHeaders);
        log.info("getModelDrivenEvnVersion() -- \u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u8bf7\u6c42\u5934\uff1a{}\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)url, (Object)JSON.toJSONString((Object)httpHeaders), (Object)JSON.toJSONString(requestMap));
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, JSONObject.class, new Object[0]);
        log.info("getModelDrivenEvnVersion() -- \u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)response.getBody()));
        if (response.getStatusCode() == HttpStatus.NOT_FOUND) {
            throw new BusinessException(String.format("%s\u670d\u52a1SDK\u7248\u672c\u9700\u8981\u5347\u7ea7\u81f3%s\uff0cDAP\u7248\u672c\u9700\u8981\u5347\u7ea7\u81f35.2.0.1136(\u542b)\u4ee5\u4e0a\uff01", serviceCode, version));
        }
        if (response.getStatusCode() != HttpStatus.OK) {
            throw new BusinessException(String.format("\u83b7\u53d6%s\u670d\u52a1SDK\u7248\u672c\u5931\u8d25\uff01", serviceCode) + response.getStatusCodeValue());
        }
        JSONObject responseObj = (JSONObject)response.getBody();
        if (null != responseObj) {
            JSONObject std_data = responseObj.getJSONObject("std_data");
            if (Objects.nonNull(std_data)) {
                JSONObject execution = std_data.getJSONObject("execution");
                if ("0".equals(execution.getString("code"))) {
                    log.info(logKey + " execute success");
                    JSONObject responseParameter = std_data.getJSONObject("parameter");
                    if (null != responseParameter && StringUtils.isNotBlank((CharSequence)responseParameter.getString("currentVersion"))) {
                        return responseParameter.getString("currentVersion");
                    }
                }
            } else {
                String errorCode = responseObj.getString("errorCode");
                String errorMessage = responseObj.getString("errorMessage");
                if ("P.ESP.200.0201".equals(errorCode)) {
                    throw new BusinessException(String.format("%s\u670d\u52a1SDK\u7248\u672c\u9700\u8981\u5347\u7ea7\u81f3%s\uff0cDAP\u7248\u672c\u9700\u8981\u5347\u7ea7\u81f35.2.0.1136(\u542b)\u4ee5\u4e0a\uff01", serviceCode, version));
                }
                throw new BusinessException(String.format("\u83b7\u53d6%s\u670d\u52a1SDK\u7248\u672c\u5931\u8d25\uff01", serviceCode) + errorMessage);
            }
        }
        throw new BusinessException(String.format("\u83b7\u53d6%s\u670d\u52a1SDK\u7248\u672c\u5931\u8d25\uff01", serviceCode) + response.getStatusCodeValue());
    }
}

