/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.service.iam.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.athena_deployer_service.config.ModuleConfig;
import com.digiwin.athena.athena_deployer_service.domain.TenantUser;
import com.digiwin.athena.athena_deployer_service.domain.iam.IamCleanTenantReqDto;
import com.digiwin.athena.athena_deployer_service.domain.param.IamAddPolicyParam;
import com.digiwin.athena.athena_deployer_service.domain.param.IamAssignmentAuthorizeParam;
import com.digiwin.athena.athena_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.athena_deployer_service.http.iam.IamApiHelper;
import com.digiwin.athena.athena_deployer_service.http.iam.dto.BuyApplicationReqDto;
import com.digiwin.athena.athena_deployer_service.http.iam.dto.DeletePermissionReqDto;
import com.digiwin.athena.athena_deployer_service.http.iam.dto.TenantInfoDto;
import com.digiwin.athena.athena_deployer_service.service.deploy.TenantService;
import com.digiwin.athena.athena_deployer_service.service.iam.IamService;
import com.digiwin.athena.athena_deployer_service.util.LogUtils;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class IamServiceImpl
implements IamService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamServiceImpl.class);
    @Autowired
    private ModuleConfig moduleConfig;
    @Value(value="${appToken}")
    private String appToken;
    @Autowired
    @Lazy
    private TenantService tenantService;
    @Autowired
    private IamApiHelper iamApiHelper;
    private static final String IV_STRING = "ghUb#er57HBh(u%g";
    private static final String CHARSET = "UTF-8";
    private static final String INTEGRATION_ACCOUNT = "integration";
    private static final String PASSWORD_HASH = "6826CC688C4AF1BD0A8DDA2DBDF8897B";

    public String getIsvCode(String tenantId) {
        String integrationToken = this.getIntegrationToken(tenantId);
        String tbbServiceUrl = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/tenant/current";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("digi-middleware-auth-user", integrationToken);
        String response = ((HttpRequest)HttpUtil.createPost((String)tbbServiceUrl).addHeaders(headers)).execute().body();
        JSONObject reponseJson = JSON.parseObject((String)response);
        return reponseJson.getJSONObject("tenant").getString("customerId");
    }

    public void iamAssignmentAuthorize(IamAssignmentAuthorizeParam iamAssignmentAuthorizeParam) {
        String message = "\u8c03IAM\u63a5\u53e3\u5f02\u5e38,\u5931\u8d25\u539f\u56e0:%s";
        String application = iamAssignmentAuthorizeParam.getApplication();
        JSONObject assignment = iamAssignmentAuthorizeParam.getAssignment();
        String token = this.getIntegrationToken(iamAssignmentAuthorizeParam.getCurrentUser().getTenantId());
        String moduleId = iamAssignmentAuthorizeParam.getModuleId();
        List tenantUsers = iamAssignmentAuthorizeParam.getTenantUsers();
        List tenantSids = tenantUsers.stream().map(t -> t.getTenantSid()).collect(Collectors.toList());
        ModuleConfig.Module iam = this.moduleConfig.getIam();
        String iamDomain = iam.getDomain();
        String singlePublish = "/api/iam/v2/app/action/update";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("digi-middleware-auth-app", this.appToken);
        header.put("digi-middleware-auth-user", token);
        String code = assignment.getString("code");
        String name = assignment.getString("name");
        String tenantId = assignment.getString("tenantId");
        String modelId = assignment.getString("modelId");
        String path = assignment.getString("path");
        String type = assignment.getString("type");
        String parentId = assignment.getString("parentId");
        Boolean regardlessAuth = assignment.getBoolean("regardlessAuth");
        Boolean updateCommonAction = assignment.getBoolean("updateCommonAction");
        Boolean isUc = null != tenantId && !"SYSTEM".equals(tenantId);
        for (Long tenantSid : tenantSids) {
            JSONObject param = new JSONObject();
            if (iamAssignmentAuthorizeParam.getIndividual().booleanValue()) {
                param.put("tenantSid", (Object)tenantSid);
            } else if (updateCommonAction == null || !updateCommonAction.booleanValue()) {
                param.put(isUc != false ? "tenantSid" : "separateTenantSid", (Object)tenantSid);
            }
            param.put("appId", (Object)application);
            param.put("moduleId", (Object)moduleId);
            param.put("id", (Object)code);
            param.put("name", (Object)name);
            param.put("modelId", (Object)(StringUtils.isNotBlank((CharSequence)modelId) ? modelId : ""));
            param.put("path", (Object)(StringUtils.isNotBlank((CharSequence)path) ? path : ""));
            param.put("type", (Object)(StringUtils.isNotBlank((CharSequence)type) ? type : ""));
            param.put("regardlessAuth", (Object)regardlessAuth);
            if (StringUtils.isNotBlank((CharSequence)parentId)) {
                param.put("parentId", (Object)parentId);
            }
            log.info("iam\u6743\u9650\u66f4\u65b0token:" + token);
            log.info("iam\u6743\u9650\u66f4\u65b0param:" + param.toJSONString());
            log.info("iam\u6743\u9650\u66f4\u65b0url:" + iamDomain + singlePublish);
            String response = ((HttpRequest)HttpUtil.createPost((String)(iamDomain + singlePublish)).addHeaders(header)).body(JSON.toJSONString((Object)param)).timeout(30000).execute().body();
            log.info("iam\u6743\u9650\u66f4\u65b0response:" + response);
            if (NumberUtil.isNumber((CharSequence)response)) continue;
            JSONObject jsonObject = JSON.parseObject((String)response);
            String messageId = IdUtil.fastUUID().replace("-", "");
            if (!jsonObject.getBoolean("success").booleanValue() || jsonObject.getInteger("code") == 500) {
                LogUtils.buildAgileLog((String)application, (String)LogUtils.MODULE_AADCS, (String)"iamAssignmentAuthorize", (String)LogUtils.WARING, (String)JSON.toJSONString((Object)param), (String)String.format(message, jsonObject), (String)"", (String)messageId);
                throw new BusinessException(Integer.valueOf(-1), response);
            }
            LogUtils.buildAgileLog((String)application, (String)LogUtils.MODULE_AADCS, (String)"iamAssignmentAuthorize", (String)LogUtils.SUCCESS, (String)JSON.toJSONString((Object)param), (String)response, (String)"", (String)messageId);
        }
    }

    public void addPolicy(IamAddPolicyParam addPolicyParam) {
        String message = "\u8c03IAM\u63a5\u53e3\u5f02\u5e38,\u5931\u8d25\u539f\u56e0:%s";
        String domain = this.moduleConfig.getIam().getDomain();
        String url = "/api/iam/v2/policy/batch/add";
        List tenantUsers = addPolicyParam.getTenantUsers();
        List assignmentList = addPolicyParam.getAssignmentList();
        String application = addPolicyParam.getApplication();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("digi-middleware-auth-app", this.appToken);
        ArrayList targets = new ArrayList();
        assignmentList.forEach(activity -> {
            JSONObject target = new JSONObject();
            target.put("moduleId", (Object)addPolicyParam.getModuleId());
            target.put("actionId", (Object)activity.getString("code"));
            target.put("self", (Object)(addPolicyParam.getIndividual() != false ? 1 : 0));
            targets.add(target);
        });
        for (TenantUser tenantUser : tenantUsers) {
            String tenantId = tenantUser.getTenantId();
            Integer option = tenantUser.getOption();
            String integrationToken = this.getIntegrationToken(tenantId);
            header.put("digi-middleware-auth-user", integrationToken);
            List<JSONObject> userIdJson = new ArrayList();
            if (option == 1) {
                userIdJson = this.tenantService.queryAllUserInTenant(tenantId, integrationToken);
            } else if (option == 3) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)tenantUser.getCurrentUserId());
                userIdJson.add(jsonObject);
            } else {
                List userIdList = tenantUser.getUserIdList();
                for (String userId : userIdList) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("id", (Object)userId);
                    userIdJson.add(jsonObject);
                }
            }
            if (CollectionUtils.isEmpty(userIdJson)) continue;
            userIdJson.forEach(user -> user.put("type", (Object)"user"));
            targets.forEach(target -> target.put("tenantSid", (Object)0));
            JSONObject paramJson = new JSONObject();
            paramJson.put("tenantId", (Object)tenantId);
            paramJson.put("appId", (Object)application);
            paramJson.put("users", userIdJson);
            paramJson.put("targets", targets);
            log.info("iam\u81ea\u52a8\u6388\u6743header:" + JSON.toJSONString(header));
            log.info("iam\u81ea\u52a8\u6388\u6743param:" + paramJson.toJSONString());
            log.info("iam\u81ea\u52a8\u6388\u6743url:" + domain + url);
            HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)(domain + url)).addHeaders(header)).body(paramJson.toJSONString()).execute();
            log.info("iam\u81ea\u52a8\u6388\u6743response body{},status{}", (Object)response.body(), (Object)response.getStatus());
            String messageId = IdUtil.fastUUID().replace("-", "");
            if (response.getStatus() != 200) {
                LogUtils.buildAgileLog((String)application, (String)LogUtils.MODULE_AADCS, (String)"addPolicy", (String)LogUtils.AADCS_500_0002, (String)JSON.toJSONString((Object)paramJson), (String)String.format(message, response.body()), (String)String.format("\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff0c\u5e76\u63d0\u4f9b\u6d88\u606f\u5e8f\u5217\u53f7\uff08%s\uff09", messageId), (String)messageId);
                throw new BusinessException("\u5f00\u542f\u7528\u6237\u6388\u6743\u5931\u8d25");
            }
            LogUtils.buildAgileLog((String)application, (String)LogUtils.MODULE_AADCS, (String)"addPolicy", (String)LogUtils.SUCCESS, (String)JSON.toJSONString((Object)paramJson), (String)response.body(), (String)"", (String)messageId);
        }
    }

    public void addCommonPolicy(IamAddPolicyParam addPolicyParam) {
        String domain = this.moduleConfig.getIam().getDomain();
        String url = "/api/iam/v2/policy/batch/add";
        List tenantUsers = addPolicyParam.getTenantUsers();
        List assignmentList = addPolicyParam.getAssignmentList();
        String application = addPolicyParam.getApplication();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("digi-middleware-auth-app", this.appToken);
        ArrayList targets = new ArrayList();
        assignmentList.forEach(activity -> {
            JSONObject target = new JSONObject();
            target.put("moduleId", (Object)activity.getString("code"));
            target.put("actionId", (Object)activity.getString("code"));
            target.put("self", (Object)false);
            targets.add(target);
        });
        for (TenantUser tenantUser : tenantUsers) {
            String tenantId = tenantUser.getTenantId();
            Integer option = tenantUser.getOption();
            String integrationToken = this.getIntegrationToken(tenantId);
            header.put("digi-middleware-auth-user", integrationToken);
            List<JSONObject> userIdJson = new ArrayList();
            if (option == 1) {
                userIdJson = this.tenantService.queryAllUserInTenant(tenantId, integrationToken);
            } else if (option == 3) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)tenantUser.getCurrentUserId());
                userIdJson.add(jsonObject);
            } else {
                List userIdList = tenantUser.getUserIdList();
                for (String userId : userIdList) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("id", (Object)userId);
                    userIdJson.add(jsonObject);
                }
            }
            if (CollectionUtils.isEmpty(userIdJson)) continue;
            userIdJson.forEach(user -> user.put("type", (Object)"user"));
            targets.forEach(target -> target.put("tenantSid", (Object)tenantUser.getTenantSid()));
            JSONObject paramJson = new JSONObject();
            paramJson.put("tenantId", (Object)tenantId);
            paramJson.put("appId", (Object)application);
            paramJson.put("users", userIdJson);
            paramJson.put("targets", targets);
            log.info("iam\u81ea\u52a8\u6388\u6743header:" + JSON.toJSONString(header));
            log.info("iam\u81ea\u52a8\u6388\u6743param:" + paramJson.toJSONString());
            log.info("iam\u81ea\u52a8\u6388\u6743url:" + domain + url);
            HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)(domain + url)).addHeaders(header)).body(paramJson.toJSONString()).execute();
            log.info("iam\u81ea\u52a8\u6388\u6743response body{},status{}", (Object)response.body(), (Object)response.getStatus());
            if (response.getStatus() == 200) continue;
            throw new BusinessException("\u5f00\u542f\u7528\u6237\u6388\u6743\u5931\u8d25");
        }
    }

    public String getIntegrationToken(String tenantId) {
        return this.iamApiHelper.getIamIntegrationToken(tenantId);
    }

    private static String getServerPublicky(String domain, String appToken) {
        String uri = domain + "/api/iam/v2/identity/publickey";
        try {
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-app", appToken);
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(uri, HttpMethod.GET, httpEntity, Map.class, new Object[0]);
            return String.valueOf(((Map)response.getBody()).get("publicKey"));
        }
        catch (Exception e) {
            log.error("\u767b\u5f55\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            return "";
        }
    }

    private static String getAesPublicky(String domain, String encryptPublicKey, String appToken) {
        String uri = domain + "/api/iam/v2/identity/aeskey";
        try {
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-app", appToken);
            HashMap<String, String> requestEntity = new HashMap<String, String>(1);
            requestEntity.put("clientEncryptPublicKey", encryptPublicKey);
            HttpEntity httpEntity = new HttpEntity(requestEntity, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(uri, HttpMethod.POST, httpEntity, Map.class, new Object[0]);
            return String.valueOf(((Map)response.getBody()).get("encryptAesKey"));
        }
        catch (Exception e) {
            log.error("\u767b\u5f55\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            return "";
        }
    }

    public static HashMap<String, String> getKeyPairMap() throws NoSuchAlgorithmException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(1024);
        KeyPair keyPair = generator.generateKeyPair();
        String privateKey = new String(org.apache.commons.codec.binary.Base64.encodeBase64((byte[])keyPair.getPrivate().getEncoded(), (boolean)Boolean.FALSE));
        String publicKey = new String(org.apache.commons.codec.binary.Base64.encodeBase64((byte[])keyPair.getPublic().getEncoded(), (boolean)Boolean.FALSE));
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put("privateKey", privateKey);
        keyMap.put("publicKey", publicKey);
        return keyMap;
    }

    public static String aesEncryptByBase64(String src, String aesKey) {
        try {
            SecretKeySpec key = new SecretKeySpec(aesKey.getBytes(CHARSET), "AES");
            byte[] initParam = IV_STRING.getBytes(CHARSET);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(initParam);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)key, ivParameterSpec);
            byte[] cleartext = src.getBytes(CHARSET);
            byte[] ciphertextBytes = cipher.doFinal(cleartext);
            Base64.Encoder encoder = Base64.getEncoder();
            return encoder.encodeToString(ciphertextBytes);
        }
        catch (Exception ex) {
            log.error("AES\u52a0\u5bc6\u5931\u8d25[{}]", (Object)src);
            return src;
        }
    }

    public String getVisualToken(String appCode, String iamToken) {
        return "";
    }

    public void commonAppModuleCreate(IamAssignmentAuthorizeParam iamAssignmentAuthorizeParam, Long appSid) {
        String nameUS;
        String nameTW;
        String nameCN;
        JSONObject module = iamAssignmentAuthorizeParam.getAssignment();
        if (module == null) {
            return;
        }
        String iamUrl = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/dev/app/module";
        JSONObject param = new JSONObject();
        String token = this.getIntegrationToken(iamAssignmentAuthorizeParam.getCurrentUser().getTenantId());
        String code = module.getString("code");
        JSONObject lang = module.getJSONObject("lang");
        if (lang == null) {
            nameTW = nameCN = module.getString("name");
            nameUS = nameCN;
        } else {
            nameCN = lang.getJSONObject("name").getString("zh_CN");
            nameTW = lang.getJSONObject("name").getString("zh_TW");
            nameUS = lang.getJSONObject("name").getString("en_US");
        }
        param.put("remarks", (Object)"");
        param.put("id", (Object)code);
        param.put("nameCN", (Object)nameCN);
        param.put("nameTW", (Object)nameTW);
        param.put("nameUS", (Object)nameUS);
        param.put("appSid", (Object)appSid);
        try {
            String response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)iamUrl).body(JSON.toJSONString((Object)param)).header("digi-middleware-auth-user", token)).header("digi-middleware-auth-app", this.appToken)).execute().body();
            JSONObject responseObj = JSON.parseObject((String)response);
            Boolean success = responseObj.getBoolean("success");
            if (!success.booleanValue()) {
                log.error("\u521b\u5efa\u6a21\u7ec4\u5931\u8d25\uff0c\u53c2\u6570:{}\uff0c\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)param), (Object)response);
            }
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u6a21\u7ec4\u5931\u8d25\uff0c\u53c2\u6570:{}\uff0c\u8fd4\u56de:{}", new Object[]{JSON.toJSONString((Object)param), e.getMessage(), e});
        }
    }

    public Long getAppSid(String appCode, String tenantId) {
        String token = this.getIntegrationToken(tenantId);
        String iamUrl = this.moduleConfig.getIam().getDomain() + StrUtil.format((CharSequence)"/api/iam/v2/dev/app/id/{}", (Object[])new Object[]{appCode});
        String response = ((HttpRequest)((HttpRequest)HttpUtil.createGet((String)iamUrl).header("digi-middleware-auth-user", token)).header("digi-middleware-auth-app", this.appToken)).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        Boolean success = responseObj.getBoolean("success");
        if (!success.booleanValue()) {
            log.error("\u83b7\u53d6\u5e94\u7528sid\u5931\u8d25\uff0c\u8fd4\u56de:{}", (Object)response);
            throw new BusinessException("\u83b7\u53d6\u5e94\u7528sid\u5931\u8d25\uff0c\u521b\u5efa\u5e94\u7528\u6a21\u7ec4\u5931\u8d25!");
        }
        String appSid = responseObj.getJSONObject("data").getString("sid");
        return Long.parseLong(appSid);
    }

    public void commonmAssignmentAuthorize(IamAssignmentAuthorizeParam iamAssignmentAuthorizeParam) {
        String application = iamAssignmentAuthorizeParam.getApplication();
        JSONObject module = iamAssignmentAuthorizeParam.getAssignment();
        String token = this.getIntegrationToken(iamAssignmentAuthorizeParam.getCurrentUser().getTenantId());
        List tenantUsers = iamAssignmentAuthorizeParam.getTenantUsers();
        List tenantSids = tenantUsers.stream().map(t -> t.getTenantSid()).collect(Collectors.toList());
        ModuleConfig.Module iam = this.moduleConfig.getIam();
        String iamDomain = iam.getDomain();
        String singlePublish = "/api/iam/v2/app/action/update";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("digi-middleware-auth-app", this.appToken);
        header.put("digi-middleware-auth-user", token);
        String modelId = module.getString("modelId");
        Boolean updateCommonAction = module.getBoolean("updateCommonAction");
        String path = module.getString("path");
        String type = module.getString("type");
        for (Long tenantSid : tenantSids) {
            JSONObject jsonObject;
            JSONObject param = new JSONObject();
            if (iamAssignmentAuthorizeParam.getIndividual().booleanValue()) {
                param.put("tenantSid", (Object)tenantSid);
            } else if (updateCommonAction == null || !updateCommonAction.booleanValue()) {
                param.put("separateTenantSid", (Object)tenantSid);
            }
            param.put("appId", (Object)application);
            param.put("moduleId", (Object)module.getString("code"));
            param.put("id", (Object)module.getString("code"));
            param.put("name", (Object)module.getString("name"));
            param.put("modelId", (Object)(StringUtils.isNotBlank((CharSequence)modelId) ? modelId : ""));
            param.put("path", (Object)(StringUtils.isNotBlank((CharSequence)path) ? path : ""));
            param.put("type", (Object)(StringUtils.isNotBlank((CharSequence)type) ? type : ""));
            param.put("regardlessAuth", (Object)module.getBoolean("regardlessAuth"));
            log.info("iam\u6743\u9650\u66f4\u65b0token:" + token);
            log.info("iam\u6743\u9650\u66f4\u65b0param:" + param.toJSONString());
            log.info("iam\u6743\u9650\u66f4\u65b0url:" + iamDomain + singlePublish);
            String response = ((HttpRequest)HttpUtil.createPost((String)(iamDomain + singlePublish)).addHeaders(header)).body(JSON.toJSONString((Object)param)).timeout(30000).execute().body();
            log.info("iam\u6743\u9650\u66f4\u65b0response:" + response);
            if (NumberUtil.isNumber((CharSequence)response) || (jsonObject = JSON.parseObject((String)response)).getBoolean("success").booleanValue() && jsonObject.getInteger("code") != 500) continue;
            throw new BusinessException(Integer.valueOf(-1), response);
        }
    }

    public void iamCleanTenant(IamCleanTenantReqDto iamCleanTenantReqDto) {
        this.iamApiHelper.iamCleanTenant(iamCleanTenantReqDto);
    }

    public JSONArray getIamPublicAssignments(String application, String integrationToken) {
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("id", application);
        String url = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/sys/tree";
        log.info("iam url is {}", (Object)url);
        try {
            String response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)url).body(JSON.toJSONString(requestBody)).header("digi-middleware-auth-app", this.appToken)).header("digi-middleware-auth-user", integrationToken)).execute().body();
            if (!NumberUtil.isNumber((CharSequence)response)) {
                JSONObject jsonObject = JSON.parseObject((String)response);
                if (!jsonObject.getBoolean("success").booleanValue() || jsonObject.getInteger("code") == 500) {
                    throw new BusinessException(Integer.valueOf(-1), response);
                }
                JSONObject data = jsonObject.getJSONObject("data");
                return data.getJSONArray("modules");
            }
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u5e94\u7528\u516c\u6709\u4f5c\u4e1a\u5931\u8d25,{}", (Object)e.getMessage());
        }
        return new JSONArray();
    }

    public void iamModuleSupplement(String appCode, String tenantId, JSONArray moduleParam) {
        String curToken = this.getIntegrationToken(tenantId);
        Long appSid = this.getAppSid(appCode, tenantId);
        JSONArray appModuleAndAction = this.getAppIamModuleAndAction(appSid, curToken);
        ArrayList moduleIds = new ArrayList();
        if (CollUtil.isNotEmpty((Collection)appModuleAndAction)) {
            appModuleAndAction.forEach(module -> moduleIds.add(JSONObject.parseObject((String)JSONObject.toJSONString((Object)module)).getString("id")));
        }
        ArrayList needAddModule = new ArrayList();
        moduleParam.forEach(mp -> {
            JSONObject mpObj = JSONObject.parseObject((String)JSONObject.toJSONString((Object)mp));
            if (!moduleIds.contains(mpObj.getString("id"))) {
                mpObj.put("appSid", (Object)appSid);
                needAddModule.add(mpObj);
            }
        });
        JSONObject param = new JSONObject();
        param.put("remarks", (Object)"");
        needAddModule.forEach(module -> {
            param.putAll((Map)module);
            this.createAppModule(param, curToken, appCode);
        });
    }

    public JSONArray getAppIamModuleAndAction(Long appSid, String iamToken) {
        String path = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/dev/app/{sid}/module";
        String url = path.replace("{sid}", Long.toString(appSid));
        String response = ((HttpRequest)((HttpRequest)HttpUtil.createGet((String)url).header("digi-middleware-auth-user", iamToken)).header("digi-middleware-auth-app", this.appToken)).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        Integer code = responseObj.getInteger("code");
        if (code.equals(200)) {
            return responseObj.getJSONArray("data");
        }
        log.error("\u67e5\u8be2\u5e94\u7528sid:{}\u4e0b\u6a21\u7ec4\u53ca\u884c\u4e3a\u4fe1\u606f\u5931\u8d25,\u9519\u8bef\u4fe1\u606f:{}", (Object)appSid, (Object)response);
        throw new BusinessException("\u67e5\u8be2\u5e94\u7528\u4e0b\u6a21\u7ec4\u53ca\u884c\u4e3a\u4fe1\u606f\u5931\u8d25,\u9519\u8bef\u4fe1\u606f:" + String.valueOf(responseObj));
    }

    public void createAppModule(JSONObject param, String token, String appCode) {
        String url = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/dev/app/module";
        String moduleId = param.getString("id");
        String response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)url).body(JSON.toJSONString((Object)param)).header("digi-middleware-auth-user", token)).header("digi-middleware-auth-app", this.appToken)).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        Boolean success = responseObj.getBoolean("success");
        if (!success.booleanValue()) {
            log.error("\u521b\u5efa\u6a21\u7ec4\u5931\u8d25\uff0c\u53c2\u6570:{}\uff0c\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)param), (Object)response);
            throw new BusinessException("IAM failed to create the application module:" + moduleId + ", error message:" + responseObj.getString("errorMessage"));
        }
        log.info("IAM\u521b\u5efa\u5e94\u7528:{} \u6a21\u7ec4:{}\u6210\u529f", (Object)appCode, (Object)moduleId);
    }

    public String getTenantTeamId(String iamToken) {
        JSONObject responseObj;
        String url = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/tenant/dev/current/info";
        String response = ((HttpRequest)((HttpRequest)HttpUtil.createGet((String)url).header("digi-middleware-auth-user", iamToken)).header("digi-middleware-auth-app", this.appToken)).execute().body();
        if (response != null && (responseObj = JSON.parseObject((String)response)).getBoolean("success").booleanValue()) {
            JSONObject data = responseObj.getJSONObject("data");
            String teamId = data.getString("teamId");
            log.info("\u67e5\u8be2\u7528\u6237:{}\u7684\u56e2\u961fid\u4e3a\uff1a{}", (Object)iamToken, (Object)teamId);
            return teamId;
        }
        log.error("\u67e5\u8be2\u7528\u6237" + iamToken + "\u7684\u56e2\u961fid\u5931\u8d25\uff01\u9519\u8bef\u8fd4\u56de\uff1a" + response);
        throw new BusinessException("Failed to query the tenant's team ID, error message:" + response);
    }

    public JSONObject getAppWholeInfo(String appCode, String tenantId) {
        JSONObject responseObj;
        String url = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/sys/tree";
        JSONObject param = new JSONObject();
        param.put("id", (Object)appCode);
        String integrationToken = this.getIntegrationToken(tenantId);
        String response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)url).body(JSON.toJSONString((Object)param)).header("digi-middleware-auth-user", integrationToken)).header("digi-middleware-auth-app", this.appToken)).execute().body();
        if (response != null && (responseObj = JSON.parseObject((String)response)).getInteger("code").equals(200)) {
            JSONObject data = responseObj.getJSONObject("data");
            log.info("\u67e5\u8be2\u5e94\u7528:{}\u7684\u8be6\u7ec6\u4fe1\u606f\u4e3a\uff1a{}", (Object)appCode, (Object)data);
            return data;
        }
        log.error("\u67e5\u8be2\u5e94\u7528" + appCode + "\u7684\u4fe1\u606f\u5931\u8d25\uff01\u9519\u8bef\u8fd4\u56de\uff1a" + response);
        throw new BusinessException(appCode + "\u5e94\u7528\u67e5\u8be2\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:" + response);
    }

    public JSONArray getAppPublicActions(String appCode, String tenantId) {
        String url = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/app/action/public?appId=" + appCode;
        String integrationToken = this.getIntegrationToken(tenantId);
        String response = ((HttpRequest)((HttpRequest)HttpUtil.createGet((String)url).header("digi-middleware-auth-user", integrationToken)).header("digi-middleware-auth-app", this.appToken)).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        Boolean success = responseObj.getBoolean("success");
        if (!success.booleanValue()) {
            log.error("\u83b7\u53d6\u5e94\u7528\u516c\u5171\u4f5c\u4e1a\u5931\u8d25\uff0c\u8fd4\u56de:{}", (Object)response);
            throw new BusinessException("\u83b7\u53d6\u5e94\u7528\u516c\u5171\u4f5c\u4e1a\u5931\u8d25!");
        }
        return responseObj.getJSONArray("data");
    }

    public List<TenantInfoDto> buyApplicationTenantInfos(BuyApplicationReqDto buyApplicationReqDto) {
        return this.iamApiHelper.buyApplicationTenantInfos(buyApplicationReqDto);
    }

    public Boolean iamBatchDeletePermissions(DeletePermissionReqDto deletePermissionReqDto) {
        return this.iamApiHelper.iamBatchDeletePermissions(deletePermissionReqDto);
    }

    public JSONObject getAppActionAttribute(String appCode, String tenantId) {
        String url = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/app";
        String integrationToken = this.getIntegrationToken(tenantId);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", appCode);
        HttpResponse response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)url).body(JSON.toJSONString(param)).header("digi-middleware-auth-user", integrationToken)).header("digi-middleware-auth-app", this.appToken)).execute();
        if (!response.isOk()) {
            throw new BusinessException("\u83b7\u53d6\u5e94\u7528\u4f5c\u4e1a\u6570\u636e\u5931\u8d25!\uff0c\u8fd4\u56de:" + String.valueOf(response));
        }
        return JSONObject.parseObject((String)response.body());
    }
}

