/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.service.sd.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.athena.athena_deployer_service.config.ModuleConfig;
import com.digiwin.athena.athena_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.athena_deployer_service.domain.template.AdTemplate;
import com.digiwin.athena.athena_deployer_service.service.sd.SmartDataService;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class SmartDataServiceImpl
implements SmartDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmartDataServiceImpl.class);
    @Autowired
    @Qualifier(value="sdRestTemplate")
    RestTemplate restTemplate;
    @Autowired
    ModuleConfig moduleConfig;
    @Value(value="${adTemplate.routerKey}")
    private String routerKey;

    public void publish(String token, Boolean needRouterKey, String tenantId, AdTemplate adTemplate) {
        String url = this.moduleConfig.getSd().getDomain() + "/restful/standard/scdispatcher/template/publish";
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Content-Type", "application/json");
        httpHeaders.put("token", token);
        if (needRouterKey != null && needRouterKey.booleanValue()) {
            httpHeaders.put("routerKey", this.routerKey);
        }
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("tenantId", tenantId);
        body.put("dsl", (String)adTemplate);
        log.info("publishScDispatcherTemplate url:{}", (Object)url);
        log.info("publishScDispatcherTemplate body:{}", body);
        String response = ((HttpRequest)HttpUtil.createPost((String)url).addHeaders(httpHeaders)).body(JSON.toJSONString(body, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        log.info("publishScDispatcherTemplate response:{}", (Object)responseObj);
        Integer status = responseObj.getInteger("status");
        if (status != null && status == 500) {
            log.error("\u670d\u52a1\u7f16\u6392\u53d1\u5e03\u5931\u8d25\uff1a" + response);
            throw new BusinessException(responseObj.getString("errorMessage"));
        }
    }

    public void batchPublish(String token, List<String> tenantIds, AdTemplate adTemplate) {
        String url = this.moduleConfig.getSd().getDomain() + "/restful/standard/scdispatcher/template/batchPublish";
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Content-Type", "application/json");
        httpHeaders.put("token", token);
        httpHeaders.put("routerKey", this.routerKey);
        HashMap<String, List<String>> body = new HashMap<String, List<String>>();
        body.put("tenantIds", tenantIds);
        body.put("dsl", (List<String>)adTemplate);
        log.info("batch publishScDispatcherTemplate url:{}", (Object)url);
        log.info("batch publishScDispatcherTemplate body:{}", body);
        String response = ((HttpRequest)HttpUtil.createPost((String)url).addHeaders(httpHeaders)).body(JSON.toJSONString(body, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        log.info("batch publishScDispatcherTemplate response:{}", (Object)responseObj);
        Integer status = responseObj.getInteger("status");
        if (status != null && status == 500) {
            log.error("\u670d\u52a1\u7f16\u6392\u53d1\u5e03\u5931\u8d25\uff1a" + response);
            throw new BusinessException(responseObj.getString("errorMessage"));
        }
    }

    public void batchDisable(String token, List<String> tenantIds, AdTemplate adTemplate) {
        String url = this.moduleConfig.getSd().getDomain() + "/restful/standard/scdispatcher/template/batchDisableTemplateAllVersion";
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Content-Type", "application/json");
        httpHeaders.put("token", token);
        httpHeaders.put("routerKey", this.routerKey);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("tenantIds", tenantIds);
        body.put("templateId", adTemplate.getId());
        log.info("batch disableTemplateAllVersion url:{}", (Object)url);
        log.info("batch disableTemplateAllVersion body:{}", body);
        String response = ((HttpRequest)HttpUtil.createPost((String)url).addHeaders(httpHeaders)).body(JSON.toJSONString(body, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        log.info("batch disableTemplateAllVersion response:{}", (Object)responseObj);
        Integer status = responseObj.getInteger("status");
        if (status != null && status == 500) {
            log.error("\u670d\u52a1\u7f16\u6392 \u5220\u9664\u79df\u6237\u7ea7 \u5931\u8d25\uff1a" + response);
            throw new BusinessException(responseObj.getString("errorMessage"));
        }
    }

    public void publishV2(String token, Boolean needRouterKey, String tenantId, AdTemplate adTemplate, Integer isCustom) {
        String url = this.moduleConfig.getSd().getDomain() + "/restful/standard/scdispatcher/template/publishV2";
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Content-Type", "application/json");
        httpHeaders.put("token", token);
        if (needRouterKey != null && needRouterKey.booleanValue()) {
            httpHeaders.put("routerKey", this.routerKey);
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("tenantId", tenantId);
        body.put("dsl", adTemplate);
        body.put("isCustom", isCustom);
        log.info("publishScDispatcherTemplate url:{}", (Object)url);
        log.info("publishScDispatcherTemplate body:{}", body);
        String response = ((HttpRequest)HttpUtil.createPost((String)url).addHeaders(httpHeaders)).body(JSON.toJSONString(body, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        log.info("publishScDispatcherTemplate response:{}", (Object)responseObj);
        Integer status = responseObj.getInteger("status");
        if (status != null && status == 500) {
            log.error("\u670d\u52a1\u7f16\u6392\u53d1\u5e03\u5931\u8d25\uff1a" + response);
            throw new BusinessException(responseObj.getString("errorMessage"));
        }
    }

    public void batchPublishV2(String token, List<String> tenantIds, AdTemplate adTemplate, Integer isCustom) {
        String url = this.moduleConfig.getSd().getDomain() + "/restful/standard/scdispatcher/template/batchPublishV2";
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Content-Type", "application/json");
        httpHeaders.put("token", token);
        httpHeaders.put("routerKey", this.routerKey);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("tenantIds", tenantIds);
        body.put("dsl", adTemplate);
        body.put("isCustom", isCustom);
        log.info("batch publishScDispatcherTemplate url:{}", (Object)url);
        log.info("batch publishScDispatcherTemplate body:{}", body);
        String response = ((HttpRequest)HttpUtil.createPost((String)url).addHeaders(httpHeaders)).body(JSON.toJSONString(body, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        log.info("batch publishScDispatcherTemplate response:{}", (Object)responseObj);
        Integer status = responseObj.getInteger("status");
        if (status != null && status == 500) {
            log.error("\u670d\u52a1\u7f16\u6392\u53d1\u5e03\u5931\u8d25\uff1a" + response);
            throw new BusinessException(responseObj.getString("errorMessage"));
        }
    }

    public void batchDisableV2(String token, List<String> tenantIds, AdTemplate adTemplate, Integer isCustom) {
        String url = this.moduleConfig.getSd().getDomain() + "/restful/standard/scdispatcher/template/batchDisableTemplateAllVersionV2";
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Content-Type", "application/json");
        httpHeaders.put("token", token);
        httpHeaders.put("routerKey", this.routerKey);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("tenantIds", tenantIds);
        body.put("templateId", adTemplate.getId());
        body.put("isCustom", isCustom);
        log.info("batch disableTemplateAllVersion url:{}", (Object)url);
        log.info("batch disableTemplateAllVersion body:{}", body);
        String response = ((HttpRequest)HttpUtil.createPost((String)url).addHeaders(httpHeaders)).body(JSON.toJSONString(body, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        log.info("batch disableTemplateAllVersion response:{}", (Object)responseObj);
        Integer status = responseObj.getInteger("status");
        if (status != null && status == 500) {
            log.error("\u670d\u52a1\u7f16\u6392 \u5220\u9664\u79df\u6237\u7ea7 \u5931\u8d25\uff1a" + response);
            throw new BusinessException(responseObj.getString("errorMessage"));
        }
    }
}

