/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.athena_deployer_service.util;

import com.alibaba.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisCache {
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public void set(String key, Object value, long expire) {
        if (expire > 0L) {
            this.redisTemplate.opsForValue().set((Object)key, (Object)this.toJson(value), expire);
        } else {
            this.redisTemplate.opsForValue().set((Object)key, (Object)this.toJson(value));
        }
    }

    public void set(String partition, String key, Object value, long expire) {
        key = partition + ":" + (String)key;
        this.set((String)key, value, expire);
    }

    public void set(String key, Object value) {
        this.set(key, value, 0L);
    }

    public void set(String partition, String key, Object value) {
        key = partition + ":" + (String)key;
        this.set((String)key, value, 0L);
    }

    public Object get(String key) {
        Object obj = this.redisTemplate.opsForValue().get((Object)key);
        return obj;
    }

    public <T> T get(String key, Class<T> clazz) {
        Object obj = this.redisTemplate.opsForValue().get((Object)key);
        return (T)(obj == null ? null : this.fromJson(String.valueOf(obj), clazz));
    }

    public <T> T get(String partition, String key, Class<T> clazz) {
        key = partition + ":" + (String)key;
        return (T)this.get((String)key, clazz);
    }

    public void delete(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public void delete(String partition, String key) {
        key = partition + ":" + (String)key;
        this.delete((String)key);
    }

    private String toJson(Object object) {
        if (object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Boolean || object instanceof String) {
            return String.valueOf(object);
        }
        return JSON.toJSONString((Object)object);
    }

    private <T> T fromJson(String json, Class<T> clazz) {
        return (T)JSON.parseObject((String)json, clazz);
    }
}

