/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.application.service.restful.ptm;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.application.service.restful.ptm.ErrorCodeQEnum;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Service
public class HttpAssistantQServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(HttpAssistantQServiceImpl.class);
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private MessageUtils messageUtils;

    public <T> T post(TypeReference<T> responseType, String url, HttpHeaders headers, Object body) {
        Object result = null;
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Object>>(){}, new Object[]{body});
            if (((BaseResultDTO)responseEntity.getBody()).getResponseWithException("") != null) {
                String json = JsonUtils.objectToString((Object)((BaseResultDTO)responseEntity.getBody()).getResponse());
                result = JsonUtils.jsonToObject((String)json, responseType);
            }
        }
        catch (ResourceAccessException e) {
            BusinessException exception = BusinessException.create((Throwable)e);
            exception.setCode(Integer.valueOf(599));
            exception.setErrorCode(ErrorCodeQEnum.ATMC_OUTER_ACCESS_ERROR.getErrCode());
            exception.setErrorMessage((Object)this.messageUtils.getMessage(ErrorCodeQEnum.ATMC_OUTER_ACCESS_NETWORK_ERROR.getErrCode()));
            exception.setDescription(this.getExceptionDescription(e.getMessage(), url, body));
            throw exception;
        }
        catch (Exception e) {
            BusinessException exception = BusinessException.create((Throwable)e);
            exception.setCode(Integer.valueOf(599));
            exception.setErrorCode(ErrorCodeQEnum.ATMC_OUTER_ACCESS_NETWORK_ERROR.getErrCode());
            exception.setErrorMessage((Object)this.messageUtils.getMessage(ErrorCodeQEnum.ATMC_OUTER_ACCESS_NETWORK_ERROR.getErrCode()));
            exception.setDescription(this.getExceptionDescription(e.getMessage(), url, body));
            throw exception;
        }
        return (T)result;
    }

    private String getExceptionDescription(Object errorMessage, String url, Object body) {
        HashMap<String, Object> description = new HashMap<String, Object>();
        description.put("uri", url);
        description.put("body", body);
        description.put("errorMessage", errorMessage);
        return JsonUtils.objectToString(description);
    }
}

