/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.application.service.restful.ptm.impl;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.application.service.restful.ptm.HttpAssistantQServiceImpl;
import com.digiwin.athena.atmc.application.service.restful.ptm.PtmQService;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.PtmBacklogItemBO;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.PtmProjectRecordBO;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.PtmTaskCardItemBO;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.PtmTaskRecordBO;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class PtmQServiceImpl
implements PtmQService {
    @Autowired
    EnvProperties envProperties;
    @Autowired
    HttpAssistantQServiceImpl httpAssistantService;
    @Autowired
    RestTemplate restTemplate;

    @Override
    public List<PtmTaskCardItemBO> queryTaskCardList(List<String> userIds) {
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("userIds", userIds);
        return this.reqPtmTaskCard(rootPara, "api/task/card/processing/list");
    }

    private List<PtmTaskCardItemBO> reqPtmTaskCard(Map<String, Object> params, String reqUrl) {
        List<PtmTaskCardItemBO> result = null;
        String url = this.envProperties.getPtmUri() + reqUrl;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        result = this.httpAssistantService.post(new TypeReference<List<PtmTaskCardItemBO>>(){}, url, headers, params);
        if (result == null) {
            result = new ArrayList<PtmTaskCardItemBO>();
        }
        return result;
    }

    @Override
    public List<PtmProjectRecordBO> getProjectRecordByProjectIdsV2(List<Long> projectIds, boolean needData) {
        String url = this.envProperties.getPtmUri() + "api/data/project/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("idList", projectIds);
        rootPara.put("needData", needData);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmProjectRecordBO>>>(){}, rootPara);
        List result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmTaskRecordBO> getTaskRecordByTaskIds(List<Long> taskIds) {
        String url = this.envProperties.getPtmUri() + "api/data/task/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("idList", taskIds);
        rootPara.put("needData", false);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmTaskRecordBO>>>(){}, rootPara);
        List result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmBacklogItemBO> getBacklogByBacklogIds(List<Long> backlogIdList) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/task/list/batch";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("backlogIds", backlogIdList);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmBacklogItemBO>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmTaskCardItemBO> queryTaskCardListByBacklogId(List<Long> backlogIdList) {
        ArrayList result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/processing/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        HashMap<String, List<Long>> rootPara = new HashMap<String, List<Long>>();
        rootPara.put("backlogIds", backlogIdList);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmTaskCardItemBO>>>(){}, rootPara);
        result = (ArrayList)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }
}

