/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.application.service.query.backlog;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.application.dto.response.eoc.ProxyUserResp;
import com.digiwin.athena.atmc.application.dto.response.task.TaskCardResp;
import com.digiwin.athena.atmc.application.service.restful.eoc.EocQService;
import com.digiwin.athena.atmc.core.meta.constants.GlobalConstant;
import com.digiwin.athena.atmc.infrastructure.mapper.biz.migration.BacklogMapper;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.BacklogBO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BpmTodoBacklogQueryCountingQryService {
    private static final Logger log = LoggerFactory.getLogger(BpmTodoBacklogQueryCountingQryService.class);
    @Autowired
    EocQService eocService;
    @Autowired
    private BacklogMapper backlogMapper;
    @Autowired
    EnvProperties envProperties;

    public List<TaskCardResp> getBacklogListByTenantIdAndUserIdAndCode(AuthoredUser user, String clientId) {
        List<BacklogBO> backlogList = this.queryByNotClosedAndActivityId(user);
        if (CollectionUtils.isEmpty(backlogList)) {
            return new ArrayList<TaskCardResp>();
        }
        return this.getBacklogList(clientId, backlogList);
    }

    public List<TaskCardResp> getBacklogList(String clientId, List<BacklogBO> backlogList) {
        ArrayList<TaskCardResp> list = new ArrayList<TaskCardResp>();
        backlogList.forEach(backlog -> {
            TaskCardResp taskCardDTO = TaskCardResp.builder().backlogId(backlog.getWorkItemId()).submitId(backlog.getSubmitId()).uri(this.envProperties.getWebUri() + "task/detail/" + backlog.getWorkItemId() + "?targetTenantId=" + backlog.getTargetTenantId()).name(backlog.getName()).subName(backlog.getSubName()).projectName(backlog.getTaskName()).projectTargetName(backlog.getTaskTargetName()).projectStartTime(backlog.getTaskStartTime()).projectEndTime(backlog.getTaskEndTime()).projectImportance(backlog.isImportance()).importance(backlog.isImportance()).content(backlog.getContent()).importanceReadOnly(backlog.isImportanceReadOnly()).startTime(backlog.getStartTime()).endTime(backlog.getEndTime()).tmTaskId(backlog.getTmTaskId()).tmActivityId(backlog.getTmActivityId()).type(backlog.getType()).tenantId(backlog.getTenantId()).targetTenantId(backlog.getTargetTenantId()).actionDefined(backlog.isActionDefined()).tmPattern(backlog.getTmPattern()).tmCategory(backlog.getTmCategory()).isOwner(backlog.getIsOwner()).ownerUserId(backlog.getOwnerUserId()).ownerUserName(backlog.getOwnerUserName()).readCount(backlog.getReadCount()).exception(null != backlog.getException() ? backlog.getException() : false).overdue(null != backlog.getOverdue() ? backlog.getOverdue() : false).overdueMinutes(null != backlog.getOverdueMinutes() ? backlog.getOverdueMinutes() : 0).overdueHours(null != backlog.getOverdueHours() ? backlog.getOverdueHours() : 0).overdueDays(null != backlog.getOverdueDays() ? backlog.getOverdueDays() : 0).approvalState(backlog.getApprovalState()).approvalStateCode(backlog.getApprovalStateCode()).modifyDate(backlog.getModifyDate()).emergency(backlog.isEmergency()).eocCode(backlog.getEocCode()).eocName(backlog.getEocName()).eocType(backlog.getEocType()).agentBeginDate(backlog.getAgentBeginDate()).agentEndDate(backlog.getAgentEndDate()).sourceTenantName(backlog.getSourceTenantName()).proxyToken(backlog.getProxyToken()).finishActionId(backlog.getFinishActionId()).tmActivityName(backlog.getTmActivityName()).summary(backlog.getSummary()).historyMessage(backlog.getHistoryMessage()).searchMessage(backlog.getSearchMessage()).dataFrom(backlog.getDataFrom()).merge(backlog.getMerge()).planEndTimeMin(backlog.getPlanEndTimeMin()).planEndTimeMax(backlog.getPlanEndTimeMax()).dataChangeRead(backlog.getDataChangeRead() != null && backlog.getDataChangeRead() == 0).groupId(backlog.getGroupId()).engineType(backlog.getEngineType()).closedTime(backlog.getClosedTime()).createTime(backlog.getCreateTime()).hasAppPermission(true).build();
            list.add(taskCardDTO);
        });
        return list;
    }

    private List<BacklogBO> queryByNotClosedAndActivityId(AuthoredUser user) {
        List<ProxyUserResp> proxyUserResps;
        ArrayList<String> userIdList = new ArrayList<String>();
        userIdList.add(user.getUserId());
        List<BacklogBO> backlogBOS = this.queryByNotClosedAndActivityId(user.getTenantId(), userIdList);
        if (!CollectionUtils.isEmpty(backlogBOS)) {
            for (BacklogBO backlogBO : backlogBOS) {
                backlogBO.setIsOwner(Boolean.valueOf(true));
                backlogBO.setOwnerUserId(user.getUserId());
                backlogBO.setOwnerUserName(user.getUserName());
            }
        }
        if (StringUtils.hasText((String)user.getToken()) && !CollectionUtils.isEmpty(proxyUserResps = this.eocService.getProxyTargetUsers(user.getUserId(), user.getToken()))) {
            userIdList.clear();
            for (ProxyUserResp proxyUserResp : proxyUserResps) {
                if (Objects.equals(proxyUserResp.getUserId(), user.getUserId())) continue;
                userIdList.add(proxyUserResp.getUserId());
            }
            if (!CollectionUtils.isEmpty(userIdList)) {
                List<BacklogBO> list = this.queryByNotClosedAndActivityId(user.getTenantId(), userIdList);
                backlogBOS.addAll(list);
            }
        }
        return backlogBOS;
    }

    private List<BacklogBO> queryByNotClosedAndActivityId(String tenantId, List<String> userIds) {
        String nowTime = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now());
        List backlogBOS = this.backlogMapper.selectByNotClosedAndUserId(userIds, tenantId, nowTime);
        this.setBacklogQueryResultSet(backlogBOS);
        return backlogBOS;
    }

    public void setBacklogQueryResultSet(List<BacklogBO> backlogBOS) {
        if (CollectionUtils.isEmpty(backlogBOS)) {
            return;
        }
        for (BacklogBO backlogBO : backlogBOS) {
            if (backlogBO.getOverdueWorkitemId() != null && backlogBO.getOverdueWorkitemId() > 0L) {
                if (Objects.equals(backlogBO.getDataFrom(), "PTM")) continue;
                backlogBO.setOverdue(Boolean.valueOf(false));
                backlogBO.setOverdueDays(Integer.valueOf(0));
                backlogBO.setOverdueHours(Integer.valueOf(0));
                backlogBO.setOverdueMinutes(Integer.valueOf(0));
                backlogBO.setEndTime(LocalDateTime.now().plusMonths(1L));
                continue;
            }
            if (!GlobalConstant.DATA_UNIFORMITY_BACKLOG_TYPE.equals(backlogBO.getType())) continue;
            backlogBO.setOverdue(Boolean.valueOf(false));
            backlogBO.setOverdueDays(Integer.valueOf(0));
            backlogBO.setOverdueHours(Integer.valueOf(0));
            backlogBO.setOverdueMinutes(Integer.valueOf(0));
            backlogBO.setEndTime(LocalDateTime.now().plusMonths(1L));
        }
    }
}

