/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.application.service.query.backlog.impl;

import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.application.service.query.backlog.PtmTransformQueryCountingQryService;
import com.digiwin.athena.atmc.application.service.restful.ptm.PtmQService;
import com.digiwin.athena.atmc.application.utils.SummaryMessagesUtils;
import com.digiwin.athena.atmc.core.meta.enums.ActivityStateEnum;
import com.digiwin.athena.atmc.core.meta.enums.BpmEngineCategoryEnum;
import com.digiwin.athena.atmc.core.meta.enums.ptm.PtmBacklogTypeEnum;
import com.digiwin.athena.atmc.infrastructure.mapper.biz.migration.PtmBacklogMapper;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.BacklogBO;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.PtmBacklogBO;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.PtmBacklogItemBO;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.PtmMergeBacklogBO;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.PtmProjectRecordBO;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.PtmTaskCardItemBO;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.PtmTaskRecordBO;
import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.PtmBacklog;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PtmTransformQueryCountingQryServiceImpl
implements PtmTransformQueryCountingQryService {
    private static final Logger log = LoggerFactory.getLogger(PtmTransformQueryCountingQryServiceImpl.class);
    @Autowired
    EnvProperties envProperties;
    @Autowired
    PtmBacklogMapper ptmBacklogMapper;
    @Autowired
    PtmQService ptmService;

    @Override
    public boolean enablePTM() {
        return StringUtils.isNotBlank((String)this.envProperties.getPtmUri());
    }

    @Override
    public List<BacklogBO> queryBacklogList(String tenantId, String userId) {
        ArrayList<BacklogBO> result = new ArrayList<BacklogBO>();
        if (!this.enablePTM()) {
            return result;
        }
        return this.queryBacklogList(tenantId, Arrays.asList(userId));
    }

    @Override
    public List<BacklogBO> queryBacklogList(String tenantId, List<String> userIds) {
        ArrayList<BacklogBO> result = new ArrayList<BacklogBO>();
        if (!this.enablePTM()) {
            return result;
        }
        List<PtmTaskCardItemBO> ptmTaskCardItemBOList = this.ptmService.queryTaskCardList(userIds);
        result.addAll(this.dealBacklogList(ptmTaskCardItemBOList));
        List overdueList = this.ptmBacklogMapper.selectNoFinishedOverdue(tenantId, userIds);
        result.addAll(this.dealOverdueBacklog(overdueList));
        List exceptionList = this.ptmBacklogMapper.selectNoFinishedException(tenantId, userIds);
        result.addAll(this.dealExceptionData(exceptionList));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(result)) {
            result.stream().forEach(backLog -> backLog.setDataFrom("PTM"));
        }
        return result;
    }

    public List<BacklogBO> dealExceptionData(List<PtmBacklogBO> exceptionList) {
        ArrayList<BacklogBO> result = new ArrayList<BacklogBO>();
        if (CollectionUtils.isNotEmpty(exceptionList)) {
            List<PtmProjectRecordBO> ptmProjectRecordList = this.ptmService.getProjectRecordByProjectIdsV2(exceptionList.stream().map(PtmBacklog::getProjectId).distinct().collect(Collectors.toList()), false);
            List<PtmTaskRecordBO> ptmTaskRecordList = this.ptmService.getTaskRecordByTaskIds(exceptionList.stream().map(PtmBacklog::getTaskId).distinct().collect(Collectors.toList()));
            exceptionList.forEach(exception -> {
                PtmTaskRecordBO ptmTaskRecordBO = ptmTaskRecordList.stream().filter(x -> Objects.equals(x.getId(), exception.getTaskId())).findFirst().get();
                PtmProjectRecordBO ptmProjectRecordBO = ptmProjectRecordList.stream().filter(x -> Objects.equals(x.getId(), exception.getProjectId())).findFirst().get();
                BacklogBO bl = BacklogBO.builder().id(exception.getBacklogId()).submitId(exception.getSubmitId()).name("{\"zh_TW\":\"\u696d\u52d9\u6578\u64da\u4e0d\u4e00\u81f4\u7570\u5e38\u6392\u9664\",\"en_US\":\"Abnormal Exclude\",\"zh_CN\":\"\u4e1a\u52a1\u6570\u636e\u4e0d\u4e00\u81f4\u5f02\u5e38\u6392\u9664\"}").subName(ptmTaskRecordBO.getTaskName()).taskName(ptmProjectRecordBO.getProjectName()).taskTargetName(null).taskStartTime(ptmProjectRecordBO.getStartTime()).taskEndTime(ptmProjectRecordBO.getEndTime()).taskImportance(ptmProjectRecordBO.getImportance().booleanValue()).importance(exception.getFavorite() > 0).content(ptmTaskRecordBO.getTaskName()).importanceReadOnly(false).importanceSource(null).uri(null).startTime(ptmTaskRecordBO.getCreateTime()).endTime(LocalDateTime.now().plusMonths(1L)).tmTaskId(ptmProjectRecordBO.getProjectDefCode()).tmActivityId(ptmTaskRecordBO.getTaskDefCode()).type(SummaryMessagesUtils.translateBacklogType(exception.getType())).tenantId(ptmTaskRecordBO.getTenantId()).actionDefined(true).bpmActivityId(ptmTaskRecordBO.getId()).tmPattern(ptmTaskRecordBO.getTaskDefPattern()).tmCategory(ptmTaskRecordBO.getTaskDefCategory()).checkItems(null).operation(null).summaryLayout(null).summaryLayoutStr(null).error(null).isOwner(Boolean.valueOf(true)).performerId(exception.getPerformerId()).performerName(exception.getPerformerName()).ownerUserId(exception.getPerformerId()).ownerUserName(exception.getPerformerName()).readCount(exception.getReadCount()).exception(ptmTaskRecordBO.getHasException()).overdue(Boolean.valueOf(false)).overdueDays(Integer.valueOf(0)).overdueHours(Integer.valueOf(0)).overdueMinutes(Integer.valueOf(0)).reassignFromId(Long.valueOf(0L)).approvalState(exception.getApprovalState()).todoItems(null).emergency(ptmProjectRecordBO.getEmergency() == 25).eocCode(ptmProjectRecordBO.getEocCode()).eocName(ptmProjectRecordBO.getEocName()).eocType(ptmProjectRecordBO.getEocType()).processSerialNumber(ptmTaskRecordBO.getProcessSerialNumber()).agentBeginDate(null).agentBeginDate(null).overdueWorkitemId(exception.getOverdueBacklogId()).sourceTenantName(StringUtils.equalsIgnoreCase((String)exception.getTenantId(), (String)exception.getTargetTenantId()) ? null : exception.getTenantName()).workItemId(exception.getBacklogId()).proxyToken(ptmTaskRecordBO.getProxyToken()).historyMessage(null).finishActionId(exception.getClosed() != false ? exception.getActionId() : null).tmActivityName(ptmTaskRecordBO.getTaskDefName()).dataFrom("PTM").summary(exception.getSummary()).historyMessage(exception.getHistoryMessage()).searchMessage(exception.getSearchMessage()).engineType(BpmEngineCategoryEnum.TaskEngine.getValue()).closedTime(ptmTaskRecordBO.getClosedTime()).createTime(ptmTaskRecordBO.getCreateTime()).targetTenantId(exception.getTargetTenantId()).hasAppPermission(this.checkByType(exception.getType())).build();
                result.add(bl);
            });
        }
        return result;
    }

    public List<BacklogBO> dealOverdueBacklog(List<PtmBacklogBO> overdueList) {
        ArrayList<BacklogBO> result = new ArrayList<BacklogBO>();
        if (CollectionUtils.isNotEmpty(overdueList)) {
            List<PtmProjectRecordBO> ptmProjectRecordList = this.ptmService.getProjectRecordByProjectIdsV2(overdueList.stream().map(PtmBacklog::getProjectId).distinct().collect(Collectors.toList()), false);
            List<PtmTaskRecordBO> ptmTaskRecordList = this.ptmService.getTaskRecordByTaskIds(overdueList.stream().map(PtmBacklog::getTaskId).distinct().collect(Collectors.toList()));
            overdueList.forEach(overdue -> {
                PtmTaskRecordBO ptmTaskRecordBO = ptmTaskRecordList.stream().filter(x -> Objects.equals(x.getId(), overdue.getTaskId())).findFirst().get();
                PtmProjectRecordBO ptmProjectRecordBO = ptmProjectRecordList.stream().filter(x -> Objects.equals(x.getId(), overdue.getProjectId())).findFirst().get();
                BacklogBO bl = BacklogBO.builder().id(overdue.getBacklogId()).submitId(overdue.getSubmitId()).name("{\"zh_TW\":\"\u903e\u6642\u8655\u7406\",\"en_US\":\"Overtime Process\",\"zh_CN\":\"\u903e\u65f6\u5904\u7406\"}").subName(ptmTaskRecordBO.getTaskName()).taskName(ptmProjectRecordBO.getProjectName()).taskTargetName(null).taskStartTime(ptmProjectRecordBO.getStartTime()).taskEndTime(ptmProjectRecordBO.getEndTime()).taskImportance(ptmProjectRecordBO.getImportance().booleanValue()).importance(overdue.getFavorite() > 0).content(ptmTaskRecordBO.getTaskName()).importanceReadOnly(false).importanceSource(null).uri(null).startTime(ptmTaskRecordBO.getCreateTime()).endTime(LocalDateTime.now().plusMonths(1L)).tmTaskId(ptmProjectRecordBO.getProjectDefCode()).tmActivityId(ptmTaskRecordBO.getTaskDefCode()).type(SummaryMessagesUtils.translateBacklogType(overdue.getType())).tenantId(ptmTaskRecordBO.getTenantId()).actionDefined(true).bpmActivityId(ptmTaskRecordBO.getId()).tmPattern(ptmTaskRecordBO.getTaskDefPattern()).tmCategory(ptmTaskRecordBO.getTaskDefCategory()).checkItems(null).operation(null).summaryLayout(null).summaryLayoutStr(null).error(null).isOwner(Boolean.valueOf(true)).performerId(overdue.getPerformerId()).performerName(overdue.getPerformerName()).ownerUserId(overdue.getPerformerId()).ownerUserName(overdue.getPerformerName()).readCount(overdue.getReadCount()).exception(ptmTaskRecordBO.getHasException()).overdue(Boolean.valueOf(false)).overdueDays(Integer.valueOf(0)).overdueHours(Integer.valueOf(0)).overdueMinutes(Integer.valueOf(0)).reassignFromId(Long.valueOf(0L)).approvalState(overdue.getApprovalState()).todoItems(null).emergency(ptmProjectRecordBO.getEmergency() == 25).eocCode(ptmProjectRecordBO.getEocCode()).eocName(ptmProjectRecordBO.getEocName()).eocType(ptmProjectRecordBO.getEocType()).processSerialNumber(ptmTaskRecordBO.getProcessSerialNumber()).agentBeginDate(null).agentBeginDate(null).overdueWorkitemId(overdue.getOverdueBacklogId()).sourceTenantName(StringUtils.equalsIgnoreCase((String)overdue.getTenantId(), (String)overdue.getTargetTenantId()) ? null : overdue.getTenantName()).workItemId(overdue.getBacklogId()).proxyToken(ptmTaskRecordBO.getProxyToken()).historyMessage(null).finishActionId(overdue.getClosed() != false ? overdue.getActionId() : null).tmActivityName(ptmTaskRecordBO.getTaskDefName()).dataFrom("PTM").summary(overdue.getSummary()).historyMessage(overdue.getHistoryMessage()).searchMessage(overdue.getSearchMessage()).dataChangeRead(overdue.getDataChangeRead()).engineType(BpmEngineCategoryEnum.TaskEngine.getValue()).closedTime(ptmTaskRecordBO.getClosedTime()).createTime(ptmTaskRecordBO.getCreateTime()).targetTenantId(overdue.getTargetTenantId()).hasAppPermission(this.checkByType(overdue.getType())).build();
                result.add(bl);
            });
        }
        return result;
    }

    public List<BacklogBO> dealBacklogList(List<PtmTaskCardItemBO> ptmTaskCardItemBOList) {
        ArrayList<BacklogBO> result = new ArrayList<BacklogBO>();
        if (CollectionUtils.isNotEmpty(ptmTaskCardItemBOList)) {
            List backlogIdList = ptmTaskCardItemBOList.stream().map(PtmTaskCardItemBO::getBacklogId).distinct().collect(Collectors.toList());
            boolean backlogIdListIsEmpty = CollectionUtils.isEmpty(backlogIdList);
            if (!backlogIdListIsEmpty) {
                Collections.sort(backlogIdList);
            }
            List ptmBacklogList = this.ptmBacklogMapper.selectByBacklogIds(backlogIdList, backlogIdListIsEmpty ? null : (Long)backlogIdList.get(0), backlogIdListIsEmpty ? null : (Long)backlogIdList.get(backlogIdList.size() - 1));
            List<PtmProjectRecordBO> ptmProjectRecordList = this.ptmService.getProjectRecordByProjectIdsV2(ptmTaskCardItemBOList.stream().map(PtmTaskCardItemBO::getProjectId).distinct().collect(Collectors.toList()), false);
            List<PtmTaskRecordBO> ptmTaskRecordList = this.ptmService.getTaskRecordByTaskIds(ptmTaskCardItemBOList.stream().map(PtmTaskCardItemBO::getTaskId).distinct().collect(Collectors.toList()));
            Map<Long, PtmMergeBacklogBO> mergeBacklogMap = this.getMergeBacklogData(ptmTaskCardItemBOList);
            for (PtmTaskCardItemBO ptmTaskCardItemBO : ptmTaskCardItemBOList) {
                Optional<PtmBacklogBO> ptmBacklogOptional;
                Optional<PtmProjectRecordBO> ptmProjectRecordOption = ptmProjectRecordList.stream().filter(x -> Objects.equals(x.getId(), ptmTaskCardItemBO.getProjectId())).findFirst();
                PtmProjectRecordBO ptmProjectRecordBO = ptmProjectRecordOption.orElseGet(ptmProjectRecordOption::get);
                Optional<PtmTaskRecordBO> ptmTaskRecordOption = ptmTaskRecordList.stream().filter(x -> Objects.equals(x.getId(), ptmTaskCardItemBO.getTaskId())).findFirst();
                PtmTaskRecordBO ptmTaskRecord = ptmTaskRecordOption.orElseGet(ptmTaskRecordOption::get);
                PtmBacklogBO ptmBacklog = new PtmBacklogBO();
                if (CollectionUtils.isNotEmpty((Collection)ptmBacklogList) && (ptmBacklogOptional = ptmBacklogList.stream().filter(x -> Objects.equals(x.getBacklogId(), ptmTaskCardItemBO.getBacklogId())).findFirst()).isPresent()) {
                    ptmBacklog = ptmBacklogOptional.get();
                }
                PtmMergeBacklogBO ptmMergeBacklogBO = mergeBacklogMap.get(ptmTaskCardItemBO.getBacklogId());
                BacklogBO bl = BacklogBO.builder().id(ptmTaskCardItemBO.getBacklogId()).submitId(ptmBacklog.getSubmitId()).name(ptmTaskCardItemBO.getTaskName()).subName(null).taskName(ptmProjectRecordBO.getProjectName()).taskTargetName(null).taskStartTime(ptmProjectRecordBO.getStartTime()).taskEndTime(ptmProjectRecordBO.getEndTime()).taskImportance(ptmProjectRecordBO.getImportance().booleanValue()).importance(ptmBacklog.getFavorite() > 0).content(ptmTaskCardItemBO.getTaskName()).importanceReadOnly(false).importanceSource(null).uri(null).startTime(ptmTaskCardItemBO.getCreateTime()).endTime(ptmTaskCardItemBO.getPlanEndTime()).tmTaskId(ptmProjectRecordBO.getProjectDefCode()).tmActivityId(ptmTaskCardItemBO.getTaskDefCode()).type(SummaryMessagesUtils.translateBacklogType(ptmBacklog.getType())).tenantId(StringUtils.isBlank((String)ptmTaskCardItemBO.getFromTenantId()) ? ptmTaskCardItemBO.getTenantId() : ptmTaskCardItemBO.getFromTenantId()).targetTenantId(StringUtils.isBlank((String)ptmTaskCardItemBO.getTenantId()) ? ptmTaskCardItemBO.getFromTenantId() : ptmTaskCardItemBO.getTenantId()).actionDefined(true).bpmActivityId(ptmTaskCardItemBO.getTaskId()).tmPattern(ptmTaskCardItemBO.getTaskDefPattern()).tmCategory(ptmTaskCardItemBO.getTaskDefCategory()).checkItems(null).operation(null).summaryLayout(null).summaryLayoutStr(null).error(null).isOwner(Boolean.valueOf(true)).performerId(ptmTaskCardItemBO.getPerformerId()).performerName(ptmTaskCardItemBO.getPerformerName()).ownerUserId(ptmTaskCardItemBO.getPerformerId()).ownerUserName(ptmTaskCardItemBO.getPerformerName()).readCount(ptmBacklog.getReadCount()).exception(ptmTaskRecord.getHasException()).overdue(Boolean.valueOf(false)).overdueDays(Integer.valueOf(0)).overdueHours(Integer.valueOf(0)).overdueMinutes(Integer.valueOf(0)).reassignFromId(Long.valueOf(0L)).approvalState(ptmBacklog.getApprovalState()).todoItems(null).emergency(ptmProjectRecordBO.getEmergency() == 25).eocCode(ptmProjectRecordBO.getEocCode()).eocName(ptmProjectRecordBO.getEocName()).eocType(ptmProjectRecordBO.getEocType()).processSerialNumber(ptmTaskRecord.getProcessSerialNumber()).agentBeginDate(null).agentBeginDate(null).overdueWorkitemId(Long.valueOf(0L)).sourceTenantName(StringUtils.equalsIgnoreCase((String)ptmBacklog.getTenantId(), (String)ptmBacklog.getTargetTenantId()) ? null : ptmBacklog.getTenantName()).workItemId(ptmTaskCardItemBO.getBacklogId()).proxyToken(ptmTaskCardItemBO.getProxyToken()).historyMessage(null).finishActionId(Boolean.TRUE.equals(ptmBacklog.getClosed()) ? ptmBacklog.getActionId() : null).tmActivityName(ptmTaskCardItemBO.getTaskDefName()).dataFrom("PTM").summary(ptmBacklog.getSummary()).historyMessage(ptmBacklog.getHistoryMessage()).searchMessage(ptmBacklog.getSearchMessage()).merge(ptmBacklog.getMerge()).dataChangeRead(ptmBacklog.getDataChangeRead()).engineType(BpmEngineCategoryEnum.TaskEngine.getValue()).closedTime(ptmTaskCardItemBO.getClosedTime()).createTime(ptmTaskCardItemBO.getCreateTime()).hasAppPermission(ptmBacklog.getType() != null ? this.checkByType(ptmBacklog.getType()) : null).auxiliaryTenantId(ptmTaskCardItemBO.getAuxiliaryTenantId()).auxiliaryTenantName(ptmTaskCardItemBO.getAuxiliaryTenantName()).engineHasWaittingData(ptmTaskCardItemBO.getEngineHasWaittingData()).build();
                if (BooleanUtils.isTrue((Boolean)ptmBacklog.getMerge())) {
                    if (ptmMergeBacklogBO != null) {
                        LocalDateTime planEndTimeMin = ptmMergeBacklogBO.getPlanEndTimeMin();
                        bl.setPlanEndTimeMin(planEndTimeMin);
                        bl.setPlanEndTimeMax(ptmMergeBacklogBO.getPlanEndTimeMax());
                        bl.setEndTime(planEndTimeMin);
                        if (Boolean.TRUE.equals(ptmMergeBacklogBO.getClosed() == false) && planEndTimeMin.isBefore(LocalDateTime.now())) {
                            bl.setOverdue(Boolean.valueOf(true));
                            bl.setOverdueDays(Integer.valueOf((int)Duration.between(planEndTimeMin, LocalDateTime.now()).toDays()));
                            bl.setOverdueHours(Integer.valueOf((int)Duration.between(planEndTimeMin, LocalDateTime.now()).toHours()));
                            bl.setOverdueMinutes(Integer.valueOf((int)Duration.between(planEndTimeMin, LocalDateTime.now()).toMinutes()));
                        } else if (ptmTaskCardItemBO.getClosedTime() != null && ptmMergeBacklogBO.getClosed().booleanValue() && planEndTimeMin.isBefore(ptmTaskCardItemBO.getClosedTime())) {
                            bl.setOverdue(Boolean.valueOf(true));
                            bl.setOverdueDays(Integer.valueOf((int)Duration.between(planEndTimeMin, ptmTaskCardItemBO.getClosedTime()).toDays()));
                            bl.setOverdueHours(Integer.valueOf((int)Duration.between(planEndTimeMin, ptmTaskCardItemBO.getClosedTime()).toHours()));
                            bl.setOverdueMinutes(Integer.valueOf((int)Duration.between(planEndTimeMin, ptmTaskCardItemBO.getClosedTime()).toMinutes()));
                        }
                    }
                } else if (Boolean.TRUE.equals(ptmTaskCardItemBO.getClosed() == false) && ptmTaskRecord.getPlanEndTime().isBefore(LocalDateTime.now())) {
                    bl.setOverdue(Boolean.valueOf(true));
                    bl.setOverdueDays(Integer.valueOf((int)Duration.between(ptmTaskRecord.getPlanEndTime(), LocalDateTime.now()).toDays()));
                    bl.setOverdueHours(Integer.valueOf((int)Duration.between(ptmTaskRecord.getPlanEndTime(), LocalDateTime.now()).toHours()));
                    bl.setOverdueMinutes(Integer.valueOf((int)Duration.between(ptmTaskRecord.getPlanEndTime(), LocalDateTime.now()).toMinutes()));
                } else if (ptmTaskCardItemBO.getClosedTime() != null && ptmTaskCardItemBO.getClosed().booleanValue() && ptmTaskRecord.getPlanEndTime().isBefore(ptmTaskCardItemBO.getClosedTime())) {
                    bl.setOverdue(Boolean.valueOf(true));
                    bl.setOverdueDays(Integer.valueOf((int)Duration.between(ptmTaskRecord.getPlanEndTime(), ptmTaskCardItemBO.getClosedTime()).toDays()));
                    bl.setOverdueHours(Integer.valueOf((int)Duration.between(ptmTaskRecord.getPlanEndTime(), ptmTaskCardItemBO.getClosedTime()).toHours()));
                    bl.setOverdueMinutes(Integer.valueOf((int)Duration.between(ptmTaskRecord.getPlanEndTime(), ptmTaskCardItemBO.getClosedTime()).toMinutes()));
                }
                if (Boolean.TRUE.equals(bl.getOverdue()) && bl.getOverdueMinutes() <= 0) {
                    bl.setOverdue(Boolean.valueOf(false));
                }
                result.add(bl);
            }
        }
        return result;
    }

    private Map<Long, PtmMergeBacklogBO> getMergeBacklogData(List<PtmTaskCardItemBO> ptmTaskCardItemBOList) {
        List<Long> closedBacklogIds;
        HashMap<Long, PtmMergeBacklogBO> mergeBacklogMap = new HashMap<Long, PtmMergeBacklogBO>();
        if (CollectionUtils.isEmpty(ptmTaskCardItemBOList)) {
            return mergeBacklogMap;
        }
        List mergeCardList = ptmTaskCardItemBOList.stream().filter(x -> Objects.equals(x.getMerge(), true)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(mergeCardList)) {
            return mergeBacklogMap;
        }
        List<Long> pendingBacklogIds = mergeCardList.stream().filter(x -> x.getClosed() == false).map(PtmTaskCardItemBO::getBacklogId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(pendingBacklogIds)) {
            mergeBacklogMap.putAll(this.dealBacklogData(pendingBacklogIds, false));
        }
        if (CollectionUtils.isNotEmpty(closedBacklogIds = mergeCardList.stream().filter(PtmTaskCardItemBO::getClosed).map(PtmTaskCardItemBO::getBacklogId).distinct().collect(Collectors.toList()))) {
            mergeBacklogMap.putAll(this.dealBacklogData(closedBacklogIds, true));
        }
        return mergeBacklogMap;
    }

    public Map<Long, PtmMergeBacklogBO> dealBacklogData(List<Long> backlogIdList, Boolean history) {
        if (history == null) {
            history = false;
        }
        if (CollectionUtils.isEmpty(backlogIdList)) {
            return new HashMap<Long, PtmMergeBacklogBO>();
        }
        List<PtmBacklogItemBO> ptmBacklogItemBOList = this.ptmService.getBacklogByBacklogIds(backlogIdList);
        if (CollectionUtils.isEmpty(ptmBacklogItemBOList)) {
            return Collections.emptyMap();
        }
        Map<Long, List<PtmBacklogItemBO>> ptmBacklogItemMap = ptmBacklogItemBOList.stream().collect(Collectors.groupingBy(PtmBacklogItemBO::getBacklogId));
        HashMap<Long, PtmMergeBacklogBO> resultMap = new HashMap<Long, PtmMergeBacklogBO>();
        for (Map.Entry<Long, List<PtmBacklogItemBO>> entry : ptmBacklogItemMap.entrySet()) {
            Long backlogId = entry.getKey();
            List<PtmBacklogItemBO> itemDTOList = entry.getValue();
            List planEndTimeList = history != false ? itemDTOList.stream().sorted(Comparator.comparing(PtmBacklogItemBO::getPlanEndTime)).map(PtmBacklogItemBO::getPlanEndTime).collect(Collectors.toList()) : itemDTOList.stream().filter(item -> !this.isWorkItemClosed(item.getState())).sorted(Comparator.comparing(PtmBacklogItemBO::getPlanEndTime)).map(PtmBacklogItemBO::getPlanEndTime).collect(Collectors.toList());
            List pendingList = itemDTOList.stream().filter(item -> !this.isWorkItemClosed(item.getState())).collect(Collectors.toList());
            PtmMergeBacklogBO ptmMergeBacklogBO = new PtmMergeBacklogBO();
            ptmMergeBacklogBO.setBacklogId(backlogId);
            ptmMergeBacklogBO.setTaskName(itemDTOList.get(0).getTaskName());
            if (CollectionUtils.isNotEmpty(planEndTimeList)) {
                ptmMergeBacklogBO.setPlanEndTimeMin((LocalDateTime)planEndTimeList.get(0));
                ptmMergeBacklogBO.setPlanEndTimeMax((LocalDateTime)planEndTimeList.get(planEndTimeList.size() - 1));
            }
            ptmMergeBacklogBO.setClosed(Boolean.valueOf(CollectionUtils.isEmpty(pendingList)));
            resultMap.put(backlogId, ptmMergeBacklogBO);
        }
        return resultMap;
    }

    private boolean isWorkItemClosed(Integer state) {
        return Objects.nonNull(state) && state >= ActivityStateEnum.COMPLETED.getCode();
    }

    private Boolean checkByType(Integer type) {
        return PtmBacklogTypeEnum.SPAN_TENANT.getValue().equals(type);
    }

    @Override
    public List<BacklogBO> queryPinningBacklogList(String tenantId, List<Long> backlogIdList) {
        ArrayList<BacklogBO> result = new ArrayList<BacklogBO>();
        if (!this.enablePTM()) {
            return result;
        }
        List<PtmTaskCardItemBO> ptmTaskCardItemBOList = this.ptmService.queryTaskCardListByBacklogId(backlogIdList);
        result.addAll(this.dealBacklogList(ptmTaskCardItemBOList));
        List overdueList = this.ptmBacklogMapper.selectNoFinishedPiningOverdue(tenantId, backlogIdList);
        result.addAll(this.dealOverdueBacklog(overdueList));
        List exceptionList = this.ptmBacklogMapper.selectNoFinishedPinningException(tenantId, backlogIdList);
        result.addAll(this.dealExceptionData(exceptionList));
        if (CollectionUtils.isNotEmpty(result)) {
            result.forEach(backLog -> backLog.setDataFrom("PTM"));
        }
        return result;
    }
}

