package com.digiwin.athena.atmc.application.configuration;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.concurrent.TimeUnit;

@Data
@Component
@EnableConfigurationProperties
@ConfigurationProperties(prefix = "backlog.async")
public class BacklogAsyncConfig {

    //超时时间
    private Long timeOut;

    private TimeUnit timeUnit;

    // 默认超时时间
    private static final Long DEFAULT_TIMEOUT = 60L;

    public static final TimeUnit TIME_UNIT = TimeUnit.SECONDS;

    @PostConstruct
    public void init() {
        if (timeOut==null) {
            timeOut = DEFAULT_TIMEOUT;
        }

        if (timeUnit == null) {
            timeUnit = TIME_UNIT;
        }
    }
}
