package com.digiwin.athena.atmc.application.dto.response.action;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * Action实体定义
 * @author zhujg
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ActionResp implements Serializable {


    /**
     * action的显示标题
     */
    private String title;

    /**
     * action的id,themeMap中定义
     */
    private String actionId;


    /**
     * type（esp）
     */
    private String type;
    /**
     * 同步异步
     */
    private String invokeType;

    /**
     * action的类型，目前只有ESP(业务)和WF(工作流BPM)
     */
    private String  category;

    /**
     * 服务Id，包括服务真正执行的服务
     */
    private Map serviceId;

    /**
     * 执行Action的参数,是多个的合并，执行的时候是分开执行
     */
    private Map<String,Object> paras;

    /**
    * 营运单元
    */
    private Map<String,String> businessUnit;

    /**
     * 所有转换参数的定义
     */
    private List<Map> actionParams;

    /**
     * 给前端使用的扩展字段
     */
    private Map<String,Object> extendedFields;

}
