package com.digiwin.athena.atmc.application.dto.response.task;

import lombok.Data;

import java.io.Serializable;

@Data
public class CardConfigDTO implements Serializable {

    private String aliasField;

    private Config config;

    @Data
    public static class Config implements Serializable {
        private Data filter;

        private Label label;

        private Data order;

        private Data group;

        private Column column;

        @lombok.Data
        public static class Data implements Serializable {

            private String aliasName;

            private String dataType;

            private String defaultEffective;
            /**
             * 兼容历史，作为同时放高级和常规的标识符
             */
            private Boolean normal;

        }

        @lombok.Data
        public static class Label implements Serializable {
            private Style style;
            private String defaultEffective;
            private String aliasName;

            @lombok.Data
            public static class Style implements Serializable {
                private String color;

                private String font;

            }
        }

        @lombok.Data
        public static class Column implements Serializable{
            private String valueType;
            private String aliasName;
            private String defaultEffective;
        }
    }
}

