package com.digiwin.athena.atmc.application.dto.response.task;

import com.digiwin.athena.appcore.domain.LanguageMark;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class TaskCardResp {

    /**
     * bpm_activity_workitem.id
     */
    private long backlogId;

    /**
     * 任务的地址
     */
    private String uri;
    /**
     * 任务名称
     */
    @LanguageMark
    private String name;

    /**
     * 格式："{"zh_CN":"xxx", "zh_TW": "xxxxx", "en_US": "xxxxxx"}"
     */
    private String withName;

    /**
     * 子标题，一般用于签核
     */
    @LanguageMark
    private String subName;

    /**
     * 项目名称
     */
    @LanguageMark
    private String projectName;
    /**
     * 项目目标名称
     */
    @LanguageMark
    private String projectTargetName;

    /**
     * 项目时距开始时间
     */
    private LocalDateTime projectStartTime;
    /**
     * 项目时距结束时间
     */
    private LocalDateTime projectEndTime;
    /**
     * 项目是否重要
     */
    private boolean projectImportance;
    /**
     * 任务是否重要
     */
    private boolean importance;
    /**
     * 任务卡内容,backlog.content
     */
    @LanguageMark
    private String content;
    /**
     * 任务的重要性是否可以改变
     * <br>如果是由于项目的重要而任务重要的，则为true,否则为false
     */
    private boolean importanceReadOnly;

    /**
     * 任务的开始时间
     */
    private LocalDateTime startTime;
    /**
     * 任务的计划结束时间
     */
    private LocalDateTime endTime;
    /**
     * ThemeMap中定义的项目Id
     */
    private String tmTaskId;
    /**
     * ThemeMap中定义的任务ID
     */
    private String tmActivityId;
    /**
     * ThemeMap中定义的pattern
     */
    private String tmPattern;
    /**
     * ThemeMap中定义的category
     */
    private String tmCategory;
    /**
     * 任务类型,backlog.type
     * <br>值为99时，表示逾期催跟任务
     */
    private int type;
    /**
     * 租户Id
     */
    private String tenantId;
    /**
     * 目标租户
     */
    private String targetTenantId;
    /**
     * 是否定义了action
     * <br>true-表示可以点击显示任务详情，false-不可点击
     */
    private boolean actionDefined;
    /**
     * 是否是当前用户的任务，false表示代理过来的任务
     */
    private Boolean isOwner;
    /**
     * 任务所有者Id
     */
    private String ownerUserId;

    /**
     * 任务所有者名称
     */
    private String ownerUserName;

    /**
     * 代理人id  被谁代理
     */
    private String ownerAgentUserId;

    /**
     * 代理人名称  被谁代理
     */
    private String ownerAgentUserName;

    /**
     * 人员状态，是否停用 true在职，false离职
     */
    private Boolean performerState;

    /**
     * 任务阅读次数
     */
    private int readCount;
    /**
     * 任务是否异常
     */
    private boolean exception;
    /**
     * 任务是否逾期
     */
    private boolean overdue;
    /**
     * 逾期总分钟数
     */
    private int overdueMinutes;
    /**
     * 逾期总小时数
     */
    private int overdueHours;
    /**
     * 逾期总天数
     */
    private int overdueDays;

    /**
     * 签核状态
     */
    @LanguageMark
    private String approvalState;
//    /**
//     * 任务卡是否有变化
//     */
//    private boolean changed;

    /**
     * 任务卡最后一次修改时间
     */
    private LocalDateTime modifyDate;

    /**
     * 任务卡已经发生了变化
     */
    private boolean hasDataChanged;

    private boolean emergency;

    /**
     * 营运单元code，由公司id、工厂id等单元拼接而成
     */
    private String eocCode;

    /**
     * 营运单元name，由公司名称、工厂名称等单元拼接而成
     */
    private String eocName;

    /**
     * 营运单元最小指示维度，如：公司：1，工厂：2
     */
    private Integer eocType;

    /**
     * 任务卡的明细
     */
//    private  TaskCardAbstractDTO detail;

    /**
     * 代理开始日期
     */
    private String agentBeginDate;

    /**
     * 代理截止日期
     */
    private String agentEndDate;
    /**
     * 来源租户名称
     */
    private String sourceTenantName;

    /**
     * 代理token
     */
    private String proxyToken;

    /**
     * 可否支持转派
     */
    private Boolean reAssignAble;

    /**
     * finish actionId
     */
    private String finishActionId;

    /**
     * themeMap定义的名称
     */
    @LanguageMark
    private String tmActivityName;

    /**
     * 格式："{"zh_CN":"xxx", "zh_TW": "xxxxx", "en_US": "xxxxxx"}"
     */
    private String tmActivityWithName;

    /**
     * 摘要
     */
    private String summary;
    /**
     * 历史资讯
     */
    private String historyMessage;
    /**
     * 搜索项
     */
    private String searchMessage;

    /**
     * 扩展数据
     */
    private Map<String, Object> extendData;

    /**
     * 是否合并的任务
     */
    private Boolean merge;
    /**
     * 合并任务卡最小预计时间
     */
    private LocalDateTime planEndTimeMin;
    /**
     * 合并任务卡最大预计时间
     */
    private LocalDateTime planEndTimeMax;

    private String dataFrom;

    /**
     * 任务变更数据是否被已读
     */
    private Boolean dataChangeRead;

    private Long groupId;

    /**
     * 是否为转派
     */
    private Boolean reassign;
    /**
     * 是否为退回
     */
    private Boolean reexecute;

    /**
     * 是否为撤回
     */
    private Boolean recall;

    private String approvalStateCode;
    /**
     * 是否为加签
     */
    private Boolean addTask;

    /**
     * 引擎类型，参考枚举类型 BpmEngineCategory。<br>
     * null也表示流程引擎
     */
    private String engineType;

    /**
     * 任务卡是否结束
     */
    private Boolean closed;

    /**
     * 提交唯一标识
     */
    private Integer submitId;

    /**
     * 实际完成时间
     */
    private LocalDateTime closedTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 是否有应用授权
     */
    private Boolean hasAppPermission;

    /**
     * 应用code
     */
    private String appCode;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 被辅助租户
     */
    private String auxiliaryTenantId;

    /**
     * 被辅助租户名称
     */
    private String auxiliaryTenantName;

    /**
     * 表示跨租户任务异常信息
     */
    private String crossTenantError;
    /**
     * 是否分享
     */
    private Boolean pinning;

    private Map<String, String> group;

    private List<Map<String, Object>> labels;

    /**
     * {"taskOrderWeight":999}
     */
    private Map<String, Integer> order;

    private List<Map<String, Object>> columns;

    /**
     * 引擎中是否有待处理  add by 6203
     */
    private Boolean engineHasWaittingData;

    /**
     * 业务数据
     */
    private Map<String, List<String>> businessMessage;

    /**
     * 分组等配置
     */
    private List<CardConfigDTO> cardConfig;

    /**
     * 卡面业务数据的来源方式
     * REAL_TIME(默认)/NON_REAL_TIME
     */
    private String businessMessageSourceMethod;

}
