package com.digiwin.athena.atmc.application.service.query.backlog;


import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
//import com.digiwin.athena.atmc.application.dto.response.eoc.ProxyUserDTO;
import com.digiwin.athena.atmc.application.dto.response.eoc.ProxyUserResp;
import com.digiwin.athena.atmc.application.dto.response.task.TaskCardResp;
import com.digiwin.athena.atmc.application.service.restful.eoc.EocQService;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.core.meta.constants.BpmConstant;
import com.digiwin.athena.atmc.core.meta.constants.GlobalConstant;
import com.digiwin.athena.atmc.infrastructure.mapper.biz.migration.BacklogMapper;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.BacklogBO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;

@Slf4j
@Service
public class BpmTodoBacklogQueryCountingQryService {



    @Autowired
    EocQService eocService;

    @Autowired
    private BacklogMapper backlogMapper;

    @Autowired
    EnvProperties envProperties;


    public List<TaskCardResp> getBacklogListByTenantIdAndUserIdAndCode(AuthoredUser user, String clientId) {

        // 查询任务卡
        List<BacklogBO> backlogList = queryByNotClosedAndActivityId(user);
        if (CollectionUtils.isEmpty(backlogList)) {
            return new ArrayList<>();
        }
        return getBacklogList(clientId, backlogList);
    }


    public List<TaskCardResp> getBacklogList(String clientId, List<BacklogBO> backlogList) {
        List<TaskCardResp> list = new ArrayList<>();
        backlogList.forEach(backlog -> {
            TaskCardResp taskCardDTO = TaskCardResp.builder()
                    .backlogId(backlog.getWorkItemId())
                    .submitId(backlog.getSubmitId())
                    .uri(envProperties.getWebUri() + "task/detail/" + backlog.getWorkItemId() + "?targetTenantId=" + backlog.getTargetTenantId())
                    .name(backlog.getName())
                    .subName(backlog.getSubName())
                    .projectName(backlog.getTaskName())
                    .projectTargetName(backlog.getTaskTargetName())
                    .projectStartTime(backlog.getTaskStartTime())
                    .projectEndTime(backlog.getTaskEndTime())
                    .projectImportance(backlog.isImportance())
                    .importance(backlog.isImportance())
                    .content(backlog.getContent())
                    .importanceReadOnly(backlog.isImportanceReadOnly())
                    .startTime(backlog.getStartTime()).endTime(backlog.getEndTime())
                    .tmTaskId(backlog.getTmTaskId())
                    .tmActivityId(backlog.getTmActivityId())
                    .type(backlog.getType())
                    .tenantId(backlog.getTenantId())
                    .targetTenantId(backlog.getTargetTenantId())
                    .actionDefined(backlog.isActionDefined())
                    .tmPattern(backlog.getTmPattern())
                    .tmCategory(backlog.getTmCategory())
                    .isOwner(backlog.getIsOwner())
                    .ownerUserId(backlog.getOwnerUserId())
                    .ownerUserName(backlog.getOwnerUserName())
                    .readCount(backlog.getReadCount())
                    .exception(null != backlog.getException() ? backlog.getException() : false)
                    .overdue(null != backlog.getOverdue() ? backlog.getOverdue() : false)
                    .overdueMinutes(null != backlog.getOverdueMinutes() ? backlog.getOverdueMinutes() : 0)
                    .overdueHours(null != backlog.getOverdueHours() ? backlog.getOverdueHours() : 0)
                    .overdueDays(null != backlog.getOverdueDays() ? backlog.getOverdueDays() : 0)
                    .approvalState(backlog.getApprovalState())
                    .approvalStateCode(backlog.getApprovalStateCode())
                    .modifyDate(backlog.getModifyDate())
                    .emergency(backlog.isEmergency())
                    .eocCode(backlog.getEocCode())
                    .eocName(backlog.getEocName())
                    .eocType(backlog.getEocType())
                    .agentBeginDate(backlog.getAgentBeginDate())
                    .agentEndDate(backlog.getAgentEndDate())
                    .sourceTenantName(backlog.getSourceTenantName())
                    .proxyToken(backlog.getProxyToken())
                    .finishActionId(backlog.getFinishActionId())
                    .tmActivityName(backlog.getTmActivityName())
                    .summary(backlog.getSummary())
                    .historyMessage(backlog.getHistoryMessage())
                    .searchMessage(backlog.getSearchMessage())
                    .dataFrom(backlog.getDataFrom())
                    .merge(backlog.getMerge())
                    .planEndTimeMin(backlog.getPlanEndTimeMin())
                    .planEndTimeMax(backlog.getPlanEndTimeMax())
                    .dataChangeRead((backlog.getDataChangeRead() != null && backlog.getDataChangeRead() == 0))
                    .groupId(backlog.getGroupId())
                    .engineType(backlog.getEngineType())
                    .closedTime(backlog.getClosedTime())
                    .createTime(backlog.getCreateTime())
                    .hasAppPermission(true)
                    .build();

            list.add(taskCardDTO);
        });

        return list;
    }


    private List<BacklogBO> queryByNotClosedAndActivityId(AuthoredUser user) {

        List<String> userIdList = new ArrayList<>();
        userIdList.add(user.getUserId());
        // 根据用户id查询任务卡列表
        List<BacklogBO> backlogBOS = this.queryByNotClosedAndActivityId(user.getTenantId(), userIdList);
        if (!CollectionUtils.isEmpty(backlogBOS)) {
            for (BacklogBO proxyBacklogBO : backlogBOS) {
                proxyBacklogBO.setIsOwner(true);
                proxyBacklogBO.setOwnerUserId(user.getUserId());
                proxyBacklogBO.setOwnerUserName(user.getUserName());
            }
        }

        //取代理人的任务
        if (StringUtils.hasText(user.getToken())) {
            // 获取代理人信息
            List<ProxyUserResp> proxyUserResps = eocService.getProxyTargetUsers(user.getUserId(), user.getToken());
            if (!CollectionUtils.isEmpty(proxyUserResps)) {
                userIdList.clear();
                for (ProxyUserResp proxyUserResp : proxyUserResps) {
                    if (Objects.equals(proxyUserResp.getUserId(), user.getUserId())) {
                        //代理人和当前用户相同，自己代理自己，不重复加载数据
                        continue;
                    }
                    userIdList.add(proxyUserResp.getUserId());
                }
                if (!CollectionUtils.isEmpty(userIdList)) {
                    // 获取代理人的任务卡信息
                    List<BacklogBO> proxyBacklogBOS = this.queryByNotClosedAndActivityId(user.getTenantId(), userIdList);
                    backlogBOS.addAll(proxyBacklogBOS);
                }
            }
        }
        return backlogBOS;
    }


    private List<BacklogBO> queryByNotClosedAndActivityId(String tenantId, List<String> userIds) {
        String nowTime = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now());
        // 流程引擎任务卡，行事历
        List<BacklogBO> backlogBOS = backlogMapper.selectByNotClosedAndUserId(userIds, tenantId, nowTime);
        setBacklogQueryResultSet(backlogBOS);
        return backlogBOS;
    }


    public void setBacklogQueryResultSet(List<BacklogBO> backlogBOS) {
        if (CollectionUtils.isEmpty(backlogBOS)){
            return;
        }
        for (BacklogBO backlogBO : backlogBOS) {
            if (backlogBO.getOverdueWorkitemId() != null && backlogBO.getOverdueWorkitemId() > 0) {
                if (!Objects.equals(backlogBO.getDataFrom(), BpmConstant.DATA_FROM_PTM)) {
                    backlogBO.setOverdue(false);
                    backlogBO.setOverdueDays(0);
                    backlogBO.setOverdueHours(0);
                    backlogBO.setOverdueMinutes(0);
                    //逾时任务卡，应该永不逾期
                    backlogBO.setEndTime(LocalDateTime.now().plusMonths(1));
                }
            } else if (GlobalConstant.DATA_UNIFORMITY_BACKLOG_TYPE.equals(backlogBO.getType())) {//数据一致性异常排除
                backlogBO.setOverdue(false);
                backlogBO.setOverdueDays(0);
                backlogBO.setOverdueHours(0);
                backlogBO.setOverdueMinutes(0);
                backlogBO.setEndTime(LocalDateTime.now().plusMonths(1));
            }
        }
    }


}
