package com.digiwin.athena.atmc.application.service.query.backlog;

import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.BacklogBO;

import java.util.List;

/**
 * PTM 与其他转换服务
 * 用于查询PTM相关数据，且转换成需要的数据格式
 */
public interface PtmTransformQueryCountingQryService {


    /**
     * 是否启用了PTM
     * @return
     */
    boolean enablePTM();

    /**
     * 查询当前租户指定用户的待办列表
     * @param tenantId
     * @param userIds
     * @return 如果不存在，返回空列表
     */
    List<BacklogBO> queryBacklogList(String tenantId, List<String> userIds);


    List<BacklogBO> queryBacklogList(String tenantId, String userId);

    /**
     * 获取分享任务卡
     * @param tenantId
     * @param backlogIdList
     * @return
     */
    List<BacklogBO> queryPinningBacklogList(String tenantId, List<Long> backlogIdList);
}