package com.digiwin.athena.atmc.application.service.query.backlog;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.atmc.infrastructure.mapper.biz.migration.TaskPinningUserMapper;
import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.TaskPinningUser;
import com.github.pagehelper.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class TaskPinningUserParentCountingQryService {


    @Autowired
    TaskPinningUserMapper taskPinningUserMapper;

    /**
     * 根据钉选人查询项目卡id
     */
    public List<Long> getMainTaskIdByPinningUser(String pinningUserId, String tenantId, Integer type) {
        if (StringUtil.isEmpty(pinningUserId) || StringUtil.isEmpty(tenantId)) {
            return new ArrayList<>();
        }
        //查询条件
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("pinning_user_id", pinningUserId);
        queryWrapper.eq("tenant_id", tenantId);
        if(type != null) {
            queryWrapper.eq("type", type);
        }
        List<TaskPinningUser> taskPinningUsers = taskPinningUserMapper.selectList(queryWrapper);
        if (CollectionUtils.isEmpty(taskPinningUsers)) {
            return new ArrayList<>();
        }
        return taskPinningUsers.stream().map(TaskPinningUser::getMainTaskId).collect(Collectors.toList());
    }

}
