package com.digiwin.athena.atmc.application.service.query.backlog;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
//import com.digiwin.athena.atmc.application.dto.response.eoc.ProxyUserDTO;
import com.digiwin.athena.atmc.application.dto.response.eoc.ProxyUserResp;
import com.digiwin.athena.atmc.application.dto.response.task.TaskCardResp;
import com.digiwin.athena.atmc.application.service.restful.eoc.EocQService;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.BacklogBO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;

@Service
@Slf4j
public class TodoBacklogQueryCountingQryService {



    @Autowired
    EocQService eocService;

    @Autowired
    TaskPinningUserParentCountingQryService taskPinningUserParentService;

    @Autowired
    PtmTransformQueryCountingQryService ptmTransformService;

    @Autowired
    EnvProperties envProperties;

    

    public List<TaskCardResp> getBacklogListByTenantIdAndUserIdAndCode(AuthoredUser user, String clientId) {
        // 查询任务卡
        List<BacklogBO> backlogList = queryByNotClosedAndActivityId(user);
        if (CollectionUtils.isEmpty(backlogList)) {
            return new ArrayList<>();
        }
        return getBacklogList(clientId, backlogList);
    }


    private List<BacklogBO> queryByNotClosedAndActivityId(AuthoredUser user) {


        List<String> userIdList = new ArrayList<>();
        userIdList.add(user.getUserId());
        // 根据用户id查询任务卡列表
        List<BacklogBO> backlogBOS = this.queryByNotClosedAndActivityId(user.getTenantId(), userIdList);
        //取代理人的任务
        if (StringUtils.hasText(user.getToken())) {
            // 获取代理人信息
            List<ProxyUserResp> proxyUserResps = eocService.getProxyTargetUsers(user.getUserId(), user.getToken());
            if (!CollectionUtils.isEmpty(proxyUserResps)) {
                userIdList.clear();
                for (ProxyUserResp proxyUserResp : proxyUserResps) {
                    if (Objects.equals(proxyUserResp.getUserId(), user.getUserId())) {
                        //代理人和当前用户相同，自己代理自己，不重复加载数据
                        continue;
                    }
                    userIdList.add(proxyUserResp.getUserId());
                }
                if (!CollectionUtils.isEmpty(userIdList)) {
                    // 获取代理人的任务卡信息
                    List<BacklogBO> proxyBacklogBOS = this.queryByNotClosedAndActivityId(user.getTenantId(), userIdList);
                    backlogBOS.addAll(proxyBacklogBOS);
                }
            }
        }

        //取分享任务卡
        List<Long> mainTaskIdList = taskPinningUserParentService.getMainTaskIdByPinningUser(user.getUserId(),
                user.getTenantId(), 2);
        if (!CollectionUtils.isEmpty(mainTaskIdList)) {
            List<BacklogBO> ptmPinningTaskList = this.queryByPinningNotClosedAndActivityId(user.getTenantId(), mainTaskIdList);
            backlogBOS.addAll(ptmPinningTaskList);
        }

        return backlogBOS;
    }


    private List<BacklogBO> queryByNotClosedAndActivityId(String tenantId, List<String> userIds) {
        // 任务引擎 PTM任务卡
        return ptmTransformService.queryBacklogList(tenantId, userIds);
    }


    public List<TaskCardResp> getBacklogList(String clientId, List<BacklogBO> backlogList) {
        List<TaskCardResp> list = new ArrayList<>();
        backlogList.forEach(backlog -> {
            TaskCardResp taskCardDTO = TaskCardResp.builder()
                    .backlogId(backlog.getWorkItemId())
                    .submitId(backlog.getSubmitId())
                    .uri(envProperties.getWebUri() + "task/detail/" + backlog.getWorkItemId() + "?targetTenantId=" + backlog.getTargetTenantId())
                    .name(backlog.getName())
                    .subName(backlog.getSubName())
                    .projectName(backlog.getTaskName())
                    .projectTargetName(backlog.getTaskTargetName())
                    .projectStartTime(backlog.getTaskStartTime())
                    .projectEndTime(backlog.getTaskEndTime())
                    .projectImportance(backlog.isImportance())
                    .exception(null != backlog.getException() && backlog.getException())
                    .overdue(null != backlog.getOverdue() && backlog.getOverdue())
                    .overdueMinutes(null != backlog.getOverdueMinutes() ? backlog.getOverdueMinutes() : 0)
                    .overdueHours(null != backlog.getOverdueHours() ? backlog.getOverdueHours() : 0)
                    .overdueDays(null != backlog.getOverdueDays() ? backlog.getOverdueDays() : 0)
                    .approvalState(backlog.getApprovalState())
                    .approvalStateCode(backlog.getApprovalStateCode())
                    .modifyDate(backlog.getModifyDate())
                    .emergency(backlog.isEmergency())
                    .eocCode(backlog.getEocCode())
                    .eocName(backlog.getEocName())
                    .eocType(backlog.getEocType())
                    .agentBeginDate(backlog.getAgentBeginDate())
                    .agentEndDate(backlog.getAgentEndDate())
                    .sourceTenantName(backlog.getSourceTenantName())
                    .proxyToken(backlog.getProxyToken())
                    .finishActionId(backlog.getFinishActionId())
                    .tmActivityName(backlog.getTmActivityName())
                    .summary(backlog.getSummary())
                    .historyMessage(backlog.getHistoryMessage())
                    .searchMessage(backlog.getSearchMessage())
                    .dataFrom(backlog.getDataFrom())
                    .merge(backlog.getMerge())
                    .planEndTimeMin(backlog.getPlanEndTimeMin())
                    .planEndTimeMax(backlog.getPlanEndTimeMax())
                    .dataChangeRead((backlog.getDataChangeRead() != null && backlog.getDataChangeRead() == 0))
                    .groupId(backlog.getGroupId())
                    .engineType(backlog.getEngineType())
                    .closedTime(backlog.getClosedTime())
                    .createTime(backlog.getCreateTime())
                    .hasAppPermission(backlog.getHasAppPermission())
                    .auxiliaryTenantId(backlog.getAuxiliaryTenantId())
                    .auxiliaryTenantName(backlog.getAuxiliaryTenantName())
                    .pinning(backlog.getPinning())
                    .engineHasWaittingData(backlog.getEngineHasWaittingData())
                    .build();
            list.add(taskCardDTO);
        });
        return list;
    }


    private List<BacklogBO> queryByPinningNotClosedAndActivityId(String tenantId, List<Long> backlogIds) {
        // 任务引擎 PTM任务卡
        return ptmTransformService.queryPinningBacklogList(tenantId, backlogIds);
    }


}