package com.digiwin.athena.atmc.application.service.restful.eoc.impl;

import com.digiwin.athena.atmc.application.dto.response.eoc.ProxyUserResp;
import com.digiwin.athena.atmc.application.dto.response.iam.ProxyUserDTOListWithCodeResp;
//import com.digiwin.athena.atmc.application.dto.response.eoc.ProxyUserDTO;
import com.digiwin.athena.atmc.application.service.restful.eoc.EocQService;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.core.meta.constants.EocApiConstant;
import com.digiwin.athena.atmc.core.meta.constants.GlobalConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Description TODO
 * Author hebaokai
 * Date 2024/8/15 15:49
 *
 * @Version 1.0
 **/
@Slf4j
@Service
public class EocQServiceImpl implements EocQService {

    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Override
    public List<ProxyUserResp> getProxyTargetUsers(String userId, String token) {
        //获取员工ID
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, token);
        //post body
        Map<String, String> param = new HashMap<>();
        param.put("userId", userId);
        HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);
        String url = envProperties.getEocUri() + EocApiConstant.EMP_AGENT_TARGET;
        ResponseEntity<ProxyUserDTOListWithCodeResp> responseEntity = restTemplate.postForEntity(url, httpEntity, ProxyUserDTOListWithCodeResp.class);
        ProxyUserDTOListWithCodeResp baseResult = responseEntity.getBody();
        if (baseResult != null && baseResult.getCode() == 200 && baseResult.getData() != null) {
            return baseResult.getData();
        }
        return null;
    }
}
