package com.digiwin.athena.atmc.application.service.restful.ptm;

import com.digiwin.athena.appcore.constant.ErrorTypeEnum;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.SpringUtil;
import lombok.Getter;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

/**
 * 错误码定义类
 *
 * @author majianfu
 * @date 2020/11/04
 * @since [迭代10]
 */
public enum ErrorCodeQEnum {

    /**
     * 调用中间价报错（中间价没有封装规范格式的错误码）
     * 第3码用于区分不同的中间件，第4码用于表示该组件不同的API
     *
     * P_ATMC_DAP_ERROR("P.ATMC.901.0001","调dap的api：报错"),
     * P_ATMC_EMC_ERROR("P.ATMC.902.0001","调emc的api：报错"),
     * P_ATMC_IAM_ERROR("P.ATMC.903.0001","调iam的api：报错"),
     * P_ATMC_CAC_ERROR("P.ATMC.904.0001","调cac的api：报错"),
     * P_ATMC_EOC_ERROR("P.ATMC.905.0001","调eoc的api：报错"),
     * P_ATMC_DMC_ERROR("P.ATMC.906.0001","调dmc的api：报错"),
     *
     */

    //调用emc报错
    EMC_MESSAGE_PUSH("P.ATMC.902.0001","atmc调用emc发送email报错"),
    EMC_GET_NOTICE_SETTINGS_FAIL("P.ATMC.902.0002","atmc从emc获取邮件模板预览异常"),
    EMC_V1_MESSAGE_EMAIL_FAIL("P.ATMC.902.0003","atmc调用emc发送邮件失败"),
    //调用iam报错
    IAM_GET_USERMETADATA_FAIL("P.ATMC.903.0001","请求aim根据userSid获取租户语言别设置失败，入参：{0}"),
    //调用eoc报错
    EOC_SEARCH_STAFF_INFO_FAIL("P.ATMC.905.0001","查询员工信息失败"),
    EOC_SEARCH_EOC_V2_DEPT_CASCADE_FAIL("P.ATMC.905.0002","查询所有部门信息以及部门下所有员工的信息失败"),

    //调用其他组件
    //Adsc
    ADSC_APPDATA_DATA_UPDATE_EXCEPTION("P.ATMC.907.0001","提交任务到adsc服务异常"),
    ADSC_REMOVE_CACHE_EXCEPTION("P.ATMC.907.0002","删除到adsc缓存异常"),
    //aim
    AIM_SEND_MESSAGE_FAIL("P.ATMC.907.0003","请求aim发送新消息失败"),
    //km
    KM_RTN_NULL("P.ATMC.907.0004","没有查询到任务：{0} 的定义，请应用开发确认是否正在版本更新"),
    KM_GET_TM_TASK_AND_ACTIVITY_BK("P.ATMC.907.0005","从tm获取bk信息失败"),
    KM_GET_ENTITY_NAME_FAIL("P.ATMC.907.0006","调用km获取 entityName为空(knowledgegraph/view/bk)，objectType: {0}，objectValue: {1}"),
    KM_NOT_FIND_ACTIVITY_DEFINITION("P.ATMC.907.0007","在KnowledgeMaps中未找到Id为 {0} 的Task的活动定义信息"),
    KM_NOT_FIND_TASK_DEFINITION("P.ATMC.907.0008","在ThemeMap中未找到Id为 {0} 的Task定义"),
    KM_GET_TASK_ACTIVITY_NAME_FAIL("P.ATMC.907.0009","从km获取项目/任务任务名称失败，项目id:{0}，任务id:{1}"),
    KM_NOT_FIND_PHASES("P.ATMC.907.0010","在KnowledgeMaps中未找到Id为 {0} 的项目阶段信息"),
    KM_RTN_ERROR("P.ATMC.907.0015","没有查询到任务：{0} 的定义或者查询过程中转换任务定义错误，请核对是否在版本更新或km返回的任务定义中的字段是否有异常"),
    //ptm、bpm
    BPM_UPDATE_WORKITEMS_FAIL("P.ATMC.907.0011","调用BPM更换工作项目的执行人失败"),
    PTM_REMOVE_BPMDATA_BY_TASK_ID("P.ATMC.907.0012","atmc访问PTM 根据taskId等信息删除bpmdata 时出现异常(/v2/api/task/activity/remove-data)"),
    PTM_QUERY_PTM_GET_TASK_RECORD("P.ATMC.907.0013","atmc访问PTM 未查到任务记录(/api/data/task?id={0})"),
    PTM_QUERY_PTM_PROJECT_CARD_RETURN_EMPTY("P.ATMC.907.0014","ptm_project_card表中没有查到项目卡记录，projectCardId：{0}"),
//    KM_BATCH_GET_TASK_BASIC("P.ATMC.909.0003","atmc访问KnowledgeMaps获取批量项目转派的定义时出现异常(batch/taskBasic),参数：{0}"),
//    KM_BATCH_GET_ACTIVITY_BASIC("P.ATMC.909.0004","atmc访问KnowledgeMaps获取批量任务转派的定义时出现异常(batch/activityBasic),参数：{0}"),

    // OK
    OK("0", "OK"),

    // 获取Token信息失败
    UNAUTHORIZED("404", "token异常，请重新登录"),

    // 待办项已关闭
    BACKLOG_CLOSED("1001001", "backlog is closed"),

    // 待办项不存在或关闭
    BACKLOG_NOT_EXIST_OR_CLOSED("1001002", "backlog not exist or closed"),

    // 分享的任务类型不允许
    INVALID_SHARING_TASK_TYPE("1001102", "invalid sharing task type"),

    // 非法的分享码
    INVALID_SHARING_CODE("1001103", "invalid sharing code or expired"),

    // 分享者token非法或以过期
    INVALID_PROXY_TOKEN("1001104", "invalid proxy token or expired"),

    // 无权访问被分享的任务
    NO_ACCESS_SHARING_TASK("1001105", "sharing task access not allowed"),

    // 多用户并发操作
    MULTI_USER_CONCURRENT_OPERATE("1001106", "multi user concurrent operate."),

    // 不支持的操作类型
    UNSUPPORTED("1001201", "Unsupported operation"),

    NOT_FOUND("1001202", "Not found resource"),

    // 行事历团队名称重复
    CALENDAR_TEAM_NAME_DUPLICATE("1001300", "duplicate team name"),
    // 行事历团队成员重复
    CALENDAR_TEAM_MEMBER_DUPLICATE("1001301", "team member exist"),
    // 非行事历团队创建者
    CALENDAR_TEAM_NON_OWNER("1001302", "non team owner"),
    // 包含非法团队成员
    CALENDAR_INVALID_TEAM_MEMBER("1001303", "非法团队成员"),

    // 行事历团队不存在
    CALENDAR_TEAM_NOT_EXIST("1001304", "团队不存在或已解散"),
    // 不允许编辑 我的行事历 成员信息
    CALENDAR_NOT_ALLOW_EDIT_PRIVATE_TEAM_MEMBER("1001305", "不允许编辑“我的行事历“"),
    CALENDAR_NOT_TEAM_ADMIN("1001306", "您无权编辑该团队成员信息"),
    CALENDAR_UNSUPPORTED_DELETE_TEAM_MEMBER("1001307", "非团队创建者不允许编辑成员信息"),
    CALENDAR_NOT_TEAM_MEMBER("1001310", "您不是该团队成员或已被移出该团队"),
    CALENDAR_NOT_SPECIFIED_ADMIN_SUCCESSOR("1001311", "必须选择一个团队其他成员作为新任管理员"),
    CALENDAR_INVALID_PARAM("1001312", "缺少必要参数信息"),
    CALENDAR_NOT_SUPPORT_PLATFORM_TASK("1001313", "不支持平台行事历任务类型"),
    CALENDAR_LACK_BK_DEFINE("1001314", "作业缺少BK定义"),
    CALENDAR_LACK_BK_DATA_PARAM("1001315", "入参缺少BK数据"),
    CALENDAR_MULTI_TASK_WITH_BK("1001316", "根据BK查询出多个任务，请检查BK定义是否正确"),
    CALENDAR_UNSUPPORTED_SET_PRIVATE_TEAM_AS_DEFAULT("1001317", "不支持将“我的行事历”设为默认行事历"),
    CALENDAR_CREATE_TASK_ANALYSIS_BK_ERROR("1001318", "创建行事历任务解析BK报错"),
    CALENDAR_CREATE_TASK_ANALYSIS_BK_EMPTY("1001319", "创建行事历任务解析业务主键为空,taskEvent:{0}"),
    CALENDAR_CREATE_MANUAL_TASK_GET_LOCK_FAILED("1001320", "尝试创建手动项目获取锁失败,key:{0}"),
    CALENDAR_CREATE_MANUAL_TASK_FAILED("1001321", "尝试创建手动项目失败"),
    CALENDAR_CREATE_TEAM_CREATE_FAIL("1001322", "新增团队行事历失败"),
    CALENDAR_UPDATE_TEAM_ADMIN_FAIL("1001323", "更新行事历团队管理员失败"),
    CALENDAR_TEAM_ID_IS_NULL("1001324","teamId为空"),

    AUXILIARY_KEY_DUPLICATE("1001401", "新增/修改数据中企业ID + 性质重复"),

    LACK_WITHDRAW_ACTION("1001600", "缺少撤回按钮配置"),

    WITHDRAW_ACTION_LACK_NECESSARY_CONFIG("1001601", "撤回按钮缺少必需信息配置"),

    TASK_UNSUPPORTED_WITHDRAW("1001602", "任务不支持撤回"),

    TASK_WITHDRAW_DATA_LACK_NECESSARY_INFO("1001603", "任务撤回数据中缺少activity__backLog__data信息，请检查作业配置"),

    TASK_WITHDRAW_LACK_BK_CONFIG("1001604", "任务撤回按钮缺少BK配置"),

    EXPERIENCE_GUIDE_SCRIPT_EMPTY("1001605", "获取开发体验引导为空"),

    LACK_RETURN_ACTION("1001606", "缺少退回按钮配置"),

    ATMC_DOMAIN_UNSUPPORTED_ERR_KEY("1001700","不支持搜索的作业类型或搜索方式"),

    ATMC_DOMAIN_NO_PERMISSION("1001701","无该项权限"),

    ATMC_DOMAIN_NO_OPEN_PERMISSION("1001702","无开启此项目的权限！"),

    ATMC_DOMAIN_NO_OPEN_TASK_PERMISSION("1001703","无开启此任务的权限！"),

    //任务、项目
    ACTIVITY_CAN_NOT_FIND("P.ATMC.500.0001","找不到任务:{0}"),
    TASK_COMMIT_ERROR("P.ATMC.500.0002","提交数据中存在异常数据！"),
    CHECK_COMPLETE_ACTION_EMPTY("P.ATMC.500.0003","未能获取到合并任务的checkCompleteAction，action：{0}"),
    ACTIVITYID_EMPTY("P.ATMC.500.0004","activityId为空！"),
    WORKITEMID_EMPTY("P.ATMC.500.0005","workItemId为空！"),
    TASKIDS_EMPTY("P.ATMC.500.0006","taskIds为空！"),
    AUXILIARY_CHECK_ENTERPRISE_NOT_EMPTY("P.ATMC.500.0007","企业ID不能为空"),
    SEARCH_PARAM_IDS_NOT_EMPTY("P.ATMC.500.0008","查询参数 ids 不能为空"),
    GET_WORKITEM_BY_TASKID_EMPTY("P.ATMC.500.0009","终止数据失败,访问PTM根据taskId获取ptmWorkItem列表为空"),
    EMAIL_EMPTY("P.ATMC.500.0011","email不能为空"),
    CAN_NOT_FIND_APPCODE("P.ATMC.500.0012","未能获取到appCode"),
    CAN_NOT_FIND_TASK_CODE("P.ATMC.500.0013","未能获取到项目定义的code"),
    CREATE_PERSON_TENANT_FAIL("P.ATMC.500.0014","创建个人租户失败"),
    TASK_BPMACTIVITYOID_EMPTY("P.ATMC.500.0015","流程实例{0},任务{1}的bpmActivityOID不能为空"),

    TASK_NEED_TE_MANUALLY_CLOSED("P.ATMC.500.0017","未实现的功能，任务引擎不需要手工关闭任务"),
    TASK_PRE_NOT_YET_IN_STORAGE("P.ATMC.500.0018","前置任务未处理完成入库"),
    TASK_UNSUPPORTED_OVERDUE_PLAN("P.ATMC.500.0019","不支持的逾期任务处理方案编码 OverduePlanType:{0}"),
    TE_PLAN_END_TIME("P.ATMC.500.0020","只有任务引擎才支持 延展预计完成日"),
    TASK_TE_SKIP("P.ATMC.500.0021","只有任务引擎才支持 跳过任务"),
    TASK_PLAN_CAN_NOT_BE_EMPTY("P.ATMC.500.0022","方案不能为空!"),
    TASK_ABNORMAL_DATA_EMPTY("P.ATMC.500.0023","异动数据为空!"),
    NOT_SUPPORT_NON_ACTIVITY("P.ATMC.500.0024","不支持非activity类型查询"),
    FIND_HANDOVER_PARAMS("P.ATMC.500.0025","缺少查询条件, backlogID {0} ,交接人 {1}"),
    PTM_BACKLOG_IS_NULL("P.ATMC.500.0026","backlog为空"),
    PTM_NOT_SUPPORT_OPERATE_TYPE("P.ATMC.500.0027","未支持的操作类型"),
    PTM_HANDOVER_ERROR("P.ATMC.500.0028","交接失败, 失败信息 {0}"),

    CLIENT_ID_IS_NULL("P.ATMC.500.0029","clientId为空"),

    TASK_ACTIVITY_DATA_START_END_TIME_LARGE("P.ATMC.500.0030","开始时间和结束时间跨度过大！"),
    UPDATE_TASK_WORKITEM_MESSAGE_PARAM("P.ATMC.500.0031","修改项目卡/任务卡资讯：类型和id不能为空！"),
    TASK_BK_EMPTY("P.ATMC.500.0032","taskEvent解析出来的业务主键为空"),
    TASK_BK_DATANODE_GET_NODE_TYPE("P.ATMC.500.0033","数据节点类型为 {0} ，非Object/Array类型!"),
    TASK_BK_DATA_EMPTY("P.ATMC.500.0034","节点数据[{0}]中解析的对应Bk数据为空,数据不一致处理结束!"),
    TASK_BK_DATA_NODE_EXCEPTION("P.ATMC.500.0035","转换data数据节点信息异常"),
    TASK_BK_PARAM_EMPTY("P.ATMC.500.0036","collectionName、bk、cardId不能为空"),
    TASK_UNIFORMITY("P.ATMC.500.0037","处理数据不一致错误"),
    APPCODES_PROJECT_GET_FROM_KM_EMPTY("134","根据指定的 appCodes 未能找到KM的项目列表"),
    PROCESS_NOT_FIND("P.ATMC.500.0038","未找到Id为{0}的流程实例，请先提交流程实例"),
    PROCESS_CHANGED_ERROR("P.ATMC.500.0039","BPM流程实例状态变更"),
    PROJECT_CARD_MESSAGE1("P.ATMC.500.0040","token、项目卡id、钉选人不能为空"),
    PROJECT_TASK_MESSAGE1("P.ATMC.500.0045","token、任务卡id、钉选人不能为空"),
    PROJECT_CARD_MESSAGE2("P.ATMC.500.0041","未找到项目信息：{0}"),
    PROJECT_CARD_MESSAGE3("P.ATMC.500.0046","未找到任务信息：{0}"),
    RESET_TASK_WORKITEM_ERORR("P.ATMC.500.0042","刷新任务卡摘要信息和历史资讯失败"),
    CHECK_TASK_WITHDRAW_ERROR("P.ATMC.500.0043","检查数据是否可撤回异常"),
    SUBMIT_GET_DATA_BY_DATASOURCENAME("P.ATMC.500.0044","从提交的data中获取submitType.schema为key的数据为空，请检查配置与数据的对应关系，submitType.schema：{0}"),

    //通知类
    API_TYPE_ERROR("P.ATMC.500.1001","API执行异常，不支持的通知类型!type：{0}"),
    NOTICE_EOC_INFO_USER_IS_EMPTY("P.ATMC.500.1002","用户为空！"),
    NOTICE_EOC_INFO_MESSAGE_IS_EMPTY("P.ATMC.500.1003","信息为空！"),

    //其他
    CONFIG_MISS("P.ATMC.500.2001","配置丢失，configId:{0}"),
    DUPLICATE_REGISTER_ACTION_ID("P.ATMC.500.2002","重复注册，actionId:{0}"),
    NO_FIND_HANDLER_FOR_ACTION_ID("P.ATMC.500.2003","找不到handler，actionId:{0}"),
    NO_FIND_DATA_PROVIDER_APP_ID("P.ATMC.500.2004","dataProviderAppId不存在！"),
    ATMC_JSON_PROCESSING_EX("P.ATMC.500.2005","JsonProcessingException"),
    ATMC_CREATE_EXCEL_SHEET("P.ATMC.500.2006","创建Excel工作薄为空！"),
    ATMC_CLOSE_EXCEL_SHEET("P.ATMC.500.2007","关闭Excel工作薄失败！"),
    ACTIVITY_CONFIG_MISS("P.ATMC.500.2008","任务定义缺失配置：{0}，对应开发平台配置：{1}，请检查相关配置"),
    PROJECT_CONFIG_MISS("P.ATMC.500.2011","项目定义缺失配置：{0}，对应开发平台配置：{1}，请检查相关配置"),


    ATMC_SYSTEM_UNSUPPORTED_MSG_HANDLER_TYPE("P.ATMC.500.2009","系统暂不支持该消息类型：{0} 的处理,请联系系统管理员"),
    ATMC_REMOVE_CACHE_FAIL("P.ATMC.500.2010","清除ATMC缓存失败：{0}"),

    CHECK_TASK_RETURN_ERROR("P.ATMC.500.2012","检查数据是否可退回异常"),

    ATMC_OUTER_ACCESS_NETWORK_ERROR("P.ATMC.599.0001","访问其他组件时网络异常，请稍后重试"),
    ATMC_OUTER_ACCESS_ERROR("P.ATMC.599.0002","访问其他组件时异常"),

    ATMC_SUBMIT_REASSIGN_LOCK_ERROR_MSG("P.ATMC.500.5005","exception.reassign.lock.error.message"),

    //业务类型的报错，第三段为600
    UNAUTHORIZED_OPERATION("P.ATMC.600.0001","无权操作！"),
    REASSIGN_NO_NEED("P.ATMC.600.0002","项目的当责者已经是:{0}，无需转派"),
    ATMC_UPLOAD_EXCEL("P.ATMC.600.0003","请上传excel文件！"),
    APP_EXPIRED("P.ATMC.600.0004", "应用已过期"),
    AUXILIARY_NOPERMISSION_TO_COMMIT_DUPLICATE("P.ATMC.600.0005", "无权提交。当前用户不是任务的所有者或代理人!"),
    ATMC_SUBMIT_TASK_LOCK_ERROR("P.ATMC.600.0006","exception.submit.lock.error"),
    ATMC_SUBMIT_HANDOVER_LOCK_ERROR("P.ATMC.600.0007","exception.handover.lock.error"),
    ATMC_SUBMIT_REASSIGN_LOCK_ERROR("P.ATMC.600.0008","exception.reassign.lock.error"),
    ATMC_SUBMIT_HANDOVER_LOCK_ERROR_MSG("P.ATMC.600.0009","exception.handover.error.message"),
    ATMC_SUBMIT_DATA_OVERFLOW("P.ATMC.600.00011","一次最多提交2000笔数据，请减少勾选后重试"),
    ATMC_CROSS_TENANT_ERROR_MSG("P.ATMC.600.0010","exception.cross.tenant.error.message"),

    ATMC_BACKLOG_NO_PERMISSION("P.ATMC.600.00012","无查看权限！"),

    REASSIGN_FAIL_INVOKE_APP("P.ATMC.600.0013","转派失败，业务接口异常"),

    REASSIGN_FAIL_INVOKE_PTM("P.ATMC.600.0014","转派失败，平台处理异常"),

    REASSIGN_FAIL_BATCH("P.ATMC.600.0015","转派失败，失败详情请查看工作提醒");


    /**
     * 错误码
     */
    @Getter
    private String errCode;

    /**
     * 错误描述
     */
    @Getter
    private String errMsg;

    private static MessageSource messageSource;

    static {
        ErrorCodeQEnum.messageSource = SpringUtil.getBean(MessageSource.class);
    }

    ErrorCodeQEnum(String errCode, String errMsg) {
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    /**
     * 把 errorCode 作为资源文件的 name ,以支持多语言
     * -- 注意： 一定要在 error 资源包中建立以 errorCode 为 name 的多语言资源。
     * 否则，会使用 errorMsg 来显示。
     *
     * @return
     */
    public BusinessException getBusinessException() {
        return BusinessException.create(this.getErrCode(), ErrorCodeQEnum.messageSource.getMessage(this.getErrCode(), null, this.getErrMsg(), LocaleContextHolder.getLocale()));
    }

    /**
     * ErrorCodeEnum转BusinessException
     *
     * @param errorTypeEnum 错误类型枚举
     * @return BusinessException实例
     */
    public BusinessException getBusinessException(ErrorTypeEnum errorTypeEnum) {
        return BusinessException.create(this.getErrCode(), ErrorCodeQEnum.messageSource.getMessage(this.getErrCode(), null, this.getErrMsg(), LocaleContextHolder.getLocale()), errorTypeEnum.getValue());
    }

    /**
     * 把 errorCode 作为资源文件的 name ,以支持多语言
     * -- 注意： 一定要在 error 资源包中建立以 errorCode 为 name 的多语言资源。
     * 否则，会使用 errorMsg 来显示。
     * args：message后面需要带的参数
     *
     * @return
     */
    public BusinessException getBusinessExceptionWithArgs(Object... paras) {
        return BusinessException.create(this.getErrCode(), ErrorCodeQEnum.messageSource.getMessage(this.getErrCode(), paras, LocaleContextHolder.getLocale()));
    }

    /**
     * ErrorCodeEnum转BusinessException
     *
     * @return BusinessException实例
     */
    public BusinessException getBusinessException(String errorMessage) {
        return BusinessException.create(this.getErrCode(), errorMessage);
    }


}
