package com.digiwin.athena.atmc.application.service.restful.ptm;

import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.PtmBacklogItemBO;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.PtmProjectRecordBO;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.PtmTaskCardItemBO;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.PtmTaskRecordBO;

import java.util.List;

public interface PtmQService {

    /**
     * 查询ptm任务卡列表
     * @param userIds 要查询的userId
     * @return 没有值则返回空 List
     */
    List<PtmTaskCardItemBO> queryTaskCardList(List<String> userIds);


    /**
     * 批量-获取项目 记录详情(ptm_project表)
     * @param projectIds
     * @param needData 是否需要data数据，默认为需要
     *
     * @return 没有值慢返回空集合
     */
    List<PtmProjectRecordBO> getProjectRecordByProjectIdsV2(List<Long> projectIds, boolean needData);

    /**
     * 获取任务记录详情(ptm_task表)
     * @param taskIds
     * @return 没有值慢返回空集合
     */
    List<PtmTaskRecordBO> getTaskRecordByTaskIds(List<Long> taskIds);

    /**
     * 根据backlogId获取全部中的任务列表（批量）
     * @Author：SYQ
     * @Date：2022/6/16 15:52
     */
    List<PtmBacklogItemBO> getBacklogByBacklogIds(List<Long> backlogIdList);


    /**
     * 查询ptm任务卡列表
     * @param backlogIdList 要查询的待办ID列表
     * @return 没有值则返回空 List
     */
    List<PtmTaskCardItemBO> queryTaskCardListByBacklogId(List<Long> backlogIdList);
}
