package com.digiwin.athena.atmc.application.service.restful.ptm.impl;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.atmc.application.service.restful.ptm.HttpAssistantQServiceImpl;
import com.digiwin.athena.atmc.application.service.restful.ptm.PtmQService;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.core.meta.constants.ptm.PtmApiConstant;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.PtmBacklogItemBO;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.PtmProjectRecordBO;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.PtmTaskCardItemBO;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.PtmTaskRecordBO;
import com.fasterxml.jackson.core.type.TypeReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Description TODO
 * Author hebaokai
 * Date 2024/8/15 19:17
 *
 * @Version 1.0
 **/
@Service
public class PtmQServiceImpl implements PtmQService {

    @Autowired
    EnvProperties envProperties;

    @Autowired
    HttpAssistantQServiceImpl httpAssistantService;

    @Autowired
    RestTemplate restTemplate;

    /**
     * 查询ptm任务卡列表
     *
     * @param userIds 要查询的userId
     * @return 没有值则返回空 List
     */
    @Override
    public List<PtmTaskCardItemBO> queryTaskCardList(List<String> userIds) {
        //入参
        Map<String, Object> rootPara = new HashMap<>();
        rootPara.put("userIds", userIds);
        return reqPtmTaskCard(rootPara, PtmApiConstant.TASK_CARD_PROCESSING_LIST);
    }

    private List<PtmTaskCardItemBO> reqPtmTaskCard(Map<String, Object> params, String reqUrl){
        List<PtmTaskCardItemBO> result = null;

        //请求地址
        String url = envProperties.getPtmUri() + reqUrl;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        //获取列表时，传当前token，如果使用代理token，获取的就是代理token的列表
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());



        result = httpAssistantService.post(new TypeReference<List<PtmTaskCardItemBO>>() {
        }, url, headers, params);

        if (result == null) {
            result = new ArrayList<>();
        }
        return result;
    }


    /**
     * 批量-获取项目 记录详情(ptm_project表)
     *
     * @param projectIds
     * @param needData   是否需要data数据，默认为需要
     * @return 没有值慢返回空集合
     */
    @Override
    public List<PtmProjectRecordBO> getProjectRecordByProjectIdsV2(List<Long> projectIds, boolean needData) {
        List<PtmProjectRecordBO> result;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.DATA_PROJECT_LIST;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> rootPara = new HashMap<>();
        rootPara.put("idList", projectIds);
        //如果不需要data，传needData为false，目的优化ptm内存消耗
        //needData不传或者传true，ptm都是默认查data
        rootPara.put("needData", needData);
        HttpEntity<?> httpEntity = new HttpEntity<>(rootPara, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<PtmProjectRecordBO>>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<PtmProjectRecordBO>>>() {
        }, rootPara);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }


    /**
     * 批量 获取任务记录详情(ptm_task表)
     *
     * @param taskIds
     * @return 没有值慢返回空集合
     */
    @Override
    public List<PtmTaskRecordBO> getTaskRecordByTaskIds(List<Long> taskIds) {
        List<PtmTaskRecordBO> result;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.DATA_TASK_LIST;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> rootPara = new HashMap<>();
        rootPara.put("idList", taskIds);
        //不需要data，传needData为false，目的优化ptm内存消耗
        //needData不传或者传true，ptm都是默认查data，atmc中查此接口的业务均不需要data
        rootPara.put("needData", false);
        HttpEntity<?> httpEntity = new HttpEntity<>(rootPara, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<PtmTaskRecordBO>>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<PtmTaskRecordBO>>>() {
        }, rootPara);
        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }


    /**
     * 根据backlogId获取全部的任务列表
     *
     * @param backlogIdList 待办id
     * @return
     */
    @Override
    public List<PtmBacklogItemBO> getBacklogByBacklogIds(List<Long> backlogIdList) {
        List<PtmBacklogItemBO> result = null;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.TASK_CARD_TASK_LIST_BATCH;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> param = new HashMap<>();
        param.put("backlogIds", backlogIdList);

        HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<PtmBacklogItemBO>>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<PtmBacklogItemBO>>>() {
        }, param);

        result = responseEntity.getBody().getResponseWithException("");
        return result;
    }


    /**
     * 查询ptm任务卡列表
     *
     * @param backlogIdList 要查询的待办ID列表
     * @return 没有值则返回空 List
     */
    @Override
    public List<PtmTaskCardItemBO> queryTaskCardListByBacklogId(List<Long> backlogIdList) {
        List<PtmTaskCardItemBO> result = null;

        //请求地址
        String url = envProperties.getPtmUri() + PtmApiConstant.TASK_CARD_PROCESSING_LIST;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        //获取列表时，传当前token，如果使用代理token，获取的就是代理token的列表
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());

        //入参
        Map<String, Object> rootPara = new HashMap<>();
        rootPara.put("backlogIds", backlogIdList);

        HttpEntity<?> httpEntity = new HttpEntity<>(rootPara, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<PtmTaskCardItemBO>>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<PtmTaskCardItemBO>>>() {
        }, rootPara);
        result = responseEntity.getBody().getResponseWithException("");
        if (result == null) {
            result = new ArrayList<>();
        }
        return result;
    }
}
