package com.digiwin.athena.atmc.application.service.restful.thememap.impl;/*
 * Copyright (C), 2001-2024, 鼎捷软件股份有限公司
 * FileName: com.digiwin.athena.atmc.application.service.restful.thememap.impl
 * Author:   杨尹(22191)
 * Date:     2024/9/5 20:33
 * Description: // 模块目的、功能描述
 * History:		// 修改记录
 * <author>		<time>		<version>		<desc>
 * 22191		2024/9/5 20:33		1.0		<描述>
 */

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.application.service.restful.thememap.ThemeMapQService;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.CardPresentConfigBO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.List;
import java.util.Map;

/**
 * @version v1.0
 * @Description: TODO
 * <p>〈功能详细描述〉</p>
 *
 * <pre>
 * 〈举例说明〉
 * </pre>
 * @ClassName ThemeMapQServiceImpl
 * @author 杨尹(22191)
 * @date 2024/9/5 20:33
 */
@Slf4j
@Service
public class ThemeMapQServiceImpl implements ThemeMapQService {

    private static final int NOT_NEED_SEARCH = -999;
    private static final String APPLY_PROJECT_TYPE_STR = "2";
    private static final String APPLY_ENTRY_TYPE_STR = "3";
    private static final String APPLY_REPORT_TYPE_STR = "4";

    private static final String REPORT_PATTERN = "STATEMENT";
    public static final String BASE_DATA_PATTERN = "DATA_ENTRY";


    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Autowired
    private MessageUtils messageUtils;

    private String getToken() {
        // 优先使用代理token
        if (null != AppAuthContextHolder.getContext().getProxyAuthoredUser()) {
            return AppAuthContextHolder.getContext().getProxyAuthoredUser().getToken();
        } else {
            return AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        }
    }

    @Override
    public List<CardPresentConfigBO> getCardPresentConfigs(String pageCode) {
        return reqThemeMapList(new ParameterizedTypeReference<BaseResultDTO<List<CardPresentConfigBO>>>() {
        }, HttpMethod.GET,
                "knowledgegraph/workbenchSetting/cardPresentConfig?pageCode="+ pageCode,null);
    }

    private <T> T reqThemeMapList(ParameterizedTypeReference<BaseResultDTO<T>> typeReference, HttpMethod httpMethod, String url, Map<String, Object> body){
        url = envProperties.getKnowledgeGraphUri() + url;
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", getToken());
        HttpEntity<?> requestEntity = new HttpEntity<>(body, headers);
        ResponseEntity<BaseResultDTO<T>> respEntity = this.restTemplate.exchange(url,httpMethod, requestEntity,
                typeReference);
        BaseResultDTO<T> baseResultDTO = respEntity.getBody();
        assert baseResultDTO != null;
        return baseResultDTO.getResponse();
    }

}
