package com.digiwin.athena.atmc.application.utils;

//import com.digiwin.athena.atmc.common.domain.BpmActivityWorkitem;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.PtmWorkItemRecordBO;
import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.BpmActivityWorkitem;
import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.PtmBacklog;
//import com.digiwin.athena.atmc.http.restful.ptm.model.PtmWorkItemRecordDTO;
import com.digiwin.athena.atmc.core.meta.enums.km.TmTaskCategoryEnum;
import com.digiwin.athena.atmc.core.meta.enums.km.TmTaskPatternEnum;
import org.apache.commons.collections4.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

/**
 * 摘要信息处理的工具类
 */
public class SummaryMessagesUtils {

    /**
     * 是否是签核型任务
     *
     * @param tmPattern
     * @param tmCategory
     * @return
     */
    public static Boolean isApprovalTask(String tmPattern, String tmCategory) {
        return Objects.equals(tmPattern, TmTaskPatternEnum.BUSINESS.getValue()) && Objects.equals(tmCategory, TmTaskCategoryEnum.APPROVAL.getValue());
    }

    public static Integer withinStateData(List<Map<String, Object>> dataList, Map dataItem, List<String> unitKeys) {
        if (CollectionUtils.isEmpty(unitKeys)) {
            return -1;
        }
        if (CollectionUtils.isEmpty(dataList)) {
            return -1;
        }
        for (int i = 0; i < dataList.size(); i++) {
            Map<String, Object> dataMap = dataList.get(i);
            AtomicReference<Boolean> isWithin = new AtomicReference<>(false);
            unitKeys.forEach(unitKey -> {
                if (dataMap.containsKey(unitKey) && dataItem.containsKey(unitKey) && dataMap.get(unitKey).equals(dataItem.get(unitKey))) {
                    isWithin.set(true);
                } else {
                    isWithin.set(false);
                }
            });
            if (isWithin.get() == true) {
                return i;
            }
        }
        return -1;
    }

    public static BpmActivityWorkitem translatePtmWorkItem(PtmBacklog ptmBacklog, PtmWorkItemRecordBO ptmWorkItemRecord) {
        if(ptmBacklog == null){
            ptmBacklog = new PtmBacklog();
        }
        BpmActivityWorkitem bpmWorkitem = BpmActivityWorkitem.builder()
                .id(ptmWorkItemRecord.getId())
                .activityStepId(ptmWorkItemRecord.getActivityId())
                .createTime(ptmWorkItemRecord.getCreateTime())
                .closedTime(ptmWorkItemRecord.getClosedTime())
                .performerId(ptmWorkItemRecord.getPerformerId())
                .performerName(ptmWorkItemRecord.getPerformerName())
                .workitemId(ptmWorkItemRecord.getWorkItemId())
                .comment(ptmWorkItemRecord.getComment())
                .state(ptmWorkItemRecord.getState())
                .agentPerformerId(ptmWorkItemRecord.getAgentPerformerId())
                .agentPerformerName(ptmWorkItemRecord.getAgentPerformerName())
                .performerType(ptmWorkItemRecord.getPerformerType())
                .readCount(ptmBacklog.getReadCount())
                .actionId(ptmBacklog.getClosed() ? ptmBacklog.getActionId() : null)
                .subState(ptmWorkItemRecord.getSubState())
                .type(ptmWorkItemRecord.getItemType())
                .createType(ptmWorkItemRecord.getCreateType())
                .approvalState(ptmBacklog.getApprovalState())
                .fromWorkitemId(ptmWorkItemRecord.getFromWorkItemId())
                .groupId(ptmWorkItemRecord.getGroupId())
                .targetTenantId(ptmWorkItemRecord.getTenantId())
                .importance(ptmBacklog.getFavorite())
                .importanceSource("self")
                .commonPerformerId(null)
                .build();
        return bpmWorkitem;
    }

    public static Integer translateBacklogType(Integer type) {
        if (type == null) {
            return 1;
        } else if (type == 0) {
            return 1;
        } else if (type == 1) {
            return 11;
        } else if (type == 2) {
            return 1;
        } else if (type == 88) {
            return 88;
        } else if (type == 89) {
            return 89;
        } else if (type == 72) {
            return 72;
        }
        return 1;
    }

    public static void main(String[] args) {

    }
}
