/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.application.service.query.backlog;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.application.dto.response.eoc.ProxyUserResp;
import com.digiwin.athena.atmc.application.dto.response.task.TaskCardResp;
import com.digiwin.athena.atmc.application.service.query.backlog.PtmTransformQueryCountingQryService;
import com.digiwin.athena.atmc.application.service.query.backlog.TaskPinningUserParentCountingQryService;
import com.digiwin.athena.atmc.application.service.restful.eoc.EocQService;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.BacklogBO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TodoBacklogQueryCountingQryService {
    private static final Logger log = LoggerFactory.getLogger(TodoBacklogQueryCountingQryService.class);
    @Autowired
    EocQService eocService;
    @Autowired
    TaskPinningUserParentCountingQryService taskPinningUserParentService;
    @Autowired
    PtmTransformQueryCountingQryService ptmTransformService;
    @Autowired
    EnvProperties envProperties;

    public List<TaskCardResp> getBacklogListByTenantIdAndUserIdAndCode(AuthoredUser user, String clientId) {
        List<BacklogBO> backlogList = this.queryByNotClosedAndActivityId(user);
        if (CollectionUtils.isEmpty(backlogList)) {
            return new ArrayList<TaskCardResp>();
        }
        return this.getBacklogList(clientId, backlogList);
    }

    private List<BacklogBO> queryByNotClosedAndActivityId(AuthoredUser user) {
        List<Long> mainTaskIdList;
        List<ProxyUserResp> proxyUserResps;
        ArrayList<String> userIdList = new ArrayList<String>();
        userIdList.add(user.getUserId());
        List<BacklogBO> backlogBOS = this.queryByNotClosedAndActivityId(user.getTenantId(), userIdList);
        if (StringUtils.hasText((String)user.getToken()) && !CollectionUtils.isEmpty(proxyUserResps = this.eocService.getProxyTargetUsers(user.getUserId(), user.getToken()))) {
            userIdList.clear();
            for (ProxyUserResp proxyUserResp : proxyUserResps) {
                if (Objects.equals(proxyUserResp.getUserId(), user.getUserId())) continue;
                userIdList.add(proxyUserResp.getUserId());
            }
            if (!CollectionUtils.isEmpty(userIdList)) {
                List<BacklogBO> proxyBacklogBOS = this.queryByNotClosedAndActivityId(user.getTenantId(), userIdList);
                backlogBOS.addAll(proxyBacklogBOS);
            }
        }
        if (!CollectionUtils.isEmpty(mainTaskIdList = this.taskPinningUserParentService.getMainTaskIdByPinningUser(user.getUserId(), user.getTenantId(), 2))) {
            List<BacklogBO> ptmPinningTaskList = this.queryByPinningNotClosedAndActivityId(user.getTenantId(), mainTaskIdList);
            backlogBOS.addAll(ptmPinningTaskList);
        }
        return backlogBOS;
    }

    private List<BacklogBO> queryByNotClosedAndActivityId(String tenantId, List<String> userIds) {
        return this.ptmTransformService.queryBacklogList(tenantId, userIds);
    }

    public List<TaskCardResp> getBacklogList(String clientId, List<BacklogBO> backlogList) {
        ArrayList<TaskCardResp> list = new ArrayList<TaskCardResp>();
        backlogList.forEach(backlog -> {
            TaskCardResp taskCardDTO = TaskCardResp.builder().backlogId(backlog.getWorkItemId()).submitId(backlog.getSubmitId()).uri(this.envProperties.getWebUri() + "task/detail/" + backlog.getWorkItemId() + "?targetTenantId=" + backlog.getTargetTenantId()).name(backlog.getName()).subName(backlog.getSubName()).projectName(backlog.getTaskName()).projectTargetName(backlog.getTaskTargetName()).projectStartTime(backlog.getTaskStartTime()).projectEndTime(backlog.getTaskEndTime()).projectImportance(backlog.isImportance()).exception(null != backlog.getException() && backlog.getException() != false).overdue(null != backlog.getOverdue() && backlog.getOverdue() != false).overdueMinutes(null != backlog.getOverdueMinutes() ? backlog.getOverdueMinutes() : 0).overdueHours(null != backlog.getOverdueHours() ? backlog.getOverdueHours() : 0).overdueDays(null != backlog.getOverdueDays() ? backlog.getOverdueDays() : 0).approvalState(backlog.getApprovalState()).approvalStateCode(backlog.getApprovalStateCode()).modifyDate(backlog.getModifyDate()).emergency(backlog.isEmergency()).eocCode(backlog.getEocCode()).eocName(backlog.getEocName()).eocType(backlog.getEocType()).agentBeginDate(backlog.getAgentBeginDate()).agentEndDate(backlog.getAgentEndDate()).sourceTenantName(backlog.getSourceTenantName()).proxyToken(backlog.getProxyToken()).finishActionId(backlog.getFinishActionId()).tmActivityName(backlog.getTmActivityName()).summary(backlog.getSummary()).historyMessage(backlog.getHistoryMessage()).searchMessage(backlog.getSearchMessage()).dataFrom(backlog.getDataFrom()).merge(backlog.getMerge()).planEndTimeMin(backlog.getPlanEndTimeMin()).planEndTimeMax(backlog.getPlanEndTimeMax()).dataChangeRead(backlog.getDataChangeRead() != null && backlog.getDataChangeRead() == 0).groupId(backlog.getGroupId()).engineType(backlog.getEngineType()).closedTime(backlog.getClosedTime()).createTime(backlog.getCreateTime()).hasAppPermission(backlog.getHasAppPermission()).auxiliaryTenantId(backlog.getAuxiliaryTenantId()).auxiliaryTenantName(backlog.getAuxiliaryTenantName()).pinning(backlog.getPinning()).engineHasWaittingData(backlog.getEngineHasWaittingData()).build();
            list.add(taskCardDTO);
        });
        return list;
    }

    private List<BacklogBO> queryByPinningNotClosedAndActivityId(String tenantId, List<Long> backlogIds) {
        return this.ptmTransformService.queryPinningBacklogList(tenantId, backlogIds);
    }
}

