/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.application.service.restful.thememap.impl;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.application.service.restful.thememap.ThemeMapQService;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.CardPresentConfigBO;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ThemeMapQServiceImpl
implements ThemeMapQService {
    private static final Logger log = LoggerFactory.getLogger(ThemeMapQServiceImpl.class);
    private static final int NOT_NEED_SEARCH = -999;
    private static final String APPLY_PROJECT_TYPE_STR = "2";
    private static final String APPLY_ENTRY_TYPE_STR = "3";
    private static final String APPLY_REPORT_TYPE_STR = "4";
    private static final String REPORT_PATTERN = "STATEMENT";
    public static final String BASE_DATA_PATTERN = "DATA_ENTRY";
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private MessageUtils messageUtils;

    private String getToken() {
        if (null != AppAuthContextHolder.getContext().getProxyAuthoredUser()) {
            return AppAuthContextHolder.getContext().getProxyAuthoredUser().getToken();
        }
        return AppAuthContextHolder.getContext().getAuthoredUser().getToken();
    }

    @Override
    public List<CardPresentConfigBO> getCardPresentConfigs(String pageCode) {
        return this.reqThemeMapList(new ParameterizedTypeReference<BaseResultDTO<List<CardPresentConfigBO>>>(){}, HttpMethod.GET, "knowledgegraph/workbenchSetting/cardPresentConfig?pageCode=" + pageCode, null);
    }

    private <T> T reqThemeMapList(ParameterizedTypeReference<BaseResultDTO<T>> typeReference, HttpMethod httpMethod, String url, Map<String, Object> body) {
        url = this.envProperties.getKnowledgeGraphUri() + url;
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", this.getToken());
        HttpEntity requestEntity = new HttpEntity(body, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, httpMethod, requestEntity, typeReference, new Object[0]);
        BaseResultDTO baseResultDTO = (BaseResultDTO)respEntity.getBody();
        assert (baseResultDTO != null);
        return (T)baseResultDTO.getResponse();
    }
}

